/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.reportbuilder;

import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XHierarchicalNameContainer;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.report.XReportDefinition;
import com.sun.star.sdb.XSubDocument;
import com.sun.star.sdb.application.XDatabaseDocumentUI;
import com.sun.star.sdbc.XConnection;
import com.sun.star.ucb.Command;
import com.sun.star.ucb.XCommandProcessor;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XModeSelector;
import com.sun.star.util.XModifiable;
import com.sun.star.util.XURLTransformer;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.NamedValueCollection;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.RecordParser;
import com.sun.star.wizards.report.IReportBuilderLayouter;
import com.sun.star.wizards.report.IReportDefinitionReadAccess;
import com.sun.star.wizards.report.IReportDocument;
import com.sun.star.wizards.report.ReportImplementationHelper;
import com.sun.star.wizards.report.ReportWizard;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportBuilderImplementation
extends ReportImplementationHelper
implements IReportDocument,
IReportDefinitionReadAccess {
    private Resource m_resource;
    private XDatabaseDocumentUI m_documentUI;
    private static final int MAXIMUM_GROUPCOUNT = 4;
    private String[] groupNames = null;
    private XFrame m_xFrame = null;
    private String m_sReportBuilderLayoutName = PropertyNames.EMPTY_STRING;
    private Object m_aReportDocument;
    private XPropertySet m_documentDefinition;
    private XReportDefinition m_reportDocument;
    private ArrayList<String> m_aReportPath;
    private LinkedHashMap<String, IReportBuilderLayouter> m_aLayoutMap = null;
    private String m_sDefaultHeaderLayoutPath;

    private ReportBuilderImplementation(XMultiServiceFactory _serviceFactory) {
        super(_serviceFactory, 30);
    }

    public static IReportDocument create(XMultiServiceFactory i_serviceFactory) {
        return new ReportBuilderImplementation(i_serviceFactory);
    }

    @Override
    public void initialize(XDatabaseDocumentUI i_documentUI, Resource i_resource) {
        this.m_documentUI = i_documentUI;
        this.m_resource = i_resource;
    }

    @Override
    public void clearDocument() {
    }

    @Override
    public XWindowPeer getWizardParent() {
        return (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.getFrame().getComponentWindow());
    }

    private IReportBuilderLayouter getReportBuilderLayouter() {
        return this.getLayoutMap().get(this.m_sReportBuilderLayoutName);
    }

    private void initialize(Object _aDoc) {
        this.m_aReportDocument = _aDoc;
        try {
            NamedValueCollection creationArgs = new NamedValueCollection();
            creationArgs.put("DocumentServiceName", "com.sun.star.report.ReportDefinition");
            creationArgs.put("Mode", "remote");
            XComponent[] docDefinition = new XComponent[]{null};
            XComponent reportDefinitionComp = this.m_documentUI.createComponentWithArguments(3, creationArgs.getPropertyValues(), docDefinition);
            this.m_documentDefinition = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)docDefinition[0]);
            this.m_reportDocument = (XReportDefinition)UnoRuntime.queryInterface(XReportDefinition.class, (Object)reportDefinitionComp);
        }
        catch (com.sun.star.uno.Exception e) {
            ReportWizard.getLogger().log(1000, "Problems with initialize the ReportDefinition" + e.getMessage());
        }
        this.switchOffPropertyBrowser();
        this.switchOffAddFieldWindow();
        this.setPageOrientation(this.m_nDefaultPageOrientation, false);
    }

    private XModeSelector getModeSelector() {
        XController xController = this.getReportDefinition().getCurrentController();
        return (XModeSelector)UnoRuntime.queryInterface(XModeSelector.class, (Object)xController);
    }

    private void switchOffAddFieldWindow() {
        try {
            this.getModeSelector().setMode("remote");
        }
        catch (com.sun.star.uno.Exception e) {
            boolean bl = false;
        }
    }

    private void switchOnAddFieldWindow() {
        try {
            this.getModeSelector().setMode("normal");
        }
        catch (com.sun.star.uno.Exception e) {
            boolean bl = false;
        }
    }

    private void sleep(int _nSeconds) {
        try {
            Thread.sleep(_nSeconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void switchOffPropertyBrowser() {
        try {
            XController xController = this.getReportDefinition().getCurrentController();
            XDispatchProvider xDP = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
            Object aURLTransformer = this.getMSF().createInstance("com.sun.star.util.URLTransformer");
            XURLTransformer xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, (Object)aURLTransformer);
            URL[] aURL = new URL[]{new URL()};
            aURL[0].Complete = ".uno:ControlProperties";
            xURLTransformer.parseStrict(aURL);
            XDispatch xDispatch = xDP.queryDispatch(aURL[0], "_self", 0);
            PropertyValue[] xEmpty = new PropertyValue[]{};
            xDispatch.dispatch(aURL[0], xEmpty);
        }
        catch (com.sun.star.uno.Exception e) {
            boolean bl = false;
        }
    }

    private void switchOnPropertyBrowser() {
        this.switchOffPropertyBrowser();
    }

    @Override
    public XFrame getFrame() {
        if (this.m_xFrame == null) {
            this.initialize(this.getRecordParser().getReportDocuments());
            this.m_xFrame = this.getReportDefinition().getCurrentController().getFrame();
            this.setPageOrientation(this.m_nDefaultPageOrientation, true);
        }
        return this.m_xFrame;
    }

    @Override
    public boolean reconnectToDatabase(XMultiServiceFactory xMSF, PropertyValue[] Properties2) {
        return false;
    }

    @Override
    public void insertDatabaseDatatoReportDocument(XMultiServiceFactory xMSF) {
    }

    @Override
    public void StopProcess() {
    }

    @Override
    public void store(String Name, int OpenMode) throws com.sun.star.uno.Exception {
        if (OpenMode == 1) {
            return;
        }
        XCommandProcessor xProcessor = (XCommandProcessor)UnoRuntime.queryInterface(XCommandProcessor.class, (Object)this.m_documentDefinition);
        Command aCommand = new Command();
        aCommand.Name = "store";
        xProcessor.execute(aCommand, xProcessor.createCommandIdentifier(), null);
        XHierarchicalNameContainer aNameContainer = (XHierarchicalNameContainer)UnoRuntime.queryInterface(XHierarchicalNameContainer.class, (Object)this.m_aReportDocument);
        aNameContainer.insertByHierarchicalName(Name, (Object)this.m_documentDefinition);
    }

    @Override
    public boolean liveupdate_addGroupNametoDocument(String[] GroupNames, String CurGroupTitle, ArrayList<String> GroupFieldVector, ArrayList<String> ReportPath, int iSelCount) {
        int GroupCount = GroupFieldVector.size();
        if (GroupCount < 4) {
            FieldColumn CurFieldColumn = this.getRecordParser().getFieldColumnByTitle(CurGroupTitle);
            GroupFieldVector.add(CurFieldColumn.getFieldName());
        }
        return true;
    }

    @Override
    public void refreshGroupFields(String[] _sNewNames) {
    }

    @Override
    public void liveupdate_removeGroupName(String[] NewSelGroupNames, String CurGroupTitle, ArrayList<String> GroupFieldVector) {
        FieldColumn CurFieldColumn = this.getRecordParser().getFieldColumnByTitle(CurGroupTitle);
        GroupFieldVector.remove(CurFieldColumn.getFieldName());
    }

    private void setPageOrientation(int nOrientation, boolean bDoLayout) {
        this.getReportBuilderLayouter().setPageOrientation(nOrientation);
        if (bDoLayout) {
            this.getReportBuilderLayouter().layout();
        }
    }

    @Override
    public void setPageOrientation(int nOrientation) {
        this.setPageOrientation(nOrientation, true);
    }

    @Override
    public void liveupdate_changeLayoutTemplate(String LayoutTemplatePath) {
        IReportBuilderLayouter aLayouter = this.getReportBuilderLayouter();
        aLayouter.loadAndSetBackgroundTemplate(LayoutTemplatePath);
        aLayouter.layout();
    }

    public void setReportBuilderLayouterName(String _sName) {
        IReportBuilderLayouter aCurrentLayouter = this.getReportBuilderLayouter();
        IReportBuilderLayouter aNewLayouter = this.m_aLayoutMap.get(_sName);
        if (aNewLayouter != null) {
            this.m_sReportBuilderLayoutName = _sName;
            aNewLayouter.initializeData(aCurrentLayouter);
            aNewLayouter.layout();
        }
    }

    @Override
    public void liveupdate_changeContentTemplate(String ContentTemplatePath) {
        this.setReportBuilderLayouterName(ContentTemplatePath);
    }

    @Override
    public void layout_setupRecordSection(String TemplateName) {
    }

    @Override
    public void removeTextTableAndTextSection() {
    }

    @Override
    public void layout_selectFirstPage() {
    }

    private void closeReportDefinition() {
        try {
            if (this.m_documentDefinition != null) {
                XModifiable documentModify = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)this.m_reportDocument);
                documentModify.setModified(false);
                XSubDocument subComponent = (XSubDocument)UnoRuntime.queryInterface(XSubDocument.class, (Object)this.m_documentDefinition);
                subComponent.close();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ReportBuilderImplementation.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.m_documentDefinition = null;
        this.m_reportDocument = null;
    }

    @Override
    public void dispose() {
        this.getReportBuilderLayouter().dispose();
        this.closeReportDefinition();
    }

    @Override
    public XComponent getComponent() {
        return null;
    }

    @Override
    public void liveupdate_changeUserFieldContent(String fieldName, String titlename) {
    }

    @Override
    public void liveupdate_updateReportTitle(String _sTitleName) {
    }

    @Override
    public void addReportToDBView() {
    }

    private XComponent loadReport(String i_reportName) {
        try {
            return this.m_documentUI.loadComponent(3, i_reportName, false);
        }
        catch (Exception ex) {
            Logger.getLogger(ReportBuilderImplementation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private XComponent loadReportFromDocumentDefinition() {
        XCommandProcessor commandProcessor = (XCommandProcessor)UnoRuntime.queryInterface(XCommandProcessor.class, (Object)this.m_documentDefinition);
        Command aCommand = new Command();
        aCommand.Name = "open";
        try {
            Object result = commandProcessor.execute(aCommand, commandProcessor.createCommandIdentifier(), null);
            return (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)result);
        }
        catch (Exception ex) {
            Logger.getLogger(ReportBuilderImplementation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void createAndOpenReportDocument(String i_name, boolean i_asTemplate, boolean i_openForEditing) {
        if (i_openForEditing) {
            this.switchOnAddFieldWindow();
            this.switchOnPropertyBrowser();
            return;
        }
        if (i_asTemplate) {
            this.closeReportDefinition();
            this.loadReport(i_name);
        } else {
            XComponent document = this.loadReportFromDocumentDefinition();
            this.closeReportDefinition();
            if (this.getRecordParser().storeDatabaseDocumentToTempPath(document, i_name)) {
                this.getRecordParser().addReportDocument(document, false);
            }
        }
        this.dispose();
    }

    private XConnection getConnection() {
        return this.getRecordParser().DBConnection;
    }

    @Override
    public void initializeFieldColumns(int _nType, String TableName, String[] FieldNames) {
        this.getRecordParser().initializeFieldColumns(FieldNames, TableName);
        RecordParser a = this.getRecordParser();
        int[] FieldTypes = new int[FieldNames.length];
        int[] FieldWidths = new int[FieldNames.length];
        for (int i = 0; i < FieldNames.length; ++i) {
            FieldTypes[i] = a.FieldColumns[i].getFieldType();
            FieldWidths[i] = a.FieldColumns[i].getFieldWidth();
        }
        this.getReportBuilderLayouter().setTableName(_nType, TableName);
        this.getReportBuilderLayouter().insertFieldNames(FieldNames);
        this.getReportBuilderLayouter().insertFieldTypes(FieldTypes);
        this.getReportBuilderLayouter().insertFieldWidths(FieldWidths);
        this.getReportBuilderLayouter().layout();
    }

    @Override
    public void setFieldTitles(String[] _aFieldTitles) {
        this.getRecordParser().setFieldTitles(_aFieldTitles);
        this.getReportBuilderLayouter().insertFieldTitles(_aFieldTitles);
        this.getReportBuilderLayouter().layout();
    }

    @Override
    public void setSorting(String[][] _aSortFieldNames) {
        this.getRecordParser().setSortFieldNames(_aSortFieldNames);
        if (this.groupNames != null) {
            this.getRecordParser().prependSortFieldNames(this.groupNames);
        }
        this.getReportBuilderLayouter().insertSortingNames(_aSortFieldNames);
        this.getReportBuilderLayouter().layout();
    }

    @Override
    public void setGrouping(String[] _aGroupFieldNames) {
        this.groupNames = _aGroupFieldNames;
        this.getRecordParser().prependSortFieldNames(_aGroupFieldNames);
        this.getReportBuilderLayouter().insertGroupNames(_aGroupFieldNames);
        this.getReportBuilderLayouter().layout();
    }

    @Override
    public String getLayoutPath() {
        return "default";
    }

    @Override
    public ArrayList<String> getReportPath() {
        if (this.m_aReportPath == null) {
            try {
                this.m_aReportPath = FileAccess.getOfficePaths(this.getMSF(), "Template", "share", "/wizard");
                FileAccess.combinePaths(this.getMSF(), this.m_aReportPath, "/wizard/report");
            }
            catch (NoValidPathException ex) {
                Logger.getLogger(ReportBuilderImplementation.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.m_aReportPath;
    }

    @Override
    public String getContentPath() {
        return PropertyNames.EMPTY_STRING;
    }

    @Override
    public int getDefaultPageOrientation() {
        return this.m_nDefaultPageOrientation;
    }

    private IReportBuilderLayouter getLayoutInstanceFrom(String _sClassName) {
        try {
            Class<?> a = Class.forName(_sClassName);
            Constructor<?> cTor = a.getConstructor(IReportDefinitionReadAccess.class, Resource.class);
            Object[] aParams = new Object[]{this, this.m_resource};
            return (IReportBuilderLayouter)cTor.newInstance(aParams);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void insertIntoLayoutMap(IReportBuilderLayouter _aLayout) {
        this.insertIntoLayoutMap(_aLayout, false);
    }

    private void insertIntoLayoutMap(IReportBuilderLayouter _aLayout, boolean _bDefault) {
        if (_aLayout != null) {
            String sName = _aLayout.getName();
            if (_bDefault) {
                this.m_sReportBuilderLayoutName = sName;
            }
            this.m_aLayoutMap.put(sName, _aLayout);
        }
    }

    private LinkedHashMap<String, IReportBuilderLayouter> getLayoutMap() {
        if (this.m_aLayoutMap == null) {
            this.m_aLayoutMap = new LinkedHashMap();
            IReportBuilderLayouter aLayout = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.Tabular");
            this.insertIntoLayoutMap(aLayout, true);
            aLayout = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.ColumnarSingleColumn");
            this.insertIntoLayoutMap(aLayout);
            aLayout = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.ColumnarTwoColumns");
            this.insertIntoLayoutMap(aLayout);
            aLayout = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.ColumnarThreeColumns");
            this.insertIntoLayoutMap(aLayout);
            aLayout = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.InBlocksLabelsAbove");
            this.insertIntoLayoutMap(aLayout);
            aLayout = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.InBlocksLabelsLeft");
            this.insertIntoLayoutMap(aLayout);
        }
        return this.m_aLayoutMap;
    }

    @Override
    public String[][] getDataLayout() {
        String[][] ContentFiles = new String[2][];
        String[] a = new String[this.getLayoutMap().size()];
        String[] b = new String[this.getLayoutMap().size()];
        Set<String> aKeys = this.getLayoutMap().keySet();
        Iterator<String> aKeyIterator = aKeys.iterator();
        int i = 0;
        while (aKeyIterator.hasNext()) {
            String sKey;
            a[i] = sKey = aKeyIterator.next();
            IReportBuilderLayouter aLayouter = this.m_aLayoutMap.get(sKey);
            b[i++] = aLayouter.getLocalizedName();
        }
        ContentFiles[1] = a;
        ContentFiles[0] = b;
        return ContentFiles;
    }

    @Override
    public String[][] getHeaderLayout() {
        String[][] LayoutFiles;
        try {
            ArrayList<String> aReportPath = FileAccess.getOfficePaths(this.getMSF(), "Template", "share", "/wizard");
            FileAccess.combinePaths(this.getMSF(), aReportPath, "/wizard/report");
            LayoutFiles = FileAccess.getFolderTitles(this.getMSF(), null, aReportPath, ".otr");
        }
        catch (NoValidPathException e) {
            LayoutFiles = new String[2][];
            String[] a = new String[1];
            String[] b = new String[1];
            a[0] = "DefaultLayoutOfHeaders";
            b[0] = "default";
            LayoutFiles[1] = a;
            LayoutFiles[0] = b;
        }
        for (int i = 0; i < LayoutFiles[0].length; ++i) {
            if (!LayoutFiles[0][i].equals("default")) continue;
            this.m_sDefaultHeaderLayoutPath = LayoutFiles[1][i];
            break;
        }
        this.exchangeLayoutTitlesWithLocalisedOnes(LayoutFiles);
        return LayoutFiles;
    }

    private void exchangeLayoutTitlesWithLocalisedOnes(String[][] LayoutFiles) {
        for (int i = 0; i < LayoutFiles[0].length && LayoutFiles[0][i] != null; ++i) {
            if (!LayoutFiles[0][i].equals("default")) continue;
            LayoutFiles[0][i] = this.m_resource.getResText(2500);
        }
    }

    @Override
    public XReportDefinition getReportDefinition() {
        if (this.m_reportDocument == null) {
            throw new NullPointerException("Report Definition is not already initialized, check if you too early access the report definition.");
        }
        return this.m_reportDocument;
    }

    @Override
    public XMultiServiceFactory getGlobalMSF() {
        return this.getMSF();
    }

    @Override
    public void importReportData(ReportWizard aWizard) {
    }

    @Override
    public String getDefaultHeaderLayout() {
        return this.m_sDefaultHeaderLayoutPath;
    }

    @Override
    public void setCommand(String _sCommand) {
        this.getRecordParser().Command = _sCommand;
        this.getReportDefinition().setCommand(_sCommand);
    }

    @Override
    public void setCommandType(int _nCommand) {
        this.getReportDefinition().setCommandType(_nCommand);
    }

    @Override
    public void checkInvariants() throws Exception {
        String sDefaultHeaderLayoutPath = this.getDefaultHeaderLayout();
        if (sDefaultHeaderLayoutPath == null) {
            throw new IOException("default.otr");
        }
        FileAccess aAccess = new FileAccess(this.getGlobalMSF());
        if (!aAccess.exists(sDefaultHeaderLayoutPath, true)) {
            throw new IOException("default.otr");
        }
    }
}

