/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.XInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XInputStreamToInputStreamAdapter
extends InputStream {
    private XInputStream xin;

    public XInputStreamToInputStreamAdapter(XInputStream in) {
        this.xin = in;
    }

    public int available() throws IOException {
        int bytesAvail;
        try {
            bytesAvail = this.xin.available();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        return bytesAvail;
    }

    public void close() throws IOException {
        try {
            this.xin.closeInput();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public int read() throws IOException {
        byte[][] tmp = new byte[1][1];
        try {
            long bytesRead = this.xin.readBytes(tmp, 1);
            if (bytesRead <= 0L) {
                return -1;
            }
            int tmpInt = tmp[0][0];
            if (tmpInt < 0) {
                tmpInt = 256 + tmpInt;
            }
            return tmpInt;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public int read(byte[] b) throws IOException {
        int bytesRead;
        byte[][] tmp = new byte[1][b.length];
        try {
            bytesRead = this.xin.readBytes(tmp, b.length);
            if (bytesRead <= 0) {
                return -1;
            }
            if (bytesRead < b.length) {
                System.arraycopy(tmp[0], 0, b, 0, bytesRead);
            } else {
                System.arraycopy(tmp[0], 0, b, 0, b.length);
            }
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        return bytesRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        boolean count = false;
        byte[][] tmp = new byte[1][b.length];
        try {
            long bytesRead = 0L;
            int av = this.xin.available();
            bytesRead = av != 0 && len > av ? (long)this.xin.readBytes(tmp, av) : (long)this.xin.readBytes(tmp, len);
            if (bytesRead <= 0L) {
                return -1;
            }
            if (bytesRead < (long)len) {
                System.arraycopy(tmp[0], 0, b, off, (int)bytesRead);
            } else {
                System.arraycopy(tmp[0], 0, b, off, len);
            }
            return (int)bytesRead;
        }
        catch (Exception e) {
            throw new IOException("reader error: " + e.toString());
        }
    }

    public long skip(long n) throws IOException {
        int avail;
        long tmpLongVal = n;
        try {
            avail = this.xin.available();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        do {
            int tmpIntVal = tmpLongVal >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)tmpLongVal;
            tmpLongVal -= (long)tmpIntVal;
            try {
                this.xin.skipBytes(tmpIntVal);
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        } while (tmpLongVal > 0L);
        if (avail != 0 && (long)avail < n) {
            return avail;
        }
        return n;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
    }
}

