/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.EventObject;
import com.sun.star.lib.uno.helper.InterfaceContainer;
import com.sun.star.uno.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MultiTypeInterfaceContainer {
    private Map<Object, InterfaceContainer> map = new HashMap<Object, InterfaceContainer>();

    public synchronized Type[] getContainedTypes() {
        Type[] retVal = null;
        int size = this.map.size();
        if (size > 0) {
            Type[] arTypes = new Type[size];
            Iterator<Object> it = this.map.keySet().iterator();
            int countTypes = 0;
            while (it.hasNext()) {
                Object key = it.next();
                InterfaceContainer cont = this.map.get(key);
                if (cont == null || cont.size() <= 0) continue;
                if (key == null) {
                    arTypes[countTypes++] = new Type();
                    continue;
                }
                if (key instanceof Type) {
                    arTypes[countTypes++] = (Type)key;
                    continue;
                }
                if (key instanceof Class) {
                    arTypes[countTypes++] = new Type((Class)key);
                    continue;
                }
                arTypes[countTypes++] = new Type(key.getClass());
            }
            if (countTypes != size) {
                retVal = new Type[countTypes];
                System.arraycopy(arTypes, 0, retVal, 0, countTypes);
            } else {
                retVal = arTypes;
            }
        }
        if (retVal == null) {
            retVal = new Type[]{};
        }
        return retVal;
    }

    public synchronized InterfaceContainer getContainer(Object key) {
        InterfaceContainer retVal = null;
        for (Object obj : this.map.keySet()) {
            if (obj == null && key == null) {
                retVal = this.map.get(null);
                break;
            }
            if (obj == null || !obj.equals(key)) continue;
            retVal = this.map.get(obj);
            break;
        }
        return retVal;
    }

    public synchronized int addInterface(Object ckey, Object iface) {
        InterfaceContainer cont = this.map.get(ckey);
        if (cont != null) {
            cont.add(iface);
        } else {
            cont = new InterfaceContainer();
            cont.add(iface);
            this.map.put(ckey, cont);
        }
        return cont.size();
    }

    public synchronized int removeInterface(Object key, Object iface) {
        int retVal = 0;
        InterfaceContainer cont = this.map.get(key);
        if (cont != null) {
            cont.remove(iface);
            retVal = cont.size();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAndClear(EventObject evt) {
        Iterator<InterfaceContainer> it = null;
        MultiTypeInterfaceContainer multiTypeInterfaceContainer = this;
        synchronized (multiTypeInterfaceContainer) {
            it = this.map.values().iterator();
        }
        while (it.hasNext()) {
            it.next().disposeAndClear(evt);
        }
    }

    public synchronized void clear() {
        Iterator<InterfaceContainer> it = this.map.values().iterator();
        while (it.hasNext()) {
            it.next().clear();
        }
    }
}

