/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.XTypeProvider;
import com.sun.star.lib.uno.helper.WeakAdapter;
import com.sun.star.uno.Type;
import com.sun.star.uno.XAdapter;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XWeak;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WeakBase
implements XWeak,
XTypeProvider {
    private final boolean DEBUG = false;
    private WeakAdapter m_adapter;
    protected static Map<Class<?>, byte[]> _mapImplementationIds = new HashMap();
    protected static Map<Class<?>, Type[]> _mapTypes = new HashMap();

    public synchronized XAdapter queryAdapter() {
        if (this.m_adapter == null) {
            this.m_adapter = new WeakAdapter(this);
        }
        return this.m_adapter;
    }

    protected void finalize() throws Throwable {
        if (this.m_adapter != null) {
            this.m_adapter.referentDying();
        }
        super.finalize();
    }

    public Type[] getTypes() {
        Type[] arTypes = _mapTypes.get(this.getClass());
        if (arTypes == null) {
            ArrayList<Type> vec = new ArrayList<Type>();
            Class<?> currentClass = this.getClass();
            do {
                Class<?>[] interfaces = currentClass.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!XInterface.class.isAssignableFrom(interfaces[i])) continue;
                    vec.add(new Type(interfaces[i]));
                }
            } while ((currentClass = currentClass.getSuperclass()) != null);
            Type[] types = vec.toArray(new Type[vec.size()]);
            _mapTypes.put(this.getClass(), types);
            arTypes = types;
        }
        return arTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getImplementationId() {
        byte[] id = null;
        Map<Class<?>, byte[]> map = _mapImplementationIds;
        synchronized (map) {
            id = _mapImplementationIds.get(this.getClass());
            if (id == null) {
                int hash = this.hashCode();
                String sName = this.getClass().getName();
                byte[] arName = sName.getBytes();
                int nNameLength = arName.length;
                id = new byte[4 + nNameLength];
                id[0] = (byte)(hash & 0xFF);
                id[1] = (byte)(hash >>> 8 & 0xFF);
                id[2] = (byte)(hash >>> 16 & 0xFF);
                id[3] = (byte)(hash >>> 24 & 0xFF);
                for (int i = 0; i < nNameLength; ++i) {
                    id[4 + i] = arName[i];
                }
                _mapImplementationIds.put(this.getClass(), id);
            }
        }
        return id;
    }
}

