/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.loader;

import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.loader.JavaLoaderFactory;
import com.sun.star.comp.loader.RegistrationClassFinder;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lib.util.StringHelper;
import com.sun.star.loader.CannotActivateFactoryException;
import com.sun.star.loader.XImplementationLoader;
import com.sun.star.registry.CannotRegisterImplementationException;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XMacroExpander;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URLDecoder;

public class JavaLoader
implements XImplementationLoader,
XServiceInfo,
XInitialization {
    private static final boolean DEBUG = false;
    private static String[] supportedServices = new String[]{"com.sun.star.loader.Java"};
    protected XMultiServiceFactory multiServiceFactory = null;
    private XMacroExpander m_xMacroExpander = null;
    private static final String EXPAND_PROTOCOL_PREFIX = "vnd.sun.star.expand:";

    private static final void DEBUG(String dbg) {
    }

    private String expand_url(String url) throws java.lang.RuntimeException {
        if (url != null && url.startsWith(EXPAND_PROTOCOL_PREFIX)) {
            try {
                if (this.m_xMacroExpander == null) {
                    XPropertySet xProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.multiServiceFactory);
                    if (xProps == null) {
                        throw new RuntimeException("service manager does not support XPropertySet!", this);
                    }
                    XComponentContext xContext = (XComponentContext)AnyConverter.toObject(new Type(XComponentContext.class), xProps.getPropertyValue("DefaultContext"));
                    this.m_xMacroExpander = (XMacroExpander)AnyConverter.toObject(new Type(XMacroExpander.class), xContext.getValueByName("/singletons/com.sun.star.util.theMacroExpander"));
                }
                String macro = URLDecoder.decode(StringHelper.replace(url.substring(EXPAND_PROTOCOL_PREFIX.length()), '+', "%2B"));
                String ret = this.m_xMacroExpander.expandMacros(macro);
                return ret;
            }
            catch (com.sun.star.uno.Exception exc) {
                throw new RuntimeException(exc.getMessage(), this);
            }
            catch (Exception exc) {
                throw new RuntimeException(exc.getMessage(), this);
            }
        }
        return url;
    }

    public JavaLoader() {
    }

    public JavaLoader(XMultiServiceFactory factory) {
        this.multiServiceFactory = factory;
    }

    public void initialize(Object[] args) throws com.sun.star.uno.Exception, RuntimeException {
        if (args.length == 0) {
            throw new IllegalArgumentException("No arguments specified");
        }
        try {
            this.multiServiceFactory = (XMultiServiceFactory)AnyConverter.toObject(new Type(XMultiServiceFactory.class), args[0]);
        }
        catch (ClassCastException castEx) {
            throw new IllegalArgumentException("The argument must be an instance of XMultiServiceFactory");
        }
    }

    public String getImplementationName() throws RuntimeException {
        return this.getClass().getName();
    }

    public boolean supportsService(String serviceName) throws RuntimeException {
        for (int i = 0; i < supportedServices.length; ++i) {
            if (!supportedServices[i].equals(serviceName)) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() throws RuntimeException {
        return supportedServices;
    }

    public Object activate(String implementationName, String implementationLoaderUrl, String locationUrl, XRegistryKey xKey) throws CannotActivateFactoryException, RuntimeException {
        Class<?> clazz;
        locationUrl = this.expand_url(locationUrl);
        Object returnObject = null;
        JavaLoader.DEBUG("try to get factory for " + implementationName);
        try {
            if (locationUrl != null) {
                clazz = RegistrationClassFinder.find(locationUrl);
                if (clazz == null) {
                    throw new CannotActivateFactoryException("Cannot activate jar " + locationUrl);
                }
            } else {
                clazz = Class.forName(implementationName);
                if (clazz == null) {
                    throw new CannotActivateFactoryException("Cannot find class " + implementationName);
                }
            }
        }
        catch (MalformedURLException e) {
            CannotActivateFactoryException cae = new CannotActivateFactoryException("Can not activate factory because " + e);
            cae.initCause(e);
            throw cae;
        }
        catch (IOException e) {
            CannotActivateFactoryException cae = new CannotActivateFactoryException("Can not activate factory because " + e);
            cae.initCause(e);
            throw cae;
        }
        catch (ClassNotFoundException e) {
            CannotActivateFactoryException cae = new CannotActivateFactoryException("Can not activate factory because " + e);
            cae.initCause(e);
            throw cae;
        }
        Class[] paramTypes = new Class[]{String.class, XMultiServiceFactory.class, XRegistryKey.class};
        Object[] params = new Object[]{implementationName, this.multiServiceFactory, xKey};
        Method compfac_method = null;
        try {
            compfac_method = clazz.getMethod("__getComponentFactory", String.class);
        }
        catch (NoSuchMethodException noSuchMethodEx) {
        }
        catch (SecurityException secEx) {
            // empty catch block
        }
        Method method = null;
        if (null == compfac_method) {
            try {
                method = clazz.getMethod("__getServiceFactory", paramTypes);
            }
            catch (NoSuchMethodException noSuchMethodEx) {
                method = null;
            }
            catch (SecurityException secEx) {
                method = null;
            }
        }
        try {
            Object oRet;
            if (null != compfac_method) {
                Object ret = compfac_method.invoke(clazz, implementationName);
                if (null == ret || !(ret instanceof XSingleComponentFactory)) {
                    throw new CannotActivateFactoryException("No factory object for " + implementationName);
                }
                return ret;
            }
            if (method == null) {
                method = clazz.getMethod("getServiceFactory", paramTypes);
            }
            if ((oRet = method.invoke(clazz, params)) != null && oRet instanceof XSingleServiceFactory) {
                returnObject = oRet;
            }
        }
        catch (NoSuchMethodException e) {
            throw new CannotActivateFactoryException("Can not activate the factory for " + implementationName + " because " + e.toString());
        }
        catch (SecurityException e) {
            throw new CannotActivateFactoryException("Can not activate the factory for " + implementationName + " because " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new CannotActivateFactoryException("Can not activate the factory for " + implementationName + " because " + e.toString());
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new CannotActivateFactoryException("Can not activate the factory for " + implementationName + " because " + e.toString());
        }
        catch (InvocationTargetException e) {
            throw new CannotActivateFactoryException("Can not activate the factory for " + implementationName + " because " + e.getTargetException().toString());
        }
        return returnObject;
    }

    public boolean writeRegistryInfo(XRegistryKey regKey, String implementationLoaderUrl, String locationUrl) throws CannotRegisterImplementationException, RuntimeException {
        locationUrl = this.expand_url(locationUrl);
        boolean success = false;
        try {
            Class<?> clazz = RegistrationClassFinder.find(locationUrl);
            if (null == clazz) {
                throw new CannotRegisterImplementationException("Cannot determine registration class!");
            }
            Class[] paramTypes = new Class[]{XRegistryKey.class};
            Object[] params = new Object[]{regKey};
            Method method = clazz.getMethod("__writeRegistryServiceInfo", paramTypes);
            Object oRet = method.invoke(clazz, params);
            if (oRet != null && oRet instanceof Boolean) {
                success = (Boolean)oRet;
            }
        }
        catch (Exception e) {
            CannotRegisterImplementationException e2 = new CannotRegisterImplementationException(e.toString());
            e2.initCause(e);
            throw e2;
        }
        return success;
    }

    public static XSingleServiceFactory getServiceFactory(String implName, XMultiServiceFactory multiFactory, XRegistryKey regKey) {
        if (implName.equals(JavaLoader.class.getName())) {
            return new JavaLoaderFactory(multiFactory);
        }
        return null;
    }

    public static boolean writeRegistryServiceInfo(XRegistryKey regKey) {
        boolean result = false;
        try {
            XRegistryKey newKey = regKey.createKey("/" + JavaLoader.class.getName() + "/UNO/SERVICE");
            for (int i = 0; i < supportedServices.length; ++i) {
                newKey.createKey(supportedServices[i]);
            }
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

