/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.loader;

import com.sun.star.lib.unoloader.UnoClassLoader;
import com.sun.star.lib.util.WeakMap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.jar.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RegistrationClassFinder {
    private static final WeakMap map = new WeakMap();
    private static final String[] accessPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> find(String locationUrl) throws ClassNotFoundException, IOException {
        String name;
        WeakMap weakMap = map;
        synchronized (weakMap) {
            Class c = (Class)WeakMap.getValue(map.get(locationUrl));
            if (c != null) {
                return c;
            }
        }
        URL url = new URL(locationUrl);
        RegistrationClassFinder.checkAccess(url);
        Attributes attr = UnoClassLoader.getJarMainAttributes(url);
        String string = name = attr == null ? null : attr.getValue("RegistrationClassName");
        if (name == null) {
            return null;
        }
        ClassLoader cl1 = RegistrationClassFinder.class.getClassLoader();
        ClassLoader cl2 = cl1 instanceof UnoClassLoader ? ((UnoClassLoader)cl1).getClassLoader(url, attr) : URLClassLoader.newInstance(new URL[]{url}, cl1);
        Class<?> c = cl2.loadClass(name);
        WeakMap weakMap2 = map;
        synchronized (weakMap2) {
            Class c2 = (Class)WeakMap.getValue(map.get(locationUrl));
            if (c2 != null) {
                return c2;
            }
            map.put(locationUrl, c);
        }
        return c;
    }

    private RegistrationClassFinder() {
    }

    private static void checkAccess(URL url) throws ClassNotFoundException {
        if (accessPath != null) {
            String p;
            if (!url.getProtocol().equals("file")) {
                throw new ClassNotFoundException("Access restriction: <" + url + "> is not a file URL");
            }
            try {
                p = new File(url.getFile()).getCanonicalPath();
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Access restriction: <" + url + "> is bad: " + e);
            }
            for (int i = 0; i < accessPath.length; ++i) {
                String p2 = accessPath[i];
                if (!p.startsWith(p2) || p.length() <= p2.length() || p2.charAt(p2.length() - 1) != File.separatorChar && p.charAt(p2.length()) != File.separatorChar) continue;
                return;
            }
            throw new ClassNotFoundException("Access restriction: <" + url + "> is restricted");
        }
    }

    static {
        String[] ap = null;
        String p = System.getProperty("com.sun.star.comp.loader.CPLD_ACCESSPATH");
        if (p != null) {
            StringTokenizer t = new StringTokenizer(p, ";");
            ap = new String[t.countTokens()];
            int i = 0;
            while (t.hasMoreTokens()) {
                try {
                    ap[i] = new File(t.nextToken()).getCanonicalPath();
                    ++i;
                }
                catch (IOException e) {}
            }
            if (i != ap.length) {
                String[] ap2 = new String[i];
                System.arraycopy(ap, 0, ap2, 0, i);
                ap = ap2;
            }
        }
        accessPath = ap;
    }
}

