/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.servicemanager;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XContentEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XSet;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

public class ServiceManager
implements XMultiServiceFactory,
XMultiComponentFactory,
XSet,
XContentEnumerationAccess,
XComponent,
XServiceInfo {
    private static final boolean DEBUG = false;
    private static Type UNO_TYPE = null;
    static String[] supportedServiceNames = new String[]{"com.sun.star.lang.MultiServiceFactory", "com.sun.star.lang.ServiceManager"};
    ArrayList<XEventListener> eventListener = new ArrayList();
    HashMap<String, Object> factoriesByImplNames = new HashMap();
    HashMap<String, ArrayList<Object>> factoriesByServiceNames = new HashMap();
    private XComponentContext m_xDefaultContext = null;

    private static final void DEBUG(String dbg) {
    }

    public void setDefaultContext(XComponentContext context) {
        this.m_xDefaultContext = context;
    }

    public Object createInstance(String serviceSpecifier) throws Exception, RuntimeException {
        return this.createInstanceWithContext(serviceSpecifier, this.m_xDefaultContext);
    }

    public Object createInstanceWithArguments(String serviceSpecifier, Object[] args) throws Exception, RuntimeException {
        return this.createInstanceWithArgumentsAndContext(serviceSpecifier, args, this.m_xDefaultContext);
    }

    private Object queryServiceFactory(String serviceName) throws Exception, RuntimeException {
        ServiceManager.DEBUG("queryServiceFactory for name " + serviceName);
        Object factory = null;
        if (this.factoriesByServiceNames.containsKey(serviceName)) {
            ArrayList<Object> availableFact = this.factoriesByServiceNames.get(serviceName);
            ServiceManager.DEBUG("");
            ServiceManager.DEBUG("aviable factories for " + serviceName + " " + availableFact);
            ServiceManager.DEBUG("");
            if (!availableFact.isEmpty()) {
                factory = availableFact.get(availableFact.size() - 1);
            }
        } else {
            factory = this.factoriesByImplNames.get(serviceName);
        }
        if (factory == null) {
            throw new Exception("Query for service factory for " + serviceName + " failed.");
        }
        return factory;
    }

    public String[] getAvailableServiceNames() throws RuntimeException {
        int i = 0;
        String[] availableServiceNames = new String[this.factoriesByServiceNames.size()];
        Iterator<String> keys = this.factoriesByServiceNames.keySet().iterator();
        while (keys.hasNext()) {
            availableServiceNames[i++] = keys.next();
        }
        return availableServiceNames;
    }

    public Object createInstanceWithContext(String rServiceSpecifier, XComponentContext xContext) throws Exception {
        Object fac = this.queryServiceFactory(rServiceSpecifier);
        if (fac != null) {
            XSingleComponentFactory xCompFac = UnoRuntime.queryInterface(XSingleComponentFactory.class, fac);
            if (xCompFac != null) {
                return xCompFac.createInstanceWithContext(xContext);
            }
            XSingleServiceFactory xServiceFac = UnoRuntime.queryInterface(XSingleServiceFactory.class, fac);
            if (xServiceFac != null) {
                return xServiceFac.createInstance();
            }
            throw new Exception("retrieved service factory object for \"" + rServiceSpecifier + "\" does not export XSingleComponentFactory nor XSingleServiceFactory!");
        }
        return null;
    }

    public Object createInstanceWithArgumentsAndContext(String rServiceSpecifier, Object[] rArguments, XComponentContext xContext) throws Exception {
        Object fac = this.queryServiceFactory(rServiceSpecifier);
        if (fac != null) {
            XSingleComponentFactory xCompFac = UnoRuntime.queryInterface(XSingleComponentFactory.class, fac);
            if (xCompFac != null) {
                return xCompFac.createInstanceWithArgumentsAndContext(rArguments, xContext);
            }
            XSingleServiceFactory xServiceFac = UnoRuntime.queryInterface(XSingleServiceFactory.class, fac);
            if (xServiceFac != null) {
                return xServiceFac.createInstanceWithArguments(rArguments);
            }
            throw new Exception("retrieved service factory object for \"" + rServiceSpecifier + "\" does not export XSingleComponentFactory nor XSingleServiceFactory!");
        }
        return null;
    }

    public void dispose() throws RuntimeException {
        if (this.eventListener != null) {
            for (XEventListener listener : this.eventListener) {
                listener.disposing(new EventObject(this));
            }
            this.eventListener.clear();
        }
        this.factoriesByServiceNames.clear();
        this.factoriesByImplNames.clear();
    }

    public void addEventListener(XEventListener xListener) throws RuntimeException {
        if (xListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (this.eventListener.contains(xListener)) {
            throw new RuntimeException("Listener already registred.");
        }
        this.eventListener.add(xListener);
    }

    public void removeEventListener(XEventListener xListener) throws RuntimeException {
        if (xListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (!this.eventListener.contains(xListener)) {
            throw new RuntimeException("Listener is not registered.");
        }
        this.eventListener.remove(xListener);
    }

    public boolean has(Object object) throws RuntimeException {
        if (object == null) {
            throw new RuntimeException("The parameter must not been null");
        }
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, object);
        return xServiceInfo != null && UnoRuntime.areSame(this.factoriesByImplNames.get(xServiceInfo.getImplementationName()), object);
    }

    public void insert(Object object) throws IllegalArgumentException, ElementExistException, RuntimeException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, object);
        if (xServiceInfo == null) {
            throw new IllegalArgumentException("The given object does not implement the XServiceInfo interface.");
        }
        if (this.factoriesByImplNames.containsKey(xServiceInfo.getImplementationName())) {
            throw new ElementExistException(xServiceInfo.getImplementationName() + " already registred");
        }
        ServiceManager.DEBUG("add factory " + object.toString() + " for " + xServiceInfo.getImplementationName());
        this.factoriesByImplNames.put(xServiceInfo.getImplementationName(), object);
        String[] serviceNames = xServiceInfo.getSupportedServiceNames();
        for (int i = 0; i < serviceNames.length; ++i) {
            ArrayList<Object> vec;
            if (!this.factoriesByServiceNames.containsKey(serviceNames[i])) {
                ServiceManager.DEBUG("> no registered services found under " + serviceNames[i] + ": adding...");
                this.factoriesByServiceNames.put(serviceNames[i], new ArrayList());
            }
            if ((vec = this.factoriesByServiceNames.get(serviceNames[i])).contains(object)) {
                System.err.println("The implementation " + xServiceInfo.getImplementationName() + " already registered for the service " + serviceNames[i] + " - ignoring!");
                continue;
            }
            vec.add(object);
        }
    }

    public void remove(Object object) throws IllegalArgumentException, NoSuchElementException, RuntimeException {
        if (object == null) {
            throw new IllegalArgumentException("The given object must not be null.");
        }
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, object);
        if (xServiceInfo == null) {
            throw new IllegalArgumentException("The given object does not implement the XServiceInfo interface.");
        }
        XSingleServiceFactory xSingleServiceFactory = UnoRuntime.queryInterface(XSingleServiceFactory.class, object);
        if (xSingleServiceFactory == null) {
            throw new IllegalArgumentException("The given object does not implement the XSingleServiceFactory interface.");
        }
        if (this.factoriesByImplNames.remove(xServiceInfo.getImplementationName()) == null) {
            throw new NoSuchElementException(xServiceInfo.getImplementationName() + " is not registered as an implementation.");
        }
        String[] serviceNames = xServiceInfo.getSupportedServiceNames();
        for (int i = 0; i < serviceNames.length; ++i) {
            if (!this.factoriesByServiceNames.containsKey(serviceNames[i])) continue;
            ArrayList<Object> vec = this.factoriesByServiceNames.get(serviceNames[i]);
            if (!vec.remove(object)) {
                System.err.println("The implementation " + xServiceInfo.getImplementationName() + " is not registered for the service " + serviceNames[i] + " - ignoring!");
            }
            if (!vec.isEmpty()) continue;
            this.factoriesByServiceNames.remove(serviceNames[i]);
        }
    }

    public XEnumeration createEnumeration() throws RuntimeException {
        return new ServiceEnumerationImpl(this.factoriesByImplNames.values().iterator());
    }

    public Type getElementType() throws RuntimeException {
        if (UNO_TYPE == null) {
            UNO_TYPE = new Type(ServiceManager.class);
        }
        return UNO_TYPE;
    }

    public boolean hasElements() {
        return !this.factoriesByImplNames.isEmpty();
    }

    public XEnumeration createContentEnumeration(String serviceName) throws RuntimeException {
        ArrayList<Object> serviceList = this.factoriesByServiceNames.get(serviceName);
        ServiceEnumerationImpl enumer = serviceList != null ? new ServiceEnumerationImpl(serviceList.iterator()) : new ServiceEnumerationImpl();
        return enumer;
    }

    public String getImplementationName() throws RuntimeException {
        return this.getClass().getName();
    }

    public boolean supportsService(String serviceName) throws RuntimeException {
        for (int i = 0; i < supportedServiceNames.length; ++i) {
            if (!supportedServiceNames[i].equals(serviceName)) continue;
            return true;
        }
        return this.getImplementationName().equals(serviceName);
    }

    public String[] getSupportedServiceNames() throws RuntimeException {
        return supportedServiceNames;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServiceEnumerationImpl
    implements XEnumeration {
        Iterator<Object> enumeration = null;

        public ServiceEnumerationImpl() {
        }

        public ServiceEnumerationImpl(Enumeration<Object> enumer) {
            this.enumeration = Collections.list(enumer).iterator();
        }

        public ServiceEnumerationImpl(Iterator<Object> enumer) {
            this.enumeration = enumer;
        }

        @Override
        public boolean hasMoreElements() throws RuntimeException {
            return this.enumeration != null && this.enumeration.hasNext();
        }

        @Override
        public Object nextElement() throws NoSuchElementException, WrappedTargetException, RuntimeException {
            if (this.enumeration == null) {
                throw new NoSuchElementException();
            }
            try {
                return this.enumeration.next();
            }
            catch (java.util.NoSuchElementException e) {
                NoSuchElementException ex = new NoSuchElementException(e.toString());
                ex.initCause(e);
                throw ex;
            }
        }
    }
}

