/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.uno.UnoRuntime;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;

public final class ThreadId {
    private static final String PREFIX = "java:" + UnoRuntime.getUniqueKey() + ":";
    private static BigInteger count = BigInteger.ZERO;
    private byte[] id;
    private int hash = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadId createFresh() {
        BigInteger c;
        String string = PREFIX;
        synchronized (string) {
            c = count;
            count = count.add(BigInteger.ONE);
        }
        try {
            return new ThreadId((PREFIX + c).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("this cannot happen: " + e);
        }
    }

    public ThreadId(byte[] id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        return obj instanceof ThreadId && Arrays.equals(this.id, ((ThreadId)obj).id);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 1;
            for (int i = 0; i < this.id.length; ++i) {
                h = 31 * h + this.id[i];
            }
            this.hash = h;
        }
        return h;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("[ThreadId:");
        for (int i = 0; i < this.id.length; ++i) {
            String n = Integer.toHexString(this.id[i] & 0xFF);
            if (n.length() == 1) {
                b.append('0');
            }
            b.append(n);
        }
        b.append(']');
        return b.toString();
    }

    public byte[] getBytes() {
        return this.id;
    }
}

