/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.protocols.urp.Cache;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.Enum;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IFieldDescription;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XInterface;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

final class Marshal {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final DataOutput output = new DataOutputStream(this.buffer);
    private final IBridge bridge;
    private final Cache objectIdCache;
    private final Cache threadIdCache;
    private final Cache typeCache;

    public Marshal(IBridge bridge, short cacheSize) {
        this.bridge = bridge;
        this.objectIdCache = new Cache(cacheSize);
        this.threadIdCache = new Cache(cacheSize);
        this.typeCache = new Cache(cacheSize);
    }

    public void write8Bit(int value) {
        try {
            this.output.writeByte(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void write16Bit(int value) {
        try {
            this.output.writeShort(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void writeObjectId(String objectId) {
        if (objectId == null) {
            this.writeStringValue(null);
            this.write16Bit(65535);
        } else {
            boolean[] found = new boolean[1];
            int index = this.objectIdCache.add(found, objectId);
            this.writeStringValue(found[0] ? null : objectId);
            this.write16Bit(index);
        }
    }

    public void writeInterface(XInterface object, Type type) {
        this.writeObjectId((String)this.bridge.mapInterfaceTo(object, type));
    }

    public void writeThreadId(ThreadId threadId) {
        byte[] data = threadId.getBytes();
        boolean[] found = new boolean[1];
        int index = this.threadIdCache.add(found, data);
        if (found[0]) {
            this.writeCompressedNumber(0);
        } else {
            this.writeCompressedNumber(data.length);
            this.writeBytes(data);
        }
        this.write16Bit(index);
    }

    public void writeType(TypeDescription type) {
        TypeClass typeClass = type.getTypeClass();
        if (TypeDescription.isTypeClassSimple(typeClass)) {
            this.write8Bit(typeClass.getValue());
        } else {
            boolean[] found = new boolean[1];
            int index = this.typeCache.add(found, type.getTypeName());
            this.write8Bit(typeClass.getValue() | (found[0] ? 0 : 128));
            this.write16Bit(index);
            if (!found[0]) {
                this.writeStringValue(type.getTypeName());
            }
        }
    }

    public void writeValue(TypeDescription type, Object value) {
        switch (type.getTypeClass().getValue()) {
            case 0: {
                break;
            }
            case 2: {
                this.writeBooleanValue((Boolean)value);
                break;
            }
            case 3: {
                this.writeByteValue((Byte)value);
                break;
            }
            case 4: 
            case 5: {
                this.writeShortValue((Short)value);
                break;
            }
            case 6: 
            case 7: {
                this.writeLongValue((Integer)value);
                break;
            }
            case 8: 
            case 9: {
                this.writeHyperValue((Long)value);
                break;
            }
            case 10: {
                this.writeFloatValue((Float)value);
                break;
            }
            case 11: {
                this.writeDoubleValue((Double)value);
                break;
            }
            case 1: {
                this.writeCharValue((Character)value);
                break;
            }
            case 12: {
                this.writeStringValue((String)value);
                break;
            }
            case 13: {
                this.writeTypeValue((Type)value);
                break;
            }
            case 14: {
                this.writeAnyValue(value);
                break;
            }
            case 20: {
                this.writeSequenceValue(type, value);
                break;
            }
            case 15: {
                this.writeEnumValue(type, (Enum)value);
                break;
            }
            case 17: {
                this.writeStructValue(type, value);
                break;
            }
            case 19: {
                this.writeExceptionValue(type, (Exception)value);
                break;
            }
            case 22: {
                this.writeInterfaceValue(type, (XInterface)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad type descriptor " + type);
            }
        }
    }

    public byte[] reset() {
        byte[] data = this.buffer.toByteArray();
        this.buffer.reset();
        return data;
    }

    private void writeBooleanValue(Boolean value) {
        try {
            this.output.writeBoolean(value != null && value != false);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void writeByteValue(Byte value) {
        this.write8Bit(value == null ? (byte)0 : value);
    }

    private void writeShortValue(Short value) {
        this.write16Bit(value == null ? (short)0 : value);
    }

    private void writeLongValue(Integer value) {
        this.write32Bit(value == null ? 0 : value);
    }

    private void writeHyperValue(Long value) {
        try {
            this.output.writeLong(value == null ? 0L : value);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void writeFloatValue(Float value) {
        try {
            this.output.writeFloat(value == null ? 0.0f : value.floatValue());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void writeDoubleValue(Double value) {
        try {
            this.output.writeDouble(value == null ? 0.0 : value);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void writeCharValue(Character value) {
        try {
            this.output.writeChar(value == null ? (char)'\u0000' : value.charValue());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void writeStringValue(String value) {
        if (value == null) {
            this.writeCompressedNumber(0);
        } else {
            byte[] data;
            try {
                data = value.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.toString());
            }
            this.writeCompressedNumber(data.length);
            this.writeBytes(data);
        }
    }

    private void writeTypeValue(Type value) {
        try {
            this.writeType(TypeDescription.getTypeDescription(value == null ? Type.VOID : value));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void writeAnyValue(Object value) {
        TypeDescription type;
        if (value == null || value instanceof XInterface) {
            type = TypeDescription.getTypeDescription(XInterface.class);
        } else if (value instanceof Any) {
            Any any = (Any)value;
            try {
                type = TypeDescription.getTypeDescription(any.getType());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.toString());
            }
            value = any.getObject();
        } else {
            if (value.getClass() == Object.class) {
                throw new IllegalArgumentException("Object instance does not represent UNO value");
            }
            type = TypeDescription.getTypeDescription(value.getClass());
        }
        this.writeType(type);
        this.writeValue(type, value);
    }

    private void writeSequenceValue(TypeDescription type, Object value) {
        if (value == null) {
            this.writeCompressedNumber(0);
        } else {
            TypeDescription ctype = (TypeDescription)type.getComponentType();
            if (ctype.getTypeClass() == TypeClass.BYTE) {
                byte[] data = (byte[])value;
                this.writeCompressedNumber(data.length);
                this.writeBytes(data);
            } else {
                int len = Array.getLength(value);
                this.writeCompressedNumber(len);
                for (int i = 0; i < len; ++i) {
                    this.writeValue(ctype, Array.get(value, i));
                }
            }
        }
    }

    private void writeEnumValue(TypeDescription type, Enum value) {
        int n;
        if (value == null) {
            try {
                n = ((Enum)type.getZClass().getMethod("getDefault", null).invoke(null, (Object[])null)).getValue();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.toString());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.toString());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e.toString());
            }
        } else {
            n = value.getValue();
        }
        this.write32Bit(n);
    }

    private void writeStructValue(TypeDescription type, Object value) {
        IFieldDescription[] fields = type.getFieldDescriptions();
        for (int i = 0; i < fields.length; ++i) {
            try {
                this.writeValue((TypeDescription)fields[i].getTypeDescription(), value == null ? null : fields[i].getField().get(value));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    private void writeExceptionValue(TypeDescription type, Exception value) {
        this.writeStringValue(value == null ? null : value.getMessage());
        this.writeStructValue(type, value);
    }

    private void writeInterfaceValue(TypeDescription type, XInterface value) {
        this.writeInterface(value, new Type(type));
    }

    private void write32Bit(int value) {
        try {
            this.output.writeInt(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void writeCompressedNumber(int number) {
        if (number >= 0 && number < 255) {
            this.write8Bit(number);
        } else {
            this.write8Bit(255);
            this.write32Bit(number);
        }
    }

    private void writeBytes(byte[] data) {
        try {
            this.output.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

