/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.Enum;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IFieldDescription;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XInterface;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

final class Unmarshal {
    private final IBridge bridge;
    private final String[] objectIdCache;
    private final ThreadId[] threadIdCache;
    private final TypeDescription[] typeCache;
    private DataInputStream input;

    public Unmarshal(IBridge bridge, int cacheSize) {
        this.bridge = bridge;
        this.objectIdCache = new String[cacheSize];
        this.threadIdCache = new ThreadId[cacheSize];
        this.typeCache = new TypeDescription[cacheSize];
        this.reset(new byte[0]);
    }

    public int read8Bit() {
        try {
            return this.input.readUnsignedByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public int read16Bit() {
        try {
            return this.input.readUnsignedShort();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public String readObjectId() {
        String id = this.readStringValue();
        int index = this.read16Bit();
        if (index == 65535) {
            if (id.length() == 0) {
                id = null;
            }
        } else if (id.length() == 0) {
            id = this.objectIdCache[index];
        } else {
            this.objectIdCache[index] = id;
        }
        return id;
    }

    public Object readInterface(Type type) {
        String id = this.readObjectId();
        return id == null ? null : this.bridge.mapInterfaceFrom(id, type);
    }

    public ThreadId readThreadId() {
        int index;
        int len = this.readCompressedNumber();
        ThreadId id = null;
        if (len != 0) {
            byte[] data = new byte[len];
            this.readBytes(data);
            id = new ThreadId(data);
        }
        if ((index = this.read16Bit()) != 65535) {
            if (len == 0) {
                id = this.threadIdCache[index];
            } else {
                this.threadIdCache[index] = id;
            }
        }
        return id;
    }

    public TypeDescription readType() {
        int b = this.read8Bit();
        TypeClass typeClass = TypeClass.fromInt(b & 0x7F);
        if (TypeDescription.isTypeClassSimple(typeClass)) {
            return TypeDescription.getTypeDescription(typeClass);
        }
        int index = this.read16Bit();
        TypeDescription type = null;
        if ((b & 0x80) != 0) {
            try {
                type = TypeDescription.getTypeDescription(this.readStringValue());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.toString());
            }
        }
        if (index != 65535) {
            if ((b & 0x80) == 0) {
                type = this.typeCache[index];
            } else {
                this.typeCache[index] = type;
            }
        }
        return type;
    }

    public Object readValue(TypeDescription type) {
        switch (type.getTypeClass().getValue()) {
            case 0: {
                return null;
            }
            case 2: {
                return this.readBooleanValue();
            }
            case 3: {
                return this.readByteValue();
            }
            case 4: 
            case 5: {
                return this.readShortValue();
            }
            case 6: 
            case 7: {
                return this.readLongValue();
            }
            case 8: 
            case 9: {
                return this.readHyperValue();
            }
            case 10: {
                return this.readFloatValue();
            }
            case 11: {
                return this.readDoubleValue();
            }
            case 1: {
                return this.readCharValue();
            }
            case 12: {
                return this.readStringValue();
            }
            case 13: {
                return this.readTypeValue();
            }
            case 14: {
                return this.readAnyValue();
            }
            case 20: {
                return this.readSequenceValue(type);
            }
            case 15: {
                return this.readEnumValue(type);
            }
            case 17: {
                return this.readStructValue(type);
            }
            case 19: {
                return this.readExceptionValue(type);
            }
            case 22: {
                return this.readInterfaceValue(type);
            }
        }
        throw new IllegalArgumentException("Bad type descriptor " + type);
    }

    public boolean hasMore() {
        try {
            return this.input.available() > 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void reset(byte[] data) {
        this.input = new DataInputStream(new ByteArrayInputStream(data));
    }

    private Boolean readBooleanValue() {
        try {
            return this.input.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private Byte readByteValue() {
        try {
            return new Byte(this.input.readByte());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private Short readShortValue() {
        try {
            return new Short(this.input.readShort());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private Integer readLongValue() {
        try {
            return new Integer(this.input.readInt());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private Long readHyperValue() {
        try {
            return new Long(this.input.readLong());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private Float readFloatValue() {
        try {
            return new Float(this.input.readFloat());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private Double readDoubleValue() {
        try {
            return new Double(this.input.readDouble());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private Character readCharValue() {
        try {
            return new Character(this.input.readChar());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private String readStringValue() {
        int len = this.readCompressedNumber();
        byte[] data = new byte[len];
        this.readBytes(data);
        try {
            return new String(data, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private Type readTypeValue() {
        return new Type(this.readType());
    }

    private Object readAnyValue() {
        TypeDescription type = this.readType();
        switch (type.getTypeClass().getValue()) {
            case 0: {
                return Any.VOID;
            }
            case 2: {
                return this.readBooleanValue();
            }
            case 3: {
                return this.readByteValue();
            }
            case 4: {
                return this.readShortValue();
            }
            case 5: {
                return new Any(Type.UNSIGNED_SHORT, (Object)this.readShortValue());
            }
            case 6: {
                return this.readLongValue();
            }
            case 7: {
                return new Any(Type.UNSIGNED_LONG, (Object)this.readLongValue());
            }
            case 8: {
                return this.readHyperValue();
            }
            case 9: {
                return new Any(Type.UNSIGNED_HYPER, (Object)this.readHyperValue());
            }
            case 10: {
                return this.readFloatValue();
            }
            case 11: {
                return this.readDoubleValue();
            }
            case 1: {
                return this.readCharValue();
            }
            case 12: {
                return this.readStringValue();
            }
            case 13: {
                return this.readTypeValue();
            }
            case 20: {
                Object value = this.readSequenceValue(type);
                TypeDescription ctype = (TypeDescription)type.getComponentType();
                while (ctype.getTypeClass() == TypeClass.SEQUENCE) {
                    ctype = (TypeDescription)ctype.getComponentType();
                }
                switch (ctype.getTypeClass().getValue()) {
                    case 5: 
                    case 7: 
                    case 9: {
                        return new Any(new Type(type), value);
                    }
                    case 17: {
                        if (!ctype.hasTypeArguments()) break;
                        return new Any(new Type(type), value);
                    }
                }
                return value;
            }
            case 15: {
                return this.readEnumValue(type);
            }
            case 17: {
                Object value = this.readStructValue(type);
                return type.hasTypeArguments() ? new Any(new Type(type), value) : value;
            }
            case 19: {
                return this.readExceptionValue(type);
            }
            case 22: {
                Object value = this.readInterfaceValue(type);
                return type.getZClass() == XInterface.class ? value : new Any(new Type(type), value);
            }
        }
        throw new RuntimeException("Reading ANY with bad type " + type.getTypeClass());
    }

    private Object readSequenceValue(TypeDescription type) {
        int len = this.readCompressedNumber();
        TypeDescription ctype = (TypeDescription)type.getComponentType();
        if (ctype.getTypeClass() == TypeClass.BYTE) {
            byte[] data = new byte[len];
            this.readBytes(data);
            return data;
        }
        Object value = Array.newInstance(ctype.getTypeClass() == TypeClass.ANY ? Object.class : ctype.getZClass(), len);
        for (int i = 0; i < len; ++i) {
            Array.set(value, i, this.readValue(ctype));
        }
        return value;
    }

    private Enum readEnumValue(TypeDescription type) {
        try {
            return (Enum)type.getZClass().getMethod("fromInt", Integer.TYPE).invoke(null, this.readLongValue());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private Object readStructValue(TypeDescription type) {
        Object value;
        try {
            value = type.getZClass().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.toString());
        }
        this.readFields(type, value);
        return value;
    }

    private Exception readExceptionValue(TypeDescription type) {
        Exception value;
        try {
            value = (Exception)type.getZClass().getConstructor(String.class).newInstance(this.readStringValue());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.toString());
        }
        this.readFields(type, value);
        return value;
    }

    private Object readInterfaceValue(TypeDescription type) {
        return this.readInterface(new Type(type));
    }

    private int readCompressedNumber() {
        int number = this.read8Bit();
        try {
            return number < 255 ? number : this.input.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void readBytes(byte[] data) {
        try {
            this.input.readFully(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void readFields(TypeDescription type, Object value) {
        IFieldDescription[] fields = type.getFieldDescriptions();
        for (int i = 0; i < fields.length; ++i) {
            try {
                fields[i].getField().set(value, this.readValue((TypeDescription)fields[i].getTypeDescription()));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }
}

