/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.util;

import com.sun.star.lib.util.StringHelper;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class UrlToFileMapper {
    private static Method urlEncoderEncode;
    private static Constructor<?> uriConstructor;
    private static Constructor<File> fileConstructor;

    public static File mapUrlToFile(URL url) {
        if (url == null) {
            return null;
        }
        if (fileConstructor == null) {
            return url.getProtocol().equalsIgnoreCase("file") && url.getAuthority() == null && url.getQuery() == null && url.getRef() == null ? new File(URLDecoder.decode(StringHelper.replace(url.getPath(), '+', "%2B"))) : null;
        }
        String encodedUrl = UrlToFileMapper.encode(url.toString());
        try {
            Object uri = uriConstructor.newInstance(encodedUrl);
            try {
                return fileConstructor.newInstance(uri);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof IllegalArgumentException) {
                    return null;
                }
                throw e;
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("This cannot happen: " + e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("This cannot happen: " + e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException("This cannot happen: " + e);
        }
    }

    private static String encode(String url) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < url.length(); ++i) {
            String enc;
            char c = url.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '?' && c <= '[' || c >= '$' && c <= ';' || c == '!' || c == '=' || c == ']' || c == '_' || c == '~') {
                buf.append(c);
                continue;
            }
            if (c == ' ') {
                buf.append("%20");
                continue;
            }
            try {
                enc = (String)urlEncoderEncode.invoke(null, Character.toString(c), "UTF-8");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("This cannot happen: " + e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("This cannot happen: " + e);
            }
            buf.append(enc);
        }
        return buf.toString();
    }

    private UrlToFileMapper() {
    }

    static {
        try {
            urlEncoderEncode = URLEncoder.class.getMethod("encode", String.class, String.class);
            Class<?> uriClass = Class.forName("java.net.URI");
            uriConstructor = uriClass.getConstructor(String.class);
            fileConstructor = File.class.getConstructor(uriClass);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

