/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.typedesc;

import com.sun.star.lib.uno.typedesc.FieldDescription;
import com.sun.star.lib.uno.typedesc.MethodDescription;
import com.sun.star.lib.uno.typeinfo.AttributeTypeInfo;
import com.sun.star.lib.uno.typeinfo.MemberTypeInfo;
import com.sun.star.lib.uno.typeinfo.MethodTypeInfo;
import com.sun.star.lib.uno.typeinfo.ParameterTypeInfo;
import com.sun.star.lib.uno.typeinfo.TypeInfo;
import com.sun.star.uno.IFieldDescription;
import com.sun.star.uno.IMethodDescription;
import com.sun.star.uno.ITypeDescription;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeDescription
implements ITypeDescription {
    private static final Cache cache = new Cache();
    private final TypeClass typeClass;
    private final String typeName;
    private final String arrayTypeName;
    private final Class<?> zClass;
    private final TypeDescription[] superTypes;
    private final ITypeDescription componentType;
    private final boolean hasTypeArguments;
    private final IFieldDescription[] fieldDescriptions;
    private IMethodDescription[] methodDescriptions = null;
    private IMethodDescription[] superMethodDescriptions;

    public static TypeDescription getTypeDescription(String typeName) throws ClassNotFoundException {
        Type t = new Type(typeName);
        if (t.getTypeClass() == TypeClass.UNKNOWN) {
            t = typeName.startsWith("[]") ? new Type(typeName, TypeClass.SEQUENCE) : new Type(Class.forName(typeName));
        }
        return TypeDescription.get(t);
    }

    public static TypeDescription getTypeDescription(Class<?> zClass) {
        return TypeDescription.getDefinitely(new Type(zClass));
    }

    public static TypeDescription getTypeDescription(Type type) throws ClassNotFoundException {
        TypeDescription desc = (TypeDescription)type.getTypeDescription();
        if (desc == null) {
            desc = TypeDescription.getTypeDescription(type.getTypeName());
            type.setTypeDescription(desc);
        }
        return desc;
    }

    public static TypeDescription getTypeDescription(TypeClass typeClass) {
        switch (typeClass.getValue()) {
            case 0: {
                return TypeDescription.getDefinitely(Type.VOID);
            }
            case 2: {
                return TypeDescription.getDefinitely(Type.BOOLEAN);
            }
            case 3: {
                return TypeDescription.getDefinitely(Type.BYTE);
            }
            case 4: {
                return TypeDescription.getDefinitely(Type.SHORT);
            }
            case 5: {
                return TypeDescription.getDefinitely(Type.UNSIGNED_SHORT);
            }
            case 6: {
                return TypeDescription.getDefinitely(Type.LONG);
            }
            case 7: {
                return TypeDescription.getDefinitely(Type.UNSIGNED_LONG);
            }
            case 8: {
                return TypeDescription.getDefinitely(Type.HYPER);
            }
            case 9: {
                return TypeDescription.getDefinitely(Type.UNSIGNED_HYPER);
            }
            case 10: {
                return TypeDescription.getDefinitely(Type.FLOAT);
            }
            case 11: {
                return TypeDescription.getDefinitely(Type.DOUBLE);
            }
            case 1: {
                return TypeDescription.getDefinitely(Type.CHAR);
            }
            case 12: {
                return TypeDescription.getDefinitely(Type.STRING);
            }
            case 13: {
                return TypeDescription.getDefinitely(Type.TYPE);
            }
            case 14: {
                return TypeDescription.getDefinitely(Type.ANY);
            }
        }
        return null;
    }

    public static boolean isTypeClassSimple(TypeClass typeClass) {
        return TypeDescription.getTypeDescription(typeClass) != null;
    }

    @Override
    public ITypeDescription getSuperType() {
        return this.superTypes == null || this.superTypes.length == 0 ? null : this.superTypes[0];
    }

    @Override
    public IMethodDescription[] getMethodDescriptions() {
        this.initMethodDescriptions();
        return this.methodDescriptions;
    }

    @Override
    public IMethodDescription getMethodDescription(int methodId) {
        this.initMethodDescriptions();
        return methodId < 0 ? null : (methodId < this.superMethodDescriptions.length ? this.superMethodDescriptions[methodId] : (methodId - this.superMethodDescriptions.length < this.methodDescriptions.length ? this.methodDescriptions[methodId - this.superMethodDescriptions.length] : null));
    }

    @Override
    public IMethodDescription getMethodDescription(String name) {
        int i;
        this.initMethodDescriptions();
        for (i = 0; i < this.superMethodDescriptions.length; ++i) {
            if (!this.superMethodDescriptions[i].getName().equals(name)) continue;
            return this.superMethodDescriptions[i];
        }
        for (i = 0; i < this.methodDescriptions.length; ++i) {
            if (!this.methodDescriptions[i].getName().equals(name)) continue;
            return this.methodDescriptions[i];
        }
        return null;
    }

    @Override
    public IFieldDescription[] getFieldDescriptions() {
        return this.fieldDescriptions;
    }

    @Override
    public IFieldDescription getFieldDescription(String name) {
        for (int i = 0; i < this.fieldDescriptions.length; ++i) {
            if (!this.fieldDescriptions[i].getName().equals(name)) continue;
            return this.fieldDescriptions[i];
        }
        return this.superTypes != null && this.superTypes.length == 1 ? this.superTypes[0].getFieldDescription(name) : null;
    }

    @Override
    public TypeClass getTypeClass() {
        return this.typeClass;
    }

    @Override
    public ITypeDescription getComponentType() {
        return this.componentType;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getArrayTypeName() {
        return this.arrayTypeName;
    }

    @Override
    public Class<?> getZClass() {
        return this.zClass;
    }

    public boolean hasTypeArguments() {
        return this.hasTypeArguments;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.getTypeClass() + ", " + this.getTypeName() + "]";
    }

    private static TypeDescription getDefinitely(Type type) {
        try {
            return TypeDescription.get(type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("this cannot happen: " + e);
        }
    }

    private static TypeDescription get(Type type) throws ClassNotFoundException {
        String typeName = type.getTypeName();
        TypeDescription desc = cache.get(typeName);
        if (desc == null) {
            desc = TypeDescription.create(type);
            cache.put(desc);
        }
        return desc;
    }

    private static TypeDescription create(Type type) throws ClassNotFoundException {
        TypeClass typeClass = type.getTypeClass();
        String typeName = type.getTypeName();
        Class<?> zClass = type.getZClass();
        if (zClass == null) {
            throw new ClassNotFoundException("UNO type " + type);
        }
        switch (typeClass.getValue()) {
            case 0: {
                return new TypeDescription(typeClass, typeName, "[Ljava.lang.Void;", zClass, null, null);
            }
            case 2: {
                return new TypeDescription(typeClass, typeName, "[Z", zClass, null, null);
            }
            case 3: {
                return new TypeDescription(typeClass, typeName, "[B", zClass, null, null);
            }
            case 4: 
            case 5: {
                return new TypeDescription(typeClass, typeName, "[S", zClass, null, null);
            }
            case 6: 
            case 7: {
                return new TypeDescription(typeClass, typeName, "[I", zClass, null, null);
            }
            case 8: 
            case 9: {
                return new TypeDescription(typeClass, typeName, "[J", zClass, null, null);
            }
            case 10: {
                return new TypeDescription(typeClass, typeName, "[F", zClass, null, null);
            }
            case 11: {
                return new TypeDescription(typeClass, typeName, "[D", zClass, null, null);
            }
            case 1: {
                return new TypeDescription(typeClass, typeName, "[C", zClass, null, null);
            }
            case 12: {
                return new TypeDescription(typeClass, typeName, "[Ljava.lang.String;", zClass, null, null);
            }
            case 13: {
                return new TypeDescription(typeClass, typeName, "[Lcom.sun.star.uno.Type;", zClass, null, null);
            }
            case 14: {
                return new TypeDescription(typeClass, typeName, "[Ljava.lang.Object;", zClass, null, null);
            }
            case 20: {
                TypeDescription componentType = TypeDescription.getTypeDescription(typeName.substring("[]".length()));
                return new TypeDescription(typeClass, typeName, "[" + zClass.getName(), zClass, null, componentType);
            }
            case 15: {
                return new TypeDescription(typeClass, typeName, "[L" + zClass.getName() + ";", zClass, null, null);
            }
            case 17: {
                TypeDescription[] typeDescriptionArray;
                Class<?> superClass = zClass.getSuperclass();
                if (superClass != Object.class) {
                    TypeDescription[] typeDescriptionArray2 = new TypeDescription[1];
                    typeDescriptionArray = typeDescriptionArray2;
                    typeDescriptionArray2[0] = TypeDescription.get(new Type(superClass));
                } else {
                    typeDescriptionArray = null;
                }
                TypeDescription[] superTypes = typeDescriptionArray;
                return new TypeDescription(typeClass, typeName, "[L" + zClass.getName() + ";", zClass, superTypes, null);
            }
            case 19: {
                TypeDescription[] typeDescriptionArray;
                if (typeName.equals("com.sun.star.uno.Exception") || typeName.equals("com.sun.star.uno.RuntimeException")) {
                    typeDescriptionArray = null;
                } else {
                    TypeDescription[] typeDescriptionArray3 = new TypeDescription[1];
                    typeDescriptionArray = typeDescriptionArray3;
                    typeDescriptionArray3[0] = TypeDescription.get(new Type(zClass.getSuperclass()));
                }
                TypeDescription[] superTypes = typeDescriptionArray;
                return new TypeDescription(typeClass, typeName, "[L" + zClass.getName() + ";", zClass, superTypes, null);
            }
            case 22: {
                List superTypes = new List();
                Class<?>[] interfaces = zClass.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    Type t = new Type(interfaces[i]);
                    if (t.getTypeClass() != TypeClass.INTERFACE) continue;
                    TypeDescription desc = TypeDescription.getDefinitely(t);
                    TypeDescription[] descs = desc.superTypes;
                    for (int j = 0; j < descs.length; ++j) {
                        superTypes.add(descs[j]);
                    }
                    superTypes.add(desc);
                }
                return new TypeDescription(typeClass, typeName, "[L" + zClass.getName() + ";", zClass, superTypes.toArray(), null);
            }
        }
        throw new IllegalArgumentException("given type has bad type class");
    }

    private TypeDescription(TypeClass typeClass, String typeName, String arrayTypeName, Class<?> zClass, TypeDescription[] superTypes, ITypeDescription componentType) {
        this.typeClass = typeClass;
        this.typeName = typeName;
        this.arrayTypeName = arrayTypeName;
        this.zClass = zClass;
        this.superTypes = superTypes;
        this.componentType = componentType;
        TypeDescription[] args = this.calculateTypeArguments();
        this.hasTypeArguments = args != null;
        this.fieldDescriptions = this.calculateFieldDescriptions(args);
    }

    private synchronized void initMethodDescriptions() {
        if (this.methodDescriptions != null || this.typeClass != TypeClass.INTERFACE) {
            return;
        }
        if (this.superTypes.length == 0) {
            this.superMethodDescriptions = new IMethodDescription[0];
            this.methodDescriptions = new IMethodDescription[]{new MethodDescription("queryInterface", 0, false, new ITypeDescription[]{TypeDescription.getDefinitely(Type.TYPE)}, new ITypeDescription[]{null}, TypeDescription.getDefinitely(Type.ANY), null), new MethodDescription("acquire", 1, true, new ITypeDescription[0], new ITypeDescription[0], TypeDescription.getDefinitely(Type.VOID), null), new MethodDescription("release", 2, true, new ITypeDescription[0], new ITypeDescription[0], TypeDescription.getDefinitely(Type.VOID), null)};
        } else {
            int methodOffset = 0;
            ArrayList<MethodDescription> superList = new ArrayList<MethodDescription>();
            for (int i = 0; i < this.superTypes.length; ++i) {
                IMethodDescription[] ds = this.superTypes[i].getMethodDescriptions();
                for (int j = 0; j < ds.length; ++j) {
                    superList.add(new MethodDescription(ds[j], methodOffset++));
                }
            }
            this.superMethodDescriptions = superList.toArray(new IMethodDescription[superList.size()]);
            ArrayList<MethodDescription> directList = new ArrayList<MethodDescription>();
            TypeInfo[] infos = this.getTypeInfo();
            int infoCount = infos == null ? 0 : infos.length;
            int index = 0;
            Method[] methods = this.zClass.getDeclaredMethods();
            int i = 0;
            while (i < infoCount) {
                TypeInfo info;
                if (infos[i] instanceof AttributeTypeInfo) {
                    if (((AttributeTypeInfo)(info = (AttributeTypeInfo)infos[i++])).getIndex() != index) {
                        throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": entries not ordererd");
                    }
                    String getterName = "get" + info.getName();
                    Method getter = this.findMethod(methods, getterName);
                    Type t = ((AttributeTypeInfo)info).getUnoType();
                    TypeDescription type = t == null ? TypeDescription.getTypeDescription(getter.getReturnType(), info) : TypeDescription.getDefinitely(t);
                    directList.add(new MethodDescription(getterName, index++ + methodOffset, false, new ITypeDescription[0], new ITypeDescription[0], type, getter));
                    if (((AttributeTypeInfo)info).isReadOnly()) continue;
                    String setterName = "set" + info.getName();
                    Method setter = this.findMethod(methods, setterName);
                    directList.add(new MethodDescription(setterName, index++ + methodOffset, false, new ITypeDescription[]{type}, new ITypeDescription[]{null}, TypeDescription.getDefinitely(Type.VOID), setter));
                    continue;
                }
                if (((MethodTypeInfo)(info = (MethodTypeInfo)infos[i++])).getIndex() != index) {
                    throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": entries not ordererd");
                }
                Method method = this.findMethod(methods, info.getName());
                Class<?>[] params = method.getParameterTypes();
                ITypeDescription[] in = new ITypeDescription[params.length];
                ITypeDescription[] out = new ITypeDescription[params.length];
                for (int j = 0; j < params.length; ++j) {
                    TypeDescription d;
                    ParameterTypeInfo p = null;
                    if (i < infoCount && infos[i] instanceof ParameterTypeInfo && ((ParameterTypeInfo)infos[i]).getIndex() == j) {
                        p = (ParameterTypeInfo)infos[i++];
                    }
                    Type pt = p == null ? null : p.getUnoType();
                    ITypeDescription iTypeDescription = d = pt == null ? TypeDescription.getTypeDescription(params[j], p) : TypeDescription.getDefinitely(pt);
                    if (p == null || p.isIN()) {
                        in[j] = d;
                    }
                    if (p == null || !p.isOUT()) continue;
                    out[j] = d;
                }
                Type t = ((MethodTypeInfo)info).getUnoType();
                directList.add(new MethodDescription(info.getName(), index++ + methodOffset, ((MethodTypeInfo)info).isOneway(), in, out, t == null ? TypeDescription.getTypeDescription(method.getReturnType(), info) : TypeDescription.getDefinitely(t), method));
            }
            this.methodDescriptions = directList.toArray(new IMethodDescription[directList.size()]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private TypeDescription[] calculateTypeArguments() {
        int j;
        if (this.typeClass != TypeClass.STRUCT) {
            return null;
        }
        int i = this.typeName.indexOf(60);
        if (i < 0) {
            return null;
        }
        ArrayList<TypeDescription> args = new ArrayList<TypeDescription>();
        do {
            int level = 0;
            block6: for (j = ++i; j != this.typeName.length(); ++j) {
                switch (this.typeName.charAt(j)) {
                    case ',': {
                        if (level != 0) break;
                        break block6;
                    }
                    case '<': {
                        ++level;
                        break;
                    }
                    case '>': {
                        if (level == 0) break block6;
                        --level;
                    }
                }
            }
            if (j == this.typeName.length()) continue;
            Type t = new Type(this.typeName.substring(i, j));
            if (t.getZClass() == null) {
                throw new IllegalArgumentException("UNO type name \"" + this.typeName + "\" contains bad type argument \"" + this.typeName.substring(i, j) + "\"");
            }
            args.add(TypeDescription.getDefinitely(t));
        } while ((i = j) != this.typeName.length() && this.typeName.charAt(i) != '>');
        if (i == this.typeName.length() - 1 && this.typeName.charAt(i) == '>' && !args.isEmpty()) {
            return args.toArray(new TypeDescription[args.size()]);
        }
        throw new IllegalArgumentException("UNO type name \"" + this.typeName + "\" is syntactically invalid");
    }

    private IFieldDescription[] calculateFieldDescriptions(TypeDescription[] typeArguments) {
        if (this.typeClass != TypeClass.STRUCT && this.typeClass != TypeClass.EXCEPTION) {
            return null;
        }
        TypeInfo[] infos = this.getTypeInfo();
        int infoCount = infos == null ? 0 : infos.length;
        ITypeDescription superType = this.getSuperType();
        IFieldDescription[] superDescs = superType == null ? null : superType.getFieldDescriptions();
        int superCount = superDescs == null ? 0 : superDescs.length;
        IFieldDescription[] descs = new IFieldDescription[superCount + infoCount];
        if (superCount != 0) {
            System.arraycopy(superDescs, 0, descs, 0, superCount);
        }
        for (int i = 0; i < infoCount; ++i) {
            Field field;
            MemberTypeInfo info = (MemberTypeInfo)infos[i];
            if (info.getIndex() != i) {
                throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": entries not ordererd");
            }
            try {
                field = this.zClass.getDeclaredField(info.getName());
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": " + e);
            }
            Type t = info.getUnoType();
            int index = info.getTypeParameterIndex();
            descs[i + superCount] = new FieldDescription(info.getName(), i + superCount, index >= 0 ? typeArguments[index] : (t == null ? TypeDescription.getTypeDescription(field.getType(), info) : TypeDescription.getDefinitely(t)), field);
        }
        return descs;
    }

    private TypeInfo[] getTypeInfo() {
        try {
            return (TypeInfo[])this.zClass.getDeclaredField("UNOTYPEINFO").get(null);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": " + e);
        }
    }

    private Method findMethod(Method[] methods, String name) {
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            return methods[i];
        }
        throw new IllegalArgumentException("Bad UNOTYPEINFO for " + this.zClass + ": no method " + name);
    }

    private static ITypeDescription getTypeDescription(Class<?> zClass, TypeInfo typeInfo) {
        return TypeDescription.getDefinitely(new Type(zClass, typeInfo != null && (typeInfo.isUnsigned() || typeInfo.isInterface())));
    }

    private static final class Cache {
        private final HashMap<String, Entry> map = new HashMap();
        private final ReferenceQueue<TypeDescription> queue = new ReferenceQueue();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TypeDescription get(String typeName) {
            HashMap<String, Entry> hashMap = this.map;
            synchronized (hashMap) {
                this.cleanUp();
                Entry e = this.map.get(typeName);
                return e == null ? null : (TypeDescription)e.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(TypeDescription desc) {
            HashMap<String, Entry> hashMap = this.map;
            synchronized (hashMap) {
                this.cleanUp();
                this.map.put(desc.getTypeName(), new Entry(desc, this.queue));
            }
        }

        private void cleanUp() {
            Reference<TypeDescription> tmp;
            Entry e;
            while ((e = (Entry)(tmp = this.queue.poll())) != null) {
                this.map.remove(e.typeName);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class Entry
        extends SoftReference<TypeDescription> {
            public final String typeName;

            public Entry(TypeDescription desc, ReferenceQueue<TypeDescription> queue) {
                super(desc, queue);
                this.typeName = desc.getTypeName();
            }
        }
    }

    private static final class List {
        private final ArrayList<TypeDescription> list = new ArrayList();

        public void add(TypeDescription desc) {
            if (!this.list.contains(desc)) {
                this.list.add(desc);
            }
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public TypeDescription[] toArray() {
            return this.list.toArray(new TypeDescription[this.list.size()]);
        }
    }
}

