/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.beans;

import com.sun.star.beans.ContainerFactory;
import com.sun.star.beans.LocalOfficeWindow;
import com.sun.star.beans.NativeService;
import com.sun.star.beans.OfficeConnection;
import com.sun.star.beans.OfficeWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.UnoUrl;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalOfficeConnection
implements OfficeConnection {
    public static final String OFFICE_APP_NAME = "soffice";
    public static final String OFFICE_LIB_NAME = "officebean";
    public static final String OFFICE_ID_SUFFIX = "_Office";
    private Process mProcess;
    private ContainerFactory mContainerFactory;
    private XComponentContext mContext;
    private String mURL;
    private String mProgramPath;
    private String mConnType;
    private String mPipe;
    private String mPort;
    private String mProtocol;
    private String mInitialObject;
    private List<XEventListener> mComponents = new ArrayList<XEventListener>();

    public LocalOfficeConnection() {
        try {
            this.setUnoUrl("uno:pipe,name=" + LocalOfficeConnection.getPipeName() + ";urp;StarOffice.ServiceManager");
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        String aSharedLibName = this.getProgramPath() + File.separator + System.mapLibraryName(OFFICE_LIB_NAME);
        System.load(aSharedLibName);
    }

    public void setUnoUrl(String url) throws MalformedURLException {
        this.mURL = null;
        String prefix = "uno:localoffice";
        if (url.startsWith(prefix)) {
            this.parseUnoUrlWithOfficePath(url, prefix);
        } else {
            try {
                UnoUrl aURL = UnoUrl.parseUnoUrl((String)url);
                this.mProgramPath = null;
                this.mConnType = aURL.getConnection();
                this.mPipe = (String)aURL.getConnectionParameters().get("pipe");
                this.mPort = (String)aURL.getConnectionParameters().get("port");
                this.mProtocol = aURL.getProtocol();
                this.mInitialObject = aURL.getRootOid();
            }
            catch (IllegalArgumentException eIll) {
                throw new MalformedURLException("Invalid UNO connection URL.");
            }
        }
        this.mURL = url;
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.mContainerFactory = containerFactory;
    }

    public XComponentContext getComponentContext() {
        if (this.mContext == null) {
            this.mContext = this.connect();
        }
        return this.mContext;
    }

    public OfficeWindow createOfficeWindow(Container container) {
        return new LocalOfficeWindow(this);
    }

    public void dispose() {
        Iterator<XEventListener> itr = this.mComponents.iterator();
        while (itr.hasNext()) {
            try {
                itr.next().disposing(null);
            }
            catch (java.lang.RuntimeException runtimeException) {}
        }
        this.mComponents.clear();
        this.mContainerFactory = null;
        this.mContext = null;
    }

    public void addEventListener(XEventListener listener) {
        this.mComponents.add(listener);
    }

    public void removeEventListener(XEventListener listener) {
        this.mComponents.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XComponentContext connect() {
        try {
            XComponentContext xLocalContext = Bootstrap.createInitialComponentContext(null);
            XMultiComponentFactory xLocalServiceManager = xLocalContext.getServiceManager();
            Object urlResolver = xLocalServiceManager.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xLocalContext);
            XUnoUrlResolver xUrlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, (Object)urlResolver);
            Object aInitialObject = null;
            try {
                aInitialObject = xUrlResolver.resolve(this.mURL);
            }
            catch (NoConnectException e) {
                OfficeService aSOffice = new OfficeService();
                aSOffice.startupService();
                long nMaxMillis = System.currentTimeMillis() + (long)(1000 * aSOffice.getStartupTime());
                while (aInitialObject == null) {
                    try {
                        Thread.sleep(500L);
                        aInitialObject = xUrlResolver.resolve(this.mURL);
                    }
                    catch (NoConnectException aEx) {
                        if (System.currentTimeMillis() <= nMaxMillis) continue;
                        throw aEx;
                    }
                }
            }
            if (null == aInitialObject) return null;
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)aInitialObject);
            Object xContext = xPropertySet.getPropertyValue("DefaultContext");
            return (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)xContext);
        }
        catch (NoConnectException e) {
            System.out.println("Couldn't connect to remote server");
            System.out.println(e.getMessage());
            return null;
        }
        catch (ConnectionSetupException e) {
            System.out.println("Couldn't access necessary local resource to establish the interprocess connection");
            System.out.println(e.getMessage());
            return null;
        }
        catch (IllegalArgumentException e) {
            System.out.println("uno-url is syntactical illegal ( " + this.mURL + " )");
            System.out.println(e.getMessage());
            return null;
        }
        catch (RuntimeException e) {
            System.out.println("--- RuntimeException:");
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.out.println("--- end.");
            throw e;
        }
        catch (Exception e) {
            System.out.println("java.lang.Exception: ");
            System.out.println(e);
            e.printStackTrace();
            System.out.println("--- end.");
            throw new RuntimeException(e.toString());
        }
    }

    private String getProgramPath() {
        if (this.mProgramPath == null) {
            File path;
            String aExec = OFFICE_APP_NAME;
            String aOS = System.getProperty("os.name");
            if (aOS.startsWith("Windows")) {
                aExec = "soffice.exe";
            }
            if ((path = NativeLibraryLoader.getResource((ClassLoader)this.getClass().getClassLoader(), (String)aExec)) != null) {
                this.mProgramPath = path.getParent();
            }
            if (this.mProgramPath == null) {
                this.mProgramPath = "";
            }
        }
        return this.mProgramPath;
    }

    private void parseUnoUrlWithOfficePath(String url, String prefix) throws MalformedURLException {
        int idx = url.indexOf(";urp;StarOffice.NamingService");
        if (idx < 0) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        String params = url.substring(prefix.length(), idx + 1);
        String name = null;
        String path = null;
        String pipe = null;
        int state = 0;
        StringBuffer buffer = new StringBuffer();
        block35: for (idx = 0; idx < params.length(); ++idx) {
            char ch = params.charAt(idx);
            switch (state) {
                case 0: {
                    switch (ch) {
                        case ',': {
                            buffer.delete(0, buffer.length());
                            state = 1;
                            continue block35;
                        }
                        case ';': {
                            state = 7;
                            continue block35;
                        }
                    }
                    buffer.delete(0, buffer.length());
                    buffer.append(ch);
                    state = 1;
                    continue block35;
                }
                case 1: {
                    switch (ch) {
                        case ' ': 
                        case '=': {
                            name = buffer.toString();
                            state = ch == ' ' ? 2 : 3;
                            continue block35;
                        }
                        case ',': 
                        case ';': {
                            state = -6;
                            continue block35;
                        }
                    }
                    buffer.append(ch);
                    continue block35;
                }
                case 2: {
                    switch (ch) {
                        case '=': {
                            state = 3;
                            continue block35;
                        }
                        case ' ': {
                            continue block35;
                        }
                    }
                    state = -1;
                    continue block35;
                }
                case 3: {
                    switch (ch) {
                        case ' ': {
                            continue block35;
                        }
                    }
                    buffer.delete(0, buffer.length());
                    buffer.append(ch);
                    state = 4;
                    continue block35;
                }
                case 4: {
                    switch (ch) {
                        case ' ': 
                        case ',': 
                        case ';': {
                            --idx;
                            state = 5;
                            if ("path".equals(name)) {
                                if (path == null) {
                                    path = buffer.toString();
                                } else {
                                    state = -3;
                                }
                            } else if ("pipe".equals(name)) {
                                if (pipe == null) {
                                    pipe = buffer.toString();
                                } else {
                                    state = -4;
                                }
                            } else {
                                state = -2;
                            }
                            buffer.delete(0, buffer.length());
                            continue block35;
                        }
                    }
                    buffer.append(ch);
                    continue block35;
                }
                case 5: {
                    switch (ch) {
                        case ' ': {
                            continue block35;
                        }
                        case ',': {
                            state = 6;
                            continue block35;
                        }
                        case ';': {
                            state = 7;
                            continue block35;
                        }
                    }
                    state = -5;
                    continue block35;
                }
                case 6: {
                    switch (ch) {
                        case ' ': {
                            continue block35;
                        }
                    }
                    buffer.delete(0, buffer.length());
                    buffer.append(ch);
                    state = 1;
                    continue block35;
                }
                default: {
                    throw new MalformedURLException("Invalid UNO connection URL.");
                }
            }
        }
        if (state != 7) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        if (path != null) {
            this.mProgramPath = path;
        }
        if (pipe != null) {
            this.mPipe = pipe;
        }
    }

    private static String replaceAll(String aString, String aSearch, String aReplace) {
        StringBuffer aBuffer = new StringBuffer(aString);
        int nPos = aString.length();
        int nOfs = aSearch.length();
        while ((nPos = aString.lastIndexOf(aSearch, nPos - 1)) > -1) {
            aBuffer.replace(nPos, nPos + nOfs, aReplace);
        }
        return aBuffer.toString();
    }

    static String getPipeName() {
        String aPipeName = System.getProperty("user.name") + OFFICE_ID_SUFFIX;
        aPipeName = LocalOfficeConnection.replaceAll(aPipeName, "_", "%B7");
        return LocalOfficeConnection.replaceAll(LocalOfficeConnection.replaceAll(URLEncoder.encode(aPipeName), "\\+", "%20"), "%", "_");
    }

    private class OfficeService
    implements NativeService {
        private OfficeService() {
        }

        public String getIdentifier() {
            if (LocalOfficeConnection.this.mPipe == null) {
                return LocalOfficeConnection.getPipeName();
            }
            return LocalOfficeConnection.this.mPipe;
        }

        public void startupService() throws IOException {
            String[] cmdArray = new String[4];
            cmdArray[0] = new File(LocalOfficeConnection.this.getProgramPath(), LocalOfficeConnection.OFFICE_APP_NAME).getPath();
            cmdArray[1] = "--nologo";
            cmdArray[2] = "--nodefault";
            if (LocalOfficeConnection.this.mConnType.equals("pipe")) {
                cmdArray[3] = "--accept=pipe,name=" + this.getIdentifier() + ";" + LocalOfficeConnection.this.mProtocol + ";" + LocalOfficeConnection.this.mInitialObject;
            } else if (LocalOfficeConnection.this.mConnType.equals("socket")) {
                cmdArray[3] = "--accept=socket,port=" + LocalOfficeConnection.this.mPort + ";urp";
            } else {
                throw new IOException("not connection specified");
            }
            LocalOfficeConnection.this.mProcess = Runtime.getRuntime().exec(cmdArray);
            if (LocalOfficeConnection.this.mProcess == null) {
                throw new java.lang.RuntimeException("cannot start soffice: " + cmdArray);
            }
        }

        public int getStartupTime() {
            return 60;
        }
    }
}

