/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.beans;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XVclWindowPeer;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.JavaWindowPeerFake;
import com.sun.star.beans.OfficeConnection;
import com.sun.star.beans.OfficeWindow;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class LocalOfficeWindow
extends Canvas
implements OfficeWindow,
XEventListener {
    private transient OfficeConnection mConnection;
    private transient XWindowPeer mParentProxy;
    private transient XWindowPeer mWindow;
    private boolean bPeer = false;

    LocalOfficeWindow(OfficeConnection connection) {
        this.mConnection = connection;
        this.mConnection.addEventListener(this);
    }

    public Component getAWTComponent() {
        return this;
    }

    public XWindowPeer getUNOWindowPeer() {
        if (this.mWindow == null) {
            this.createUNOWindowPeer();
        }
        return this.mWindow;
    }

    public void disposing(EventObject source) {
        this.mWindow = null;
        this.mConnection = null;
    }

    private XToolkit queryAWTToolkit() throws Exception {
        XComponentContext xContext = this.mConnection.getComponentContext();
        if (xContext != null) {
            XMultiComponentFactory compfactory = this.mConnection.getComponentContext().getServiceManager();
            XMultiServiceFactory factory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)compfactory);
            Object object = factory.createInstance("com.sun.star.awt.Toolkit");
            return (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)object);
        }
        return null;
    }

    private void aquireSystemWindow() {
        if (!this.bPeer) {
            XVclWindowPeer xVclWindowPeer = (XVclWindowPeer)UnoRuntime.queryInterface(XVclWindowPeer.class, (Object)this.mWindow);
            xVclWindowPeer.setProperty("PluginParent", (Object)new Long(this.getNativeWindow()));
            this.bPeer = true;
            XWindow aWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            aWindow.setVisible(true);
        }
    }

    private void releaseSystemWindow() {
        if (this.bPeer) {
            XWindow aWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            aWindow.setVisible(false);
            XVclWindowPeer xVclWindowPeer = (XVclWindowPeer)UnoRuntime.queryInterface(XVclWindowPeer.class, (Object)this.mWindow);
            xVclWindowPeer.setProperty("PluginParent", (Object)new Long(0L));
            this.bPeer = false;
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.aquireSystemWindow();
        } else {
            this.releaseSystemWindow();
        }
    }

    private XWindowPeer createUNOWindowPeer() {
        try {
            JavaWindowPeerFake parentPeer;
            int type = this.getNativeWindowSystemType();
            if (this.isShowing()) {
                parentPeer = new JavaWindowPeerFake(this.getNativeWindow(), type);
                this.bPeer = true;
            } else {
                parentPeer = null;
                this.bPeer = false;
            }
            Rectangle aRect = new Rectangle(0, 0, 20, 20);
            WindowDescriptor desc = new WindowDescriptor();
            desc.Type = WindowClass.TOP;
            desc.Parent = parentPeer;
            desc.Bounds = aRect;
            desc.WindowServiceName = "workwindow";
            desc.WindowAttributes = type == 1 ? 1 : 0;
            this.mWindow = this.queryAWTToolkit().createWindow(desc);
            this.addComponentListener(new ComponentEventHandler());
            XWindow aWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            aWindow.setVisible(this.bPeer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mWindow;
    }

    private native long getNativeWindow();

    private native int getNativeWindowSystemType();

    class CallWatchThread
    extends Thread {
        Thread aWatchedThread = Thread.currentThread();
        long nTimeout;

        CallWatchThread(long nTimeout) {
            this.nTimeout = nTimeout;
            this.start();
        }

        void cancel() throws InterruptedException {
            Thread aThread = this.aWatchedThread;
            this.aWatchedThread = null;
            this.stop();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }

        public void run() {
            while (this.aWatchedThread != null) {
                try {
                    CallWatchThread.sleep(this.nTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.aWatchedThread == null) continue;
                this.aWatchedThread.interrupt();
            }
        }
    }

    class ComponentEventHandler
    extends ComponentAdapter {
        ComponentEventHandler() {
        }

        public void componentHidden(ComponentEvent e) {
            CallWatchThread aCallWatchThread = new CallWatchThread(500L);
            LocalOfficeWindow.this.setVisible(false);
            try {
                aCallWatchThread.cancel();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void componentShown(ComponentEvent e) {
            LocalOfficeWindow.this.aquireSystemWindow();
        }
    }
}

