/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CachedRow;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.PointerNode;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

class CachedDataRow
extends CachedRow {
    CachedDataRow(Table t, Object[] o) throws HsqlException {
        super(t, o);
        this.hasDataChanged = true;
    }

    CachedDataRow(Table t, RowInputInterface in) throws IOException, HsqlException {
        this.tTable = t;
        this.iPos = in.getPos();
        this.storageSize = in.getSize();
        this.oData = in.readData(this.tTable.getColumnTypes());
        this.hasDataChanged = false;
    }

    Row getUpdatedRow() throws HsqlException {
        return this.tTable.getRow(this.iPos, this.nPrimaryNode);
    }

    void setNewNodes() {
        int index = this.tTable.getIndexCount();
        Node n = this.nPrimaryNode = Node.newNode(this, 0, this.tTable);
        for (int i = 1; i < index; ++i) {
            n = n.nNext = Node.newNode(this, i, this.tTable);
        }
    }

    void setPrimaryNode(Node primary) {
        this.nPrimaryNode = primary;
    }

    public int getRealSize(RowOutputInterface out) {
        return out.getSize(this);
    }

    public void write(RowOutputInterface out) {
        out.writeSize(this.storageSize);
        out.writeData(this.oData, this.tTable);
        out.writeEnd();
        this.hasDataChanged = false;
    }

    public boolean hasChanged() {
        return this.hasDataChanged;
    }

    public void setPos(int pos) {
        this.iPos = pos;
        Node n = this.nPrimaryNode;
        while (n != null) {
            ((PointerNode)n).iData = this.iPos;
            n = n.nNext;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CachedDataRow) {
            return ((CachedDataRow)obj).iPos == this.iPos && ((CachedDataRow)obj).tTable == this.tTable;
        }
        return false;
    }
}

