/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Constructor;
import org.hsqldb.Collation;
import org.hsqldb.CompiledStatementManager;
import org.hsqldb.DatabaseInformation;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Library;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.Trace;
import org.hsqldb.TransactionManager;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.Logger;

public class Database {
    int databaseID;
    String sType;
    String sName;
    private HsqlProperties urlProperties;
    private String sPath;
    DatabaseInformation dbInfo;
    ClassLoader classLoader;
    private int dbState;
    public Logger logger;
    boolean databaseReadOnly;
    private boolean filesReadOnly;
    private boolean filesInJar;
    public boolean sqlEnforceStrictSize;
    public int firstIdentity;
    private boolean bIgnoreCase;
    private boolean bReferentialIntegrity;
    private HsqlDatabaseProperties databaseProperties;
    private boolean shutdownOnNoConnection;
    private HashMap hAlias;
    public UserManager userManager;
    public GranteeManager granteeManager;
    public HsqlNameManager nameManager;
    public SessionManager sessionManager;
    public TransactionManager txManager;
    CompiledStatementManager compiledStatementManager;
    public SchemaManager schemaManager;
    public Collation collation;
    public static final int DATABASE_ONLINE = 1;
    public static final int DATABASE_OPENING = 4;
    public static final int DATABASE_CLOSING = 8;
    public static final int DATABASE_SHUTDOWN = 16;
    public static final int CLOSEMODE_IMMEDIATELY = -1;
    public static final int CLOSEMODE_NORMAL = 0;
    public static final int CLOSEMODE_COMPACT = 1;
    public static final int CLOSEMODE_SCRIPT = 2;
    private FileAccess fileaccess;
    private boolean isStoredFileAccess;

    Database(String type, String path, String name, HsqlProperties props) throws HsqlException {
        this.urlProperties = props;
        this.setState(16);
        this.sName = name;
        this.sType = type;
        this.sPath = path;
        if (this.sType == "res:") {
            this.filesInJar = true;
            this.filesReadOnly = true;
        }
        try {
            this.classLoader = this.getClass().getClassLoader();
        }
        catch (Exception e) {
            this.classLoader = null;
        }
        String fileaccess_class_name = this.urlProperties.getProperty("fileaccess_class_name");
        if (fileaccess_class_name != null) {
            String storagekey = this.urlProperties.getProperty("storage_key");
            try {
                Class<?> fileAccessClass = null;
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    fileAccessClass = classLoader.loadClass(fileaccess_class_name);
                }
                catch (ClassNotFoundException e) {
                    fileAccessClass = Class.forName(fileaccess_class_name);
                }
                Constructor<?> constructor = fileAccessClass.getConstructor(Object.class);
                this.fileaccess = (FileAccess)constructor.newInstance(storagekey);
                this.isStoredFileAccess = true;
            }
            catch (Exception e) {
                throw Trace.error(256, new Object[]{e.toString()});
            }
        }
        this.fileaccess = FileUtil.getDefaultInstance();
        this.shutdownOnNoConnection = this.urlProperties.getProperty("shutdown", "false").equals("true");
        this.logger = new Logger();
        this.compiledStatementManager = new CompiledStatementManager(this);
    }

    synchronized void open() throws HsqlException {
        if (!this.isShutdown()) {
            return;
        }
        this.reopen();
    }

    void reopen() throws HsqlException {
        this.setState(4);
        try {
            boolean isNew;
            this.databaseProperties = new HsqlDatabaseProperties(this);
            boolean bl = isNew = !DatabaseURL.isFileBasedDatabaseType(this.sType) || !this.databaseProperties.checkFileExists();
            if (isNew && this.urlProperties.isPropertyTrue("ifexists")) {
                throw Trace.error(94, this.sName);
            }
            this.databaseProperties.load();
            this.databaseProperties.setURLProperties(this.urlProperties);
            this.compiledStatementManager.reset();
            this.nameManager = new HsqlNameManager();
            this.granteeManager = new GranteeManager(this);
            this.userManager = new UserManager(this);
            this.hAlias = Library.getAliasMap();
            this.schemaManager = new SchemaManager(this);
            this.bReferentialIntegrity = true;
            this.sessionManager = new SessionManager(this);
            this.txManager = new TransactionManager(this);
            this.collation = new Collation();
            this.dbInfo = DatabaseInformation.newDatabaseInformation(this);
            this.databaseProperties.setDatabaseVariables();
            if (DatabaseURL.isFileBasedDatabaseType(this.sType)) {
                this.logger.openLog(this);
            }
            if (isNew) {
                this.sessionManager.getSysSession().sqlExecuteDirectNoPreChecks("CREATE USER SA PASSWORD \"\" ADMIN");
                this.logger.synchLogForce();
            }
            this.dbInfo.setWithContent(true);
        }
        catch (Throwable e2) {
            HsqlException e2;
            this.logger.closeLog(-1);
            this.logger.releaseLock();
            this.setState(16);
            this.clearStructures();
            DatabaseManager.removeDatabase(this);
            if (!(e2 instanceof HsqlException)) {
                e2 = Trace.error(40, e2.toString());
            }
            throw (HsqlException)e2;
        }
        this.setState(1);
    }

    void clearStructures() {
        if (this.schemaManager != null) {
            this.schemaManager.clearStructures();
        }
        this.granteeManager = null;
        this.userManager = null;
        this.hAlias = null;
        this.nameManager = null;
        this.schemaManager = null;
        this.sessionManager = null;
        this.dbInfo = null;
    }

    public String getType() {
        return this.sType;
    }

    public String getPath() {
        return this.sPath;
    }

    public HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    synchronized boolean isShutdown() {
        return this.dbState == 16;
    }

    synchronized Session connect(String username, String password) throws HsqlException {
        User user = this.userManager.getUser(username, password);
        Session session = this.sessionManager.newSession(this, user, this.databaseReadOnly, false);
        this.logger.logConnectUser(session);
        return session;
    }

    public void setReadOnly() {
        this.databaseReadOnly = true;
        this.filesReadOnly = true;
    }

    public void setFilesReadOnly() {
        this.filesReadOnly = true;
    }

    public boolean isFilesReadOnly() {
        return this.filesReadOnly;
    }

    public boolean isFilesInJar() {
        return this.filesInJar;
    }

    UserManager getUserManager() {
        return this.userManager;
    }

    GranteeManager getGranteeManager() {
        return this.granteeManager;
    }

    public void setReferentialIntegrity(boolean ref) {
        this.bReferentialIntegrity = ref;
    }

    boolean isReferentialIntegrity() {
        return this.bReferentialIntegrity;
    }

    HashMap getAliasMap() {
        return this.hAlias;
    }

    String getJavaName(String name) throws HsqlException {
        String target = (String)this.hAlias.get(name);
        if (target == null) {
            target = name;
        }
        if (HsqlDatabaseProperties.supportsJavaMethod(target)) {
            return target;
        }
        throw Trace.error(33, target);
    }

    void setIgnoreCase(boolean b) {
        this.bIgnoreCase = b;
    }

    boolean isIgnoreCase() {
        return this.bIgnoreCase;
    }

    int getDefaultTableType() {
        String dttName = this.getProperties().getProperty("hsqldb.default_table_type");
        return "CACHED".equalsIgnoreCase(dttName) ? 4 : 3;
    }

    protected void finalize() {
        if (this.getState() != 1) {
            return;
        }
        try {
            this.close(-1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    void closeIfLast() {
        if (this.shutdownOnNoConnection && this.sessionManager.isEmpty()) {
            if (this.dbState == 1) {
                try {
                    this.close(0);
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
    }

    void close(int closemode) throws HsqlException {
        HsqlException he = null;
        this.setState(8);
        this.sessionManager.closeAllSessions();
        this.sessionManager.clearAll();
        if (this.filesReadOnly) {
            closemode = -1;
        }
        this.logger.closeLog(closemode);
        try {
            if (closemode == 1) {
                this.clearStructures();
                this.reopen();
                this.setState(8);
                this.logger.closeLog(0);
            }
        }
        catch (Throwable t) {
            he = t instanceof HsqlException ? (HsqlException)t : Trace.error(40, t.toString());
        }
        this.classLoader = null;
        this.logger.releaseLock();
        this.setState(16);
        this.clearStructures();
        DatabaseManager.removeDatabase(this);
        if (he != null) {
            throw he;
        }
    }

    public void setMetaDirty(boolean resetPrepared) {
        if (this.dbInfo != null) {
            this.dbInfo.setDirty();
        }
        if (resetPrepared) {
            this.compiledStatementManager.resetStatements();
        }
    }

    private synchronized void setState(int state) {
        this.dbState = state;
    }

    synchronized int getState() {
        return this.dbState;
    }

    String getStateString() {
        int state = this.getState();
        switch (state) {
            case 8: {
                return "DATABASE_CLOSING";
            }
            case 1: {
                return "DATABASE_ONLINE";
            }
            case 4: {
                return "DATABASE_OPENING";
            }
            case 16: {
                return "DATABASE_SHUTDOWN";
            }
        }
        return "UNKNOWN";
    }

    public String getURI() {
        return this.sName;
    }

    public HsqlProperties getURLProperties() {
        return this.urlProperties;
    }

    public synchronized FileAccess getFileAccess() {
        return this.fileaccess;
    }

    public synchronized boolean isStoredFileAccess() {
        return this.isStoredFileAccess;
    }
}

