/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Locale;
import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.DatabaseScript;
import org.hsqldb.Expression;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Parser;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.View;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.scriptio.ScriptWriterText;

class DatabaseCommandInterpreter {
    private Tokenizer tokenizer = new Tokenizer();
    private Database database;
    private Session session;
    static final String oldLib = "org.hsql.Library.";
    static final int oldLibLen = "org.hsql.Library.".length();
    static final String newLib = "org.hsqldb.Library.";

    DatabaseCommandInterpreter(Session s) {
        this.session = s;
        this.database = s.getDatabase();
    }

    Result execute(String sql) {
        JavaSystem.gc();
        Result result = null;
        int cmd = -1;
        try {
            this.tokenizer.reset(sql);
            while (true) {
                this.tokenizer.setPartMarker();
                this.session.setScripting(false);
                String token = this.tokenizer.getSimpleToken();
                if (token.length() == 0) {
                    this.session.endSchemaDefinition();
                    break;
                }
                cmd = Token.get(token);
                if (cmd == 323) {
                    this.session.endSchemaDefinition();
                    continue;
                }
                result = this.executePart(cmd, token);
                if (result.isError()) {
                    this.session.endSchemaDefinition();
                    break;
                }
                if (!this.session.getScripting()) continue;
                this.database.logger.writeToLog(this.session, this.tokenizer.getLastPart());
            }
        }
        catch (Throwable t) {
            try {
                if (this.session.isSchemaDefintion()) {
                    HsqlNameManager.HsqlName schemaName = this.session.getSchemaHsqlName(null);
                    this.database.schemaManager.dropSchema(schemaName.name, true);
                    this.database.logger.writeToLog(this.session, "DROP SCHEMA " + schemaName.statementName + ' ' + "CASCADE");
                    this.session.endSchemaDefinition();
                }
            }
            catch (HsqlException e) {
                // empty catch block
            }
            result = new Result(t, this.tokenizer.getLastPart());
        }
        return result == null ? Session.emptyUpdateCount : result;
    }

    private Result executePart(int cmd, String token) throws Throwable {
        Result result = Session.emptyUpdateCount;
        int brackets = 0;
        if (this.session.isSchemaDefintion()) {
            switch (cmd) {
                case 41: 
                case 96: {
                    break;
                }
                default: {
                    throw Trace.error(74, 250, new Object[]{token});
                }
            }
        }
        switch (cmd) {
            case 313: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                brackets = parser.parseOpenBracketsSelect() + 1;
            }
            case 193: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                CompiledStatement cStatement = parser.compileSelectStatement(brackets);
                if (cStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(cStatement, null);
                break;
            }
            case 112: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                CompiledStatement cStatement = parser.compileInsertStatement();
                if (cStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(cStatement, null);
                break;
            }
            case 222: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                CompiledStatement cStatement = parser.compileUpdateStatement();
                if (cStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(cStatement, null);
                break;
            }
            case 62: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                CompiledStatement cStatement = parser.compileDeleteStatement();
                if (cStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(cStatement, null);
                break;
            }
            case 23: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                CompiledStatement cStatement = parser.compileCallStatement();
                if (cStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(cStatement, null);
                break;
            }
            case 196: {
                this.processSet();
                break;
            }
            case 35: {
                this.processCommit();
                break;
            }
            case 184: {
                this.processRollback();
                break;
            }
            case 188: {
                this.processSavepoint();
                break;
            }
            case 176: {
                this.processReleaseSavepoint();
                break;
            }
            case 41: {
                this.processCreate();
                this.database.setMetaDirty(false);
                break;
            }
            case 4: {
                this.processAlter();
                this.database.setMetaDirty(true);
                break;
            }
            case 70: {
                this.processDrop();
                this.database.setMetaDirty(true);
                break;
            }
            case 96: {
                this.processGrantOrRevoke(true);
                this.database.setMetaDirty(false);
                break;
            }
            case 182: {
                this.processGrantOrRevoke(false);
                this.database.setMetaDirty(true);
                break;
            }
            case 37: {
                this.processConnect();
                this.database.setMetaDirty(false);
                this.session.setScripting(false);
                break;
            }
            case 66: {
                this.processDisconnect();
                this.session.setScripting(true);
                break;
            }
            case 321: {
                result = this.processScript();
                break;
            }
            case 325: {
                this.processShutdown();
                break;
            }
            case 303: {
                this.processCheckpoint();
                break;
            }
            case 304: {
                result = this.processExplainPlan();
                break;
            }
            default: {
                throw Trace.error(11, token);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result processScript() throws IOException, HsqlException {
        String token = this.tokenizer.getString();
        ScriptWriterBase dsw = null;
        this.session.checkAdmin();
        try {
            if (this.tokenizer.wasValue()) {
                if (this.tokenizer.getType() != 12) {
                    throw Trace.error(74);
                }
                dsw = new ScriptWriterText(this.database, token, true, true, true);
                dsw.writeAll();
                Result result = new Result(1);
                return result;
            }
            this.tokenizer.back();
            Result result = DatabaseScript.getScript(this.database, false);
            return result;
        }
        finally {
            if (dsw != null) {
                dsw.close();
            }
        }
    }

    private void processCreate() throws HsqlException {
        boolean unique = false;
        boolean isTempTable = false;
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        this.session.setScripting(true);
        if (this.tokenizer.isGetThis("GLOBAL")) {
            this.tokenizer.getThis("TEMPORARY");
            isTempTable = true;
        } else if (this.tokenizer.isGetThis("TEMP")) {
            isTempTable = true;
        } else if (this.tokenizer.isGetThis("TEMPORARY")) {
            isTempTable = true;
        }
        String token = this.tokenizer.getSimpleToken();
        switch (Token.get(token)) {
            case 310: {
                this.tokenizer.getThis("TABLE");
            }
            case 213: {
                int tableType = isTempTable ? 2 : this.database.getDefaultTableType();
                this.processCreateTable(tableType);
                return;
            }
            case 302: {
                if (isTempTable) {
                    throw Trace.error(11, token);
                }
                this.tokenizer.getThis("TABLE");
                this.processCreateTable(4);
                return;
            }
            case 328: {
                if (isTempTable) {
                    throw Trace.error(11, token);
                }
                this.tokenizer.getThis("TABLE");
                this.processCreateTable(6);
                return;
            }
        }
        if (isTempTable) {
            throw Trace.error(11, token);
        }
        switch (Token.get(token)) {
            case 300: {
                this.processCreateAlias();
                break;
            }
            case 324: {
                this.processCreateSequence();
                break;
            }
            case 338: {
                this.session.setScripting(false);
                this.processCreateSchema();
                break;
            }
            case 224: {
                this.processCreateTrigger();
                break;
            }
            case 223: {
                this.processCreateUser();
                break;
            }
            case 339: {
                this.database.getGranteeManager().addRole(this.getUserIdentifier());
                break;
            }
            case 329: {
                this.processCreateView();
                break;
            }
            case 228: {
                unique = true;
                this.tokenizer.getThis("INDEX");
            }
            case 306: {
                this.processCreateIndex(unique);
                break;
            }
            default: {
                throw Trace.error(11, token);
            }
        }
    }

    private int[] processColumnList(Table t, boolean acceptAscDesc) throws HsqlException {
        HashMappedList list = Parser.processColumnList(this.tokenizer, acceptAscDesc);
        int size = list.size();
        int[] col = new int[size];
        for (int i = 0; i < size; ++i) {
            col[i] = t.getColumnNr((String)list.getKey(i));
        }
        return col;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCreateTrigger() throws HsqlException {
        String triggerName = this.tokenizer.getName();
        String schemaname = this.tokenizer.getLongNameFirst();
        this.database.schemaManager.checkTriggerExists(triggerName, this.session.getSchemaNameForWrite(schemaname), false);
        boolean isQuoted = this.tokenizer.wasQuotedIdentifier();
        boolean isForEach = false;
        boolean isNowait = false;
        int queueSize = TriggerDef.getDefaultQueueSize();
        String sWhen = this.tokenizer.getSimpleToken();
        String sOper = this.tokenizer.getSimpleToken();
        this.tokenizer.getThis("ON");
        String tableName = this.tokenizer.getName();
        if (schemaname == null) {
            schemaname = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        } else if (!schemaname.equals(this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst()))) {
            throw Trace.error(227);
        }
        Table t = this.database.schemaManager.getUserTable(this.session, tableName, schemaname);
        if (t.isView()) {
            throw Trace.error(55);
        }
        this.session.setScripting(true);
        String token = this.tokenizer.getSimpleToken();
        if (token.equals("FOR")) {
            token = this.tokenizer.getSimpleToken();
            if (!token.equals("EACH")) throw Trace.error(12, token);
            token = this.tokenizer.getSimpleToken();
            if (!token.equals("ROW")) throw Trace.error(12, token);
            isForEach = true;
            token = this.tokenizer.getSimpleToken();
        }
        if (token.equals("NOWAIT")) {
            isNowait = true;
            token = this.tokenizer.getSimpleToken();
        }
        if (token.equals("QUEUE")) {
            queueSize = this.tokenizer.getInt();
            token = this.tokenizer.getSimpleToken();
        }
        if (!token.equals("CALL")) {
            throw Trace.error(12, token);
        }
        String className = this.tokenizer.getSimpleName();
        if (!this.tokenizer.wasQuotedIdentifier()) {
            throw Trace.error(12, className);
        }
        HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(triggerName, isQuoted);
        TriggerDef td = new TriggerDef(name, sWhen, sOper, isForEach, t, className, isNowait, queueSize, this.database.classLoader);
        t.addTrigger(td);
        if (td.isValid()) {
            try {
                td.start();
            }
            catch (Exception e) {
                throw Trace.error(13, e.toString());
            }
        }
        this.database.schemaManager.registerTriggerName(triggerName, t.getName());
    }

    private Column processCreateColumn() throws HsqlException {
        String token = this.tokenizer.getSimpleName();
        boolean isQuoted = this.tokenizer.wasQuotedIdentifier();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(token, isQuoted);
        return this.processCreateColumn(hsqlName);
    }

    private Column processCreateColumn(HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        boolean isIdentity = false;
        long identityStart = this.database.firstIdentity;
        long identityIncrement = 1L;
        boolean isPrimaryKey = false;
        int length = 0;
        int scale = 0;
        boolean hasLength = false;
        boolean isNullable = true;
        Expression defaultExpr = null;
        String typeName = this.tokenizer.getSimpleToken();
        int type = Types.getTypeNr(typeName);
        if (type == 1 && this.tokenizer.isGetThis("VARYING")) {
            type = 12;
        }
        if (typeName.equals("IDENTITY")) {
            isIdentity = true;
            isPrimaryKey = true;
        }
        if (type == 8) {
            this.tokenizer.isGetThis("PRECISION");
        }
        if (this.tokenizer.isGetThis("(")) {
            hasLength = true;
            length = this.tokenizer.getInt();
            Trace.check(Types.acceptsPrecisionCreateParam(type), 11);
            if (type != 93 && type != 92 && length == 0) {
                throw Trace.error(254);
            }
            if (this.tokenizer.isGetThis(",")) {
                Trace.check(Types.acceptsScaleCreateParam(type), 11);
                scale = this.tokenizer.getInt();
            }
            this.tokenizer.getThis(")");
        } else if (type == 1 && this.database.sqlEnforceStrictSize) {
            length = 1;
        } else if (type == 12 && this.database.sqlEnforceStrictSize) {
            throw Trace.error(253);
        }
        if (type == 12 && this.database.isIgnoreCase()) {
            type = 100;
        }
        if (type == 6 && length > 53) {
            throw Trace.error(65);
        }
        if (type == 93) {
            if (!hasLength) {
                length = 6;
            } else if (length != 0 && length != 6) {
                throw Trace.error(65);
            }
        }
        if (type == 92 && length != 0) {
            throw Trace.error(65);
        }
        String token = this.tokenizer.getSimpleToken();
        if (token.equals("DEFAULT")) {
            defaultExpr = this.processCreateDefaultExpression(type, length, scale);
            token = this.tokenizer.getSimpleToken();
        } else if (token.equals("GENERATED")) {
            this.tokenizer.getThis("BY");
            this.tokenizer.getThis("DEFAULT");
            this.tokenizer.getThis("AS");
            this.tokenizer.getThis("IDENTITY");
            if (this.tokenizer.isGetThis("(")) {
                this.tokenizer.getThis("START");
                this.tokenizer.getThis("WITH");
                identityStart = this.tokenizer.getBigint();
                if (this.tokenizer.isGetThis(",")) {
                    this.tokenizer.getThis("INCREMENT");
                    this.tokenizer.getThis("BY");
                    identityIncrement = this.tokenizer.getBigint();
                }
                this.tokenizer.getThis(")");
            }
            isIdentity = true;
            isPrimaryKey = true;
            token = this.tokenizer.getSimpleToken();
        }
        if (token.equals("IDENTITY")) {
            isIdentity = true;
            isPrimaryKey = true;
            token = this.tokenizer.getSimpleToken();
        }
        if (token.equals("NULL")) {
            token = this.tokenizer.getSimpleToken();
        } else if (token.equals("NOT")) {
            this.tokenizer.getThis("NULL");
            isNullable = false;
            token = this.tokenizer.getSimpleToken();
        }
        if (token.equals("IDENTITY")) {
            if (isIdentity) {
                throw Trace.error(24, "IDENTITY");
            }
            isIdentity = true;
            isPrimaryKey = true;
            token = this.tokenizer.getSimpleToken();
        }
        if (token.equals("PRIMARY")) {
            this.tokenizer.getThis("KEY");
            isPrimaryKey = true;
        } else {
            this.tokenizer.back();
        }
        if (isIdentity && defaultExpr != null) {
            throw Trace.error(11, "DEFAULT");
        }
        Column column = new Column(hsqlName, isNullable, type, length, scale, isPrimaryKey, defaultExpr);
        column.setIdentity(isIdentity, identityStart, identityIncrement);
        return column;
    }

    private Expression processCreateDefaultExpression(int type, int length, int scale) throws HsqlException {
        if (type == 1111) {
            throw Trace.error(46);
        }
        Parser parser = new Parser(this.session, this.database, this.tokenizer);
        Expression expr = parser.readDefaultClause(type);
        expr.resolveTypes(this.session);
        int newType = expr.getType();
        if (newType == 1 || newType == 4 || newType == -4 || newType == 7 && expr.function.isSimple) {
            Object defValTemp;
            try {
                defValTemp = expr.getValue(this.session, type);
            }
            catch (HsqlException e) {
                throw Trace.error(46);
            }
            if (defValTemp != null && this.database.sqlEnforceStrictSize) {
                try {
                    Column.enforceSize(defValTemp, type, length, scale, true);
                }
                catch (HsqlException e) {
                    throw Trace.error(46);
                }
            }
            return expr;
        }
        throw Trace.error(46);
    }

    public static void checkBooleanDefault(String s, int type) throws HsqlException {
        if (type != 16 || s == null) {
            return;
        }
        if ((s = s.toUpperCase()).equals("TRUE") || s.equals("FALSE")) {
            return;
        }
        if (s.equals("0") || s.equals("1")) {
            return;
        }
        throw Trace.error(46, s);
    }

    private HsqlArrayList processCreateConstraints(Table t, boolean constraint, int[] primarykeycolumn) throws HsqlException {
        String token;
        HsqlArrayList tcList = new HsqlArrayList();
        Constraint tempConst = new Constraint(null, primarykeycolumn, null, null, 1, 3, 3);
        HsqlNameManager.HsqlName pkHsqlName = null;
        tcList.add(tempConst);
        if (!constraint) {
            return tcList;
        }
        do {
            HsqlNameManager.HsqlName cname = null;
            if (this.tokenizer.isGetThis("CONSTRAINT")) {
                token = this.tokenizer.getName();
                String constraintSchema = this.tokenizer.getLongNameFirst();
                if (constraintSchema != null) {
                    constraintSchema = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
                    if (!t.getSchemaName().equals(constraintSchema)) {
                        throw Trace.error(227, constraintSchema);
                    }
                }
                cname = this.database.nameManager.newHsqlName(token, this.tokenizer.wasQuotedIdentifier());
            }
            token = this.tokenizer.getSimpleToken();
            switch (Token.get(token)) {
                case 167: {
                    this.tokenizer.getThis("KEY");
                    pkHsqlName = cname;
                    int[] cols = this.processColumnList(t, false);
                    Constraint mainConst = (Constraint)tcList.get(0);
                    if (mainConst.core.mainColArray != null && !ArrayUtil.areEqual(mainConst.core.mainColArray, cols, cols.length, true)) {
                        throw Trace.error(24);
                    }
                    mainConst.core.mainColArray = cols;
                    mainConst.constName = pkHsqlName;
                    break;
                }
                case 228: {
                    int[] col = this.processColumnList(t, false);
                    if (cname == null) {
                        cname = this.database.nameManager.newAutoName("CT");
                    }
                    tempConst = new Constraint(cname, col, null, null, 2, 3, 3);
                    tcList.add(tempConst);
                    break;
                }
                case 89: {
                    this.tokenizer.getThis("KEY");
                    tempConst = this.processCreateFK(t, cname);
                    if (tempConst.core.refColArray == null) {
                        Constraint mainConst = (Constraint)tcList.get(0);
                        tempConst.core.refColArray = mainConst.core.mainColArray;
                        if (tempConst.core.refColArray == null) {
                            throw Trace.error(61, 103);
                        }
                    }
                    this.checkFKColumnDefaults(t, tempConst);
                    t.checkColumnsMatch(tempConst.core.mainColArray, tempConst.core.refTable, tempConst.core.refColArray);
                    tcList.add(tempConst);
                    break;
                }
                case 30: {
                    if (cname == null) {
                        cname = this.database.nameManager.newAutoName("CT");
                    }
                    tempConst = new Constraint(cname, null, null, null, 3, 3, 3);
                    this.processCreateCheckConstraintCondition(tempConst);
                    tcList.add(tempConst);
                }
            }
        } while ((token = this.tokenizer.getSimpleToken()).equals(","));
        if (!token.equals(")")) {
            throw Trace.error(11, token);
        }
        return tcList;
    }

    private void processCreateCheckConstraintCondition(Constraint c) throws HsqlException {
        this.tokenizer.getThis("(");
        Parser parser = new Parser(this.session, this.database, this.tokenizer);
        Expression condition = parser.parseExpression();
        this.tokenizer.getThis(")");
        c.core.check = condition;
    }

    private void processCreateTable(int type) throws HsqlException {
        Table t;
        boolean constraint;
        int[] pkCols;
        String token;
        block18: {
            token = this.tokenizer.getName();
            HsqlNameManager.HsqlName schemaname = this.session.getSchemaHsqlNameForWrite(this.tokenizer.getLongNameFirst());
            this.database.schemaManager.checkUserTableNotExists(this.session, token, schemaname.name);
            boolean isnamequoted = this.tokenizer.wasQuotedIdentifier();
            pkCols = null;
            int colIndex = 0;
            constraint = false;
            t = this.newTable(type, token, isnamequoted, schemaname);
            this.tokenizer.getThis("(");
            while (true) {
                token = this.tokenizer.getString();
                switch (Token.get(token)) {
                    case 30: 
                    case 38: 
                    case 89: 
                    case 167: 
                    case 228: {
                        constraint = !this.tokenizer.wasQuotedIdentifier() && !this.tokenizer.wasLongName();
                    }
                }
                this.tokenizer.back();
                if (constraint) break block18;
                Column newcolumn = this.processCreateColumn();
                t.addColumn(newcolumn);
                if (newcolumn.isPrimaryKey()) {
                    Trace.check(pkCols == null, 24, newcolumn.columnName.name);
                    pkCols = new int[]{colIndex};
                }
                if (!(token = this.tokenizer.getSimpleToken()).equals(",")) break;
                ++colIndex;
            }
            if (!token.equals(")")) {
                throw Trace.error(11, token);
            }
        }
        HsqlArrayList tempConstraints = this.processCreateConstraints(t, constraint, pkCols);
        if (this.tokenizer.isGetThis("ON")) {
            if (!t.isTemp) {
                throw Trace.error(11, "ON");
            }
            this.tokenizer.getThis("COMMIT");
            token = this.tokenizer.getSimpleToken();
            if (!token.equals("DELETE")) {
                if (token.equals("PRESERVE")) {
                    t.onCommitPreserve = true;
                } else {
                    throw Trace.error(11, token);
                }
            }
            this.tokenizer.getThis("ROWS");
        }
        try {
            this.session.commit();
            Constraint primaryConst = (Constraint)tempConstraints.get(0);
            t.createPrimaryKey(null, primaryConst.core.mainColArray, true);
            if (primaryConst.core.mainColArray != null) {
                if (primaryConst.constName == null) {
                    primaryConst.constName = t.makeSysPKName();
                }
                Constraint newconstraint = new Constraint(primaryConst.constName, t, t.getPrimaryIndex(), 4);
                t.addConstraint(newconstraint);
                this.database.schemaManager.registerConstraintName(primaryConst.constName.name, t.getName());
            }
            for (int i = 1; i < tempConstraints.size(); ++i) {
                TableWorks tableWorks;
                Constraint tempConst = (Constraint)tempConstraints.get(i);
                if (tempConst.constType == 2) {
                    tableWorks = new TableWorks(this.session, t);
                    tableWorks.createUniqueConstraint(tempConst.core.mainColArray, tempConst.constName);
                    t = tableWorks.getTable();
                }
                if (tempConst.constType == 0) {
                    tableWorks = new TableWorks(this.session, t);
                    tableWorks.createForeignKey(tempConst.core.mainColArray, tempConst.core.refColArray, tempConst.constName, tempConst.core.refTable, tempConst.core.deleteAction, tempConst.core.updateAction);
                    t = tableWorks.getTable();
                }
                if (tempConst.constType != 3) continue;
                tableWorks = new TableWorks(this.session, t);
                tableWorks.createCheckConstraint(tempConst, tempConst.constName);
                t = tableWorks.getTable();
            }
            this.database.schemaManager.linkTable(t);
        }
        catch (HsqlException e) {
            this.database.schemaManager.removeExportedKeys(t);
            this.database.schemaManager.removeIndexNames(t.tableName);
            this.database.schemaManager.removeConstraintNames(t.tableName);
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Constraint processCreateFK(Table t, HsqlNameManager.HsqlName cname) throws HsqlException {
        int[] localcol = this.processColumnList(t, false);
        this.tokenizer.getThis("REFERENCES");
        String expTableName = this.tokenizer.getName();
        String constraintSchema = this.tokenizer.getLongNameFirst();
        if (constraintSchema != null) {
            constraintSchema = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
            if (!t.getSchemaName().equals(constraintSchema)) {
                throw Trace.error(227, constraintSchema);
            }
        }
        Table expTable = t.getName().name.equals(expTableName) ? t : this.database.schemaManager.getTable(this.session, expTableName, t.getSchemaName());
        int[] expcol = null;
        String token = this.tokenizer.getSimpleToken();
        this.tokenizer.back();
        if (token.equals("(")) {
            expcol = this.processColumnList(expTable, false);
        } else if (expTable.getPrimaryKey() == null) {
            Trace.check(t == expTable, 103);
        } else {
            if (!expTable.hasPrimaryKey()) throw Trace.error(61, 103);
            expcol = expTable.getPrimaryKey();
        }
        token = this.tokenizer.getSimpleToken();
        int deleteAction = 3;
        int updateAction = 3;
        while (token.equals("ON")) {
            token = this.tokenizer.getSimpleToken();
            if (deleteAction == 3 && token.equals("DELETE")) {
                token = this.tokenizer.getSimpleToken();
                if (token.equals("SET")) {
                    token = this.tokenizer.getSimpleToken();
                    if (token.equals("DEFAULT")) {
                        deleteAction = 4;
                    } else {
                        if (!token.equals("NULL")) throw Trace.error(11, token);
                        deleteAction = 2;
                    }
                } else if (token.equals("CASCADE")) {
                    deleteAction = 0;
                } else if (!token.equals("RESTRICT")) {
                    this.tokenizer.matchThis("NO");
                    this.tokenizer.getThis("ACTION");
                }
            } else {
                if (updateAction != 3 || !token.equals("UPDATE")) throw Trace.error(11, token);
                token = this.tokenizer.getSimpleToken();
                if (token.equals("SET")) {
                    token = this.tokenizer.getSimpleToken();
                    if (token.equals("DEFAULT")) {
                        updateAction = 4;
                    } else {
                        if (!token.equals("NULL")) throw Trace.error(11, token);
                        updateAction = 2;
                    }
                } else if (token.equals("CASCADE")) {
                    updateAction = 0;
                } else if (!token.equals("RESTRICT")) {
                    this.tokenizer.matchThis("NO");
                    this.tokenizer.getThis("ACTION");
                }
            }
            token = this.tokenizer.getSimpleToken();
        }
        this.tokenizer.back();
        if (cname != null) return new Constraint(cname, localcol, expTable, expcol, 0, deleteAction, updateAction);
        cname = this.database.nameManager.newAutoName("FK");
        return new Constraint(cname, localcol, expTable, expcol, 0, deleteAction, updateAction);
    }

    private void processCreateView() throws HsqlException {
        String name = this.tokenizer.getName();
        HsqlNameManager.HsqlName schemaname = this.session.getSchemaHsqlNameForWrite(this.tokenizer.getLongNameFirst());
        int logposition = this.tokenizer.getPartMarker();
        this.database.schemaManager.checkUserViewNotExists(this.session, name, schemaname.name);
        HsqlNameManager.HsqlName viewHsqlName = this.database.nameManager.newHsqlName(name, this.tokenizer.wasQuotedIdentifier());
        viewHsqlName.schema = schemaname;
        HsqlNameManager.HsqlName[] colList = null;
        if (this.tokenizer.isGetThis("(")) {
            try {
                HsqlArrayList list = Parser.getColumnNames(this.database, null, this.tokenizer, true);
                colList = new HsqlNameManager.HsqlName[list.size()];
                colList = (HsqlNameManager.HsqlName[])list.toArray(colList);
            }
            catch (HsqlException e) {
                if (this.database.isStoredFileAccess() && this.session.isProcessingScript()) {
                    String token;
                    while (!(token = this.tokenizer.getString()).equals(")") && !token.equals("")) {
                    }
                }
                throw e;
            }
        }
        this.tokenizer.getThis("AS");
        this.tokenizer.setPartMarker();
        Parser parser = new Parser(this.session, this.database, this.tokenizer);
        int brackets = parser.parseOpenBracketsSelect();
        Select select = parser.parseSelect(brackets, true, false, true, true);
        if (select.sIntoTable != null) {
            throw Trace.error(74, 117);
        }
        select.prepareResult(this.session);
        View view = new View(this.session, this.database, viewHsqlName, this.tokenizer.getLastPart(), colList);
        this.session.commit();
        this.database.schemaManager.linkTable(view);
        this.tokenizer.setPartMarker(logposition);
    }

    private void processAlterTableRename(Table t) throws HsqlException {
        String schema = t.getSchemaName();
        this.tokenizer.getThis("TO");
        String newName = this.tokenizer.getName();
        String newSchema = this.tokenizer.getLongNameFirst();
        boolean isquoted = this.tokenizer.wasQuotedIdentifier();
        String string = newSchema = newSchema == null ? schema : this.session.getSchemaNameForWrite(newSchema);
        if (!schema.equals(newSchema)) {
            throw Trace.error(227);
        }
        this.database.schemaManager.checkUserTableNotExists(this.session, newName, schema);
        this.session.commit();
        this.session.setScripting(true);
        this.database.schemaManager.renameTable(this.session, t, newName, isquoted);
    }

    private void processAlter() throws HsqlException {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        this.session.setScripting(true);
        String token = this.tokenizer.getSimpleToken();
        switch (Token.get(token)) {
            case 306: {
                this.processAlterIndex();
                break;
            }
            case 338: {
                this.processAlterSchema();
                break;
            }
            case 324: {
                this.processAlterSequence();
                break;
            }
            case 213: {
                this.processAlterTable();
                break;
            }
            case 223: {
                this.processAlterUser();
                break;
            }
            default: {
                throw Trace.error(11, token);
            }
        }
    }

    private void processAlterTable() throws HsqlException {
        String schema;
        String tableName = this.tokenizer.getName();
        Table t = this.database.schemaManager.getUserTable(this.session, tableName, schema = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst()));
        if (t.isView()) {
            throw Trace.error(55);
        }
        this.session.setScripting(true);
        String token = this.tokenizer.getSimpleToken();
        switch (Token.get(token)) {
            case 319: {
                this.processAlterTableRename(t);
                return;
            }
            case 1: {
                HsqlNameManager.HsqlName cname = null;
                if (this.tokenizer.isGetThis("CONSTRAINT")) {
                    token = this.tokenizer.getName();
                    String constraintSchema = this.tokenizer.getLongNameFirst();
                    if (constraintSchema != null) {
                        constraintSchema = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
                        if (!t.getSchemaName().equals(constraintSchema)) {
                            throw Trace.error(227, constraintSchema);
                        }
                    }
                    cname = this.database.nameManager.newHsqlName(token, this.tokenizer.wasQuotedIdentifier());
                }
                token = this.tokenizer.getString();
                if (this.tokenizer.wasQuotedIdentifier() && this.tokenizer.wasSimpleName()) {
                    this.tokenizer.back();
                    this.processAlterTableAddColumn(t);
                    return;
                }
                if (!this.tokenizer.wasSimpleToken()) {
                    throw Trace.error(11, token);
                }
                switch (Token.get(token)) {
                    case 89: {
                        this.tokenizer.getThis("KEY");
                        this.processAlterTableAddForeignKeyConstraint(t, cname);
                        return;
                    }
                    case 228: {
                        this.processAlterTableAddUniqueConstraint(t, cname);
                        return;
                    }
                    case 30: {
                        this.processAlterTableAddCheckConstraint(t, cname);
                        return;
                    }
                    case 167: {
                        this.tokenizer.getThis("KEY");
                        this.processAlterTableAddPrimaryKey(t, cname);
                        return;
                    }
                    default: {
                        if (cname != null) {
                            throw Trace.error(11, token);
                        }
                        this.tokenizer.back();
                    }
                    case 34: 
                }
                this.processAlterTableAddColumn(t);
                return;
            }
            case 70: {
                token = this.tokenizer.getString();
                if (this.tokenizer.wasQuotedIdentifier() && this.tokenizer.wasSimpleName()) {
                    this.tokenizer.back();
                    this.processAlterTableDropColumn(t);
                    return;
                }
                if (!this.tokenizer.wasSimpleToken()) {
                    throw Trace.error(11, token);
                }
                switch (Token.get(token)) {
                    case 167: {
                        this.tokenizer.getThis("KEY");
                        if (!t.hasPrimaryKey()) {
                            throw Trace.error(61, 103, new Object[]{"PRIMARY KEY", t.getName().name});
                        }
                        this.processAlterTableDropConstraint(t, t.getPrimaryConstraint().getName().name);
                        return;
                    }
                    case 38: {
                        this.processAlterTableDropConstraint(t);
                        return;
                    }
                    default: {
                        this.tokenizer.back();
                    }
                    case 34: 
                }
                this.processAlterTableDropColumn(t);
                return;
            }
            case 4: {
                this.tokenizer.isGetThis("COLUMN");
                this.processAlterColumn(t);
                return;
            }
        }
        throw Trace.error(11, token);
    }

    private void processAlterColumn(Table t) throws HsqlException {
        String columnName = this.tokenizer.getSimpleName();
        int columnIndex = t.getColumnNr(columnName);
        Column column = t.getColumn(columnIndex);
        String token = this.tokenizer.getSimpleToken();
        switch (Token.get(token)) {
            case 319: {
                this.tokenizer.getThis("TO");
                this.processAlterColumnRename(t, column);
                return;
            }
            case 70: {
                this.tokenizer.getThis("DEFAULT");
                TableWorks tw = new TableWorks(this.session, t);
                tw.setColDefaultExpression(columnIndex, null);
                return;
            }
            case 196: {
                token = this.tokenizer.getSimpleToken();
                if (token.equals("NOT")) {
                    this.tokenizer.getThis("NULL");
                    TableWorks tw = new TableWorks(this.session, t);
                    tw.setColNullability(column, false);
                } else if (token.equals("NULL")) {
                    TableWorks tw = new TableWorks(this.session, t);
                    tw.setColNullability(column, true);
                } else if (token.equals("DEFAULT")) {
                    TableWorks tw = new TableWorks(this.session, t);
                    int type = column.getType();
                    int length = column.getSize();
                    int scale = column.getScale();
                    Expression expr = this.processCreateDefaultExpression(type, length, scale);
                    tw.setColDefaultExpression(columnIndex, expr);
                } else {
                    throw Trace.error(11, token);
                }
                return;
            }
            case 320: {
                this.tokenizer.getThis("WITH");
                long identityStart = this.tokenizer.getBigint();
                int id = t.getIdentityColumn();
                if (id == -1) {
                    throw Trace.error(73);
                }
                t.identitySequence.reset(identityStart);
                return;
            }
        }
        this.tokenizer.back();
        this.processAlterColumnType(t, column);
    }

    private void processAlterColumnType(Table table, Column oldCol) throws HsqlException {
        Column newCol = this.processCreateColumn(oldCol.columnName);
        TableWorks tw = new TableWorks(this.session, table);
        tw.reTypeColumn(oldCol, newCol);
    }

    private void processAlterColumnRename(Table t, Column column) throws HsqlException {
        String newName = this.tokenizer.getSimpleName();
        boolean isquoted = this.tokenizer.wasQuotedIdentifier();
        if (t.findColumn(newName) > -1) {
            throw Trace.error(27, newName);
        }
        t.database.schemaManager.checkColumnIsInView(t, column.columnName.name);
        this.session.commit();
        this.session.setScripting(true);
        t.renameColumn(column, newName, isquoted);
    }

    private void processAlterIndex() throws HsqlException {
        this.processAlterIndexRename();
    }

    private void processAlterSchema() throws HsqlException {
        this.processAlterSchemaRename();
    }

    private void processDrop() throws HsqlException {
        this.session.checkReadWrite();
        this.session.checkAdmin();
        this.session.setScripting(true);
        String token = this.tokenizer.getSimpleToken();
        boolean isview = false;
        switch (Token.get(token)) {
            case 306: {
                this.processDropIndex();
                break;
            }
            case 338: {
                this.processDropSchema();
                break;
            }
            case 324: {
                this.processDropSequence();
                break;
            }
            case 224: {
                this.processDropTrigger();
                break;
            }
            case 223: {
                this.processDropUser();
                break;
            }
            case 339: {
                this.database.getGranteeManager().dropRole(this.tokenizer.getSimpleName());
                break;
            }
            case 329: {
                isview = true;
            }
            case 213: {
                this.processDropTable(isview);
                break;
            }
            default: {
                throw Trace.error(11, token);
            }
        }
    }

    private void processGrantOrRevoke(boolean grant) throws HsqlException {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        this.session.setScripting(true);
        int right = 0;
        String token = this.tokenizer.getSimpleToken();
        this.tokenizer.back();
        if (!GranteeManager.validRightString(token)) {
            this.processRoleGrantOrRevoke(grant);
            return;
        }
        do {
            token = this.tokenizer.getSimpleToken();
            right |= GranteeManager.getCheckRight(token);
        } while (this.tokenizer.isGetThis(","));
        this.tokenizer.getThis("ON");
        Object accessKey = null;
        if (this.tokenizer.isGetThis("CLASS")) {
            accessKey = this.tokenizer.getSimpleName();
            if (!this.tokenizer.wasQuotedIdentifier()) {
                throw Trace.error(125);
            }
        } else {
            token = this.tokenizer.getName();
            String schema = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
            Table t = this.database.schemaManager.getTable(this.session, token, schema);
            accessKey = t.getName();
            this.session.setScripting(true);
        }
        this.tokenizer.getThis(grant ? "TO" : "FROM");
        token = this.getUserIdentifier();
        GranteeManager gm = this.database.getGranteeManager();
        if (grant) {
            gm.grant(token, accessKey, right);
        } else {
            gm.revoke(token, accessKey, right);
        }
    }

    private void processConnect() throws HsqlException {
        this.tokenizer.getThis("USER");
        String userName = this.getUserIdentifier();
        if (this.tokenizer.isGetThis("PASSWORD")) {
            String password = this.getPassword();
            User user = this.database.getUserManager().getUser(userName, password);
            this.session.commit();
            this.session.setUser(user);
            this.database.logger.logConnectUser(this.session);
        } else if (this.session.isProcessingLog) {
            this.session.commit();
        } else {
            this.tokenizer.getThis("PASSWORD");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSet() throws HsqlException {
        this.session.setScripting(true);
        String token = this.tokenizer.getSimpleToken();
        switch (Token.get(token)) {
            case 316: {
                this.session.checkAdmin();
                token = this.tokenizer.getSimpleName();
                if (!this.tokenizer.wasQuotedIdentifier()) {
                    throw Trace.error(125);
                }
                HsqlDatabaseProperties p = this.database.getProperties();
                boolean isboolean = p.isBoolean(token);
                boolean isintegral = p.isIntegral(token);
                boolean isstring = p.isString(token);
                Trace.check(isboolean || isintegral || isstring, 33, token);
                int type = isboolean ? 16 : (isintegral ? 4 : 12);
                Object value = this.tokenizer.getInType(type);
                if ("hsqldb.cache_file_scale".equals(token) && (this.database.logger.hasCache() || (Integer)value != 8)) {
                    Trace.throwerror(33, token);
                }
                p.setDatabaseProperty(token, value.toString().toLowerCase());
                p.setDatabaseVariables();
                return;
            }
            case 338: {
                this.session.setScripting(false);
                this.session.setSchema(this.tokenizer.getSimpleName());
                return;
            }
            case 314: {
                this.session.checkDDLWrite();
                this.session.getUser().setPassword(this.getPassword());
                return;
            }
            case 317: {
                this.session.commit();
                this.session.setReadOnly(this.processTrueOrFalse());
                return;
            }
            case 307: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                int i = this.tokenizer.getInt();
                this.database.logger.setLogSize(i);
                return;
            }
            case 322: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.session.setScripting(false);
                token = this.tokenizer.getSimpleToken();
                int i = ArrayUtil.find(ScriptWriterBase.LIST_SCRIPT_FORMATS, token);
                if (i != 0 && i != 1) {
                    if (i != 3) throw Trace.error(11, token);
                }
                this.database.logger.setScriptType(i);
                return;
            }
            case 305: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.database.setIgnoreCase(this.processTrueOrFalse());
                return;
            }
            case 309: {
                this.session.setScripting(false);
                int i = this.tokenizer.getInt();
                this.session.setSQLMaxRows(i);
                return;
            }
            case 301: {
                this.session.setAutoCommit(this.processTrueOrFalse());
                return;
            }
            case 213: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                token = this.tokenizer.getName();
                String schema = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
                Table t = this.database.schemaManager.getTable(this.session, token, schema);
                token = this.tokenizer.getSimpleToken();
                this.session.setScripting(true);
                switch (Token.get(token)) {
                    default: {
                        throw Trace.error(11, token);
                    }
                    case 326: {
                        this.session.checkAdmin();
                        if (this.tokenizer.isGetThis("HEADER")) {
                            token = this.tokenizer.getString();
                            if (!this.tokenizer.wasQuotedIdentifier()) {
                                throw Trace.error(75);
                            }
                            try {
                                t.setHeader(token);
                                return;
                            }
                            catch (Throwable e) {
                                if (!this.session.isProcessingLog() && !this.session.isProcessingScript()) {
                                    if (!(e instanceof HsqlException)) throw Trace.error(98, e.getMessage());
                                    throw (HsqlException)e;
                                }
                                HsqlException warning = Trace.error(98, e.getMessage());
                                this.session.addWarning(warning);
                                return;
                            }
                        }
                        if (this.tokenizer.isGetThis("ON")) {
                            t.connect(this.session);
                            this.database.setMetaDirty(false);
                            return;
                        }
                        if (this.tokenizer.isGetThis("OFF")) {
                            t.disconnect(this.session);
                            this.database.setMetaDirty(false);
                            return;
                        }
                        token = this.tokenizer.getString();
                        if (!this.tokenizer.wasQuotedIdentifier()) {
                            throw Trace.error(75);
                        }
                        boolean isDesc = false;
                        isDesc = this.tokenizer.isGetThis("DESC");
                        try {
                            t.setDataSource(this.session, token, isDesc, false);
                            return;
                        }
                        catch (Throwable e) {
                            if (!this.session.isProcessingLog() && !this.session.isProcessingScript()) {
                                if (!(e instanceof HsqlException)) throw Trace.error(98, e.getMessage());
                                throw (HsqlException)e;
                            }
                            HsqlException warning = Trace.error(98, e.getMessage());
                            this.session.addWarning(warning);
                            return;
                        }
                    }
                    case 317: {
                        this.session.checkAdmin();
                        t.setDataReadOnly(this.processTrueOrFalse());
                        this.database.setMetaDirty(false);
                        return;
                    }
                    case 306: 
                }
                this.session.checkAdmin();
                String roots = (String)this.tokenizer.getInType(12);
                t.setIndexRoots(roots);
                return;
            }
            case 318: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.session.setScripting(false);
                this.database.setReferentialIntegrity(this.processTrueOrFalse());
                return;
            }
            case 303: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.tokenizer.getThis("DEFRAG");
                int size = this.tokenizer.getInt();
                this.database.getProperties().setProperty("hsqldb.defrag_limit", size);
                return;
            }
            case 330: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                int delay = 0;
                this.tokenizer.getString();
                Object value = this.tokenizer.getAsValue();
                if (this.tokenizer.getType() == 4) {
                    delay = (Integer)value;
                } else if (Boolean.TRUE.equals(value)) {
                    delay = this.database.getProperties().getDefaultWriteDelay();
                } else {
                    if (!Boolean.FALSE.equals(value)) throw Trace.error(11);
                    delay = 0;
                }
                if (!this.tokenizer.isGetThis("MILLIS")) {
                    delay *= 1000;
                }
                this.database.logger.setWriteDelay(delay);
                return;
            }
            case 337: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.tokenizer.getThis("COLLATION");
                String cname = this.tokenizer.getSimpleName();
                if (!this.tokenizer.wasQuotedIdentifier()) {
                    throw Trace.error(74);
                }
                this.database.collation.setCollation(cname);
                return;
            }
        }
        throw Trace.error(11, token);
    }

    private boolean processTrueOrFalse() throws HsqlException {
        String sToken = this.tokenizer.getSimpleToken();
        if (sToken.equals("TRUE")) {
            return true;
        }
        if (sToken.equals("FALSE")) {
            return false;
        }
        throw Trace.error(11, sToken);
    }

    private void processCommit() throws HsqlException {
        this.tokenizer.isGetThis("WORK");
        this.session.commit();
    }

    private void processRollback() throws HsqlException {
        String token = this.tokenizer.getSimpleToken();
        boolean toSavepoint = false;
        if (!token.equals("WORK")) {
            if (token.equals("TO")) {
                this.tokenizer.getThis("SAVEPOINT");
                token = this.tokenizer.getSimpleName();
                toSavepoint = true;
            } else {
                this.tokenizer.back();
            }
        }
        if (toSavepoint) {
            this.session.rollbackToSavepoint(token);
        } else {
            this.session.rollback();
        }
    }

    private void processSavepoint() throws HsqlException {
        String token = this.tokenizer.getSimpleName();
        this.session.savepoint(token);
    }

    private void processShutdown() throws HsqlException {
        if (!this.session.isClosed()) {
            this.session.checkAdmin();
        }
        int closemode = 0;
        String token = this.tokenizer.getSimpleToken();
        if (token.equals("IMMEDIATELY")) {
            closemode = -1;
        } else if (token.equals("COMPACT")) {
            closemode = 1;
        } else if (token.equals("SCRIPT")) {
            closemode = 2;
        } else if (!token.equals(";") && token.length() != 0) {
            throw Trace.error(11, token);
        }
        this.database.close(closemode);
    }

    private void processCheckpoint() throws HsqlException {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        boolean defrag = false;
        String token = this.tokenizer.getSimpleToken();
        if (token.equals("DEFRAG")) {
            defrag = true;
        } else if (!token.equals(";") && token.length() != 0) {
            throw Trace.error(11, token);
        }
        this.database.logger.checkpoint(defrag);
    }

    private HsqlNameManager.HsqlName newIndexHsqlName(String name, boolean isQuoted) throws HsqlException {
        return HsqlNameManager.HsqlName.isReservedName(name) ? this.database.nameManager.newAutoName("USER", name) : this.database.nameManager.newHsqlName(name, isQuoted);
    }

    private Table newTable(int type, String name, boolean quoted, HsqlNameManager.HsqlName schema) throws HsqlException {
        HsqlNameManager.HsqlName tableHsqlName = this.database.nameManager.newHsqlName(name, quoted);
        tableHsqlName.schema = schema;
        switch (type) {
            case 5: 
            case 6: {
                return new TextTable(this.database, tableHsqlName, type);
            }
        }
        return new Table(this.database, tableHsqlName, type);
    }

    private void checkAddColumn(Table t, Column c) throws HsqlException {
        boolean canAdd = true;
        if (t.findColumn(c.columnName.name) != -1) {
            throw Trace.error(27, c.columnName.name);
        }
        if (c.isPrimaryKey() && t.hasPrimaryKey()) {
            canAdd = false;
        }
        if (canAdd && !t.isEmpty(this.session)) {
            boolean bl = canAdd = c.isNullable() || c.getDefaultExpression() != null;
        }
        if (!canAdd) {
            throw Trace.error(58);
        }
    }

    private void checkFKColumnDefaults(Table t, Constraint tc) throws HsqlException {
        boolean check = tc.core.updateAction == 4;
        boolean bl = check = check || tc.core.deleteAction == 4;
        if (check) {
            int[] localCol = tc.core.mainColArray;
            for (int j = 0; j < localCol.length; ++j) {
                Column column = t.getColumn(localCol[j]);
                Expression defExpr = column.getDefaultExpression();
                if (defExpr != null) continue;
                String columnName = column.columnName.name;
                throw Trace.error(105, new Object[]{columnName});
            }
        }
    }

    private void processAlterSequence() throws HsqlException {
        String name = this.tokenizer.getName();
        String schemaname = this.tokenizer.getLongNameFirst();
        schemaname = this.session.getSchemaNameForWrite(schemaname);
        this.tokenizer.getThis("RESTART");
        this.tokenizer.getThis("WITH");
        long start = this.tokenizer.getBigint();
        NumberSequence seq = this.database.schemaManager.getSequence(name, schemaname);
        seq.reset(start);
    }

    private void processAlterIndexRename() throws HsqlException {
        String name = this.tokenizer.getName();
        String schema = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        this.tokenizer.getThis("RENAME");
        this.tokenizer.getThis("TO");
        String newName = this.tokenizer.getName();
        String newSchema = this.tokenizer.getLongNameFirst();
        newSchema = newSchema == null ? schema : this.session.getSchemaNameForWrite(newSchema);
        boolean isQuoted = this.tokenizer.wasQuotedIdentifier();
        if (!schema.equals(newSchema)) {
            throw Trace.error(227);
        }
        Table t = this.database.schemaManager.findUserTableForIndex(this.session, name, schema);
        if (t == null) {
            throw Trace.error(26, name);
        }
        this.database.schemaManager.checkIndexExists(name, t.getSchemaName(), true);
        if (HsqlNameManager.HsqlName.isReservedName(name)) {
            throw Trace.error(56, name);
        }
        if (HsqlNameManager.HsqlName.isReservedName(newName)) {
            throw Trace.error(49, newName);
        }
        this.session.setScripting(true);
        this.session.commit();
        t.getIndex(name).setName(newName, isQuoted);
        this.database.schemaManager.renameIndex(name, newName, t.getName());
    }

    private void processAlterSchemaRename() throws HsqlException {
        String name = this.tokenizer.getSimpleName();
        this.tokenizer.getThis("RENAME");
        this.tokenizer.getThis("TO");
        String newName = this.tokenizer.getSimpleName();
        boolean isQuoted = this.tokenizer.wasQuotedIdentifier();
        this.database.schemaManager.renameSchema(name, newName, isQuoted);
    }

    private void processAlterTableAddColumn(Table t) throws HsqlException {
        int colindex = t.getColumnCount();
        Column column = this.processCreateColumn();
        this.checkAddColumn(t, column);
        if (this.tokenizer.isGetThis("BEFORE")) {
            String token = this.tokenizer.getSimpleName();
            colindex = t.getColumnNr(token);
        }
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, t);
        tableWorks.addColumn(column, colindex);
    }

    private void processAlterTableDropColumn(Table t) throws HsqlException {
        String token = this.tokenizer.getName();
        int colindex = t.getColumnNr(token);
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, t);
        tableWorks.dropColumn(colindex);
    }

    private void processAlterTableDropConstraint(Table t) throws HsqlException {
        this.processAlterTableDropConstraint(t, this.tokenizer.getName());
    }

    private void processAlterTableDropConstraint(Table t, String cname) throws HsqlException {
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, t);
        tableWorks.dropConstraint(cname);
    }

    private void processCreateAlias() throws HsqlException {
        String alias;
        try {
            alias = this.tokenizer.getSimpleName();
        }
        catch (HsqlException e) {
            if (this.session.isProcessingScript()) {
                alias = null;
            }
            throw e;
        }
        this.tokenizer.getThis("FOR");
        String methodFQN = DatabaseCommandInterpreter.upgradeMethodFQN(this.tokenizer.getSimpleName());
        if (alias != null) {
            this.database.getAliasMap().put(alias, methodFQN);
        }
    }

    private void processCreateIndex(boolean unique) throws HsqlException {
        String indexName = this.tokenizer.getName();
        String schema = this.tokenizer.getLongNameFirst();
        boolean indexNameQuoted = this.tokenizer.wasQuotedIdentifier();
        this.tokenizer.getThis("ON");
        String tablename = this.tokenizer.getName();
        String tableschema = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        if (schema != null && !schema.equals(tableschema)) {
            throw Trace.error(227);
        }
        Table t = this.database.schemaManager.getTable(this.session, tablename, tableschema);
        this.database.schemaManager.checkIndexExists(indexName, t.getSchemaName(), false);
        HsqlNameManager.HsqlName indexHsqlName = this.newIndexHsqlName(indexName, indexNameQuoted);
        int[] indexColumns = this.processColumnList(t, true);
        String extra = this.tokenizer.getSimpleToken();
        if (!"DESC".equals(extra) && !"ASC".equals(extra)) {
            this.tokenizer.back();
        }
        this.session.commit();
        this.session.setScripting(true);
        TableWorks tableWorks = new TableWorks(this.session, t);
        tableWorks.createIndex(indexColumns, indexHsqlName, unique, false, false);
    }

    private void processCreateSequence() throws HsqlException {
        int type = 4;
        long increment = 1L;
        long start = 0L;
        String name = this.tokenizer.getName();
        boolean isquoted = this.tokenizer.wasQuotedIdentifier();
        HsqlNameManager.HsqlName schemaname = this.session.getSchemaHsqlNameForWrite(this.tokenizer.getLongNameFirst());
        if (this.tokenizer.isGetThis("AS")) {
            String typestring = this.tokenizer.getSimpleToken();
            type = Types.getTypeNr(typestring);
            Trace.check(type == 4 || type == -5, 16);
        }
        if (this.tokenizer.isGetThis("START")) {
            this.tokenizer.getThis("WITH");
            start = this.tokenizer.getBigint();
        }
        if (this.tokenizer.isGetThis("INCREMENT")) {
            this.tokenizer.getThis("BY");
            increment = this.tokenizer.getBigint();
        }
        HsqlNameManager.HsqlName hsqlname = this.database.nameManager.newHsqlName(name, isquoted);
        hsqlname.schema = schemaname;
        this.database.schemaManager.createSequence(hsqlname, start, increment, type);
    }

    private void processCreateSchema() throws HsqlException {
        String name = this.tokenizer.getSimpleName();
        boolean isquoted = this.tokenizer.wasQuotedIdentifier();
        if (this.session.isSchemaDefintion()) {
            throw Trace.error(74);
        }
        this.tokenizer.getThis("AUTHORIZATION");
        this.tokenizer.getThis("DBA");
        if (this.database.schemaManager.schemaExists(name)) {
            if (!this.session.isProcessingScript) {
                throw Trace.error(227);
            }
        } else {
            this.database.schemaManager.createSchema(name, isquoted);
        }
        HsqlNameManager.HsqlName schemaName = this.database.schemaManager.getSchemaHsqlName(name);
        this.database.logger.writeToLog(this.session, DatabaseScript.getSchemaCreateDDL(this.database, schemaName));
        this.database.logger.writeToLog(this.session, "SET SCHEMA " + schemaName.statementName);
        this.session.startSchemaDefinition(name);
        this.session.loggedSchema = this.session.currentSchema;
    }

    private void processCreateUser() throws HsqlException {
        String name = this.getUserIdentifier();
        this.tokenizer.getThis("PASSWORD");
        String password = this.getPassword();
        boolean admin = this.tokenizer.isGetThis("ADMIN");
        this.database.getUserManager().createUser(name, password);
        if (admin) {
            this.database.getGranteeManager().grant(name, "DBA");
        }
    }

    private void processDisconnect() throws HsqlException {
        this.session.close();
    }

    private void processDropTable(boolean isView) throws HsqlException {
        boolean ifexists = false;
        boolean cascade = false;
        if (this.tokenizer.isGetThis("IF")) {
            this.tokenizer.getThis("EXISTS");
            ifexists = true;
        }
        String name = this.tokenizer.getName();
        String schema = this.tokenizer.getLongNameFirst();
        if (this.tokenizer.isGetThis("IF")) {
            this.tokenizer.getThis("EXISTS");
            ifexists = true;
        }
        if (!(cascade = this.tokenizer.isGetThis("CASCADE"))) {
            this.tokenizer.isGetThis("RESTRICT");
        }
        if (ifexists && schema != null && !this.database.schemaManager.schemaExists(schema)) {
            return;
        }
        schema = this.session.getSchemaNameForWrite(schema);
        this.database.schemaManager.dropTable(this.session, name, schema, ifexists, isView, cascade);
    }

    private void processDropUser() throws HsqlException {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        String userName = this.getPassword();
        if (this.database.getSessionManager().isUserActive(userName)) {
            throw Trace.error(33);
        }
        this.database.getUserManager().dropUser(userName);
    }

    private void processDropSequence() throws HsqlException {
        NumberSequence sequence;
        boolean cascade;
        boolean ifexists = false;
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        String name = this.tokenizer.getName();
        String schemaname = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        if (this.tokenizer.isGetThis("IF")) {
            this.tokenizer.getThis("EXISTS");
            ifexists = true;
        }
        if (!(cascade = this.tokenizer.isGetThis("CASCADE"))) {
            this.tokenizer.isGetThis("RESTRICT");
        }
        if ((sequence = this.database.schemaManager.findSequence(name, schemaname)) == null) {
            if (ifexists) {
                return;
            }
            throw Trace.error(191);
        }
        this.database.schemaManager.checkCascadeDropViews(sequence, cascade);
        this.database.schemaManager.dropSequence(sequence);
    }

    private void processDropTrigger() throws HsqlException {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        String triggername = this.tokenizer.getName();
        String schemaname = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        this.database.schemaManager.dropTrigger(this.session, triggername, schemaname);
    }

    private void processDropIndex() throws HsqlException {
        String name = this.tokenizer.getName();
        String schema = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        boolean ifexists = false;
        if (this.tokenizer.isGetThis("ON")) {
            this.tokenizer.getName();
        }
        if (this.tokenizer.isGetThis("IF")) {
            this.tokenizer.getThis("EXISTS");
            ifexists = true;
        }
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        this.database.schemaManager.dropIndex(this.session, name, schema, ifexists);
    }

    private void processDropSchema() throws HsqlException {
        String name = this.tokenizer.getSimpleName();
        boolean cascade = this.tokenizer.isGetThis("CASCADE");
        if (!cascade) {
            this.tokenizer.isGetThis("RESTRICT");
        }
        this.processDropSchema(name, cascade);
    }

    private void processDropSchema(String name, boolean cascade) throws HsqlException {
        if (!this.database.schemaManager.schemaExists(name)) {
            throw Trace.error(227);
        }
        this.database.schemaManager.dropSchema(name, cascade);
        if (name.equals(this.session.getSchemaName(null))) {
            this.session.setSchema(this.database.schemaManager.getDefaultSchemaName());
        }
    }

    private Result processExplainPlan() throws IOException, HsqlException {
        String line;
        CompiledStatement cs;
        this.tokenizer.getThis("PLAN");
        this.tokenizer.getThis("FOR");
        Parser parser = new Parser(this.session, this.database, this.tokenizer);
        String token = this.tokenizer.getSimpleToken();
        int cmd = Token.get(token);
        Result result = Result.newSingleColumnResult("OPERATION", 12);
        int brackets = 0;
        switch (cmd) {
            case 313: {
                brackets = parser.parseOpenBracketsSelect() + 1;
            }
            case 193: {
                cs = parser.compileSelectStatement(brackets);
                break;
            }
            case 112: {
                cs = parser.compileInsertStatement();
                break;
            }
            case 222: {
                cs = parser.compileUpdateStatement();
                break;
            }
            case 62: {
                cs = parser.compileDeleteStatement();
                break;
            }
            case 23: {
                cs = parser.compileCallStatement();
                break;
            }
            default: {
                return result;
            }
        }
        LineNumberReader lnr = new LineNumberReader(new StringReader(cs.describe(this.session)));
        while (null != (line = lnr.readLine())) {
            result.add(new Object[]{line});
        }
        return result;
    }

    private static String upgradeMethodFQN(String fqn) {
        if (fqn.startsWith(oldLib)) {
            fqn = newLib + fqn.substring(oldLibLen);
        } else if (fqn.equals("java.lang.Math.abs")) {
            fqn = "org.hsqldb.Library.abs";
        }
        return fqn;
    }

    Result processSelectInto(Result result, HsqlNameManager.HsqlName intoHsqlName, int intoType) throws HsqlException {
        int colCount = result.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            if (result.metaData.colLabels[i].length() != 0) continue;
            throw Trace.error(45);
        }
        Table t = intoType == 6 ? new TextTable(this.database, intoHsqlName, intoType) : new Table(this.database, intoHsqlName, intoType);
        t.addColumns(result.metaData, result.getColumnCount());
        t.createPrimaryKey();
        this.database.schemaManager.linkTable(t);
        if (intoType == 6) {
            try {
                String txtSrc = StringUtil.toLowerSubset(intoHsqlName.name, '_') + ".csv";
                t.setDataSource(this.session, txtSrc, false, true);
                this.logTableDDL(t);
                t.insertIntoTable(this.session, result);
            }
            catch (HsqlException e) {
                this.database.schemaManager.dropTable(this.session, intoHsqlName.name, null, false, false, false);
                throw e;
            }
        } else {
            this.logTableDDL(t);
            t.insertIntoTable(this.session, result);
        }
        Result uc = new Result(1);
        uc.updateCount = result.getSize();
        return uc;
    }

    private void logTableDDL(Table t) throws HsqlException {
        StringBuffer tableDDL = new StringBuffer();
        DatabaseScript.getTableDDL(this.database, t, 0, null, true, tableDDL);
        String sourceDDL = DatabaseScript.getDataSource(t);
        this.database.logger.writeToLog(this.session, tableDDL.toString());
        if (sourceDDL != null) {
            this.database.logger.writeToLog(this.session, sourceDDL);
        }
    }

    private void processAlterTableAddUniqueConstraint(Table t, HsqlNameManager.HsqlName n) throws HsqlException {
        int[] col = this.processColumnList(t, false);
        if (n == null) {
            n = this.database.nameManager.newAutoName("CT");
        }
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, t);
        tableWorks.createUniqueConstraint(col, n);
    }

    private void processAlterTableAddForeignKeyConstraint(Table t, HsqlNameManager.HsqlName n) throws HsqlException {
        if (n == null) {
            n = this.database.nameManager.newAutoName("FK");
        }
        Constraint tc = this.processCreateFK(t, n);
        this.checkFKColumnDefaults(t, tc);
        t.checkColumnsMatch(tc.core.mainColArray, tc.core.refTable, tc.core.refColArray);
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, t);
        tableWorks.createForeignKey(tc.core.mainColArray, tc.core.refColArray, tc.constName, tc.core.refTable, tc.core.deleteAction, tc.core.updateAction);
    }

    private void processAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName name) throws HsqlException {
        if (name == null) {
            name = this.database.nameManager.newAutoName("CT");
        }
        Constraint check = new Constraint(name, null, null, null, 3, 3, 3);
        this.processCreateCheckConstraintCondition(check);
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.createCheckConstraint(check, name);
    }

    private void processAlterTableAddPrimaryKey(Table t, HsqlNameManager.HsqlName n) throws HsqlException {
        int[] col = this.processColumnList(t, false);
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, t);
        tableWorks.addPrimaryKey(col, n);
    }

    private void processReleaseSavepoint() throws HsqlException {
        this.tokenizer.getThis("SAVEPOINT");
        String token = this.tokenizer.getSimpleName();
        this.session.releaseSavepoint(token);
    }

    private void processAlterUser() throws HsqlException {
        String userName = this.getUserIdentifier();
        User userObject = (User)this.database.getUserManager().getUsers().get(userName);
        Trace.check(userObject != null, 37, userName);
        this.tokenizer.getThis("SET");
        this.tokenizer.getThis("PASSWORD");
        String password = this.getPassword();
        userObject.setPassword(password);
        this.database.logger.writeToLog(this.session, userObject.getAlterUserDDL());
        this.session.setScripting(false);
    }

    private String getUserIdentifier() throws HsqlException {
        String token = this.tokenizer.getString();
        Tokenizer t = new Tokenizer(token);
        return t.getSimpleName();
    }

    private String getPassword() throws HsqlException {
        String token = this.tokenizer.getString();
        return token.toUpperCase(Locale.ENGLISH);
    }

    private void processRoleGrantOrRevoke(boolean grant) throws HsqlException {
        HsqlArrayList list = new HsqlArrayList();
        GranteeManager granteeManager = this.database.getGranteeManager();
        do {
            String role = this.tokenizer.getSimpleToken();
            Trace.check(granteeManager.isRole(role), grant ? 229 : 230);
            list.add(role);
        } while (this.tokenizer.isGetThis(","));
        this.tokenizer.getThis(grant ? "TO" : "FROM");
        String token = this.getUserIdentifier();
        GranteeManager gm = this.database.getGranteeManager();
        for (int i = 0; i < list.size(); ++i) {
            if (grant) {
                gm.grant(token, (String)list.get(i));
                continue;
            }
            gm.revoke(token, (String)list.get(i));
        }
    }
}

