/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import org.hsqldb.HsqlSocketFactory;
import org.hsqldb.Trace;
import org.hsqldb.lib.StringConverter;

public final class HsqlSocketFactorySecure
extends HsqlSocketFactory
implements HandshakeCompletedListener {
    protected Object socketFactory;
    protected Object serverSocketFactory;
    protected final Object socket_factory_mutex = new Object();
    protected final Object server_socket_factory_mutex = new Object();

    protected HsqlSocketFactorySecure() throws Exception {
        if (Security.getProvider("SunJSSE") == null) {
            try {
                Provider p = (Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance();
                Security.addProvider(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void configureSocket(Socket socket) {
        super.configureSocket(socket);
        SSLSocket s = (SSLSocket)socket;
        s.addHandshakeCompletedListener(this);
    }

    public ServerSocket createServerSocket(int port) throws Exception {
        SSLServerSocket ss = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(port);
        if (Trace.TRACE) {
            Trace.printSystemOut("[" + this + "]: createServerSocket()");
            Trace.printSystemOut("capabilities for " + ss + ":");
            Trace.printSystemOut("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", ss.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", ss.getEnabledCipherSuites());
        }
        return ss;
    }

    public ServerSocket createServerSocket(int port, String address) throws Exception {
        InetAddress addr = InetAddress.getByName(address);
        SSLServerSocket ss = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(port, 128, addr);
        if (Trace.TRACE) {
            Trace.printSystemOut("[" + this + "]: createServerSocket()");
            Trace.printSystemOut("capabilities for " + ss + ":");
            Trace.printSystemOut("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", ss.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", ss.getEnabledCipherSuites());
        }
        return ss;
    }

    private static void dump(String title, String[] as) {
        Trace.printSystemOut(title);
        Trace.printSystemOut("----------------------------");
        for (int i = 0; i < as.length; ++i) {
            Trace.printSystemOut(String.valueOf(as[i]));
        }
        Trace.printSystemOut("----------------------------");
    }

    public Socket createSocket(String host, int port) throws Exception {
        SSLSocket socket = (SSLSocket)this.getSocketFactoryImpl().createSocket(host, port);
        socket.addHandshakeCompletedListener(this);
        socket.startHandshake();
        this.verify(host, socket.getSession());
        return socket;
    }

    public boolean isSecure() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLServerSocketFactory getServerSocketFactoryImpl() throws Exception {
        Object factory;
        Object object = this.server_socket_factory_mutex;
        synchronized (object) {
            factory = this.serverSocketFactory;
            if (factory == null) {
                this.serverSocketFactory = factory = SSLServerSocketFactory.getDefault();
            }
        }
        return (SSLServerSocketFactory)factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLSocketFactory getSocketFactoryImpl() throws Exception {
        Object factory;
        Object object = this.socket_factory_mutex;
        synchronized (object) {
            factory = this.socketFactory;
            if (factory == null) {
                this.socketFactory = factory = SSLSocketFactory.getDefault();
            }
        }
        return (SSLSocketFactory)factory;
    }

    protected void verify(String host, SSLSession session) throws Exception {
        String CN;
        X509Certificate[] chain = session.getPeerCertificateChain();
        X509Certificate certificate = chain[0];
        Principal principal = certificate.getSubjectDN();
        String DN = String.valueOf(principal);
        int start = DN.indexOf("CN=");
        if (start < 0) {
            throw new UnknownHostException(Trace.getMessage(136));
        }
        int end = DN.indexOf(44, start += 3);
        if ((CN = DN.substring(start, end > -1 ? end : DN.length())).length() < 1) {
            throw new UnknownHostException(Trace.getMessage(137));
        }
        if (!CN.equalsIgnoreCase(host)) {
            throw new UnknownHostException(Trace.getMessage(139, true, new Object[]{CN, host}));
        }
    }

    public void handshakeCompleted(HandshakeCompletedEvent evt) {
        if (Trace.TRACE) {
            SSLSocket socket = evt.getSocket();
            SSLSession session = evt.getSession();
            Trace.printSystemOut("SSL handshake completed:");
            Trace.printSystemOut("------------------------------------------------");
            Trace.printSystemOut("socket:      : " + socket);
            Trace.printSystemOut("cipher suite : " + session.getCipherSuite());
            String sessionId = StringConverter.byteToHex(session.getId());
            Trace.printSystemOut("session id   : " + sessionId);
            Trace.printSystemOut("------------------------------------------------");
        }
    }
}

