/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.hsqldb.Column;
import org.hsqldb.HsqlException;
import org.hsqldb.Record;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.Iterator;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class Result {
    public Record rRoot;
    private Record rTail;
    private int size;
    private int significantColumns;
    public int mode;
    int databaseID;
    int sessionID;
    String mainString;
    String subString;
    String subSubString;
    private Throwable exception;
    int statementID;
    int updateCount;
    public ResultMetaData metaData;

    public Result(int type) {
        this.mode = type;
        if (type == 3 || type == 5 || type == 65548 || type == 6) {
            this.metaData = new ResultMetaData();
        }
    }

    Result(ResultMetaData md) {
        this.mode = 3;
        this.significantColumns = md.colTypes.length;
        this.metaData = md;
    }

    Result(String error, String state, int code) {
        this.mode = 2;
        this.mainString = error;
        this.subString = state;
        this.statementID = code;
        this.subSubString = "";
    }

    Result(int type, int columns) {
        this.metaData = new ResultMetaData();
        this.metaData.prepareData(columns);
        if (type == 5) {
            this.metaData.isParameterDescription = true;
            this.metaData.paramMode = new int[columns];
        }
        this.mode = type;
        this.significantColumns = columns;
    }

    public Result(int type, int[] types, int id) {
        this.mode = type;
        this.metaData = new ResultMetaData();
        this.metaData.colTypes = types;
        this.significantColumns = types.length;
        this.statementID = id;
    }

    Result(RowInputBinary in) throws HsqlException {
        try {
            this.mode = in.readIntData();
            if (this.mode == 0) {
                this.readMultiResult(in);
                return;
            }
            this.databaseID = in.readIntData();
            this.sessionID = in.readIntData();
            switch (this.mode) {
                case 7: 
                case 10: 
                case 65545: 
                case 65610: {
                    break;
                }
                case 65555: {
                    this.setStatementType(in.readIntData());
                    this.mainString = in.readString();
                    break;
                }
                case 4: 
                case 65552: {
                    this.statementID = in.readIntData();
                    break;
                }
                case 65547: {
                    this.updateCount = in.readIntData();
                    this.statementID = in.readIntData();
                    this.mainString = in.readString();
                    break;
                }
                case 2: 
                case 65543: {
                    this.mainString = in.readString();
                    this.subString = in.readString();
                    this.subSubString = in.readString();
                    this.statementID = in.readIntData();
                    break;
                }
                case 1: {
                    this.updateCount = in.readIntData();
                    break;
                }
                case 66541: {
                    int type = in.readIntData();
                    this.setEndTranType(type);
                    switch (type) {
                        case 2: 
                        case 4: {
                            this.mainString = in.readString();
                        }
                    }
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 65548: {
                    this.updateCount = in.readIntData();
                    this.statementID = in.readIntData();
                    int l = in.readIntData();
                    this.metaData = new ResultMetaData(l);
                    this.significantColumns = l;
                    for (int i = 0; i < l; ++i) {
                        this.metaData.colTypes[i] = in.readType();
                    }
                    int count = in.readIntData();
                    while (count-- > 0) {
                        this.add(in.readData(this.metaData.colTypes));
                    }
                    break;
                }
                case 3: 
                case 5: {
                    this.metaData = new ResultMetaData(in, this.mode);
                    this.significantColumns = this.metaData.colLabels.length;
                    int count = in.readIntData();
                    while (count-- > 0) {
                        this.add(in.readData(this.metaData.colTypes));
                    }
                    break;
                }
                case 66552: {
                    int type = in.readIntData();
                    this.setConnectionAttrType(type);
                    switch (type) {
                        case 10027: {
                            this.mainString = in.readString();
                        }
                    }
                    break;
                }
                default: {
                    throw new HsqlException(Trace.getMessage(146, true, new Object[]{new Integer(this.mode)}), null, 0);
                }
            }
        }
        catch (IOException e) {
            throw Trace.error(19);
        }
    }

    static Result newSingleColumnResult(String colName, int colType) {
        Result result = new Result(3, 1);
        result.metaData.colNames[0] = colName;
        result.metaData.colLabels[0] = colName;
        result.metaData.tableNames[0] = "";
        result.metaData.colTypes[0] = colType;
        return result;
    }

    static Result newPrepareResponse(int csid, Result rsmd, Result pmd) {
        Result out = new Result(0);
        Result pack = new Result(4);
        pack.statementID = csid;
        out.add(new Object[]{pack});
        out.add(new Object[]{rsmd});
        out.add(new Object[]{pmd});
        return out;
    }

    static Result newParameterDescriptionResult(int len) {
        Result r = new Result(5, len);
        r.metaData.isParameterDescription = true;
        r.metaData.paramMode = new int[len];
        return r;
    }

    public static Result newFreeStmtRequest(int statementID) {
        Result r = new Result(65552);
        r.statementID = statementID;
        return r;
    }

    static Result newExecuteDirectRequest(String sql) {
        Result out = new Result(65547);
        out.setMainString(sql);
        return out;
    }

    public static Result newReleaseSavepointRequest(String name) {
        Result out = new Result(66541);
        out.setMainString(name);
        out.setEndTranType(4);
        return out;
    }

    public static Result newRollbackToSavepointRequest(String name) {
        Result out = new Result(66541);
        out.setMainString(name);
        out.setEndTranType(2);
        return out;
    }

    public static Result newSetSavepointRequest(String name) {
        Result out = new Result(66552);
        out.setConnectionAttrType(10027);
        out.setMainString(name);
        return out;
    }

    public int getSize() {
        return this.size;
    }

    void setColumnCount(int columns) {
        this.significantColumns = columns;
    }

    public int getColumnCount() {
        return this.significantColumns;
    }

    void append(Result a) {
        if (a.rRoot == null) {
            return;
        }
        if (this.rRoot == null) {
            this.rRoot = a.rRoot;
        } else {
            this.rTail.next = a.rRoot;
        }
        this.rTail = a.rTail;
        this.size += a.size;
    }

    void addAll(Result r) {
        if (r == null) {
            return;
        }
        Record from = r.rRoot;
        while (from != null) {
            this.add(from.data);
            from = from.next;
        }
    }

    public void clear() {
        this.rRoot = null;
        this.rTail = null;
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.rRoot == null;
    }

    void setRows(Result a) {
        if (a == null) {
            this.rRoot = null;
            this.rTail = null;
            this.size = 0;
        } else {
            this.rRoot = a.rRoot;
            this.rTail = a.rTail;
            this.size = a.size;
        }
    }

    public void add(Object[] d) {
        Record r = new Record();
        r.data = d;
        if (this.rRoot == null) {
            this.rRoot = r;
        } else {
            this.rTail.next = r;
        }
        this.rTail = r;
        ++this.size;
    }

    void trimResult(int limitstart, int limitcount) {
        int i;
        Record n = this.rRoot;
        if (n == null) {
            return;
        }
        if (limitstart >= this.size) {
            this.size = 0;
            this.rTail = null;
            this.rRoot = null;
            return;
        }
        this.size -= limitstart;
        for (i = 0; i < limitstart; ++i) {
            n = n.next;
            if (n != null) continue;
            this.size = 0;
            this.rRoot = this.rTail = n;
            return;
        }
        this.rRoot = n;
        if (limitcount == 0 || limitcount >= this.size) {
            return;
        }
        for (i = 1; i < limitcount; ++i) {
            n = n.next;
            if (n != null) continue;
            return;
        }
        this.size = limitcount;
        n.next = null;
        this.rTail = n;
    }

    void removeDuplicates(Session session) throws HsqlException {
        this.removeDuplicates(session, this.significantColumns);
    }

    void removeDuplicates(Session session, int columnCount) throws HsqlException {
        Record next;
        if (this.rRoot == null) {
            return;
        }
        int[] order = new int[columnCount];
        int[] way = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            order[i] = i;
            way[i] = 1;
        }
        this.sortResult(session, order, way);
        Record n = this.rRoot;
        while ((next = n.next) != null) {
            if (this.compareRecord(session, n.data, next.data, columnCount) == 0) {
                n.next = next.next;
                --this.size;
                continue;
            }
            n = next;
        }
        this.rTail = n;
    }

    void removeSecond(Session session, Result minus, int columnCount) throws HsqlException {
        this.removeDuplicates(session, columnCount);
        minus.removeDuplicates(session, columnCount);
        Record n = this.rRoot;
        Record last = this.rRoot;
        boolean rootr = true;
        Record n2 = minus.rRoot;
        int i = 0;
        while (n != null && n2 != null) {
            i = this.compareRecord(session, n.data, n2.data, columnCount);
            if (i == 0) {
                if (rootr) {
                    this.rRoot = last = n.next;
                } else {
                    last.next = n.next;
                }
                n = n.next;
                --this.size;
                continue;
            }
            if (i > 0) {
                n2 = n2.next;
                continue;
            }
            last = n;
            rootr = false;
            n = n.next;
        }
        while (n != null) {
            last = n;
            n = n.next;
        }
        this.rTail = last;
    }

    void removeDifferent(Session session, Result r2, int columnCount) throws HsqlException {
        this.removeDuplicates(session, columnCount);
        r2.removeDuplicates(session, columnCount);
        Record n = this.rRoot;
        Record last = this.rRoot;
        boolean rootr = true;
        Record n2 = r2.rRoot;
        int i = 0;
        this.size = 0;
        while (n != null && n2 != null) {
            i = this.compareRecord(session, n.data, n2.data, columnCount);
            if (i == 0) {
                if (rootr) {
                    this.rRoot = n;
                } else {
                    last.next = n;
                }
                rootr = false;
                last = n;
                n = n.next;
                n2 = n2.next;
                ++this.size;
                continue;
            }
            if (i > 0) {
                n2 = n2.next;
                continue;
            }
            n = n.next;
        }
        if (rootr) {
            this.rRoot = null;
            last = null;
        } else {
            last.next = null;
        }
        this.rTail = last;
    }

    void sortResult(Session session, int[] order, int[] way) throws HsqlException {
        if (this.rRoot == null || this.rRoot.next == null) {
            return;
        }
        Record[] target = new Record[2];
        Record[] targetlast = new Record[2];
        int dest = 0;
        Record n = this.rRoot;
        while (n != null) {
            Record next = n.next;
            n.next = target[dest];
            target[dest] = n;
            n = next;
            dest ^= 1;
        }
        int blocksize = 1;
        while (target[1] != null) {
            Record source0 = target[0];
            Record source1 = target[1];
            targetlast[1] = null;
            targetlast[0] = null;
            target[1] = null;
            target[0] = null;
            dest = 0;
            while (source0 != null) {
                int n0 = blocksize;
                int n1 = blocksize;
                while (true) {
                    if (n0 == 0 || source0 == null) {
                        if (n1 == 0 || source1 == null) break;
                        n = source1;
                        source1 = source1.next;
                        --n1;
                    } else if (n1 == 0 || source1 == null) {
                        n = source0;
                        source0 = source0.next;
                        --n0;
                    } else if (this.compareRecord(session, source0.data, source1.data, order, way) > 0) {
                        n = source1;
                        source1 = source1.next;
                        --n1;
                    } else {
                        n = source0;
                        source0 = source0.next;
                        --n0;
                    }
                    if (target[dest] == null) {
                        target[dest] = n;
                    } else {
                        targetlast[dest].next = n;
                    }
                    targetlast[dest] = n;
                    n.next = null;
                }
                dest ^= 1;
            }
            blocksize <<= 1;
        }
        this.rRoot = target[0];
        this.rTail = targetlast[0];
    }

    private int compareRecord(Session session, Object[] a, Object[] b, int[] order, int[] way) throws HsqlException {
        int i = Column.compare(session.database.collation, a[order[0]], b[order[0]], this.metaData.colTypes[order[0]]);
        if (i == 0) {
            for (int j = 1; j < order.length; ++j) {
                i = Column.compare(session.database.collation, a[order[j]], b[order[j]], this.metaData.colTypes[order[j]]);
                if (i == 0) continue;
                return i * way[j];
            }
        }
        return i * way[0];
    }

    private int compareRecord(Session session, Object[] a, Object[] b, int len) throws HsqlException {
        for (int j = 0; j < len; ++j) {
            int i = Column.compare(session.database.collation, a[j], b[j], this.metaData.colTypes[j]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    static Result newSessionAttributesResult() {
        Result r = new Result(3, 7);
        r.metaData.tableNames = new String[]{"", "", "", "", "", "", ""};
        r.metaData.colLabels = r.metaData.tableNames;
        r.metaData.colNames = r.metaData.tableNames;
        r.metaData.colTypes = new int[]{12, 12, 4, 4, 16, 16, 16};
        return r;
    }

    void write(RowOutputBinary out) throws IOException, HsqlException {
        if (this.mode == 0) {
            this.writeMulti(out);
            return;
        }
        int startPos = out.size();
        out.writeSize(0);
        out.writeIntData(this.mode);
        out.writeIntData(this.databaseID);
        out.writeIntData(this.sessionID);
        switch (this.mode) {
            case 7: 
            case 10: 
            case 65545: 
            case 65610: {
                break;
            }
            case 65555: {
                out.writeIntData(this.getStatementType());
                out.writeString(this.mainString);
                break;
            }
            case 4: 
            case 65552: {
                out.writeIntData(this.statementID);
                break;
            }
            case 65547: {
                out.writeIntData(this.updateCount);
                out.writeIntData(this.statementID);
                out.writeString(this.mainString);
                break;
            }
            case 2: 
            case 65543: {
                out.writeString(this.mainString);
                out.writeString(this.subString);
                out.writeString(this.subSubString);
                out.writeIntData(this.statementID);
                break;
            }
            case 1: {
                out.writeIntData(this.updateCount);
                break;
            }
            case 66541: {
                int type = this.getEndTranType();
                out.writeIntData(type);
                switch (type) {
                    case 2: 
                    case 4: {
                        out.writeString(this.mainString);
                    }
                }
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 65548: {
                out.writeIntData(this.updateCount);
                out.writeIntData(this.statementID);
                int l = this.significantColumns;
                out.writeIntData(l);
                for (int i = 0; i < l; ++i) {
                    out.writeType(this.metaData.colTypes[i]);
                }
                out.writeIntData(this.size);
                Record n = this.rRoot;
                while (n != null) {
                    out.writeData(l, this.metaData.colTypes, n.data, null, null);
                    n = n.next;
                }
                break;
            }
            case 3: 
            case 5: {
                this.metaData.write(out, this.significantColumns);
                out.writeIntData(this.size);
                Record n = this.rRoot;
                while (n != null) {
                    out.writeData(this.significantColumns, this.metaData.colTypes, n.data, null, null);
                    n = n.next;
                }
                break;
            }
            case 66552: {
                int type = this.getConnectionAttrType();
                out.writeIntData(type);
                switch (type) {
                    case 10027: {
                        out.writeString(this.mainString);
                    }
                }
                break;
            }
            default: {
                throw new HsqlException(Trace.getMessage(146, true, new Object[]{new Integer(this.mode)}), null, 0);
            }
        }
        out.writeIntData(out.size(), startPos);
    }

    void readMultiResult(RowInputBinary in) throws HsqlException, IOException {
        this.mode = 0;
        this.databaseID = in.readIntData();
        this.sessionID = in.readIntData();
        int count = in.readIntData();
        for (int i = 0; i < count; ++i) {
            in.readIntData();
            this.add(new Object[]{new Result(in)});
        }
    }

    private void writeMulti(RowOutputBinary out) throws IOException, HsqlException {
        int startPos = out.size();
        out.writeSize(0);
        out.writeIntData(this.mode);
        out.writeIntData(this.databaseID);
        out.writeIntData(this.sessionID);
        out.writeIntData(this.size);
        Record n = this.rRoot;
        while (n != null) {
            ((Result)n.data[0]).write(out);
            n = n.next;
        }
        out.writeIntData(out.size(), startPos);
    }

    public static void write(Result r, RowOutputBinary rowout, OutputStream dataout) throws IOException, HsqlException {
        rowout.reset();
        r.write(rowout);
        dataout.write(rowout.getOutputStream().getBuffer(), 0, rowout.getOutputStream().size());
        dataout.flush();
    }

    public static Result read(RowInputBinary rowin, DataInput datain) throws IOException, HsqlException {
        int length = datain.readInt();
        rowin.resetRow(0, length);
        byte[] byteArray = rowin.getBuffer();
        int offset = 4;
        datain.readFully(byteArray, offset, length - offset);
        return new Result(rowin);
    }

    public Result(Throwable t, String statement) {
        this.mode = 2;
        this.exception = t;
        if (t instanceof HsqlException) {
            HsqlException he = (HsqlException)t;
            this.subString = he.getSQLState();
            this.mainString = he.getMessage();
            if (statement != null) {
                this.mainString = this.mainString + " in statement [" + statement + "]";
            }
            this.statementID = he.getErrorCode();
        } else if (t instanceof OutOfMemoryError) {
            System.gc();
            this.subString = "S1000";
            this.mainString = "out of memory";
            this.statementID = 72;
        } else {
            this.subString = "S1000";
            this.mainString = Trace.getMessage(40) + " " + t;
            if (statement != null) {
                this.mainString = this.mainString + " in statement [" + statement + "]";
            }
            this.statementID = 40;
        }
        this.subSubString = "";
    }

    public Throwable getException() {
        return this.exception;
    }

    public int getStatementID() {
        return this.statementID;
    }

    void setStatementID(int id) {
        this.statementID = id;
    }

    public String getMainString() {
        return this.mainString;
    }

    public void setMainString(String sql) {
        this.mainString = sql;
    }

    public String getSubString() {
        return this.subString;
    }

    public void setMaxRows(int count) {
        this.updateCount = count;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    int getConnectionAttrType() {
        return this.updateCount;
    }

    void setConnectionAttrType(int type) {
        this.updateCount = type;
    }

    int getEndTranType() {
        return this.updateCount;
    }

    void setEndTranType(int type) {
        this.updateCount = type;
    }

    public int[] getUpdateCounts() {
        return this.metaData.colTypes;
    }

    Object[] getParameterData() {
        return this.rRoot == null ? null : this.rRoot.data;
    }

    public void setParameterData(Object[] data) {
        if (this.rRoot == null) {
            this.rRoot = new Record();
        }
        this.rRoot.data = data;
        this.rRoot.next = null;
        this.rTail = this.rRoot;
        this.size = 1;
    }

    public void setResultType(int type) {
        this.mode = type;
    }

    public void setStatementType(int type) {
        this.updateCount = type;
    }

    public int getStatementType() {
        return this.updateCount;
    }

    public int getType() {
        return this.mode;
    }

    public boolean isData() {
        return this.mode == 3;
    }

    public boolean isError() {
        return this.mode == 2;
    }

    public boolean isUpdateCount() {
        return this.mode == 1;
    }

    public Iterator iterator() {
        return new ResultIterator();
    }

    private class ResultIterator
    implements Iterator {
        boolean removed;
        int counter;
        Record current;
        Record last;

        private ResultIterator() {
            this.current = Result.this.rRoot;
        }

        public boolean hasNext() {
            return this.counter < Result.this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                this.removed = false;
                if (this.counter != 0) {
                    this.last = this.current;
                    this.current = this.current.next;
                }
                ++this.counter;
                return this.current.data;
            }
            throw new NoSuchElementException();
        }

        public int nextInt() {
            throw new NoSuchElementException();
        }

        public long nextLong() {
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.counter <= Result.this.size && this.counter != 0 && !this.removed) {
                this.removed = true;
                if (this.current == Result.this.rTail) {
                    Result.this.rTail = this.last;
                }
                if (this.current == Result.this.rRoot) {
                    this.current = Result.this.rRoot = Result.this.rRoot.next;
                } else {
                    this.current = this.last;
                    this.last = null;
                    this.current.next = this.current.next.next;
                }
                Result.this.size--;
                --this.counter;
                return;
            }
            throw new NoSuchElementException();
        }
    }

    public static class ResultMetaData {
        public String[] colLabels;
        public String[] tableNames;
        public String[] colNames;
        public boolean[] isLabelQuoted;
        public int[] colTypes;
        public int[] colSizes;
        public int[] colScales;
        public String[] catalogNames;
        public String[] schemaNames;
        public int[] colNullable;
        public boolean[] isIdentity;
        public boolean[] isWritable;
        public int[] paramMode;
        public String[] classNames;
        boolean isParameterDescription;

        ResultMetaData() {
        }

        ResultMetaData(int n) {
            this.prepareData(n);
        }

        private void prepareData(int columns) {
            this.colLabels = new String[columns];
            this.tableNames = new String[columns];
            this.colNames = new String[columns];
            this.isLabelQuoted = new boolean[columns];
            this.colTypes = new int[columns];
            this.colSizes = new int[columns];
            this.colScales = new int[columns];
            this.catalogNames = new String[columns];
            this.schemaNames = new String[columns];
            this.colNullable = new int[columns];
            this.isIdentity = new boolean[columns];
            this.isWritable = new boolean[columns];
            this.classNames = new String[columns];
        }

        public int[] getParameterTypes() {
            return this.colTypes;
        }

        boolean isTableColumn(int i) {
            return this.tableNames[i] != null && this.tableNames[i].length() > 0 && this.colNames[i] != null && this.colNames[i].length() > 0;
        }

        private void decodeTableColumnAttrs(int in, int i) {
            this.colNullable[i] = in & 0xF;
            this.isIdentity[i] = (in & 0x10) != 0;
            this.isWritable[i] = (in & 0x20) != 0;
        }

        private void writeTableColumnAttrs(RowOutputBinary out, int i) throws IOException, HsqlException {
            out.writeIntData(this.encodeTableColumnAttrs(i));
            out.writeString(this.catalogNames[i] == null ? "" : this.catalogNames[i]);
            out.writeString(this.schemaNames[i] == null ? "" : this.schemaNames[i]);
        }

        private int encodeTableColumnAttrs(int i) {
            int out = this.colNullable[i];
            if (this.isIdentity[i]) {
                out |= 0x10;
            }
            if (this.isWritable[i]) {
                out |= 0x20;
            }
            return out;
        }

        private void readTableColumnAttrs(RowInputBinary in, int i) throws IOException, HsqlException {
            this.decodeTableColumnAttrs(in.readIntData(), i);
            this.catalogNames[i] = in.readString();
            this.schemaNames[i] = in.readString();
        }

        ResultMetaData(RowInputBinary in, int mode) throws HsqlException, IOException {
            int l = in.readIntData();
            this.prepareData(l);
            if (mode == 5) {
                this.isParameterDescription = true;
                this.paramMode = new int[l];
            }
            for (int i = 0; i < l; ++i) {
                this.colTypes[i] = in.readType();
                this.colSizes[i] = in.readIntData();
                this.colScales[i] = in.readIntData();
                this.colLabels[i] = in.readString();
                this.tableNames[i] = in.readString();
                this.colNames[i] = in.readString();
                this.classNames[i] = in.readString();
                if (this.isTableColumn(i)) {
                    this.readTableColumnAttrs(in, i);
                }
                if (mode != 5) continue;
                this.paramMode[i] = in.readIntData();
            }
        }

        void write(RowOutputBinary out, int colCount) throws HsqlException, IOException {
            out.writeIntData(colCount);
            for (int i = 0; i < colCount; ++i) {
                out.writeType(this.colTypes[i]);
                out.writeIntData(this.colSizes[i]);
                out.writeIntData(this.colScales[i]);
                out.writeString(this.colLabels[i] == null ? "" : this.colLabels[i]);
                out.writeString(this.tableNames[i] == null ? "" : this.tableNames[i]);
                out.writeString(this.colNames[i] == null ? "" : this.colNames[i]);
                out.writeString(this.classNames[i] == null ? "" : this.classNames[i]);
                if (this.isTableColumn(i)) {
                    this.writeTableColumnAttrs(out, i);
                }
                if (!this.isParameterDescription) continue;
                out.writeIntData(this.paramMode[i]);
            }
        }
    }
}

