/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.CachedRow;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextCache;

class TextTable
extends Table {
    private String dataSource = "";
    private boolean isReversed = false;
    private boolean isConnected = false;

    TextTable(Database db, HsqlNameManager.HsqlName name, int type) throws HsqlException {
        super(db, name, type);
    }

    private void onConnectError(Session session) {
        if (this.cache != null) {
            try {
                this.cache.close(false);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
        this.cache = null;
        this.clearAllRows(session);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void connect(Session session) throws HsqlException {
        this.connect(session, this.isReadOnly);
    }

    private void connect(Session session, boolean withReadOnlyData) throws HsqlException {
        if (this.dataSource.length() == 0 || this.isConnected) {
            return;
        }
        try {
            this.cache = this.database.logger.openTextCache(this, this.dataSource, withReadOnlyData, this.isReversed);
            CachedRow row = null;
            int nextpos = 0;
            if (((TextCache)this.cache).ignoreFirst) {
                nextpos += ((TextCache)this.cache).readHeaderLine();
            }
            while ((row = (CachedRow)this.rowStore.get(nextpos)) != null) {
                nextpos = row.getPos() + row.getStorageSize();
                row.setNewNodes();
                this.insertFromTextSource(row);
            }
        }
        catch (HsqlException e) {
            int linenumber = this.cache == null ? 0 : ((TextCache)this.cache).getLineNumber();
            this.onConnectError(session);
            throw Trace.error(76, new Object[]{new Integer(linenumber), e.getMessage()});
        }
        catch (RuntimeException t) {
            int linenumber = this.cache == null ? 0 : ((TextCache)this.cache).getLineNumber();
            this.onConnectError(session);
            throw Trace.error(76, new Object[]{new Integer(linenumber), t.getClass().getName() + ": " + t.getMessage()});
        }
        this.isConnected = true;
        this.setIsReadOnly(withReadOnlyData);
    }

    public void disconnect(Session session) throws HsqlException {
        this.database.logger.closeTextCache(this);
        this.cache = null;
        this.clearAllRows(session);
        this.isConnected = false;
    }

    private void openCache(Session session, String dataSourceNew, boolean isReversedNew, boolean isReadOnlyNew) throws HsqlException {
        if (dataSourceNew == null) {
            dataSourceNew = "";
        }
        this.disconnect(session);
        this.dataSource = dataSourceNew;
        this.isReversed = isReversedNew && this.dataSource.length() > 0;
        this.connect(session, isReadOnlyNew);
    }

    protected void setDataSource(Session session, String dataSourceNew, boolean isReversedNew, boolean newFile) throws HsqlException {
        if (this.getTableType() != 5) {
            session.checkAdmin();
        }
        dataSourceNew = dataSourceNew.trim();
        if (newFile && FileUtil.getDefaultInstance().exists(dataSourceNew)) {
            throw Trace.error(196, dataSourceNew);
        }
        if (isReversedNew || isReversedNew != this.isReversed || !this.dataSource.equals(dataSourceNew) || !this.isConnected) {
            this.openCache(session, dataSourceNew, isReversedNew, this.isReadOnly);
        }
        if (this.isReversed) {
            this.setIsReadOnly(true);
        }
    }

    protected String getDataSource() {
        return this.dataSource;
    }

    protected boolean isDescDataSource() {
        return this.isReversed;
    }

    public void setHeader(String header) throws HsqlException {
        if (this.cache != null && ((TextCache)this.cache).ignoreFirst) {
            ((TextCache)this.cache).setHeader(header);
            return;
        }
        throw Trace.error(150);
    }

    public String getHeader() {
        String header = this.cache == null ? null : ((TextCache)this.cache).getHeader();
        return header == null ? null : StringConverter.toQuotedString(header, '\"', true);
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.dataSource.length() == 0) {
            throw Trace.error(48);
        }
        if (this.isDataReadOnly()) {
            throw Trace.error(32);
        }
    }

    public boolean isDataReadOnly() {
        return !this.isConnected() || super.isDataReadOnly();
    }

    void setDataReadOnly(boolean value) throws HsqlException {
        if (this.isReversed && !value) {
            throw Trace.error(32);
        }
        this.openCache(null, this.dataSource, this.isReversed, value);
        this.setIsReadOnly(value);
    }

    boolean isIndexCached() {
        return false;
    }

    protected Table duplicate() throws HsqlException {
        return new TextTable(this.database, this.tableName, this.getTableType());
    }

    void drop() throws HsqlException {
        this.openCache(null, "", false, false);
    }

    void setIndexRoots(String s) throws HsqlException {
    }
}

