/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.Transaction;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongKeyIntValueHashMap;

public class TransactionManager {
    LongKeyIntValueHashMap rowSessionMap;
    boolean reWriteProtect;
    Database database;
    private long globalActionTimestamp = 0L;

    TransactionManager(Database db) {
        this.database = db;
        this.rowSessionMap = new LongKeyIntValueHashMap(true);
    }

    public void setReWriteProtection(boolean value) {
        this.reWriteProtect = value;
    }

    void checkDelete(Session session, Row row) throws HsqlException {
    }

    void checkDelete(Session session, HashMappedList rowSet) throws HsqlException {
        if (!this.reWriteProtect) {
            return;
        }
        int sessionid = session.getId();
        int size = rowSet.size();
        for (int i = 0; i < size; ++i) {
            Row row = (Row)rowSet.getKey(i);
            long rowid = row.getId();
            if (this.rowSessionMap.get(rowid, sessionid) == sessionid) continue;
            throw Trace.error(117, 122);
        }
    }

    void checkDelete(Session session, HsqlArrayList rowSet) throws HsqlException {
        if (!this.reWriteProtect) {
            return;
        }
        int sessionid = session.getId();
        int size = rowSet.size();
        for (int i = 0; i < size; ++i) {
            Row row = (Row)rowSet.get(i);
            long rowid = row.getId();
            if (this.rowSessionMap.get(rowid, sessionid) == sessionid) continue;
            throw Trace.error(117, 122);
        }
    }

    void commit(Session session) {
        Object[] list = session.rowActionList.getArray();
        int size = session.rowActionList.size();
        for (int i = 0; i < size; ++i) {
            Transaction tx = (Transaction)list[i];
            long rowid = tx.row.getId();
            tx.commit(session);
            this.rowSessionMap.remove(rowid);
        }
        session.rowActionList.clear();
        session.savepoints.clear();
    }

    synchronized void rollback(Session session) {
        this.rollbackTransactions(session, 0, false);
        session.savepoints.clear();
    }

    void rollbackSavepoint(Session session, String name) throws HsqlException {
        int index = session.savepoints.getIndex(name);
        if (index < 0) {
            throw Trace.error(44, name);
        }
        Integer oi = (Integer)session.savepoints.get(index);
        int limit = oi;
        this.rollbackTransactions(session, limit, false);
        while (session.savepoints.size() > index) {
            session.savepoints.remove(session.savepoints.size() - 1);
        }
    }

    void rollbackTransactions(Session session, int limit, boolean log) {
        Transaction tx;
        int i;
        Object[] list = session.rowActionList.getArray();
        int size = session.rowActionList.size();
        for (i = size - 1; i >= limit; --i) {
            tx = (Transaction)list[i];
            tx.rollback(session, log);
        }
        for (i = limit; i < size; ++i) {
            tx = (Transaction)list[i];
            long rowid = tx.row.getId();
            this.rowSessionMap.remove(rowid);
        }
        session.rowActionList.setSize(limit);
    }

    void addTransaction(Session session, Transaction transaction) {
        if (this.reWriteProtect) {
            this.rowSessionMap.put(transaction.row.getId(), session.getId());
        }
    }

    long nextActionTimestamp() {
        ++this.globalActionTimestamp;
        return this.globalActionTimestamp;
    }

    /*
     * Unable to fully structure code
     */
    Transaction[] getTransactionList() {
        sessions = this.database.sessionManager.getAllSessions();
        tIndex = new int[sessions.length];
        transactionCount = 0;
        actioncount = 0;
        for (i = 0; i < sessions.length; ++i) {
            actioncount += sessions[i].getTransactionSize();
        }
        transactions = new Transaction[actioncount];
        block1: while (true) {
            found = false;
            minChangeNo = 0x7FFFFFFFFFFFFFFFL;
            sessionIndex = 0;
            for (i = 0; i < sessions.length; ++i) {
                tSize = sessions[i].getTransactionSize();
                if (tIndex[i] >= tSize) continue;
                current = (Transaction)sessions[i].rowActionList.get(tIndex[i]);
                if (current.SCN < minChangeNo) {
                    minChangeNo = current.SCN;
                    sessionIndex = i;
                }
                found = true;
            }
            if (!found) break;
            currentList = sessions[sessionIndex].rowActionList;
            while (true) {
                if (tIndex[sessionIndex] >= currentList.size()) continue block1;
                current = (Transaction)currentList.get(tIndex[sessionIndex]);
                if (current.SCN == minChangeNo + 1L) {
                    ++minChangeNo;
                }
                if (current.SCN == minChangeNo) ** break;
                continue block1;
                transactions[transactionCount++] = current;
                v0 = sessionIndex;
                tIndex[v0] = tIndex[v0] + 1;
            }
            break;
        }
        return transactions;
    }

    public DoubleIntIndex getTransactionIDList() {
        Session[] sessions = this.database.sessionManager.getAllSessions();
        DoubleIntIndex lookup = new DoubleIntIndex(10, false);
        lookup.setKeysSearchTarget();
        for (int i = 0; i < sessions.length; ++i) {
            HsqlArrayList tlist = sessions[i].rowActionList;
            int size = tlist.size();
            for (int j = 0; j < size; ++j) {
                Transaction tx = (Transaction)tlist.get(j);
                if (tx.tTable.getTableType() != 4) continue;
                lookup.addUnique(tx.row.getPos(), 0);
            }
        }
        return lookup;
    }

    public void convertTransactionIDs(DoubleIntIndex lookup) {
        Session[] sessions = this.database.sessionManager.getAllSessions();
        for (int i = 0; i < sessions.length; ++i) {
            HsqlArrayList tlist = sessions[i].rowActionList;
            int size = tlist.size();
            for (int j = 0; j < size; ++j) {
                Transaction tx = (Transaction)tlist.get(j);
                if (tx.tTable.getTableType() != 4) continue;
                int pos = lookup.lookupFirstEqual(tx.row.getPos());
                tx.row.setPos(pos);
            }
        }
    }
}

