/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.Trigger;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.StringConverter;

class TriggerDef
extends Thread {
    static final int NUM_TRIGGER_OPS = 3;
    static final int NUM_TRIGS = 12;
    HsqlNameManager.HsqlName name;
    String when;
    String operation;
    boolean forEachRow;
    boolean nowait;
    int maxRowsQueued;
    protected static int defaultQueueSize = 1024;
    Table table;
    Trigger trigger;
    String triggerClassName;
    int vectorIndex;
    protected HsqlDeque pendingQueue;
    protected int rowsQueued;
    protected boolean valid = true;
    protected volatile boolean keepGoing = true;

    public static int getDefaultQueueSize() {
        return defaultQueueSize;
    }

    public TriggerDef(HsqlNameManager.HsqlName name, String when, String operation, boolean forEach, Table table, String triggerClassName, boolean noWait, int queueSize, ClassLoader loader) throws HsqlException {
        Class<Object> cl;
        this.name = name;
        this.when = when;
        this.operation = operation;
        this.forEachRow = forEach;
        this.nowait = noWait;
        this.maxRowsQueued = queueSize;
        this.table = table;
        this.vectorIndex = this.SqlToIndex();
        this.triggerClassName = triggerClassName;
        this.rowsQueued = 0;
        this.pendingQueue = new HsqlDeque();
        if (this.vectorIndex < 0) {
            throw Trace.error(11, 204);
        }
        try {
            cl = loader == null ? Class.forName(triggerClassName) : loader.loadClass(triggerClassName);
        }
        catch (ClassNotFoundException e) {
            this.valid = false;
            cl = DefaultTrigger.class;
        }
        try {
            this.trigger = (Trigger)cl.newInstance();
        }
        catch (Exception e) {
            this.valid = false;
            cl = DefaultTrigger.class;
        }
    }

    public StringBuffer getDDL() {
        StringBuffer a = new StringBuffer(256);
        a.append("CREATE").append(' ');
        a.append("TRIGGER").append(' ');
        a.append(this.name.statementName).append(' ');
        a.append(this.when).append(' ');
        a.append(this.operation).append(' ');
        a.append("ON").append(' ');
        a.append(this.table.getName().statementName).append(' ');
        if (this.forEachRow) {
            a.append("FOR").append(' ');
            a.append("EACH").append(' ');
            a.append("ROW").append(' ');
        }
        if (this.nowait) {
            a.append("NOWAIT").append(' ');
        }
        if (this.maxRowsQueued != TriggerDef.getDefaultQueueSize()) {
            a.append("QUEUE").append(' ');
            a.append(this.maxRowsQueued).append(' ');
        }
        a.append("CALL").append(' ');
        a.append(StringConverter.toQuotedString(this.triggerClassName, '\"', false));
        return a;
    }

    public int SqlToIndex() {
        int indx;
        if (this.operation.equals("INSERT")) {
            indx = 0;
        } else if (this.operation.equals("DELETE")) {
            indx = 1;
        } else if (this.operation.equals("UPDATE")) {
            indx = 2;
        } else {
            return -1;
        }
        if (this.when.equals("BEFORE")) {
            indx += 3;
        } else if (!this.when.equals("AFTER")) {
            return -1;
        }
        if (this.forEachRow) {
            indx += 6;
        }
        return indx;
    }

    public static int indexToRight(int idx) {
        switch (idx) {
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                return 2;
            }
            case 0: 
            case 3: 
            case 6: 
            case 9: {
                return 4;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                return 8;
            }
        }
        return 0;
    }

    public void run() {
        while (this.keepGoing) {
            TriggerData triggerData = this.popPair();
            if (triggerData == null || triggerData.username == null) continue;
            this.trigger.fire(this.vectorIndex, this.name.name, this.table.getName().name, triggerData.oldRow, triggerData.newRow);
        }
    }

    public synchronized void start() {
        if (this.maxRowsQueued != 0) {
            super.start();
        }
    }

    public synchronized void terminate() {
        this.keepGoing = false;
        this.notify();
    }

    synchronized TriggerData popPair() {
        if (this.rowsQueued == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.rowsQueued;
        this.notify();
        if (this.pendingQueue.size() == 0) {
            return null;
        }
        return (TriggerData)this.pendingQueue.removeFirst();
    }

    synchronized void pushPair(Session session, Object[] row1, Object[] row2) {
        if (this.maxRowsQueued == 0) {
            this.trigger.fire(this.vectorIndex, this.name.name, this.table.getName().name, row1, row2);
            return;
        }
        if (this.rowsQueued >= this.maxRowsQueued) {
            if (this.nowait) {
                this.pendingQueue.removeLast();
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ++this.rowsQueued;
            }
        } else {
            ++this.rowsQueued;
        }
        this.pendingQueue.add(new TriggerData(session, row1, row2));
        this.notify();
    }

    public boolean isBusy() {
        return this.rowsQueued != 0;
    }

    public boolean isValid() {
        return this.valid;
    }

    static class DefaultTrigger
    implements Trigger {
        DefaultTrigger() {
        }

        public void fire(int i, String name, String table, Object[] row1, Object[] row2) {
            throw new RuntimeException("Missing Trigger class!");
        }
    }

    class TriggerData {
        public Object[] oldRow;
        public Object[] newRow;
        public String username;

        public TriggerData(Session session, Object[] oldRow, Object[] newRow) {
            this.oldRow = oldRow;
            this.newRow = newRow;
            this.username = session.getUsername();
        }
    }
}

