/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Grantee;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.IntValueHashMap;

public class User {
    private boolean isSys;
    private boolean isPublic;
    private String sName;
    private String sPassword;
    private HsqlNameManager.HsqlName initialSchema = null;
    private Grantee grantee;

    User(String name, String password, Grantee inGrantee) throws HsqlException {
        boolean granteeOk;
        this.sName = name;
        this.grantee = inGrantee;
        boolean bl = granteeOk = this.grantee != null || GranteeManager.isReserved(name);
        if (!granteeOk) {
            Trace.doAssert(false, Trace.getMessage(234) + ": " + name);
        }
        this.setPassword(password);
        this.isSys = name.equals("_SYSTEM");
        this.isPublic = name.equals("PUBLIC");
    }

    String getName() {
        return this.sName;
    }

    void setPassword(String password) throws HsqlException {
        this.sPassword = password;
    }

    void checkPassword(String test) throws HsqlException {
        Trace.check(test.equals(this.sPassword), 33);
    }

    boolean isSys() {
        return this.isSys;
    }

    HsqlNameManager.HsqlName getInitialSchema() {
        return this.initialSchema;
    }

    void setInitialSchema(HsqlNameManager.HsqlName schema) {
        this.initialSchema = schema;
    }

    boolean isPublic() {
        return this.isPublic;
    }

    String getAlterUserDDL() {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER").append(' ');
        sb.append("USER").append(' ');
        sb.append(this.sName).append(' ');
        sb.append("SET").append(' ');
        sb.append("PASSWORD").append(' ');
        sb.append('\"').append(this.sPassword).append('\"');
        return sb.toString();
    }

    String getCreateUserDDL() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("CREATE").append(' ');
        sb.append("USER").append(' ');
        sb.append(this.sName).append(' ');
        sb.append("PASSWORD").append(' ');
        sb.append('\"').append(this.sPassword).append('\"');
        return sb.toString();
    }

    public String getConnectStatement() {
        StringBuffer sb = new StringBuffer();
        sb.append("CONNECT").append(' ');
        sb.append("USER").append(' ');
        sb.append(this.sName);
        return sb.toString();
    }

    Grantee getGrantee() {
        return this.grantee;
    }

    void setGrantee(Grantee inGrantee) throws HsqlException {
        if (this.grantee != null) {
            Trace.doAssert(false, Trace.getMessage(235) + ": " + this.sName);
        }
        this.grantee = inGrantee;
    }

    boolean isAdmin() {
        return this.grantee.isAdmin();
    }

    String[] listGrantedTablePrivileges(HsqlNameManager.HsqlName name) {
        return this.grantee.listGrantedTablePrivileges(name);
    }

    HashSet getGrantedClassNames(boolean andToPublic) throws HsqlException {
        return this.grantee.getGrantedClassNames(andToPublic);
    }

    IntValueHashMap getRights() {
        return this.grantee.getRights();
    }

    void checkAdmin() throws HsqlException {
        this.grantee.checkAdmin();
    }

    void check(HsqlNameManager.HsqlName dbobject, int rights) throws HsqlException {
        this.grantee.check(dbobject, rights);
    }

    void check(String dbobject) throws HsqlException {
        this.grantee.check(dbobject);
    }

    boolean isAccessible(HsqlNameManager.HsqlName dbobject, int rights) throws HsqlException {
        return this.grantee.isAccessible(dbobject, rights);
    }

    boolean isAccessible(String dbobject) throws HsqlException {
        return this.grantee.isAccessible(dbobject);
    }

    boolean isAccessible(HsqlNameManager.HsqlName dbobject) throws HsqlException {
        return this.grantee.isAccessible(dbobject);
    }
}

