/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Trace;

public class Util {
    static final void throwError(HsqlException e) throws SQLException {
        throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
    }

    static final void throwError(Result r) throws SQLException {
        throw new SQLException(r.getMainString(), r.getSubString(), r.getStatementID());
    }

    public static final SQLException sqlException(HsqlException e) {
        return new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
    }

    public static final SQLWarning sqlWarning(HsqlException e) {
        return new SQLWarning(e.getMessage(), e.getSQLState(), e.getErrorCode());
    }

    static final SQLException sqlException(int id) {
        return Util.sqlException(Trace.error(id));
    }

    static final SQLException sqlException(int id, String message) {
        return Util.sqlException(Trace.error(id, message));
    }

    static final SQLException sqlException(int id, int subId, Object[] add) {
        return Util.sqlException(Trace.error(id, subId, add));
    }

    static final SQLException notSupported() {
        return Util.sqlException(Trace.error(20));
    }

    public static SQLException nullArgument() {
        return Util.sqlException(62);
    }

    static SQLException nullArgument(String name) {
        return Util.sqlException(62, name + ": null");
    }

    public static SQLException invalidArgument() {
        return Util.sqlException(62);
    }

    public static SQLException invalidArgument(String name) {
        return Util.sqlException(62, name);
    }

    public static SQLException outOfRangeArgument() {
        return Util.sqlException(62);
    }

    public static SQLException outOfRangeArgument(String name) {
        return Util.sqlException(62, name);
    }

    public static SQLException connectionClosedException() {
        return Util.sqlException(2);
    }
}

