/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.HsqlException;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.jdbc.jdbcPreparedStatement;
import org.hsqldb.lib.IntValueHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jdbcCallableStatement
extends jdbcPreparedStatement
implements CallableStatement {
    private IntValueHashMap parameterNameMap = new IntValueHashMap();

    public jdbcCallableStatement(jdbcConnection c, String sql, int type) throws HsqlException, SQLException {
        super(c, sql, type);
        if (this.pmdDescriptor != null && this.pmdDescriptor.metaData != null) {
            String[] names = this.pmdDescriptor.metaData.colNames;
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                if (name == null || name.length() == 0) continue;
                this.parameterNameMap.put(name, i);
            }
        }
    }

    int findParameterIndex(String parameterName) throws SQLException {
        this.checkClosed();
        int index = this.parameterNameMap.get((Object)parameterName, -1);
        if (index >= 0) {
            return index + 1;
        }
        throw Util.sqlException(28, parameterName);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.parameterNameMap = null;
        super.close();
    }

    private void checkGetParameterIndex(int i) throws SQLException {
        this.checkClosed();
        if (i < 1 || i > this.parameterModes.length) {
            String msg = "Parameter index out of bounds: " + i;
            throw Util.sqlException(62, msg);
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.setURL(this.findParameterIndex(parameterName), val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.findParameterIndex(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.findParameterIndex(parameterName), x, length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.findParameterIndex(parameterName), x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.findParameterIndex(parameterName), x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.findParameterIndex(parameterName), reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.findParameterIndex(parameterName), x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.findParameterIndex(parameterName), x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.findParameterIndex(parameterName), x, cal);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.findParameterIndex(parameterName), sqlType, typeName);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.getString(this.findParameterIndex(parameterName));
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getBoolean(this.findParameterIndex(parameterName));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.getByte(this.findParameterIndex(parameterName));
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.getShort(this.findParameterIndex(parameterName));
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.getInt(this.findParameterIndex(parameterName));
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.getLong(this.findParameterIndex(parameterName));
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.getFloat(this.findParameterIndex(parameterName));
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.getDouble(this.findParameterIndex(parameterName));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getBytes(this.findParameterIndex(parameterName));
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.getDate(this.findParameterIndex(parameterName));
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.getTime(this.findParameterIndex(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(parameterName));
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.findParameterIndex(parameterName));
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getBigDecimal(this.findParameterIndex(parameterName));
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return this.getObject(this.findParameterIndex(parameterName), map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.getRef(this.findParameterIndex(parameterName));
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.getBlob(this.findParameterIndex(parameterName));
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.getClob(this.findParameterIndex(parameterName));
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.getArray(this.findParameterIndex(parameterName));
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getDate(this.findParameterIndex(parameterName), cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getTime(this.findParameterIndex(parameterName), cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(parameterName), cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.getURL(this.findParameterIndex(parameterName));
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

