/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HSQLClientConnection;
import org.hsqldb.HTTPClientConnection;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcCallableStatement;
import org.hsqldb.jdbc.jdbcDatabaseMetaData;
import org.hsqldb.jdbc.jdbcPreparedStatement;
import org.hsqldb.jdbc.jdbcSavepoint;
import org.hsqldb.jdbc.jdbcStatement;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jdbcConnection
implements Connection {
    HsqlProperties connProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    protected boolean isNetConn;
    boolean isClosed;
    private SQLWarning rootWarning;
    private Object rootWarning_mutex = new Object();

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        jdbcStatement stmt = new jdbcStatement(this, 1003);
        return stmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        try {
            jdbcPreparedStatement stmt = new jdbcPreparedStatement(this, sql, 1003);
            return stmt;
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        try {
            jdbcCallableStatement stmt = new jdbcCallableStatement(this, sql, 1003);
            return stmt;
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        if (sql == null || sql.length() == 0 || sql.indexOf(123) == -1) {
            return sql;
        }
        int state = 0;
        int len = sql.length();
        int nest = 0;
        StringBuffer sb = new StringBuffer(sql.length());
        boolean outside_all = false;
        boolean outside_escape_inside_single_quotes = true;
        int outside_escape_inside_double_quotes = 2;
        int inside_escape = 3;
        int inside_escape_inside_single_quotes = 4;
        int inside_escape_inside_double_quotes = 5;
        sb.append(sql);
        block6: for (int i = 0; i < len; ++i) {
            char c = sb.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                        continue block6;
                    }
                    if (c == '\"') {
                        state = 2;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    i = this.onStartEscapeSequence(sql, sb, i);
                    ++nest;
                    state = 3;
                    continue block6;
                }
                case 1: 
                case 4: {
                    if (c != '\'') continue block6;
                    --state;
                    continue block6;
                }
                case 2: 
                case 5: {
                    if (c != '\"') continue block6;
                    state -= 2;
                    continue block6;
                }
                case 3: {
                    if (c == '\'') {
                        state = 4;
                        continue block6;
                    }
                    if (c == '\"') {
                        state = 5;
                        continue block6;
                    }
                    if (c == '}') {
                        sb.setCharAt(i, ' ');
                        state = --nest == 0 ? 0 : 3;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    i = this.onStartEscapeSequence(sql, sb, i);
                    ++nest;
                    state = 3;
                }
            }
        }
        return sb.toString();
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(autoCommit);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.commit();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.rollback();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.sessionProxy != null) {
            this.sessionProxy.close();
        }
        this.sessionProxy = null;
        this.rootWarning = null;
        this.connProperties = null;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new jdbcDatabaseMetaData(this);
    }

    @Override
    public synchronized void setReadOnly(boolean readonly) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnly(readonly);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        try {
            return this.sessionProxy.isReadOnly();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw Util.invalidArgument();
            }
        }
        try {
            this.sessionProxy.setIsolation(level);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.getIsolation();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (!this.isNetConn) {
                HsqlException[] warnings = ((Session)this.sessionProxy).getAndClearWarnings();
                for (int i = 0; i < warnings.length; ++i) {
                    SQLWarning warning = Util.sqlWarning(warnings[i]);
                    this.addWarning(warning);
                }
            }
            return this.rootWarning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = null;
        }
    }

    @Override
    public synchronized Statement createStatement(int type, int concurrency) throws SQLException {
        this.checkClosed();
        type = this.xlateRSType(type);
        concurrency = this.xlateRSConcurrency(concurrency);
        return new jdbcStatement(this, type);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int type, int concurrency) throws SQLException {
        this.checkClosed();
        type = this.xlateRSType(type);
        concurrency = this.xlateRSConcurrency(concurrency);
        try {
            return new jdbcPreparedStatement(this, sql, type);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        resultSetType = this.xlateRSType(resultSetType);
        resultSetConcurrency = this.xlateRSConcurrency(resultSetConcurrency);
        try {
            return new jdbcCallableStatement(this, sql, resultSetType);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public synchronized Map getTypeMap() throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public synchronized void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        switch (holdability) {
            case 1: {
                break;
            }
            case 2: {
                String msg = "ResultSet holdability: " + holdability;
                throw Util.sqlException(20, msg);
            }
            default: {
                throw Util.invalidArgument();
            }
        }
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (name == null) {
            String msg = "name is null";
            throw Util.sqlException(62, msg);
        }
        Result req = Result.newSetSavepointRequest(name);
        try {
            this.sessionProxy.execute(req);
        }
        catch (HsqlException e) {
            Util.throwError(e);
        }
        return new jdbcSavepoint(name, this);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            String msg = "savepoint is null";
            throw Util.sqlException(62, msg);
        }
        try {
            if (this.sessionProxy.isAutoCommit()) {
                String msg = "connection is autocommit";
                throw Util.sqlException(62, msg);
            }
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
        if (!(savepoint instanceof jdbcSavepoint)) {
            throw Util.sqlException(62);
        }
        jdbcSavepoint sp = (jdbcSavepoint)savepoint;
        if (this != sp.connection) {
            String msg = savepoint + " was not issued on this connection";
            throw Util.sqlException(62, msg);
        }
        Result req = Result.newRollbackToSavepointRequest(sp.name);
        try {
            Result result = this.sessionProxy.execute(req);
            if (result.isError()) {
                Util.throwError(result);
            }
        }
        catch (HsqlException e) {
            Util.throwError(e);
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            String msg = "savepoint is null";
            throw Util.sqlException(62, msg);
        }
        if (!(savepoint instanceof jdbcSavepoint)) {
            throw Util.sqlException(62);
        }
        jdbcSavepoint sp = (jdbcSavepoint)savepoint;
        if (this != sp.connection) {
            String msg = savepoint.getSavepointName() + " was not issued on this connection";
            throw Util.sqlException(62, msg);
        }
        Result req = Result.newReleaseSavepointRequest(sp.name);
        try {
            Result result = this.sessionProxy.execute(req);
            if (result.isError()) {
                Util.throwError(result);
            }
        }
        catch (HsqlException e) {
            Util.throwError(e);
        }
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        resultSetType = this.xlateRSType(resultSetType);
        resultSetConcurrency = this.xlateRSConcurrency(resultSetConcurrency);
        resultSetHoldability = this.xlateRSHoldability(resultSetHoldability);
        return new jdbcStatement(this, resultSetType);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        resultSetType = this.xlateRSType(resultSetType);
        resultSetConcurrency = this.xlateRSConcurrency(resultSetConcurrency);
        resultSetHoldability = this.xlateRSHoldability(resultSetHoldability);
        try {
            return new jdbcPreparedStatement(this, sql, resultSetType);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        resultSetType = this.xlateRSType(resultSetType);
        resultSetConcurrency = this.xlateRSConcurrency(resultSetConcurrency);
        resultSetHoldability = this.xlateRSHoldability(resultSetHoldability);
        try {
            return new jdbcCallableStatement(this, sql, resultSetType);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    public jdbcConnection(HsqlProperties props) throws SQLException {
        boolean isTLS;
        String user = props.getProperty("user");
        String password = props.getProperty("password");
        String connType = props.getProperty("connection_type");
        String host = props.getProperty("host");
        int port = props.getIntegerProperty("port", 0);
        String path = props.getProperty("path");
        String database = props.getProperty("database");
        boolean bl = isTLS = connType == "hsqls://" || connType == "https://";
        if (user == null) {
            user = "SA";
        }
        if (password == null) {
            password = "";
        }
        user = user.toUpperCase(Locale.ENGLISH);
        password = password.toUpperCase(Locale.ENGLISH);
        try {
            if (DatabaseURL.isInProcessDatabaseType(connType)) {
                this.sessionProxy = DatabaseManager.newSession(connType, database, user, password, props);
            } else if (connType == "hsql://" || connType == "hsqls://") {
                this.sessionProxy = new HSQLClientConnection(host, port, path, database, isTLS, user, password);
                this.isNetConn = true;
            } else if (connType == "http://" || connType == "https://") {
                this.sessionProxy = new HTTPClientConnection(host, port, path, database, isTLS, user, password);
                this.isNetConn = true;
            } else {
                throw Util.sqlException(62);
            }
            this.connProperties = props;
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public jdbcConnection(Session c) throws HsqlException {
        this.isInternal = true;
        this.sessionProxy = c;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    synchronized String getURL() throws SQLException {
        this.checkClosed();
        if (this.isInternal) {
            return ((Session)this.sessionProxy).getInternalConnectionURL();
        }
        return this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.sqlException(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWarning(SQLWarning w) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = w;
            } else {
                this.rootWarning.setNextWarning(w);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearWarningsNoCheck() {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = null;
        }
    }

    int xlateRSType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return type;
            }
            case 1005: {
                String msg = "TYPE_SCROLL_SENSITIVE => TYPE_SCROLL_SENSITIVE";
                SQLWarning w = new SQLWarning(msg, "SOO10", 62);
                this.addWarning(w);
                return 1004;
            }
        }
        String msg = "ResultSet type: " + type;
        throw Util.sqlException(62, msg);
    }

    int xlateRSConcurrency(int concurrency) throws SQLException {
        switch (concurrency) {
            case 1007: {
                return concurrency;
            }
            case 1008: {
                String msg = "CONCUR_UPDATABLE => CONCUR_READ_ONLY";
                SQLWarning w = new SQLWarning(msg, "SOO10", 62);
                this.addWarning(w);
                return 1007;
            }
        }
        String msg = "ResultSet concurrency: " + concurrency;
        throw Util.sqlException(62, msg);
    }

    int xlateRSHoldability(int holdability) throws SQLException {
        switch (holdability) {
            case 1: {
                return holdability;
            }
            case 2: {
                String msg = "CLOSE_CURSORS_AT_COMMIT => HOLD_CURSORS_OVER_COMMIT";
                SQLWarning w = new SQLWarning(msg, "SOO10", 62);
                this.addWarning(w);
                return 1;
            }
        }
        String msg = "ResultSet holdability: " + holdability;
        throw Util.sqlException(62, msg);
    }

    public void reset() throws SQLException {
        try {
            this.sessionProxy.resetSession();
        }
        catch (HsqlException e) {
            throw new SQLException("Error resetting connection: " + e.getMessage());
        }
    }

    private int onStartEscapeSequence(String sql, StringBuffer sb, int i) throws SQLException {
        sb.setCharAt(i++, ' ');
        i = StringUtil.skipSpaces(sql, i);
        if (sql.regionMatches(true, i, "fn ", 0, 3) || sql.regionMatches(true, i, "oj ", 0, 3) || sql.regionMatches(true, i, "ts ", 0, 3)) {
            sb.setCharAt(i++, ' ');
            sb.setCharAt(i++, ' ');
        } else if (sql.regionMatches(true, i, "d ", 0, 2) || sql.regionMatches(true, i, "t ", 0, 2)) {
            sb.setCharAt(i++, ' ');
        } else if (sql.regionMatches(true, i, "call ", 0, 5)) {
            i += 4;
        } else if (sql.regionMatches(true, i, "?= call ", 0, 8)) {
            sb.setCharAt(i++, ' ');
            sb.setCharAt(i++, ' ');
            i += 5;
        } else if (sql.regionMatches(true, i, "escape ", 0, 7)) {
            i += 6;
        } else {
            throw new SQLException(Trace.getMessage(138, true, new Object[]{sql.substring(--i)}), "S0010", 62);
        }
        return i;
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

