/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.hsqldb.Result;
import org.hsqldb.Types;
import org.hsqldb.jdbc.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jdbcParameterMetaData
implements ParameterMetaData {
    Result.ResultMetaData rmd;
    int[] types;
    int[] modes;
    boolean[] isIdentity;
    int[] nullability;
    String[] classNames;
    int parameterCount;

    jdbcParameterMetaData(Result r) throws SQLException {
        if (r == null) {
            this.parameterCount = 0;
            return;
        }
        this.rmd = r.metaData;
        this.types = this.rmd.colTypes;
        this.parameterCount = this.types.length;
        this.nullability = this.rmd.colNullable;
        this.isIdentity = this.rmd.isIdentity;
        this.classNames = this.rmd.classNames;
        this.modes = this.rmd.paramMode;
    }

    void checkRange(int param) throws SQLException {
        if (param < 1 || param > this.parameterCount) {
            String msg = param + " is out of range";
            throw Util.sqlException(62, msg);
        }
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkRange(param);
        return this.classNames[--param];
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkRange(param);
        return this.modes[--param];
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkRange(param);
        int t = this.types[--param];
        return t == 100 ? 12 : t;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkRange(param);
        return Types.getTypeName(this.types[--param]);
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkRange(param);
        return Types.getPrecision(this.types[--param]);
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkRange(param);
        return 0;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkRange(param);
        return this.nullability[--param];
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkRange(param);
        Boolean b = Types.isUnsignedAttribute(this.types[--param]);
        return b != null && b == false && !this.isIdentity[param];
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Throwable t) {
            return super.toString() + "[toStringImpl_exception=" + t + "]";
        }
    }

    private String toStringImpl() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        int count = this.getParameterCount();
        if (count == 0) {
            sb.append("[parameterCount=0]");
            return sb.toString();
        }
        Method[] methods = this.getClass().getDeclaredMethods();
        sb.append('[');
        int len = methods.length;
        for (int i = 0; i < count; ++i) {
            sb.append('\n');
            sb.append("    parameter_");
            sb.append(i + 1);
            sb.append('=');
            sb.append('[');
            for (int j = 0; j < len; ++j) {
                Method method = methods[j];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                sb.append(method.getName());
                sb.append('=');
                sb.append(method.invoke((Object)this, new Integer(i + 1)));
                if (j + 1 >= len) continue;
                sb.append(',');
                sb.append(' ');
            }
            sb.append(']');
            if (i + 1 >= count) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('\n');
        sb.append(']');
        return sb.toString();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

