/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcBlob;
import org.hsqldb.jdbc.jdbcClob;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.jdbc.jdbcParameterMetaData;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.jdbc.jdbcResultSetMetaData;
import org.hsqldb.jdbc.jdbcStatement;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement {
    protected Object[] parameterValues;
    protected boolean[] parameterSet;
    protected boolean[] parameterStream;
    protected int[] parameterTypes;
    protected int[] parameterModes;
    protected int[] streamLengths;
    protected boolean hasStreams;
    protected Result rsmdDescriptor;
    protected Result pmdDescriptor;
    protected jdbcResultSetMetaData rsmd;
    protected Object pmd;
    protected String sql;
    protected int statementID;
    protected boolean isRowCount;

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.resultIn = null;
        try {
            this.resultOut.setMaxRows(this.maxRows);
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
        if (this.resultIn.isError()) {
            Util.throwError(this.resultIn);
        }
        return this.resultIn.isData();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.checkIsRowCount(false);
        this.checkParametersSet();
        this.resultIn = null;
        try {
            this.resultOut.setMaxRows(this.maxRows);
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
        if (this.resultIn.isError()) {
            Util.throwError(this.resultIn);
        } else if (!this.resultIn.isData()) {
            String msg = "Expected but did not recieve a result set";
            throw Util.sqlException(85, msg);
        }
        return new jdbcResultSet(this, this.resultIn, this.connection.connProperties, this.connection.isNetConn);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.checkIsRowCount(true);
        this.checkParametersSet();
        this.resultIn = null;
        try {
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
        if (this.resultIn.isError()) {
            Util.throwError(this.resultIn);
        } else if (this.resultIn.mode != 1) {
            String msg = "Expected but did not recieve a row update count";
            throw Util.sqlException(85, msg);
        }
        return this.resultIn.getUpdateCount();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchResultOut == null) {
            this.batchResultOut = new Result(9, this.parameterTypes, this.statementID);
        }
        return super.executeBatch();
    }

    @Override
    public void setNull(int paramIndex, int sqlType) throws SQLException {
        this.setParameter(paramIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        Boolean b = x ? Boolean.TRUE : Boolean.FALSE;
        this.setParameter(parameterIndex, b);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setIntParameter(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setIntParameter(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setIntParameter(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setLongParameter(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setDouble(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        Double d = new Double(x);
        this.setParameter(parameterIndex, d);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setBytes(int paramIndex, byte[] x) throws SQLException {
        this.setParameter(paramIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, true);
        if (x == null) {
            String s = "input stream is null";
            throw Util.sqlException(62, s);
        }
        try {
            String s = StringConverter.inputStreamToString(x, length);
            this.setParameter(parameterIndex, s);
        }
        catch (IOException e) {
            throw Util.sqlException(81);
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, true);
        String msg = null;
        if (x == null) {
            msg = "input stream is null";
        } else if (length % 2 != 0) {
            msg = "odd length argument";
        }
        if (msg != null) {
            throw Util.sqlException(62, msg);
        }
        int chlen = length / 2;
        StringBuffer sb = new StringBuffer();
        try {
            int lo;
            int hi;
            for (int chread = 0; chread < chlen && (hi = x.read()) != -1 && (lo = x.read()) != -1; ++chread) {
                sb.append((char)(hi << 8 | lo));
            }
        }
        catch (IOException e) {
            throw Util.sqlException(19);
        }
        this.setParameter(parameterIndex, sb.toString());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, true);
        if (x == null) {
            throw Util.sqlException(Trace.error(62, 176));
        }
        HsqlByteArrayOutputStream out = null;
        try {
            int read;
            out = new HsqlByteArrayOutputStream();
            int size = 2048;
            byte[] buff = new byte[size];
            for (int left = length; left > 0 && (read = x.read(buff, 0, left > size ? size : left)) != -1; left -= read) {
                out.write(buff, 0, read);
            }
            this.setParameter(parameterIndex, out.toByteArray());
        }
        catch (IOException e) {
            throw Util.sqlException(34, e.toString());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        ArrayUtil.fillArray(this.parameterValues, null);
        ArrayUtil.clearArray(90, this.parameterSet, 0, this.parameterSet.length);
        if (this.parameterStream != null) {
            ArrayUtil.clearArray(90, this.parameterStream, 0, this.parameterStream.length);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        int len = this.parameterValues.length;
        Object[] bpValues = new Object[len];
        this.checkParametersSet();
        System.arraycopy(this.parameterValues, 0, bpValues, 0, len);
        if (this.batchResultOut == null) {
            this.batchResultOut = new Result(9, this.parameterTypes, this.statementID);
        }
        this.batchResultOut.add(bpValues);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, true);
        if (reader == null) {
            String msg = "reader is null";
            throw Util.sqlException(62, msg);
        }
        StringBuffer sb = new StringBuffer();
        int size = 2048;
        char[] buff = new char[2048];
        try {
            int read;
            for (int left = length; left > 0 && (read = reader.read(buff, 0, left > 2048 ? 2048 : left)) != -1; left -= read) {
                sb.append(buff, 0, read);
            }
        }
        catch (IOException e) {
            throw Util.sqlException(19, e.toString());
        }
        this.setParameter(parameterIndex, sb.toString());
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        if (x instanceof jdbcBlob) {
            this.setParameter(i, ((jdbcBlob)x).data);
            return;
        }
        if (x == null) {
            this.setParameter(i, null);
            return;
        }
        this.checkSetParameterIndex(i, false);
        long length = x.length();
        if (length > Integer.MAX_VALUE) {
            String msg = "Maximum Blob input octet length exceeded: " + length;
            throw Util.sqlException(34, msg);
        }
        HsqlByteArrayOutputStream out = null;
        try {
            int read;
            out = new HsqlByteArrayOutputStream();
            InputStream in = x.getBinaryStream();
            int buffSize = 2048;
            byte[] buff = new byte[buffSize];
            for (int left = (int)length; left > 0 && (read = in.read(buff, 0, left > buffSize ? buffSize : left)) != -1; left -= read) {
                out.write(buff, 0, read);
            }
            this.setParameter(i, out.toByteArray());
        }
        catch (IOException e) {
            throw Util.sqlException(34, e.toString());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        if (x instanceof jdbcClob) {
            this.setParameter(i, ((jdbcClob)x).data);
            return;
        }
        if (x == null) {
            this.setParameter(i, null);
            return;
        }
        this.checkSetParameterIndex(i, false);
        long length = x.length();
        if (length > Integer.MAX_VALUE) {
            String msg = "Max Clob input character length exceeded: " + length;
            throw Util.sqlException(34, msg);
        }
        Reader reader = x.getCharacterStream();
        StringBuffer sb = new StringBuffer();
        int size = 2048;
        char[] buff = new char[2048];
        try {
            int read;
            for (int left = (int)length; left > 0 && (read = reader.read(buff, 0, left > 2048 ? 2048 : left)) != -1; left -= read) {
                sb.append(buff, 0, read);
            }
        }
        catch (IOException e) {
            throw Util.sqlException(19, e.toString());
        }
        this.setParameter(i, sb.toString());
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.isRowCount) {
            return null;
        }
        if (this.rsmd == null) {
            this.rsmd = new jdbcResultSetMetaData(this.rsmdDescriptor, this.connection.connProperties);
        }
        return this.rsmd;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        String s;
        try {
            s = HsqlDateTime.getDateString(x, cal);
        }
        catch (Exception e) {
            throw Util.sqlException(7, e.toString());
        }
        this.setParameter(parameterIndex, s);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        String s;
        try {
            s = HsqlDateTime.getTimeString(x, cal);
        }
        catch (Exception e) {
            throw Util.sqlException(7, e.toString());
        }
        this.setParameter(parameterIndex, s);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, false);
        if (cal != null && x != null) {
            int ns = x.getNanos();
            x = new Timestamp(HsqlDateTime.getTimeInMillis(x, cal, null));
            x.setNanos(ns);
        }
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(paramIndex, null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.pmd == null) {
            this.pmd = new jdbcParameterMetaData(this.pmdDescriptor);
        }
        return (ParameterMetaData)this.pmd;
    }

    jdbcPreparedStatement(jdbcConnection c, String sql, int type) throws HsqlException, SQLException {
        super(c, type);
        sql = c.nativeSQL(sql);
        this.resultOut.setResultType(65555);
        this.resultOut.setMainString(sql);
        Result in = this.connection.sessionProxy.execute(this.resultOut);
        if (in.isError()) {
            Util.throwError(in);
        }
        Iterator i = in.iterator();
        try {
            Object[] row = (Object[])i.next();
            this.statementID = ((Result)row[0]).getStatementID();
            row = (Object[])i.next();
            this.rsmdDescriptor = (Result)row[0];
            this.isRowCount = this.rsmdDescriptor.mode == 1;
            row = (Object[])i.next();
            this.pmdDescriptor = (Result)row[0];
            this.parameterTypes = this.pmdDescriptor.metaData.getParameterTypes();
            this.parameterValues = new Object[this.parameterTypes.length];
            this.parameterSet = new boolean[this.parameterTypes.length];
            this.parameterModes = this.pmdDescriptor.metaData.paramMode;
        }
        catch (Exception e) {
            throw Trace.error(40, e.toString());
        }
        this.resultOut = new Result(65548, this.parameterTypes, this.statementID);
        this.sql = sql;
    }

    protected void checkIsRowCount(boolean yes) throws SQLException {
        if (yes != this.isRowCount) {
            int msg = yes ? 154 : 155;
            throw Util.sqlException(msg);
        }
    }

    protected void checkSetParameterIndex(int i, boolean isStream) throws SQLException {
        this.checkClosed();
        if (i < 1 || i > this.parameterValues.length) {
            String msg = "parameter index out of range: " + i;
            throw Util.sqlException(62, msg);
        }
        if (isStream) {
            if (this.parameterStream == null) {
                this.parameterStream = new boolean[this.parameterTypes.length];
            }
            this.parameterStream[i - 1] = true;
            this.parameterSet[i - 1] = false;
        } else {
            this.parameterSet[i - 1] = true;
        }
    }

    private void checkParametersSet() throws SQLException {
    }

    private void setParameter(int i, Object o) throws SQLException {
        this.checkSetParameterIndex(i, false);
        --i;
        if (o == null) {
            this.parameterValues[i] = null;
            return;
        }
        int outType = this.parameterTypes[i];
        try {
            switch (outType) {
                case 1111: {
                    o = new JavaObject((Serializable)o);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (!(o instanceof byte[])) {
                        throw Util.sqlException(Trace.error(95));
                    }
                    o = new Binary((byte[])o, !this.connection.isNetConn);
                    break;
                }
                case 91: {
                    if (o instanceof java.util.Date) {
                        long t = HsqlDateTime.getNormalisedDate(((java.util.Date)o).getTime());
                        o = new Date(t);
                        break;
                    }
                    o = Column.convertObject(o, outType);
                    break;
                }
                case 92: {
                    if (o instanceof java.util.Date) {
                        long m = HsqlDateTime.getNormalisedTime(((java.util.Date)o).getTime());
                        o = new Time(m);
                        break;
                    }
                    o = Column.convertObject(o, outType);
                    break;
                }
                case 93: {
                    if (o instanceof Timestamp) {
                        long m = ((Timestamp)o).getTime();
                        int n = ((Timestamp)o).getNanos();
                        o = new Timestamp(m);
                        ((Timestamp)o).setNanos(n);
                        break;
                    }
                    o = Column.convertObject(o, outType);
                    break;
                }
                default: {
                    o = Column.convertObject(o, outType);
                    break;
                }
            }
        }
        catch (HsqlException e) {
            Util.throwError(e);
        }
        this.parameterValues[i] = o;
    }

    private void setIntParameter(int i, int value) throws SQLException {
        this.checkSetParameterIndex(i, false);
        int outType = this.parameterTypes[i - 1];
        switch (outType) {
            case -6: 
            case 4: 
            case 5: {
                Integer o = new Integer(value);
                this.parameterValues[i - 1] = o;
                break;
            }
            default: {
                this.setLongParameter(i, value);
            }
        }
    }

    private void setLongParameter(int i, long value) throws SQLException {
        this.checkSetParameterIndex(i, false);
        int outType = this.parameterTypes[i - 1];
        switch (outType) {
            case -5: {
                Long o = new Long(value);
                this.parameterValues[i - 1] = o;
                break;
            }
            case -2: 
            case 1111: {
                throw Util.sqlException(Trace.error(95));
            }
            default: {
                this.setParameter(i, new Long(value));
            }
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        HsqlException he = null;
        try {
            if (!this.connection.isClosed) {
                this.connection.sessionProxy.execute(Result.newFreeStmtRequest(this.statementID));
            }
        }
        catch (HsqlException e) {
            he = e;
        }
        this.parameterValues = null;
        this.parameterSet = null;
        this.parameterStream = null;
        this.parameterTypes = null;
        this.parameterModes = null;
        this.rsmdDescriptor = null;
        this.pmdDescriptor = null;
        this.rsmd = null;
        this.pmd = null;
        super.close();
        if (he != null) {
            throw Util.sqlException(he);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        String sql = this.sql;
        Object[] pv = this.parameterValues;
        if (sql == null || pv == null) {
            sb.append("[closed]");
            return sb.toString();
        }
        sb.append("[sql=[").append(sql).append("]");
        if (pv.length > 0) {
            sb.append(", parameters=[");
            for (int i = 0; i < pv.length; ++i) {
                sb.append('[');
                sb.append(pv[i]);
                sb.append("], ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(']');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

