/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.store.BaseHashMap;

public class HashSet
extends BaseHashMap
implements Set {
    public HashSet() {
        this(16, 0.75f);
    }

    public HashSet(int initialCapacity) throws IllegalArgumentException {
        this(initialCapacity, 0.75f);
    }

    public HashSet(int initialCapacity, float loadFactor) throws IllegalArgumentException {
        super(initialCapacity, loadFactor, 3, 0, false);
    }

    public boolean contains(Object key) {
        return super.containsKey(key);
    }

    public Object get(Object key) {
        int lookup = this.getLookup(key, key.hashCode());
        if (lookup < 0) {
            return null;
        }
        return this.objectKeyTable[lookup];
    }

    public boolean add(Object key) {
        int oldSize = this.size();
        super.addOrRemove(0L, 0L, key, null, false);
        return oldSize != this.size();
    }

    public boolean addAll(Collection c) {
        int oldSize = this.size();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return oldSize != this.size();
    }

    public boolean addAll(Object[] keys) {
        boolean changed = false;
        for (int i = 0; i < keys.length; ++i) {
            if (!this.add(keys[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean remove(Object key) {
        int oldSize = this.size();
        super.removeObject(key);
        return oldSize != this.size();
    }

    public Object[] toArray(Object[] a) {
        if (a == null || a.length < this.size()) {
            a = new Object[this.size()];
        }
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            a[i] = it.next();
            ++i;
        }
        return a;
    }

    public Iterator iterator() {
        return new BaseHashMap.BaseHashIterator(this, true);
    }

    public String toString() {
        Iterator it = this.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(", ");
            } else {
                sb.append('[');
            }
            sb.append(it.next());
        }
        return sb.toString() + ']';
    }
}

