/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Date;
import org.hsqldb.lib.HsqlArrayHeap;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.ThreadFactory;

public final class HsqlTimer
implements ObjectComparator,
ThreadFactory {
    protected final TaskQueue taskQueue = new TaskQueue(16, this);
    protected final TaskRunner taskRunner = new TaskRunner();
    protected Thread taskRunnerThread;
    protected final ThreadFactory threadFactory;
    protected volatile boolean isShutdown;
    static int nowCount = 0;

    public HsqlTimer() {
        this(null);
    }

    public HsqlTimer(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory == null ? this : threadFactory;
    }

    public int compare(Object a, Object b) {
        long bwhen;
        long awhen = ((Task)a).getNextScheduled();
        return awhen < (bwhen = ((Task)b).getNextScheduled()) ? -1 : (awhen == bwhen ? 0 : 1);
    }

    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName("HSQLDB Timer @" + Integer.toHexString(this.hashCode()));
        thread.setDaemon(true);
        return thread;
    }

    public synchronized Thread getThread() {
        return this.taskRunnerThread;
    }

    public synchronized void restart() throws IllegalStateException {
        if (this.isShutdown) {
            throw new IllegalStateException("isShutdown==true");
        }
        if (this.taskRunnerThread == null) {
            this.taskRunnerThread = this.threadFactory.newThread(this.taskRunner);
            this.taskRunnerThread.start();
        } else {
            this.taskQueue.unpark();
        }
    }

    public Object scheduleAfter(long delay, Runnable runnable) throws IllegalArgumentException {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(HsqlTimer.now() + delay, runnable, 0L, false);
    }

    public Object scheduleAt(Date date, Runnable runnable) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("date == null");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(date.getTime(), runnable, 0L, false);
    }

    public Object schedulePeriodicallyAt(Date date, long period, Runnable runnable, boolean relative) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("date == null");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("period <= 0");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(date.getTime(), runnable, period, relative);
    }

    public Object schedulePeriodicallyAfter(long delay, long period, Runnable runnable, boolean relative) throws IllegalArgumentException {
        if (period <= 0L) {
            throw new IllegalArgumentException("period <= 0");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        return this.addTask(HsqlTimer.now() + delay, runnable, period, relative);
    }

    public synchronized void shutdown() {
        if (!this.isShutdown) {
            this.isShutdown = true;
            this.taskQueue.cancelAllTasks();
        }
    }

    public synchronized void shutDown() {
        this.shutdown();
    }

    public synchronized void shutdownImmediately() {
        if (!this.isShutdown) {
            Thread runner = this.taskRunnerThread;
            this.isShutdown = true;
            if (runner != null && runner.isAlive()) {
                runner.interrupt();
            }
            this.taskQueue.cancelAllTasks();
        }
    }

    public static void cancel(Object task) {
        if (task instanceof Task) {
            ((Task)task).cancel();
        }
    }

    public static boolean isCancelled(Object task) {
        return task instanceof Task ? ((Task)task).isCancelled() : true;
    }

    public static boolean isFixedRate(Object task) {
        if (task instanceof Task) {
            Task ltask = (Task)task;
            return ltask.relative && ltask.period > 0L;
        }
        return false;
    }

    public static boolean isFixedDelay(Object task) {
        if (task instanceof Task) {
            Task ltask = (Task)task;
            return !ltask.relative && ltask.period > 0L;
        }
        return false;
    }

    public static boolean isPeriodic(Object task) {
        return task instanceof Task ? ((Task)task).period > 0L : false;
    }

    public static Date getLastScheduled(Object task) {
        if (task instanceof Task) {
            Task ltask = (Task)task;
            long last = ltask.getLastScheduled();
            return last == 0L ? null : new Date(last);
        }
        return null;
    }

    public static Object setPeriod(Object task, long period) {
        return task instanceof Task ? ((Task)task).setPeriod(period) : task;
    }

    public static Date getNextScheduled(Object task) {
        if (task instanceof Task) {
            Task ltask = (Task)task;
            long next = ltask.isCancelled() ? 0L : ltask.getNextScheduled();
            return next == 0L ? null : new Date(next);
        }
        return null;
    }

    protected Task addTask(long first, Runnable runnable, long period, boolean relative) {
        if (this.isShutdown) {
            throw new IllegalStateException("shutdown");
        }
        Task task = new Task(first, runnable, period, relative);
        this.taskQueue.addTask(task);
        this.restart();
        return task;
    }

    protected synchronized void clearThread() {
        try {
            this.taskRunnerThread.setContextClassLoader(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.taskRunnerThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Task nextTask() {
        try {
            while (!this.isShutdown || Thread.interrupted()) {
                long now;
                long next;
                Task task;
                TaskQueue taskQueue = this.taskQueue;
                synchronized (taskQueue) {
                    task = this.taskQueue.peekTask();
                    if (task == null) {
                        break;
                    }
                    next = task.next;
                    now = System.currentTimeMillis();
                    long wait = next - now;
                    if (wait > 0L) {
                        this.taskQueue.park(wait);
                        continue;
                    }
                    this.taskQueue.removeTask();
                }
                long period = task.period;
                if (period > 0L) {
                    if (task.relative) {
                        long late = now - next;
                        if (late > period) {
                            period = 0L;
                        } else if (late > 0L) {
                            period -= late;
                        }
                    }
                    task.updateSchedule(now, now + period);
                    this.taskQueue.addTask(task);
                }
                return task;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private static long now() {
        ++nowCount;
        return System.currentTimeMillis();
    }

    protected static class TaskQueue
    extends HsqlArrayHeap {
        TaskQueue(int capacity, ObjectComparator oc) {
            super(capacity, oc);
        }

        void addTask(Task task) {
            super.add(task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelAllTasks() {
            int oldCount;
            TaskQueue taskQueue = this;
            synchronized (taskQueue) {
                Object[] oldHeap = this.heap;
                oldCount = this.count;
                this.heap = new Object[1];
                this.count = 0;
            }
            for (int i = 0; i < oldCount; ++i) {
                ((Task)oldHeap[i]).cancelled = true;
            }
        }

        synchronized void park(long timeout) throws InterruptedException {
            this.wait(timeout);
        }

        synchronized Task peekTask() {
            while (this.heap[0] != null && ((Task)this.heap[0]).isCancelled()) {
                super.remove();
            }
            return (Task)this.heap[0];
        }

        synchronized void signalTaskCancelled(Task task) {
            if (task == this.heap[0]) {
                super.remove();
                this.notify();
            }
        }

        Task removeTask() {
            return (Task)super.remove();
        }

        synchronized void unpark() {
            this.notify();
        }
    }

    protected class Task {
        Runnable runnable;
        long period;
        long last;
        long next;
        boolean cancelled = false;
        private Object cancel_mutex = new Object();
        final boolean relative;

        Task(long first, Runnable runnable, long period, boolean relative) {
            this.next = first;
            this.runnable = runnable;
            this.period = period;
            this.relative = relative;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            boolean signalCancelled = false;
            Object object = this.cancel_mutex;
            synchronized (object) {
                if (!this.cancelled) {
                    signalCancelled = true;
                    this.cancelled = true;
                }
            }
            if (signalCancelled) {
                HsqlTimer.this.taskQueue.signalTaskCancelled(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isCancelled() {
            Object object = this.cancel_mutex;
            synchronized (object) {
                return this.cancelled;
            }
        }

        synchronized long getLastScheduled() {
            return this.last;
        }

        synchronized long getNextScheduled() {
            return this.next;
        }

        synchronized void updateSchedule(long last, long next) {
            this.last = last;
            this.next = next;
        }

        synchronized Object setPeriod(long newPeriod) {
            if (this.period == newPeriod || this.isCancelled()) {
                return this;
            }
            if (newPeriod > this.period) {
                this.period = newPeriod;
                return this;
            }
            this.cancel();
            return HsqlTimer.this.addTask(HsqlTimer.now(), this.runnable, newPeriod, this.relative);
        }
    }

    protected class TaskRunner
    implements Runnable {
        protected TaskRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Task task;
                while ((task = HsqlTimer.this.nextTask()) != null) {
                    task.runnable.run();
                }
            }
            finally {
                HsqlTimer.this.clearThread();
            }
        }
    }
}

