/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.store.BaseHashMap;

public class LongKeyIntValueHashMap
extends BaseHashMap {
    private Set keySet;
    private Collection values;

    public LongKeyIntValueHashMap() {
        this(16, 0.75f);
    }

    public LongKeyIntValueHashMap(boolean minimize) {
        this(16, 0.75f);
        this.minimizeOnEmpty = minimize;
    }

    public LongKeyIntValueHashMap(int initialCapacity) throws IllegalArgumentException {
        this(initialCapacity, 0.75f);
    }

    public LongKeyIntValueHashMap(int initialCapacity, float loadFactor) throws IllegalArgumentException {
        super(initialCapacity, loadFactor, 2, 1, false);
    }

    public int get(long key) throws NoSuchElementException {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        throw new NoSuchElementException();
    }

    public int get(long key, int defaultValue) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        return defaultValue;
    }

    public boolean get(long key, int[] value) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            value[0] = this.intValueTable[lookup];
            return true;
        }
        return false;
    }

    public boolean put(long key, int value) {
        int oldSize = this.size();
        super.addOrRemove(key, value, null, null, false);
        return oldSize != this.size();
    }

    public boolean remove(long key) {
        int oldSize = this.size();
        super.addOrRemove(key, 0L, null, null, true);
        return oldSize != this.size();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class Values
    implements Collection {
        Values() {
        }

        public Iterator iterator() {
            LongKeyIntValueHashMap longKeyIntValueHashMap = LongKeyIntValueHashMap.this;
            longKeyIntValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyIntValueHashMap, false);
        }

        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        public boolean add(Object value) {
            throw new RuntimeException();
        }

        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public void clear() {
            LongKeyIntValueHashMap.this.clear();
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        public Iterator iterator() {
            LongKeyIntValueHashMap longKeyIntValueHashMap = LongKeyIntValueHashMap.this;
            longKeyIntValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyIntValueHashMap, true);
        }

        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        public Object get(Object key) {
            throw new RuntimeException();
        }

        public boolean add(Object value) {
            throw new RuntimeException();
        }

        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public void clear() {
            LongKeyIntValueHashMap.this.clear();
        }
    }
}

