/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.ZipUnzipFile;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

public class DataFileCache {
    protected FileAccess fa;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    static final int LONG_EMPTY_SIZE = 4;
    static final int LONG_FREE_POS_POS = 12;
    static final int LONG_EMPTY_INDEX_POS = 20;
    static final int FLAGS_POS = 28;
    static final int INITIAL_FREE_POS = 32;
    DataFileBlockManager freeBlocks;
    private static final int initIOBufferSize = 256;
    protected String fileName;
    protected String backupFileName;
    protected Database database;
    protected boolean fileModified;
    protected int cacheFileScale;
    protected boolean cacheReadonly;
    protected boolean storeOnInsert;
    protected int cachedRowPadding = 8;
    protected boolean hasRowInfo = false;
    protected RowInputInterface rowIn;
    protected RowOutputInterface rowOut;
    public long maxDataFileSize;
    protected Storage dataFile;
    protected long fileFreePosition;
    protected int maxCacheSize;
    protected long maxCacheBytes;
    protected int maxFreeBlocks;
    protected Cache cache;

    public DataFileCache(Database db, String baseFileName) throws HsqlException {
        this.initParams(db, baseFileName);
        this.cache = new Cache(this);
    }

    protected void initParams(Database database, String baseFileName) throws HsqlException {
        HsqlDatabaseProperties props = database.getProperties();
        this.fileName = baseFileName + ".data";
        this.backupFileName = baseFileName + ".backup";
        this.database = database;
        this.fa = database.getFileAccess();
        int cacheScale = props.getIntegerProperty("hsqldb.cache_scale", 14, 8, 18);
        int cacheSizeScale = props.getIntegerProperty("hsqldb.cache_size_scale", 10, 6, 20);
        int cacheFreeCountScale = props.getIntegerProperty("hsqldb.cache_free_count_scale", 9, 6, 12);
        this.cacheFileScale = database.getProperties().getIntegerProperty("hsqldb.cache_file_scale", 1);
        if (this.cacheFileScale != 1) {
            this.cacheFileScale = 8;
        }
        this.cacheReadonly = database.isFilesReadOnly();
        int lookupTableLength = 1 << cacheScale;
        int avgRowBytes = 1 << cacheSizeScale;
        this.maxCacheSize = lookupTableLength * 3;
        this.maxCacheBytes = this.maxCacheSize * avgRowBytes;
        this.maxDataFileSize = this.cacheFileScale == 1 ? Integer.MAX_VALUE : 0x1FFFFFFFCL;
        this.maxFreeBlocks = 1 << cacheFreeCountScale;
        this.dataFile = null;
    }

    public void open(boolean readonly) throws HsqlException {
        this.fileFreePosition = 0L;
        this.database.logger.appLog.logContext(2, "start");
        try {
            boolean isNio;
            int fileType;
            boolean preexists = this.database.isFilesInJar();
            long freesize = 0L;
            if (!preexists && this.fa.isStreamElement(this.fileName)) {
                if (this.database.isStoredFileAccess()) {
                    preexists = true;
                }
                if (!preexists) {
                    File f = new File(this.fileName);
                    boolean bl = preexists = f.length() > 32L;
                }
            }
            if (preexists) {
                String version = this.database.getProperties().getProperty("hsqldb.cache_version");
                boolean v17 = "1.7.0".equals(version);
                boolean v18 = "1.8.0".equals(version);
                if (!v17) {
                    throw Trace.error(30);
                }
            }
            int n = fileType = (isNio = this.database.getProperties().isPropertyTrue("hsqldb.nio_data_file")) ? 1 : 0;
            if (this.database.isFilesInJar()) {
                fileType = 2;
            }
            String cname = this.database.getURLProperties().getProperty("storage_class_name");
            String skey = this.database.getURLProperties().getProperty("storage_key");
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.fileName, readonly, fileType, cname, skey);
            if (preexists) {
                this.dataFile.seek(28L);
                int flags = this.dataFile.readInt();
                this.hasRowInfo = BitMap.isSet(flags, 3);
                this.dataFile.seek(4L);
                freesize = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                if (this.fileFreePosition < 32L) {
                    this.fileFreePosition = 32L;
                }
            } else {
                this.fileFreePosition = 32L;
                this.dataFile.seek(12L);
                this.dataFile.writeLong(32L);
                this.dataFile.seek(28L);
                this.dataFile.writeInt(0);
            }
            this.initBuffers();
            this.fileModified = false;
            this.freeBlocks = new DataFileBlockManager(this.maxFreeBlocks, this.cacheFileScale, freesize);
            this.database.logger.appLog.logContext(2, "end");
        }
        catch (Throwable e) {
            this.database.logger.appLog.logContext(e, "failed");
            this.close(false);
            throw Trace.error(29, 210, new Object[]{e, this.fileName});
        }
    }

    public void close(boolean write) throws HsqlException {
        SimpleLog appLog = this.database.logger.appLog;
        try {
            boolean empty;
            if (this.cacheReadonly) {
                if (this.dataFile != null) {
                    this.dataFile.close();
                }
                return;
            }
            StopWatch sw = new StopWatch();
            appLog.sendLine(2, "DataFileCache.close(" + write + ") : start");
            if (write) {
                this.cache.saveAll();
                Trace.printSystemOut("saveAll: " + sw.elapsedTime());
                appLog.sendLine(2, "DataFileCache.close() : save data");
                if (this.fileModified || this.freeBlocks.isModified()) {
                    this.dataFile.seek(4L);
                    this.dataFile.writeLong(this.freeBlocks.getLostBlocksSize());
                    this.dataFile.seek(12L);
                    this.dataFile.writeLong(this.fileFreePosition);
                    this.dataFile.seek(28L);
                    int flag = BitMap.set(0, 2);
                    if (this.hasRowInfo) {
                        flag = BitMap.set(flag, 3);
                    }
                    this.dataFile.writeInt(flag);
                    appLog.sendLine(2, "DataFileCache.close() : flags");
                    if (this.dataFile.length() != this.fileFreePosition) {
                        this.dataFile.seek(this.fileFreePosition);
                    }
                    appLog.sendLine(2, "DataFileCache.close() : seek end");
                    Trace.printSystemOut("pos and flags: " + sw.elapsedTime());
                }
            }
            if (this.dataFile != null) {
                this.dataFile.close();
                appLog.sendLine(2, "DataFileCache.close() : close");
                this.dataFile = null;
                Trace.printSystemOut("close: " + sw.elapsedTime());
            }
            boolean bl = empty = this.fileFreePosition == 32L;
            if (empty) {
                this.fa.removeElement(this.fileName);
                this.fa.removeElement(this.backupFileName);
            }
        }
        catch (Throwable e) {
            appLog.logContext(e, null);
            throw Trace.error(29, 211, new Object[]{e, this.fileName});
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null || ((RowOutputBinary)this.rowOut).getBuffer().length > 256) {
            this.rowOut = new RowOutputBinary(256);
        }
        if (this.rowIn == null || ((RowInputBinary)this.rowIn).getBuffer().length > 256) {
            this.rowIn = new RowInputBinary(new byte[256]);
        }
    }

    public void defrag() throws HsqlException {
        if (this.cacheReadonly) {
            return;
        }
        if (this.fileFreePosition == 32L) {
            return;
        }
        this.database.logger.appLog.logContext(2, "start");
        try {
            boolean wasNio = this.dataFile.wasNio();
            this.cache.saveAll();
            DataFileDefrag dfd = new DataFileDefrag(this.database, this, this.fileName);
            dfd.process();
            this.close(false);
            this.deleteFile(wasNio);
            this.renameDataFile();
            this.backupFile();
            this.database.getProperties().setProperty("hsqldb.cache_version", "1.7.0");
            this.database.getProperties().save();
            this.cache.clear();
            this.cache = new Cache(this);
            this.open(this.cacheReadonly);
            dfd.updateTableIndexRoots();
            dfd.updateTransactionRowIDs();
        }
        catch (Throwable e) {
            this.database.logger.appLog.logContext(e, null);
            throw new HsqlException(e, Trace.getMessage(98), 98);
        }
        this.database.logger.appLog.logContext(2, "end");
    }

    public synchronized void remove(int i, PersistentStore store) throws IOException {
        CachedObject r = this.release(i);
        if (r != null) {
            int size = r.getStorageSize();
            this.freeBlocks.add(i, size);
        }
    }

    public synchronized void removePersistence(int i, PersistentStore store) throws IOException {
    }

    private int setFilePos(CachedObject r) throws IOException {
        int i;
        int rowSize = r.getStorageSize();
        int n = i = this.freeBlocks == null ? -1 : this.freeBlocks.get(rowSize);
        if (i == -1) {
            i = (int)(this.fileFreePosition / (long)this.cacheFileScale);
            long newFreePosition = this.fileFreePosition + (long)rowSize;
            if (newFreePosition > this.maxDataFileSize) {
                throw new IOException(Trace.getMessage(225));
            }
            this.fileFreePosition = newFreePosition;
        }
        r.setPos(i);
        return i;
    }

    public synchronized void add(CachedObject object) throws IOException {
        int size = object.getRealSize(this.rowOut);
        size = (size + this.cachedRowPadding - 1) / this.cachedRowPadding * this.cachedRowPadding;
        object.setStorageSize(size);
        int i = this.setFilePos(object);
        this.cache.put(i, object);
        if (this.storeOnInsert) {
            this.saveRow(object);
        }
    }

    public synchronized void restore(CachedObject object) throws IOException {
        int i = object.getPos();
        this.cache.put(i, object);
        if (this.storeOnInsert) {
            this.saveRow(object);
        }
    }

    public synchronized int getStorageSize(int i) throws IOException {
        CachedObject value = this.cache.get(i);
        if (value != null) {
            return value.getStorageSize();
        }
        return this.readSize(i);
    }

    public synchronized CachedObject get(int i, PersistentStore store, boolean keep) throws HsqlException {
        if (i < 0) {
            return null;
        }
        try {
            CachedObject object = this.cache.get(i);
            if (object == null) {
                RowInputInterface rowInput = this.readObject(i);
                if (rowInput == null) {
                    return null;
                }
                object = store.get(rowInput);
                if (object == null) {
                    throw new IOException("cannot build object from file");
                }
                i = object.getPos();
                this.cache.put(i, object);
            }
            if (keep) {
                object.keepInMemory(true);
            }
            return object;
        }
        catch (IOException e) {
            this.database.logger.appLog.logContext(e, this.fileName + " get pos: " + i);
            throw Trace.error(129, 209, new Object[]{e, this.fileName});
        }
    }

    synchronized RowInputInterface getRaw(int i) throws IOException {
        return this.readObject(i);
    }

    protected synchronized int readSize(int pos) throws IOException {
        this.dataFile.seek((long)pos * (long)this.cacheFileScale);
        return this.dataFile.readInt();
    }

    protected synchronized RowInputInterface readObject(int pos) throws IOException {
        this.dataFile.seek((long)pos * (long)this.cacheFileScale);
        int size = this.dataFile.readInt();
        this.rowIn.resetRow(pos, size);
        this.dataFile.read(this.rowIn.getBuffer(), 4, size - 4);
        return this.rowIn;
    }

    public synchronized CachedObject release(int i) {
        return this.cache.release(i);
    }

    protected synchronized void saveRows(CachedObject[] rows, int offset, int count) throws IOException {
        if (count == 0) {
            return;
        }
        try {
            for (int i = offset; i < offset + count; ++i) {
                CachedObject r = rows[i];
                this.saveRow(r);
                rows[i] = null;
            }
        }
        catch (IOException e) {
            this.database.logger.appLog.logContext(e, null);
            throw e;
        }
        catch (Throwable e) {
            this.database.logger.appLog.logContext(e, null);
            throw new IOException(e.toString());
        }
        finally {
            this.initBuffers();
        }
    }

    public synchronized void saveRow(CachedObject row) throws IOException {
        this.setFileModified();
        this.rowOut.reset();
        row.write(this.rowOut);
        this.dataFile.seek((long)row.getPos() * (long)this.cacheFileScale);
        this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
    }

    void backupFile() throws IOException {
        try {
            if (this.fa.isStreamElement(this.fileName)) {
                ZipUnzipFile.compressFile(this.fileName, this.backupFileName + ".new", this.database.getFileAccess());
            }
        }
        catch (IOException e) {
            this.database.logger.appLog.logContext(e, null);
            throw e;
        }
    }

    void renameBackupFile() {
        if (this.fa.isStreamElement(this.backupFileName + ".new")) {
            this.fa.removeElement(this.backupFileName);
            this.fa.renameElement(this.backupFileName + ".new", this.backupFileName);
        }
    }

    void renameDataFile() {
        if (this.fa.isStreamElement(this.fileName + ".new")) {
            this.fa.removeElement(this.fileName);
            this.fa.renameElement(this.fileName + ".new", this.fileName);
        }
    }

    void deleteFile(boolean wasNio) {
        this.fa.removeElement(this.fileName);
        if (this.database.isStoredFileAccess()) {
            return;
        }
        if (this.fa.isStreamElement(this.fileName)) {
            if (wasNio) {
                System.gc();
                this.fa.removeElement(this.fileName);
            }
            if (this.fa.isStreamElement(this.fileName)) {
                this.fa.renameElement(this.fileName, this.fileName + ".old");
                File oldfile = new File(this.fileName + ".old");
                FileUtil.getDefaultInstance().deleteOnExit(oldfile);
            }
        }
    }

    void deleteBackup() {
        this.fa.removeElement(this.backupFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteOrResetFreePos(Database database, String filename) {
        ScaledRAFile raFile = null;
        database.getFileAccess().removeElement(filename);
        if (database.isStoredFileAccess()) {
            return;
        }
        if (!database.getFileAccess().isStreamElement(filename)) {
            return;
        }
        try {
            raFile = new ScaledRAFile(database, filename, false);
            raFile.seek(12L);
            raFile.writeLong(32L);
        }
        catch (IOException e) {
            database.logger.appLog.logContext(e, null);
        }
        finally {
            if (raFile != null) {
                try {
                    raFile.close();
                }
                catch (IOException e) {
                    database.logger.appLog.logContext(e, null);
                }
            }
        }
    }

    public int capacity() {
        return this.maxCacheSize;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public int getFreeBlockCount() {
        return this.freeBlocks.size();
    }

    public int getTotalFreeBlockSize() {
        return 0;
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    protected synchronized void setFileModified() throws IOException {
        if (!this.fileModified) {
            this.fileModified = true;
        }
    }
}

