/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.java.JavaSystem;

public class HsqlProperties {
    public static final int NO_VALUE_FOR_KEY = 1;
    protected String fileName;
    protected Properties stringProps;
    protected int[] errorCodes = new int[0];
    protected String[] errorKeys = new String[0];
    protected boolean resource = false;
    protected FileAccess fa;

    public HsqlProperties() {
        this.stringProps = new Properties();
        this.fileName = null;
    }

    public HsqlProperties(String name) {
        this.stringProps = new Properties();
        this.fileName = name;
        this.fa = FileUtil.getDefaultInstance();
    }

    public HsqlProperties(String name, FileAccess accessor, boolean b) {
        this.stringProps = new Properties();
        this.fileName = name;
        this.resource = b;
        this.fa = accessor;
    }

    public HsqlProperties(Properties props) {
        this.stringProps = props;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String setProperty(String key, int value) {
        return this.setProperty(key, Integer.toString(value));
    }

    public String setProperty(String key, boolean value) {
        return this.setProperty(key, String.valueOf(value));
    }

    public String setProperty(String key, String value) {
        return (String)this.stringProps.put(key, value);
    }

    public String setPropertyIfNotExists(String key, String value) {
        value = this.getProperty(key, value);
        return this.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.stringProps;
    }

    public String getProperty(String key) {
        return this.stringProps.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.stringProps.getProperty(key, defaultValue);
    }

    public int getIntegerProperty(String key, int defaultValue) {
        String prop = this.getProperty(key);
        try {
            if (prop != null) {
                defaultValue = Integer.parseInt(prop);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return defaultValue;
    }

    public int getIntegerProperty(String key, int defaultValue, int minimum, int maximum) {
        String prop = this.getProperty(key);
        boolean badvalue = false;
        try {
            defaultValue = Integer.parseInt(prop);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (defaultValue < minimum) {
            defaultValue = minimum;
            badvalue = true;
        } else if (defaultValue > maximum) {
            defaultValue = maximum;
            badvalue = true;
        }
        return defaultValue;
    }

    public int getIntegerProperty(String key, int defaultValue, int[] values) {
        String prop = this.getProperty(key);
        int value = defaultValue;
        try {
            if (prop != null) {
                value = Integer.parseInt(prop);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (ArrayUtil.find(values, value) == -1) {
            return defaultValue;
        }
        return value;
    }

    public boolean isPropertyTrue(String key) {
        return this.isPropertyTrue(key, false);
    }

    public boolean isPropertyTrue(String key, boolean defaultValue) {
        String value = this.stringProps.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toLowerCase().equals("true");
    }

    public void removeProperty(String key) {
        this.stringProps.remove(key);
    }

    public void addProperties(Properties props) {
        if (props == null) {
            return;
        }
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this.stringProps.put(key, props.get(key));
        }
    }

    public void addProperties(HsqlProperties props) {
        if (props == null) {
            return;
        }
        this.addProperties(props.stringProps);
    }

    public boolean checkFileExists() throws IOException {
        String propFilename = this.fileName + ".properties";
        return this.fa.isStreamElement(propFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() throws Exception {
        if (!this.checkFileExists()) {
            return false;
        }
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException(Trace.getMessage(135));
        }
        InputStream fis = null;
        String propsFilename = this.fileName + ".properties";
        try {
            fis = this.resource ? this.getClass().getResourceAsStream(propsFilename) : this.fa.openInputStreamElement(propsFilename);
            this.stringProps.load(fis);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return true;
    }

    public void save() throws Exception {
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException(Trace.getMessage(135));
        }
        String filestring = this.fileName + ".properties";
        this.save(filestring);
    }

    public void save(String fileString) throws Exception {
        this.fa.createParentDirs(fileString);
        OutputStream fos = this.fa.openOutputStreamElement(fileString);
        FileAccess.FileSync outDescriptor = this.fa.getFileSync(fos);
        JavaSystem.saveProperties(this.stringProps, "HSQL Database Engine 1.8.0.10", fos);
        fos.flush();
        outDescriptor.sync();
        fos.close();
    }

    private void addError(int code, String key) {
        this.errorCodes = (int[])ArrayUtil.resizeArray(this.errorCodes, this.errorCodes.length + 1);
        this.errorKeys = (String[])ArrayUtil.resizeArray(this.errorKeys, this.errorKeys.length + 1);
        this.errorCodes[this.errorCodes.length - 1] = code;
        this.errorKeys[this.errorKeys.length - 1] = key;
    }

    public static HsqlProperties argArrayToProps(String[] arg, String type) {
        HsqlProperties props = new HsqlProperties();
        for (int i = 0; i < arg.length; ++i) {
            String p = arg[i];
            if (p.startsWith("-?")) {
                props.addError(1, p.substring(1));
                continue;
            }
            if (p.charAt(0) != '-') continue;
            String value = i + 1 < arg.length ? arg[i + 1] : "";
            props.setProperty(type + "." + p.substring(1), value);
            ++i;
        }
        return props;
    }

    public static HsqlProperties delimitedArgPairsToProps(String s, String pairsep, String dlimiter, String type) {
        HsqlProperties props = new HsqlProperties();
        int currentpair = 0;
        while (true) {
            int valindex;
            int nextpair;
            if ((nextpair = s.indexOf(dlimiter, currentpair)) == -1) {
                nextpair = s.length();
            }
            if ((valindex = s.substring(0, nextpair).indexOf(pairsep, currentpair)) == -1) {
                props.addError(1, s.substring(currentpair, nextpair).trim());
            } else {
                String key = s.substring(currentpair, valindex).trim();
                String value = s.substring(valindex + pairsep.length(), nextpair).trim();
                if (type != null) {
                    key = type + "." + key;
                }
                props.setProperty(key, value);
            }
            if (nextpair == s.length()) break;
            currentpair = nextpair + dlimiter.length();
        }
        return props;
    }

    public Enumeration propertyNames() {
        return this.stringProps.propertyNames();
    }

    public boolean isEmpty() {
        return this.stringProps.isEmpty();
    }

    public String[] getErrorKeys() {
        return this.errorKeys;
    }
}

