/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

public class BitMap {
    int defaultCapacity;
    int capacity;
    int[] map;

    public BitMap(int initialCapacity) {
        int words = initialCapacity / 32;
        if (initialCapacity % 32 != 0) {
            ++words;
        }
        this.defaultCapacity = this.capacity = words * 32;
        this.map = new int[words];
    }

    public void reset() {
        this.map = new int[this.defaultCapacity / 32];
        this.capacity = this.defaultCapacity;
    }

    public int set(int pos) {
        while (pos >= this.capacity) {
            this.doubleCapacity();
        }
        int windex = pos >> 5;
        int word = this.map[windex];
        int mask = Integer.MIN_VALUE >>> (pos & 0x1F);
        int result = (word & mask) == 0 ? 0 : 1;
        this.map[windex] = word | mask;
        return result;
    }

    public int unset(int pos) {
        if (pos >= this.capacity) {
            return 0;
        }
        int windex = pos >> 5;
        int word = this.map[windex];
        int mask = Integer.MIN_VALUE >>> (pos & 0x1F);
        int result = (word & mask) == 0 ? 0 : 1;
        this.map[windex] = word & (mask ^= 0xFFFFFFFF);
        return result;
    }

    public int get(int pos) {
        while (pos >= this.capacity) {
            this.doubleCapacity();
        }
        int windex = pos >> 5;
        int word = this.map[windex];
        int mask = Integer.MIN_VALUE >>> (pos & 0x1F);
        return (word & mask) == 0 ? 0 : 1;
    }

    public static int set(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return map | mask;
    }

    public static int unset(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return map & (mask ^= 0xFFFFFFFF);
    }

    public static boolean isSet(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return (map & mask) != 0;
    }

    private void doubleCapacity() {
        int[] newmap = new int[this.map.length * 2];
        this.capacity *= 2;
        System.arraycopy(this.map, 0, newmap, 0, this.map.length);
        this.map = newmap;
    }
}

