/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.browse;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;

public class DialogFactory {
    private static DialogFactory factory;
    private XComponentContext xComponentContext;

    private DialogFactory(XComponentContext xComponentContext) {
        this.xComponentContext = xComponentContext;
        factory = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createDialogFactory(XComponentContext xComponentContext) {
        if (factory != null) return;
        Class<DialogFactory> clazz = DialogFactory.class;
        synchronized (DialogFactory.class) {
            if (factory != null) return;
            factory = new DialogFactory(xComponentContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static DialogFactory getDialogFactory() throws Exception {
        if (factory == null) {
            throw new Exception("DialogFactory not initialized");
        }
        return factory;
    }

    public boolean showConfirmDialog(String title, String prompt) {
        XDialog xDialog;
        try {
            xDialog = this.createConfirmDialog(title, prompt);
        }
        catch (com.sun.star.uno.Exception e) {
            return false;
        }
        XControlContainer controls = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)xDialog);
        XButton okButton = (XButton)UnoRuntime.queryInterface(XButton.class, (Object)controls.getControl("Ok"));
        okButton.setActionCommand("Ok");
        XButton cancelButton = (XButton)UnoRuntime.queryInterface(XButton.class, (Object)controls.getControl("Cancel"));
        cancelButton.setActionCommand("Cancel");
        final ResultHolder resultHolder = new ResultHolder();
        XActionListener listener = new XActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.ActionCommand.equals("Cancel")) {
                    resultHolder.setResult(Boolean.FALSE);
                    xDialog.endExecute();
                } else {
                    resultHolder.setResult(Boolean.TRUE);
                    xDialog.endExecute();
                }
            }

            public void disposing(EventObject o) {
            }
        };
        okButton.addActionListener(listener);
        cancelButton.addActionListener(listener);
        xDialog.execute();
        Boolean result = (Boolean)resultHolder.getResult();
        return result == null ? false : result;
    }

    public String showInputDialog(String title, String prompt) {
        XDialog xDialog;
        try {
            xDialog = this.createInputDialog(title, prompt);
        }
        catch (com.sun.star.uno.Exception e) {
            return null;
        }
        XControlContainer controls = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)xDialog);
        XButton okButton = (XButton)UnoRuntime.queryInterface(XButton.class, (Object)controls.getControl("Ok"));
        okButton.setActionCommand("Ok");
        XButton cancelButton = (XButton)UnoRuntime.queryInterface(XButton.class, (Object)controls.getControl("Cancel"));
        cancelButton.setActionCommand("Cancel");
        final XTextComponent textField = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)controls.getControl("NameField"));
        final ResultHolder resultHolder = new ResultHolder();
        XActionListener listener = new XActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.ActionCommand.equals("Cancel")) {
                    resultHolder.setResult(null);
                    xDialog.endExecute();
                } else {
                    resultHolder.setResult(textField.getText());
                    xDialog.endExecute();
                }
            }

            public void disposing(EventObject o) {
            }
        };
        okButton.addActionListener(listener);
        cancelButton.addActionListener(listener);
        xDialog.execute();
        return (String)resultHolder.getResult();
    }

    private XDialog createConfirmDialog(String title, String prompt) throws com.sun.star.uno.Exception {
        if (title == null || title.equals("")) {
            title = "Scripting Framework";
        }
        if (prompt == null || prompt.equals("")) {
            prompt = "Enter name";
        }
        XMultiComponentFactory xMultiComponentFactory = this.xComponentContext.getServiceManager();
        Object dialogModel = xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.UnoControlDialogModel", this.xComponentContext);
        XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)dialogModel);
        props.setPropertyValue("Title", (Object)title);
        this.setDimensions(dialogModel, 100, 100, 157, 37);
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)dialogModel);
        Object label = xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlFixedTextModel");
        this.setDimensions(label, 15, 5, 134, 12);
        XPropertySet labelProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)label);
        labelProps.setPropertyValue("Name", (Object)"PromptLabel");
        labelProps.setPropertyValue("Label", (Object)prompt);
        Object okButtonModel = xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlButtonModel");
        this.setDimensions(okButtonModel, 40, 18, 38, 15);
        XPropertySet buttonProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)okButtonModel);
        buttonProps.setPropertyValue("Name", (Object)"Ok");
        buttonProps.setPropertyValue("Label", (Object)"Ok");
        Object cancelButtonModel = xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlButtonModel");
        this.setDimensions(cancelButtonModel, 83, 18, 38, 15);
        buttonProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)cancelButtonModel);
        buttonProps.setPropertyValue("Name", (Object)"Cancel");
        buttonProps.setPropertyValue("Label", (Object)"Cancel");
        XNameContainer xNameCont = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)dialogModel);
        xNameCont.insertByName("PromptLabel", label);
        xNameCont.insertByName("Ok", okButtonModel);
        xNameCont.insertByName("Cancel", cancelButtonModel);
        Object dialog = xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.UnoControlDialog", this.xComponentContext);
        XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)dialog);
        XControlModel xControlModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, (Object)dialogModel);
        xControl.setModel(xControlModel);
        Object toolkit = xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.ExtToolkit", this.xComponentContext);
        XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)toolkit);
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xControl);
        xWindow.setVisible(false);
        xControl.createPeer(xToolkit, null);
        return (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)dialog);
    }

    private void setDimensions(Object o, int x, int y, int width, int height) throws com.sun.star.uno.Exception {
        XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)o);
        props.setPropertyValue("PositionX", (Object)new Integer(x));
        props.setPropertyValue("PositionY", (Object)new Integer(y));
        props.setPropertyValue("Height", (Object)new Integer(height));
        props.setPropertyValue("Width", (Object)new Integer(width));
    }

    private XDialog createInputDialog(String title, String prompt) throws com.sun.star.uno.Exception {
        if (title == null || title.equals("")) {
            title = "Scripting Framework";
        }
        if (prompt == null || prompt.equals("")) {
            prompt = "Enter name";
        }
        XMultiComponentFactory xMultiComponentFactory = this.xComponentContext.getServiceManager();
        Object dialogModel = xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.UnoControlDialogModel", this.xComponentContext);
        this.setDimensions(dialogModel, 100, 100, 157, 58);
        XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)dialogModel);
        props.setPropertyValue("Title", (Object)title);
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)dialogModel);
        Object label = xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlFixedTextModel");
        this.setDimensions(label, 15, 5, 134, 12);
        XPropertySet labelProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)label);
        labelProps.setPropertyValue("Name", (Object)"PromptLabel");
        labelProps.setPropertyValue("Label", (Object)prompt);
        Object edit = xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlEditModel");
        this.setDimensions(edit, 15, 18, 134, 12);
        XPropertySet editProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)edit);
        editProps.setPropertyValue("Name", (Object)"NameField");
        Object okButtonModel = xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlButtonModel");
        this.setDimensions(okButtonModel, 40, 39, 38, 15);
        XPropertySet buttonProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)okButtonModel);
        buttonProps.setPropertyValue("Name", (Object)"Ok");
        buttonProps.setPropertyValue("Label", (Object)"Ok");
        Object cancelButtonModel = xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlButtonModel");
        this.setDimensions(cancelButtonModel, 83, 39, 38, 15);
        buttonProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)cancelButtonModel);
        buttonProps.setPropertyValue("Name", (Object)"Cancel");
        buttonProps.setPropertyValue("Label", (Object)"Cancel");
        XNameContainer xNameCont = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)dialogModel);
        xNameCont.insertByName("PromptLabel", label);
        xNameCont.insertByName("NameField", edit);
        xNameCont.insertByName("Ok", okButtonModel);
        xNameCont.insertByName("Cancel", cancelButtonModel);
        Object dialog = xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.UnoControlDialog", this.xComponentContext);
        XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)dialog);
        XControlModel xControlModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, (Object)dialogModel);
        xControl.setModel(xControlModel);
        Object toolkit = xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.ExtToolkit", this.xComponentContext);
        XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)toolkit);
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xControl);
        xWindow.setVisible(false);
        xControl.createPeer(xToolkit, null);
        return (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)dialog);
    }

    private static class ResultHolder {
        private Object result = null;

        private ResultHolder() {
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = result;
        }
    }
}

