/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.browse;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XIntrospectionAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.PropertySet;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.CannotConvertException;
import com.sun.star.script.XInvocation;
import com.sun.star.script.browse.XBrowseNode;
import com.sun.star.script.framework.browse.DialogFactory;
import com.sun.star.script.framework.browse.ParcelBrowseNode;
import com.sun.star.script.framework.browse.PkgProviderBrowseNode;
import com.sun.star.script.framework.container.Parcel;
import com.sun.star.script.framework.container.ParcelContainer;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ScriptProvider;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;

public class ProviderBrowseNode
extends PropertySet
implements XBrowseNode,
XInvocation {
    protected ScriptProvider provider;
    protected Collection<XBrowseNode> browsenodes;
    protected String name;
    protected ParcelContainer container;
    protected Parcel parcel;
    protected XComponentContext m_xCtx;
    public boolean deletable = true;
    public boolean creatable = true;
    public boolean editable = false;

    public ProviderBrowseNode(ScriptProvider provider, ParcelContainer container, XComponentContext xCtx) {
        LogUtils.DEBUG("*** ProviderBrowseNode ctor");
        this.container = container;
        this.name = this.container.getLanguage();
        this.provider = provider;
        this.m_xCtx = xCtx;
        this.registerProperty("Deletable", new Type(Boolean.TYPE), (short)0, "deletable");
        this.registerProperty("Creatable", new Type(Boolean.TYPE), (short)0, "creatable");
        this.registerProperty("Editable", new Type(Boolean.TYPE), (short)0, "editable");
        XSimpleFileAccess xSFA = null;
        XMultiComponentFactory xFac = this.m_xCtx.getServiceManager();
        try {
            xSFA = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xFac.createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", xCtx));
            if (container.isUnoPkg() || xSFA.isReadOnly(container.getParcelContainerDir())) {
                this.deletable = false;
                this.creatable = false;
            }
        }
        catch (com.sun.star.uno.Exception e) {
            LogUtils.DEBUG("Caught exception in creation of ProviderBrowseNode ");
            LogUtils.DEBUG(LogUtils.getTrace((Exception)((Object)e)));
        }
    }

    public String getName() {
        return this.name;
    }

    public XBrowseNode[] getChildNodes() {
        LogUtils.DEBUG("***** ProviderBrowseNode.getChildNodes()");
        if (this.hasChildNodes()) {
            LogUtils.DEBUG("** ProviderBrowseNode.getChildNodes(), container is " + this.container);
            String[] parcels = this.container.getElementNames();
            this.browsenodes = new ArrayList<XBrowseNode>(parcels.length);
            for (int index = 0; index < parcels.length; ++index) {
                try {
                    ParcelBrowseNode node = new ParcelBrowseNode(this.provider, this.container, parcels[index]);
                    this.browsenodes.add(node);
                    continue;
                }
                catch (Exception e) {
                    LogUtils.DEBUG("*** Failed to create parcel node for " + parcels[index]);
                    LogUtils.DEBUG(e.toString());
                }
            }
            ParcelContainer[] packageContainers = this.container.getChildContainers();
            LogUtils.DEBUG("**** For container named " + this.container.getName() + " with root path " + this.container.getParcelContainerDir() + " has " + packageContainers.length + " child containers ");
            for (int i = 0; i < packageContainers.length; ++i) {
                PkgProviderBrowseNode node = new PkgProviderBrowseNode(this.provider, packageContainers[i], this.m_xCtx);
                this.browsenodes.add(node);
            }
        } else {
            LogUtils.DEBUG("*** No container available");
            return new XBrowseNode[0];
        }
        return this.browsenodes.toArray(new XBrowseNode[this.browsenodes.size()]);
    }

    public boolean hasChildNodes() {
        boolean result = true;
        if (this.container == null || !this.container.hasElements() && this.container.getChildContainers().length == 0) {
            result = false;
        }
        LogUtils.DEBUG("***** ProviderBrowseNode.hasChildNodes(): name=" + this.name + ", path=" + this.container.getParcelContainerDir() + ", result=" + result);
        return result;
    }

    public short getType() {
        return 1;
    }

    public String toString() {
        return this.getName();
    }

    public XIntrospectionAccess getIntrospection() {
        return null;
    }

    public Object invoke(String aFunctionName, Object[] aParams, short[][] aOutParamIndex, Object[][] aOutParam) throws IllegalArgumentException, CannotConvertException, InvocationTargetException {
        Any result;
        block11: {
            aOutParamIndex[0] = new short[0];
            aOutParam[0] = new Object[0];
            result = new Any(new Type(Boolean.class), (Object)Boolean.TRUE);
            if (aFunctionName.equals("Creatable")) {
                try {
                    String name;
                    if (aParams == null || aParams.length < 1 || !AnyConverter.isString((Object)aParams[0])) {
                        String prompt = "Enter name for new Parcel";
                        String title = "Create Parcel";
                        try {
                            DialogFactory dialogFactory = DialogFactory.getDialogFactory();
                            name = dialogFactory.showInputDialog(title, prompt);
                        }
                        catch (Exception e) {
                            name = JOptionPane.showInputDialog(null, prompt, title, 3);
                        }
                    } else {
                        name = AnyConverter.toString((Object)aParams[0]);
                    }
                    if (name == null || name.equals("")) {
                        result = new Any(new Type(Boolean.class), (Object)Boolean.FALSE);
                        break block11;
                    }
                    XNameContainer newParcel = this.container.createParcel(name);
                    LogUtils.DEBUG("Parcel created " + name + " " + newParcel);
                    if (newParcel == null) {
                        result = new Any(new Type(Boolean.class), (Object)Boolean.FALSE);
                        break block11;
                    }
                    ParcelBrowseNode parcel = new ParcelBrowseNode(this.provider, this.container, name);
                    LogUtils.DEBUG("created parcel node ");
                    if (this.browsenodes == null) {
                        this.browsenodes = new ArrayList<XBrowseNode>(5);
                    }
                    this.browsenodes.add(parcel);
                    result = new Any(new Type(XBrowseNode.class), (Object)parcel);
                }
                catch (Exception e) {
                    LogUtils.DEBUG("ProviderBrowseNode[create] failed with: " + e);
                    LogUtils.DEBUG(LogUtils.getTrace(e));
                    result = new Any(new Type(Boolean.class), (Object)Boolean.FALSE);
                }
            } else {
                throw new IllegalArgumentException("Function " + aFunctionName + " not supported.");
            }
        }
        return result;
    }

    public void setValue(String aPropertyName, Object aValue) throws UnknownPropertyException, CannotConvertException, InvocationTargetException {
    }

    public Object getValue(String aPropertyName) throws UnknownPropertyException {
        return null;
    }

    public boolean hasMethod(String aName) {
        return false;
    }

    public boolean hasProperty(String aName) {
        return false;
    }
}

