/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.script.framework.container.XMLParserFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DeployedUnoPackagesDB {
    private static final String PARCEL_DESCRIPTOR_NAME = "unopkg-desc.xml";
    private static final byte[] EMPTY_DOCUMENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<unopackages xmlns:unopackages=\"unopackages.dtd\">\n</unopackages>".getBytes();
    private File file = null;
    private Document document = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployedUnoPackagesDB() throws IOException {
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(EMPTY_DOCUMENT);
            this.document = XMLParserFactory.getParser().parse(bis);
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    public DeployedUnoPackagesDB(Document document) {
        this.document = document;
    }

    public DeployedUnoPackagesDB(InputStream is) throws IOException {
        this(XMLParserFactory.getParser().parse(is));
    }

    public String[] getDeployedPackages(String language) {
        ArrayList<String> packageUrls = new ArrayList<String>(4);
        Element main = this.document.getDocumentElement();
        Element root = null;
        int len = 0;
        NodeList langNodes = null;
        langNodes = main.getElementsByTagName("language");
        if (langNodes != null && (len = langNodes.getLength()) != 0) {
            for (int i = 0; i < len; ++i) {
                Element e = (Element)langNodes.item(i);
                if (!e.getAttribute("value").equals(language)) continue;
                root = e;
                break;
            }
        }
        if (root != null) {
            len = 0;
            NodeList packages = null;
            packages = root.getElementsByTagName("package");
            if (packages != null && (len = packages.getLength()) != 0) {
                for (int i = 0; i < len; ++i) {
                    Element e = (Element)packages.item(i);
                    packageUrls.add(e.getAttribute("value"));
                }
            }
        }
        if (!packageUrls.isEmpty()) {
            return packageUrls.toArray(new String[packageUrls.size()]);
        }
        return new String[0];
    }

    public void write(OutputStream out) throws IOException {
        XMLParserFactory.getParser().write(this.document, out);
    }

    public Document getDocument() {
        return this.document;
    }

    private void clearEntries() {
        int len;
        Element main = this.document.getDocumentElement();
        NodeList langNodes = this.document.getElementsByTagName("language");
        if (langNodes != null && (len = langNodes.getLength()) != 0) {
            for (int i = len - 1; i >= 0; --i) {
                try {
                    main.removeChild(langNodes.item(i));
                    continue;
                }
                catch (DOMException de) {
                    // empty catch block
                }
            }
        }
    }

    public boolean removePackage(String language, String url) {
        Element main = this.document.getDocumentElement();
        Element langNode = null;
        int len = 0;
        NodeList langNodes = null;
        boolean result = false;
        langNodes = main.getElementsByTagName("language");
        if (langNodes != null && (len = langNodes.getLength()) != 0) {
            for (int i = 0; i < len; ++i) {
                Element e = (Element)langNodes.item(i);
                if (!e.getAttribute("value").equals(language)) continue;
                langNode = e;
                break;
            }
        }
        if (langNode != null) {
            len = 0;
            NodeList packages = null;
            packages = langNode.getElementsByTagName("package");
            if (packages != null && (len = packages.getLength()) != 0) {
                for (int i = 0; i < len; ++i) {
                    Element e = (Element)packages.item(i);
                    String value = e.getAttribute("value");
                    if (!value.equals(url)) continue;
                    langNode.removeChild(e);
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public void addPackage(String language, String url) {
        Element main = this.document.getDocumentElement();
        Element langNode = null;
        Element pkgNode = null;
        int len = 0;
        NodeList langNodes = null;
        langNodes = this.document.getElementsByTagName("language");
        if (langNodes != null && (len = langNodes.getLength()) != 0) {
            for (int i = 0; i < len; ++i) {
                Element e = (Element)langNodes.item(i);
                if (!e.getAttribute("value").equals(language)) continue;
                langNode = e;
                break;
            }
        }
        if (langNode == null) {
            langNode = this.document.createElement("language");
            langNode.setAttribute("value", language);
        }
        pkgNode = this.document.createElement("package");
        pkgNode.setAttribute("value", url);
        langNode.appendChild(pkgNode);
        main.appendChild(langNode);
    }
}

