/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.script.framework.container.ScriptEntry;
import com.sun.star.script.framework.container.XMLParserFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParcelDescriptor {
    public static final String PARCEL_DESCRIPTOR_NAME = "parcel-descriptor.xml";
    private static final Map<File, ParcelDescriptor> PARCEL_DESCRIPTOR_MAP = new HashMap<File, ParcelDescriptor>(5);
    private static final byte[] EMPTY_DOCUMENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<parcel xmlns:parcel=\"scripting.dtd\" language=\"Java\">\n</parcel>".getBytes();
    private File file = null;
    private Document document = null;
    private String language = null;
    private Map<String, String> languagedepprops = new HashMap<String, String>(3);

    public static synchronized void removeParcelDescriptor(File parent) {
        File path = new File(parent, PARCEL_DESCRIPTOR_NAME);
        PARCEL_DESCRIPTOR_MAP.remove(path);
    }

    public static synchronized void renameParcelDescriptor(File oldFile, File newFile) {
        File oldPath = new File(oldFile, PARCEL_DESCRIPTOR_NAME);
        ParcelDescriptor pd = PARCEL_DESCRIPTOR_MAP.get(oldPath);
        if (pd != null) {
            File newPath;
            PARCEL_DESCRIPTOR_MAP.remove(oldPath);
            pd.file = newPath = new File(newFile, PARCEL_DESCRIPTOR_NAME);
            PARCEL_DESCRIPTOR_MAP.put(newPath, pd);
        }
    }

    public static synchronized ParcelDescriptor getParcelDescriptor(File parent) {
        File path = new File(parent, PARCEL_DESCRIPTOR_NAME);
        ParcelDescriptor pd = PARCEL_DESCRIPTOR_MAP.get(path);
        if (pd == null && path.exists()) {
            try {
                pd = new ParcelDescriptor(path);
            }
            catch (IOException ioe) {
                return null;
            }
            PARCEL_DESCRIPTOR_MAP.put(path, pd);
        }
        return pd;
    }

    public static synchronized ParcelDescriptor createParcelDescriptor(File parent) throws IOException {
        ParcelDescriptor pd = ParcelDescriptor.getParcelDescriptor(parent);
        if (pd == null) {
            if (parent == null || !parent.exists() || !parent.isDirectory()) {
                throw new IOException("Cannot create Parcel Descriptor");
            }
            File path = new File(parent, PARCEL_DESCRIPTOR_NAME);
            pd = new ParcelDescriptor(path);
            PARCEL_DESCRIPTOR_MAP.put(path, pd);
        }
        return pd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelDescriptor() throws IOException {
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(EMPTY_DOCUMENT);
            this.document = XMLParserFactory.getParser().parse(bis);
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    public ParcelDescriptor(Document document) {
        this.document = document;
        this.initLanguageProperties();
    }

    public ParcelDescriptor(InputStream is) throws IOException {
        this(XMLParserFactory.getParser().parse(is));
    }

    public ParcelDescriptor(File file) throws IOException {
        this(file, "Java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelDescriptor(File file, String language) throws IOException {
        this.file = file;
        if (file.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                this.document = XMLParserFactory.getParser().parse(fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(EMPTY_DOCUMENT);
            this.document = XMLParserFactory.getParser().parse(bis);
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
        this.setLanguage(language);
        this.initLanguageProperties();
    }

    public void write(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        XMLParserFactory.getParser().write(this.document, fos);
        fos.close();
    }

    public void write() throws IOException {
        if (this.file == null) {
            throw new FileNotFoundException("No file specified");
        }
        this.write(this.file);
    }

    public void write(OutputStream out) throws IOException {
        XMLParserFactory.getParser().write(this.document, out);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getLanguage() {
        if (this.language == null && this.document != null) {
            Element e = this.document.getDocumentElement();
            this.language = e.getAttribute("language");
        }
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
        if (this.document != null) {
            try {
                Element e = this.document.getDocumentElement();
                e.setAttribute("language", language);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
    }

    public ScriptEntry[] getScriptEntries() {
        int len;
        NodeList scriptNodes;
        ArrayList<ScriptEntry> scripts = new ArrayList<ScriptEntry>();
        if (this.document == null || (scriptNodes = this.document.getElementsByTagName("script")) == null || (len = scriptNodes.getLength()) == 0) {
            return new ScriptEntry[0];
        }
        for (int i = 0; i < len; ++i) {
            NodeList props;
            String languagename;
            Element tmp;
            String logicalname;
            String description = "";
            HashMap<String, String> langProps = new HashMap<String, String>();
            Element scriptElement = (Element)scriptNodes.item(i);
            String language = scriptElement.getAttribute("language");
            NodeList nl = scriptElement.getElementsByTagName("logicalname");
            if (nl == null) {
                logicalname = "";
            } else {
                tmp = (Element)nl.item(0);
                logicalname = tmp.getAttribute("value");
            }
            nl = scriptElement.getElementsByTagName("locale");
            if (nl != null && (nl = nl.item(0).getChildNodes()) != null) {
                for (int j = 0; j < nl.getLength(); ++j) {
                    if (!nl.item(j).getNodeName().equals("description")) continue;
                    CharacterData cd = (CharacterData)nl.item(j).getFirstChild();
                    description = cd.getData().trim();
                }
            }
            if ((nl = scriptElement.getElementsByTagName("functionname")) == null) {
                languagename = "";
            } else {
                tmp = (Element)nl.item(0);
                languagename = tmp.getAttribute("value");
            }
            nl = scriptElement.getElementsByTagName("languagedepprops");
            if (nl != null && nl.getLength() > 0 && (props = ((Element)nl.item(0)).getElementsByTagName("prop")) != null) {
                for (int j = 0; j < props.getLength(); ++j) {
                    tmp = (Element)props.item(j);
                    String key = tmp.getAttribute("name");
                    String val = tmp.getAttribute("value");
                    langProps.put(key, val);
                }
            }
            ScriptEntry entry = new ScriptEntry(language, languagename, logicalname, "", langProps, description);
            scripts.add(entry);
        }
        return scripts.toArray(new ScriptEntry[scripts.size()]);
    }

    public void setScriptEntries(ScriptEntry[] scripts) {
        this.clearEntries();
        for (int i = 0; i < scripts.length; ++i) {
            this.addScriptEntry(scripts[i]);
        }
    }

    public void setScriptEntries(Iterator<ScriptEntry> scripts) {
        this.clearEntries();
        while (scripts.hasNext()) {
            this.addScriptEntry(scripts.next());
        }
    }

    public String getLanguageProperty(String name) {
        return this.languagedepprops.get(name);
    }

    public void setLanguageProperty(String name, String value) {
        this.languagedepprops.put(name, value);
        this.setScriptEntries(this.getScriptEntries());
    }

    private void initLanguageProperties() {
        int len;
        NodeList nl = this.document.getElementsByTagName("languagedepprops");
        if (nl != null && (len = nl.getLength()) != 0) {
            for (int i = 0; i < len; ++i) {
                int len2;
                Element e = (Element)nl.item(i);
                NodeList nl2 = e.getElementsByTagName("prop");
                if (nl2 == null || (len2 = nl2.getLength()) == 0) continue;
                for (int j = 0; j < len2; ++j) {
                    Element e2 = (Element)nl2.item(j);
                    String name = e2.getAttribute("name");
                    String value = e2.getAttribute("value");
                    if (this.getLanguageProperty(name) != null) continue;
                    this.languagedepprops.put(name, value);
                }
            }
        }
    }

    private void clearEntries() {
        int len;
        Element main = this.document.getDocumentElement();
        NodeList scriptNodes = this.document.getElementsByTagName("script");
        if (scriptNodes != null && (len = scriptNodes.getLength()) != 0) {
            for (int i = len - 1; i >= 0; --i) {
                try {
                    main.removeChild(scriptNodes.item(i));
                    continue;
                }
                catch (DOMException de) {
                    // empty catch block
                }
            }
        }
    }

    public void removeScriptEntry(ScriptEntry script) {
        int len;
        Element main = this.document.getDocumentElement();
        NodeList scriptNodes = this.document.getElementsByTagName("script");
        if (scriptNodes != null && (len = scriptNodes.getLength()) != 0) {
            for (int i = len - 1; i >= 0; --i) {
                try {
                    Element tmp;
                    Element scriptElement = (Element)scriptNodes.item(i);
                    String languagename = "";
                    NodeList nl = scriptElement.getElementsByTagName("functionname");
                    if (nl == null || !(languagename = (tmp = (Element)nl.item(0)).getAttribute("value")).equals(script.getLanguageName())) continue;
                    main.removeChild(scriptElement);
                    continue;
                }
                catch (DOMException de) {
                    // empty catch block
                }
            }
        }
    }

    public void addScriptEntry(ScriptEntry script) {
        Element main = this.document.getDocumentElement();
        Element root = this.document.createElement("script");
        root.setAttribute("language", script.getLanguage());
        Element item = this.document.createElement("locale");
        item.setAttribute("lang", "en");
        Element tempitem = this.document.createElement("displayname");
        tempitem.setAttribute("value", script.getLogicalName());
        item.appendChild(tempitem);
        tempitem = this.document.createElement("description");
        String description = script.getDescription();
        if (description == null || description.equals("")) {
            description = script.getLogicalName();
        }
        tempitem.appendChild(this.document.createTextNode(description));
        item.appendChild(tempitem);
        root.appendChild(item);
        item = this.document.createElement("logicalname");
        item.setAttribute("value", script.getLogicalName());
        root.appendChild(item);
        item = this.document.createElement("functionname");
        item.setAttribute("value", script.getLanguageName());
        root.appendChild(item);
        if (this.languagedepprops != null && this.languagedepprops.size() != 0) {
            item = this.document.createElement("languagedepprops");
            Iterator<String> iter = this.languagedepprops.keySet().iterator();
            while (iter.hasNext()) {
                tempitem = this.document.createElement("prop");
                String key = iter.next();
                tempitem.setAttribute("name", key);
                tempitem.setAttribute("value", this.languagedepprops.get(key));
                item.appendChild(tempitem);
            }
            root.appendChild(item);
        }
        main.appendChild(root);
    }
}

