/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.script.framework.container.XMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLParserFactory {
    private static XMLParser parser = null;
    private static String officedtdurl = null;

    private XMLParserFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XMLParser getParser() {
        if (parser != null) return parser;
        Class<XMLParserFactory> clazz = XMLParserFactory.class;
        synchronized (XMLParserFactory.class) {
            if (parser != null) return parser;
            parser = new DefaultParser();
            // ** MonitorExit[var0] (shouldn't be in output)
            return parser;
        }
    }

    public static void setParser(XMLParser p) {
        parser = p;
    }

    public static void setOfficeDTDURL(String url) {
        officedtdurl = url;
    }

    private static class DefaultParser
    implements XMLParser {
        private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

        public Document parse(InputStream inputStream) throws IOException {
            Document result = null;
            InputSource is = null;
            try {
                DocumentBuilder builder = this.factory.newDocumentBuilder();
                is = new InputSource(inputStream);
                if (officedtdurl != null) {
                    is.setSystemId(officedtdurl);
                }
                result = builder.parse(is);
            }
            catch (SAXParseException spe) {
                throw new IOException(spe.getMessage());
            }
            catch (SAXException se) {
                throw new IOException(se.getMessage());
            }
            catch (ParserConfigurationException pce) {
                throw new IOException(pce.getMessage());
            }
            return result;
        }

        public void write(Document doc, OutputStream out) throws IOException {
            block7: {
                Class<?> clazz = doc.getClass();
                String name = clazz.getName();
                try {
                    if (name.equals("com.sun.xml.tree.XmlDocument") || name.equals("org.apache.crimson.tree.XmlDocument")) {
                        Method write = clazz.getDeclaredMethod("write", OutputStream.class);
                        write.invoke((Object)doc, out);
                        break block7;
                    }
                    ClassLoader cl = this.getClass().getClassLoader();
                    Class<?> serializerClass = null;
                    Class<?> formatterClass = null;
                    try {
                        serializerClass = Class.forName("org.apache.xml.serialize.XMLSerializer", true, cl);
                        formatterClass = Class.forName("org.apache.xml.serialize.OutputFormat", true, cl);
                    }
                    catch (ClassNotFoundException cnfe) {
                        String prefix = "com.sun.org.apache.xml.internal.";
                        serializerClass = Class.forName(prefix + "serialize.XMLSerializer", true, cl);
                        formatterClass = Class.forName(prefix + "serialize.OutputFormat", true, cl);
                    }
                    Object serializerObject = serializerClass.newInstance();
                    Object formatterObject = formatterClass.newInstance();
                    Method method = null;
                    method = formatterClass.getMethod("setMethod", String.class);
                    method.invoke(formatterObject, "xml");
                    method = formatterClass.getMethod("setIndenting", Boolean.TYPE);
                    method.invoke(formatterObject, Boolean.TRUE);
                    method = serializerClass.getMethod("setOutputByteStream", OutputStream.class);
                    method.invoke(serializerObject, out);
                    method = serializerClass.getMethod("setOutputFormat", formatterClass);
                    method.invoke(serializerObject, formatterObject);
                    method = serializerClass.getMethod("asDOMSerializer", new Class[0]);
                    Object impl = method.invoke(serializerObject, new Object[0]);
                    method = impl.getClass().getMethod("serialize", Document.class);
                    method.invoke(impl, doc);
                }
                catch (NoSuchMethodException ex) {
                    throw new IOException(ex.getMessage());
                }
                catch (ClassNotFoundException ex) {
                    throw new IOException(ex.getMessage());
                }
                catch (Exception ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        }
    }
}

