/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.io;

import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XTruncate;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.script.framework.io.XOutputStreamWrapper;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UCBStreamHandler
extends URLStreamHandler {
    public static final String separator = "/ucb/";
    private XComponentContext m_xContext = null;
    private XMultiComponentFactory m_xMultiComponentFactory = null;
    private XSimpleFileAccess m_xSimpleFileAccess = null;
    private HashMap<String, InputStream> m_jarStreamMap = new HashMap(12);
    public static String m_ucbscheme;

    public UCBStreamHandler(XComponentContext ctxt, String scheme, XSimpleFileAccess xSFA) {
        LogUtils.DEBUG("UCBStreamHandler ctor, scheme = " + scheme);
        this.m_xContext = ctxt;
        m_ucbscheme = scheme;
        this.m_xSimpleFileAccess = xSFA;
    }

    public void parseURL(URL url, String spec, int start, int limit) {
        LogUtils.DEBUG("**XUCBStreamHandler, parseURL: " + url + " spec: " + spec + " start: " + start + " limit: " + limit);
        String file = url.getFile();
        file = file == null ? spec.substring(start, limit) : file + spec.substring(start, limit);
        LogUtils.DEBUG("**For scheme = " + m_ucbscheme);
        LogUtils.DEBUG("**Setting path = " + file);
        this.setURL(url, m_ucbscheme, null, -1, null, null, file, null, null);
    }

    public URLConnection openConnection(URL u) throws IOException {
        return new UCBConnection(u);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getUCBStream(String file, String path) throws IOException {
        InputStream result;
        block13: {
            InputStream is = null;
            result = null;
            try {
                if (path.endsWith(".jar")) {
                    is = this.m_jarStreamMap.get(path);
                    if (is == null) {
                        is = this.getFileStreamFromUCB(path);
                        this.m_jarStreamMap.put(path, is);
                    } else {
                        try {
                            is.reset();
                        }
                        catch (IOException e) {
                            is.close();
                            is = this.getFileStreamFromUCB(path);
                            this.m_jarStreamMap.put(path, is);
                        }
                    }
                    result = this.getFileStreamFromJarStream(file, is);
                    break block13;
                }
                String fileUrl = PathUtils.make_url(path, file);
                result = this.getFileStreamFromUCB(fileUrl);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        LogUtils.DEBUG("Caught exception closing stream: " + ioe.getMessage());
                    }
                }
            }
        }
        return result;
    }

    private InputStream getFileStreamFromJarStream(String file, InputStream is) throws IOException {
        ZipInputStream zis = null;
        ZipEntry entry = null;
        boolean found = false;
        zis = new ZipInputStream(is);
        while (zis.available() != 0) {
            entry = zis.getNextEntry();
            if (!entry.getName().equals(file)) continue;
            return zis;
        }
        return null;
    }

    private InputStream getFileStreamFromUCB(String path) throws IOException {
        ByteArrayInputStream result = null;
        XInputStream xInputStream = null;
        try {
            LogUtils.DEBUG("Trying to read from " + path);
            xInputStream = this.m_xSimpleFileAccess.openFileRead(path);
            LogUtils.DEBUG("sfa appeared to read file ");
            byte[][] inputBytes = new byte[1][];
            int ln = 0;
            int sz = this.m_xSimpleFileAccess.getSize(path);
            if (sz == 0 && xInputStream.available() > 0) {
                sz = xInputStream.available();
            }
            LogUtils.DEBUG("size of file " + path + " is " + sz);
            LogUtils.DEBUG("available = " + xInputStream.available());
            inputBytes[0] = new byte[sz];
            ln = xInputStream.readBytes((byte[][])inputBytes, sz);
            if (ln != sz) {
                throw new IOException("Failed to read " + sz + " bytes from XInputStream");
            }
            result = new ByteArrayInputStream(inputBytes[0]);
        }
        catch (com.sun.star.io.IOException ioe) {
            LogUtils.DEBUG("caught exception " + (Object)((Object)ioe));
            throw new IOException(ioe.getMessage());
        }
        catch (com.sun.star.uno.Exception e) {
            LogUtils.DEBUG("caught exception " + (Object)((Object)e));
            throw new IOException(e.getMessage());
        }
        finally {
            if (xInputStream != null) {
                try {
                    xInputStream.closeInput();
                }
                catch (Exception e2) {
                    LogUtils.DEBUG("Error closing XInputStream:" + e2.getMessage());
                }
            }
        }
        return result;
    }

    private String convertClassNameToFileName(String name) {
        return name.replace('.', File.separatorChar) + ".class";
    }

    private class UCBConnection
    extends URLConnection {
        public UCBConnection(URL url) {
            super(url);
        }

        public void connect() {
        }

        public InputStream getInputStream() throws IOException {
            LogUtils.DEBUG("UCBConnectionHandler GetInputStream on " + this.url);
            String sUrl = this.url.toString();
            if (sUrl.lastIndexOf(UCBStreamHandler.separator) == -1) {
                LogUtils.DEBUG("getInputStream straight file load");
                return UCBStreamHandler.this.getFileStreamFromUCB(sUrl);
            }
            String path = sUrl.substring(0, sUrl.lastIndexOf(UCBStreamHandler.separator));
            String file = sUrl.substring(sUrl.lastIndexOf(UCBStreamHandler.separator) + UCBStreamHandler.separator.length());
            LogUtils.DEBUG("getInputStream, load of file from another file eg. " + file + " from " + path);
            return UCBStreamHandler.this.getUCBStream(file, path);
        }

        public OutputStream getOutputStream() throws IOException {
            LogUtils.DEBUG("UCBConnectionHandler getOutputStream on " + this.url);
            XOutputStreamWrapper os = null;
            try {
                String sUrl = this.url.toString();
                if (sUrl.lastIndexOf(UCBStreamHandler.separator) != -1) {
                    String path = sUrl.substring(0, sUrl.lastIndexOf(UCBStreamHandler.separator));
                    String file = sUrl.substring(sUrl.lastIndexOf(UCBStreamHandler.separator) + UCBStreamHandler.separator.length());
                    if (UCBStreamHandler.this.m_xSimpleFileAccess.isReadOnly(path)) {
                        throw new IOException("File is read only");
                    }
                    LogUtils.DEBUG("getOutputStream, create o/p  stream  for file eg. " + path);
                    XOutputStream xos = UCBStreamHandler.this.m_xSimpleFileAccess.openFileWrite(path);
                    XTruncate xtrunc = (XTruncate)UnoRuntime.queryInterface(XTruncate.class, (Object)xos);
                    if (xtrunc != null) {
                        xtrunc.truncate();
                    }
                    os = new XOutputStreamWrapper(xos);
                }
                if (os == null) {
                    throw new IOException("Failed to get OutputStream for " + sUrl);
                }
            }
            catch (CommandAbortedException cae) {
                LogUtils.DEBUG("caught exception: " + cae.toString() + " getting writable stream from " + this.url);
                throw new IOException(cae.toString());
            }
            catch (com.sun.star.uno.Exception e) {
                LogUtils.DEBUG("caught unknown exception: " + e.toString() + " getting writable stream from " + this.url);
                throw new IOException(e.toString());
            }
            return os;
        }
    }
}

