/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider;

import com.sun.star.frame.XModel;
import com.sun.star.uno.IQueryInterface;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class PathUtils {
    public static String FILE_URL_PREFIX;
    public static String BOOTSTRAP_NAME;
    private static boolean m_windows;

    public static String getOidForModel(XModel xModel) {
        String oid = new String("");
        if (xModel != null) {
            try {
                Method getOid = IQueryInterface.class.getMethod("getOid", null);
                if (getOid != null) {
                    oid = (String)getOid.invoke((Object)xModel, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return oid;
    }

    public static String make_url(String baseUrl, String url) {
        StringBuffer buff = new StringBuffer(baseUrl.length() + url.length());
        buff.append(baseUrl);
        StringTokenizer t = new StringTokenizer(url, "/");
        while (t.hasMoreElements()) {
            if (buff.charAt(buff.length() - 1) != '/') {
                buff.append('/');
            }
            buff.append(URLEncoder.encode((String)t.nextElement()));
        }
        return buff.toString();
    }

    private PathUtils() {
    }

    static {
        m_windows = false;
        if (System.getProperty("os.name").startsWith("Windows")) {
            m_windows = true;
        }
        FILE_URL_PREFIX = m_windows ? "file:///" : "file://";
        BOOTSTRAP_NAME = m_windows ? "bootstrap.ini" : "bootstraprc";
    }
}

