/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XIntrospectionAccess;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameContainer;
import com.sun.star.deployment.XPackage;
import com.sun.star.document.XScriptInvocationContext;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XTransientDocumentsDocumentContentFactory;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.CannotConvertException;
import com.sun.star.script.XInvocation;
import com.sun.star.script.browse.XBrowseNode;
import com.sun.star.script.framework.browse.DialogFactory;
import com.sun.star.script.framework.browse.ProviderBrowseNode;
import com.sun.star.script.framework.container.ParcelContainer;
import com.sun.star.script.framework.container.ParsedScriptUri;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.container.UnoPkgContainer;
import com.sun.star.script.framework.container.XMLParserFactory;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.script.framework.provider.ScriptContext;
import com.sun.star.script.framework.provider.ScriptEditor;
import com.sun.star.script.provider.ScriptFrameworkErrorException;
import com.sun.star.script.provider.XScript;
import com.sun.star.script.provider.XScriptContext;
import com.sun.star.script.provider.XScriptProvider;
import com.sun.star.sdbc.XRow;
import com.sun.star.ucb.Command;
import com.sun.star.ucb.UniversalContentBroker;
import com.sun.star.ucb.XCommandEnvironment;
import com.sun.star.ucb.XCommandProcessor;
import com.sun.star.ucb.XContent;
import com.sun.star.ucb.XContentIdentifier;
import com.sun.star.ucb.XUniversalContentBroker;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XMacroExpander;

public abstract class ScriptProvider
implements XScriptProvider,
XBrowseNode,
XPropertySet,
XInvocation,
XInitialization,
XTypeProvider,
XServiceInfo,
XNameContainer {
    private final String[] __serviceNames = new String[]{"com.sun.star.script.provider.ScriptProviderFor", "com.sun.star.script.provider.LanguageScriptProvider"};
    public static final String CLASSPATH = "classpath";
    protected String language;
    protected XComponentContext m_xContext;
    protected XMultiComponentFactory m_xMultiComponentFactory;
    protected XModel m_xModel;
    protected XScriptInvocationContext m_xInvocContext;
    protected ParcelContainer m_container;
    private XPropertySet m_xPropertySetProxy;
    private XInvocation m_xInvocationProxy;
    private XBrowseNode m_xBrowseNodeProxy;
    private XScriptContext m_xScriptContext;

    public ScriptProvider(XComponentContext ctx, String language) {
        this.language = language;
        this.__serviceNames[0] = this.__serviceNames[0] + language;
        LogUtils.DEBUG("ScriptProvider: constructor - start. " + language);
        this.m_xContext = ctx;
        DialogFactory.createDialogFactory(this.m_xContext);
        try {
            this.m_xMultiComponentFactory = this.m_xContext.getServiceManager();
            if (this.m_xMultiComponentFactory == null) {
                throw new com.sun.star.uno.Exception("Error could not obtain a multicomponent factory - rethrowing Exception.");
            }
            Object serviceObj = this.m_xContext.getValueByName("/singletons/com.sun.star.util.theMacroExpander");
            XMacroExpander me = (XMacroExpander)AnyConverter.toObject((Type)new Type(XMacroExpander.class), (Object)serviceObj);
            XMLParserFactory.setOfficeDTDURL(me.expandMacros("$BRAND_BASE_DIR/$BRAND_SHARE_SUBDIR/dtd/officedocument/1_0/"));
        }
        catch (com.sun.star.uno.Exception e) {
            LogUtils.DEBUG(LogUtils.getTrace((Exception)((Object)e)));
            RuntimeException e2 = new RuntimeException("Error constructing  ScriptProvider: " + (Object)((Object)e));
            e2.initCause((Throwable)e);
            throw e2;
        }
        LogUtils.DEBUG("ScriptProvider: constructor - finished.");
    }

    public synchronized XScriptContext getScriptingContext() {
        if (this.m_xScriptContext == null) {
            this.m_xScriptContext = ScriptContext.createContext(this.m_xModel, this.m_xInvocContext, this.m_xContext, this.m_xMultiComponentFactory);
        }
        return this.m_xScriptContext;
    }

    public void initialize(Object[] aArguments) throws com.sun.star.uno.Exception {
        LogUtils.DEBUG("entering XInit for language " + this.language);
        boolean isPkgProvider = false;
        if (aArguments.length == 1) {
            String contextUrl = null;
            if (AnyConverter.getType((Object)aArguments[0]).getTypeClass().equals(TypeClass.INTERFACE)) {
                this.m_xInvocContext = (XScriptInvocationContext)UnoRuntime.queryInterface(XScriptInvocationContext.class, (Object)aArguments[0]);
                this.m_xModel = this.m_xInvocContext != null ? (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.m_xInvocContext.getScriptContainer()) : (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.m_xInvocContext.getScriptContainer());
                if (this.m_xModel == null) {
                    throw new com.sun.star.uno.Exception("ScriptProvider argument must be either a string, a valid XScriptInvocationContext, or an XModel", (Object)this);
                }
                contextUrl = this.getDocUrlFromModel(this.m_xModel);
                this.m_container = new ParcelContainer(this.m_xContext, contextUrl, this.language);
            } else if (AnyConverter.isString((Object)aArguments[0])) {
                String originalContextURL = AnyConverter.toString((Object)aArguments[0]);
                LogUtils.DEBUG("creating Application, path: " + originalContextURL);
                contextUrl = originalContextURL;
                if (originalContextURL.startsWith("vnd.sun.star.tdoc")) {
                    this.m_container = new ParcelContainer(this.m_xContext, contextUrl, this.language);
                    this.m_xModel = this.getModelFromDocUrl(originalContextURL);
                } else {
                    String extensionDb = null;
                    String extensionRepository = null;
                    if (originalContextURL.startsWith("bundled")) {
                        contextUrl = "vnd.sun.star.expand:$BUNDLED_EXTENSIONS";
                        extensionDb = "vnd.sun.star.expand:${$BRAND_BASE_DIR/$BRAND_BIN_SUBDIR/" + PathUtils.BOOTSTRAP_NAME + "::UserInstallation}/user";
                        extensionRepository = "bundled";
                    }
                    if (originalContextURL.startsWith("share")) {
                        contextUrl = "vnd.sun.star.expand:$BRAND_BASE_DIR/$BRAND_SHARE_SUBDIR";
                        extensionDb = "vnd.sun.star.expand:${$BRAND_BASE_DIR/$BRAND_BIN_SUBDIR/" + PathUtils.BOOTSTRAP_NAME + "::UserInstallation}/user";
                        extensionRepository = "shared";
                    } else if (originalContextURL.startsWith("user")) {
                        contextUrl = "vnd.sun.star.expand:${$BRAND_BASE_DIR/$BRAND_BIN_SUBDIR/" + PathUtils.BOOTSTRAP_NAME + "::UserInstallation}/user";
                        extensionDb = "vnd.sun.star.expand:${$BRAND_BASE_DIR/$BRAND_BIN_SUBDIR/" + PathUtils.BOOTSTRAP_NAME + "::UserInstallation}/user";
                        extensionRepository = "user";
                    }
                    if (originalContextURL.endsWith("uno_packages")) {
                        isPkgProvider = true;
                    }
                    if (originalContextURL.endsWith("uno_packages") && !originalContextURL.equals(contextUrl) && !extensionRepository.equals("bundled")) {
                        contextUrl = PathUtils.make_url(contextUrl, "uno_packages");
                    }
                    this.m_container = isPkgProvider ? new UnoPkgContainer(this.m_xContext, contextUrl, extensionDb, extensionRepository, this.language) : new ParcelContainer(this.m_xContext, contextUrl, this.language);
                }
            } else {
                throw new RuntimeException("ScriptProvider created with invalid argument");
            }
            LogUtils.DEBUG("Modified Application path is: " + contextUrl);
            LogUtils.DEBUG("isPkgProvider is: " + isPkgProvider);
            this.m_xBrowseNodeProxy = new ProviderBrowseNode(this, this.m_container, this.m_xContext);
            this.m_xInvocationProxy = (XInvocation)UnoRuntime.queryInterface(XInvocation.class, (Object)this.m_xBrowseNodeProxy);
            this.m_xPropertySetProxy = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_xBrowseNodeProxy);
        } else {
            LogUtils.DEBUG("ScriptProviderFor" + this.language + " initialized without a context");
        }
        LogUtils.DEBUG("leaving XInit");
    }

    public Type[] getTypes() {
        Type[] retValue = new Type[]{new Type(XScriptProvider.class), new Type(XBrowseNode.class), new Type(XInitialization.class), new Type(XTypeProvider.class), new Type(XServiceInfo.class), new Type(XPropertySet.class), new Type(XInvocation.class), new Type(XNameContainer.class)};
        return retValue;
    }

    public byte[] getImplementationId() {
        return this.getClass().getName().getBytes();
    }

    public String getImplementationName() {
        return this.getClass().getName();
    }

    public boolean supportsService(String serviceName) {
        int index = this.__serviceNames.length;
        while (index-- > 0) {
            if (!serviceName.equals(this.__serviceNames[index])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return this.__serviceNames;
    }

    public abstract XScript getScript(String var1) throws RuntimeException, ScriptFrameworkErrorException;

    public abstract boolean hasScriptEditor();

    public abstract ScriptEditor getScriptEditor();

    public ScriptMetaData getScriptData(String scriptURI) throws ScriptFrameworkErrorException {
        ParsedScriptUri details = null;
        try {
            details = this.m_container.parseScriptUri(scriptURI);
            ScriptMetaData scriptData = this.m_container.findScript(details);
            if (scriptData == null) {
                throw new ScriptFrameworkErrorException(details.function + " does not exist", null, details.function, this.language, 2);
            }
            return scriptData;
        }
        catch (IllegalArgumentException ila) {
            ScriptFrameworkErrorException e2 = new ScriptFrameworkErrorException(ila.getMessage(), null, scriptURI, this.language, 0);
            e2.initCause((Throwable)ila);
            throw e2;
        }
        catch (NoSuchElementException nse) {
            ScriptFrameworkErrorException e2 = new ScriptFrameworkErrorException(nse.getMessage(), null, details.function, this.language, 2);
            e2.initCause((Throwable)nse);
            throw e2;
        }
        catch (WrappedTargetException wta) {
            com.sun.star.uno.Exception wrapped = (com.sun.star.uno.Exception)((Object)wta.TargetException);
            String message = wta.getMessage();
            if (wrapped != null) {
                message = wrapped.getMessage();
            }
            ScriptFrameworkErrorException e2 = new ScriptFrameworkErrorException(message, null, details.function, this.language, 0);
            e2.initCause((Throwable)wta);
            throw e2;
        }
    }

    public String getName() {
        return this.language;
    }

    public XBrowseNode[] getChildNodes() {
        if (this.m_xBrowseNodeProxy == null) {
            LogUtils.DEBUG("No Nodes available ");
            return new XBrowseNode[0];
        }
        return this.m_xBrowseNodeProxy.getChildNodes();
    }

    public boolean hasChildNodes() {
        if (this.m_xBrowseNodeProxy == null) {
            LogUtils.DEBUG("No Nodes available ");
            return false;
        }
        return this.m_xBrowseNodeProxy.hasChildNodes();
    }

    public short getType() {
        return 1;
    }

    public String toString() {
        return this.getName();
    }

    public XIntrospectionAccess getIntrospection() {
        return this.m_xInvocationProxy.getIntrospection();
    }

    public Object invoke(String aFunctionName, Object[] aParams, short[][] aOutParamIndex, Object[][] aOutParam) throws IllegalArgumentException, CannotConvertException, InvocationTargetException {
        return this.m_xInvocationProxy.invoke(aFunctionName, aParams, aOutParamIndex, aOutParam);
    }

    public void setValue(String aPropertyName, Object aValue) throws UnknownPropertyException, CannotConvertException, InvocationTargetException {
        this.m_xInvocationProxy.setValue(aPropertyName, aValue);
    }

    public Object getValue(String aPropertyName) throws UnknownPropertyException {
        return this.m_xInvocationProxy.getValue(aPropertyName);
    }

    public boolean hasMethod(String aName) {
        return this.m_xInvocationProxy.hasMethod(aName);
    }

    public boolean hasProperty(String aName) {
        return this.m_xInvocationProxy.hasProperty(aName);
    }

    public XPropertySetInfo getPropertySetInfo() {
        return this.m_xPropertySetProxy.getPropertySetInfo();
    }

    public void setPropertyValue(String aPropertyName, Object aValue) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.m_xPropertySetProxy.setPropertyValue(aPropertyName, aValue);
    }

    public Object getPropertyValue(String PropertyName) throws UnknownPropertyException, WrappedTargetException {
        return this.m_xPropertySetProxy.getPropertyValue(PropertyName);
    }

    public void addPropertyChangeListener(String aPropertyName, XPropertyChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_xPropertySetProxy.addPropertyChangeListener(aPropertyName, xListener);
    }

    public void removePropertyChangeListener(String aPropertyName, XPropertyChangeListener aListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_xPropertySetProxy.removePropertyChangeListener(aPropertyName, aListener);
    }

    public void addVetoableChangeListener(String PropertyName, XVetoableChangeListener aListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_xPropertySetProxy.addVetoableChangeListener(PropertyName, aListener);
    }

    public void removeVetoableChangeListener(String PropertyName, XVetoableChangeListener aListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_xPropertySetProxy.removeVetoableChangeListener(PropertyName, aListener);
    }

    public Object getByName(String aName) throws NoSuchElementException, WrappedTargetException {
        throw new RuntimeException("getByName not implemented");
    }

    public String[] getElementNames() {
        String[] result = new String[]{};
        throw new RuntimeException("getElementNames not implemented");
    }

    public boolean hasByName(String aName) {
        boolean result = false;
        if (((UnoPkgContainer)this.m_container).hasRegisteredUnoPkgContainer(aName)) {
            result = true;
        }
        return result;
    }

    public Type getElementType() {
        return new Type();
    }

    public boolean hasElements() {
        throw new RuntimeException("hasElements not implemented");
    }

    public void replaceByName(String aName, Object aElement) throws IllegalArgumentException, NoSuchElementException, WrappedTargetException {
        throw new RuntimeException("replaceByName not implemented");
    }

    public void insertByName(String aName, Object aElement) throws IllegalArgumentException, ElementExistException, WrappedTargetException {
        LogUtils.DEBUG("Provider for " + this.language + " received register for package " + aName);
        XPackage newPackage = (XPackage)UnoRuntime.queryInterface(XPackage.class, (Object)aElement);
        if (aName.length() == 0) {
            throw new IllegalArgumentException("Empty name");
        }
        if (newPackage == null) {
            throw new IllegalArgumentException("No package supplied");
        }
        ((UnoPkgContainer)this.m_container).processUnoPackage(newPackage, this.language);
    }

    public void removeByName(String Name2) throws NoSuchElementException, WrappedTargetException {
        LogUtils.DEBUG("In ScriptProvider.removeByName() for " + Name2 + " this provider = " + this.language);
        ParcelContainer c = ((UnoPkgContainer)this.m_container).getRegisteredUnoPkgContainer(Name2);
        if (c != null) {
            String libName;
            if (Name2.endsWith("/")) {
                String tmp = Name2.substring(0, Name2.lastIndexOf("/"));
                libName = tmp.substring(tmp.lastIndexOf("/") + 1);
            } else {
                libName = Name2.substring(Name2.lastIndexOf("/") + 1);
            }
            LogUtils.DEBUG("Deregistering library " + libName);
            if (!c.removeParcel(libName)) {
                throw new NoSuchElementException(libName + " cannot be removed from container.");
            }
        } else {
            throw new NoSuchElementException(Name2 + " doesn't exist for " + this.language);
        }
        ((UnoPkgContainer)this.m_container).deRegisterPackageContainer(Name2);
    }

    private String getDocUrlFromModel(XModel document) {
        XTransientDocumentsDocumentContentFactory factory = null;
        try {
            factory = (XTransientDocumentsDocumentContentFactory)UnoRuntime.queryInterface(XTransientDocumentsDocumentContentFactory.class, (Object)this.m_xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.TransientDocumentsDocumentContentFactory", this.m_xContext));
        }
        catch (com.sun.star.uno.Exception ex) {
            // empty catch block
        }
        if (factory == null) {
            throw new RuntimeException("ScriptProvider: unable to create a TDOC context factory.", (Object)this);
        }
        try {
            XContent content = factory.createDocumentContent(document);
            return content.getIdentifier().getContentIdentifier();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogUtils.DEBUG("unable to determine the model's TDOC URL");
            return "";
        }
    }

    private XModel getModelFromDocUrl(String docUrl) {
        LogUtils.DEBUG("getModelFromDocUrl - searching for match for ->" + docUrl + "<-");
        XModel xModel = null;
        try {
            XUniversalContentBroker ucb = UniversalContentBroker.create((XComponentContext)this.m_xContext);
            XContentIdentifier xCntId = ucb.createContentIdentifier(docUrl);
            XContent xCnt = ucb.queryContent(xCntId);
            XCommandProcessor xCmd = (XCommandProcessor)UnoRuntime.queryInterface(XCommandProcessor.class, (Object)xCnt);
            Property[] pArgs = new Property[]{new Property()};
            pArgs[0].Name = "DocumentModel";
            pArgs[0].Handle = -1;
            Command command = new Command();
            command.Handle = -1;
            command.Name = "getPropertyValues";
            command.Argument = pArgs;
            XCommandEnvironment env = null;
            Object result = xCmd.execute(command, 0, env);
            XRow values = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)result);
            xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)values.getObject(1, null));
        }
        catch (com.sun.star.uno.Exception ignore) {
            LogUtils.DEBUG("Failed to get model exception " + (Object)((Object)ignore));
        }
        return xModel;
    }
}

