/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.java;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptDescriptor {
    private String m_name;
    private String m_methodName;
    private String m_className;
    private List<String> m_classpath;
    private ArrayList<Class<?>> m_argumentTypes = new ArrayList(11);

    public ScriptDescriptor(String name) throws IllegalArgumentException {
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            throw new IllegalArgumentException("Invalid method name");
        }
        this.m_name = name;
        this.m_methodName = name.substring(idx + 1);
        this.m_className = name.substring(0, idx);
    }

    public String getName() {
        return this.m_name;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public void setClasspath(String classpath) {
        StringTokenizer stk = new StringTokenizer(classpath, ":");
        while (stk.hasMoreElements()) {
            this.m_classpath.add((String)stk.nextElement());
        }
    }

    public void setClasspath(List<String> classpath) {
        this.m_classpath = classpath;
    }

    public List<String> getClasspath() {
        return this.m_classpath;
    }

    public synchronized void addArgumentType(Class<?> clazz) {
        this.m_argumentTypes.add(clazz);
    }

    public synchronized void addArgumentTypes(Class<?>[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            this.addArgumentType(classes[i]);
        }
    }

    public synchronized Class<?>[] getArgumentTypes() {
        if (this.m_argumentTypes.size() > 0) {
            return this.m_argumentTypes.toArray(new Class[this.m_argumentTypes.size()]);
        }
        return null;
    }

    public String toString() {
        StringBuffer description = new StringBuffer(this.m_name);
        Class<?>[] types = this.getArgumentTypes();
        description.append(" (");
        if (types != null) {
            for (int i = 0; i < types.length - 1; ++i) {
                description.append(types[i].getName());
                description.append(", ");
            }
            description.append(types[types.length - 1].getName());
        }
        description.append(")");
        return description.toString();
    }
}

