/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.i18n.ParseResult;
import com.sun.star.i18n.XCharacterClassification;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Any;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XStringSubstitution;
import com.sun.star.util.XURLTransformer;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.PropertyNames;

public class Desktop {
    public static XDesktop getDesktop(XMultiServiceFactory xMSF) {
        XInterface xInterface = null;
        XDesktop xDesktop = null;
        if (xMSF != null) {
            try {
                xInterface = (XInterface)xMSF.createInstance("com.sun.star.frame.Desktop");
                xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)xInterface);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        } else {
            System.out.println("Can't create a desktop. null pointer !");
        }
        return xDesktop;
    }

    public static XFrame getActiveFrame(XMultiServiceFactory xMSF) {
        XDesktop xDesktop = Desktop.getDesktop(xMSF);
        XFramesSupplier xFrameSuppl = (XFramesSupplier)UnoRuntime.queryInterface(XFramesSupplier.class, (Object)xDesktop);
        return xFrameSuppl.getActiveFrame();
    }

    public static XComponent getActiveComponent(XMultiServiceFactory _xMSF) {
        XFrame xFrame = Desktop.getActiveFrame(_xMSF);
        return (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xFrame.getController().getModel());
    }

    public static XTextDocument getActiveTextDocument(XMultiServiceFactory _xMSF) {
        XComponent xComponent = Desktop.getActiveComponent(_xMSF);
        return (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
    }

    public static XSpreadsheetDocument getActiveSpreadsheetDocument(XMultiServiceFactory _xMSF) {
        XComponent xComponent = Desktop.getActiveComponent(_xMSF);
        return (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
    }

    public static XDispatch getDispatcher(XMultiServiceFactory xMSF, XFrame xFrame, String _stargetframe, URL oURL) {
        try {
            URL[] oURLArray = new URL[]{oURL};
            XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xFrame);
            return xDispatchProvider.queryDispatch(oURLArray[0], _stargetframe, 23);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static URL getDispatchURL(XMultiServiceFactory xMSF, String _sURL) {
        try {
            Object oTransformer = xMSF.createInstance("com.sun.star.util.URLTransformer");
            XURLTransformer xTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, (Object)oTransformer);
            URL[] oURL = new URL[]{new URL()};
            oURL[0].Complete = _sURL;
            xTransformer.parseStrict(oURL);
            return oURL[0];
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static void dispatchURL(XMultiServiceFactory xMSF, String sURL, XFrame xFrame, String _stargetframe) {
        URL oURL = Desktop.getDispatchURL(xMSF, sURL);
        XDispatch xDispatch = Desktop.getDispatcher(xMSF, xFrame, _stargetframe, oURL);
        Desktop.dispatchURL(xDispatch, oURL);
    }

    public static void dispatchURL(XMultiServiceFactory xMSF, String sURL, XFrame xFrame) {
        Desktop.dispatchURL(xMSF, sURL, xFrame, PropertyNames.EMPTY_STRING);
    }

    public static void dispatchURL(XDispatch _xDispatch, URL oURL) {
        PropertyValue[] oArg = new PropertyValue[]{};
        _xDispatch.dispatch(oURL, oArg);
    }

    public static XMultiComponentFactory getMultiComponentFactory() throws com.sun.star.uno.Exception, java.lang.RuntimeException, Exception {
        XComponentContext xcomponentcontext = Bootstrap.createInitialComponentContext(null);
        return xcomponentcontext.getServiceManager();
    }

    public static XMultiServiceFactory connect(String connectStr) throws com.sun.star.uno.Exception, RuntimeException, Exception {
        XMultiComponentFactory componentFactory = Desktop.getMultiComponentFactory();
        Object xUrlResolver = componentFactory.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", null);
        XUnoUrlResolver urlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, (Object)xUrlResolver);
        return (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)urlResolver.resolve(connectStr));
    }

    public static String getIncrementSuffix(XNameAccess xElementContainer, String ElementName) {
        boolean bElementexists = true;
        int i = 1;
        String sIncSuffix = PropertyNames.EMPTY_STRING;
        String BaseName = ElementName;
        while (bElementexists) {
            bElementexists = xElementContainer.hasByName(ElementName);
            if (!bElementexists) continue;
            ElementName = BaseName + Integer.toString(++i);
        }
        if (i > 1) {
            sIncSuffix = Integer.toString(i);
        }
        return sIncSuffix;
    }

    public static String getIncrementSuffix(XHierarchicalNameAccess xElementContainer, String ElementName) {
        boolean bElementexists = true;
        int i = 1;
        String sIncSuffix = PropertyNames.EMPTY_STRING;
        String BaseName = ElementName;
        while (bElementexists) {
            bElementexists = xElementContainer.hasByHierarchicalName(ElementName);
            if (!bElementexists) continue;
            ElementName = BaseName + Integer.toString(++i);
        }
        if (i > 1) {
            sIncSuffix = Integer.toString(i);
        }
        return sIncSuffix;
    }

    public static int checkforfirstSpecialCharacter(XMultiServiceFactory _xMSF, String _sString, Locale _aLocale) {
        try {
            int nStartFlags = 1044495;
            Object ocharservice = _xMSF.createInstance("com.sun.star.i18n.CharacterClassification");
            XCharacterClassification xCharacterClassification = (XCharacterClassification)UnoRuntime.queryInterface(XCharacterClassification.class, (Object)ocharservice);
            ParseResult aResult = xCharacterClassification.parsePredefinedToken(4, _sString, 0, _aLocale, nStartFlags, PropertyNames.EMPTY_STRING, nStartFlags, PropertyNames.SPACE);
            return aResult.EndPos;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -1;
        }
    }

    public static String removeSpecialCharacters(XMultiServiceFactory _xMSF, Locale _aLocale, String _sname) {
        String snewname = _sname;
        int i = 0;
        while (i < snewname.length()) {
            i = Desktop.checkforfirstSpecialCharacter(_xMSF, snewname, _aLocale);
            if (i >= snewname.length()) continue;
            String sspecialchar = snewname.substring(i, i + 1);
            snewname = JavaTools.replaceSubString(snewname, PropertyNames.EMPTY_STRING, sspecialchar);
        }
        return snewname;
    }

    public static String getUniqueName(XNameAccess xElementContainer, String sElementName) {
        String sIncSuffix = Desktop.getIncrementSuffix(xElementContainer, sElementName);
        return sElementName + sIncSuffix;
    }

    public static String getUniqueName(XHierarchicalNameAccess xElementContainer, String sElementName) {
        String sIncSuffix = Desktop.getIncrementSuffix(xElementContainer, sElementName);
        return sElementName + sIncSuffix;
    }

    public static String getUniqueName(String[] _slist, String _sElementName, String _sSuffixSeparator) {
        int a = 2;
        String scompname = _sElementName;
        boolean bElementexists = true;
        if (_slist == null) {
            return _sElementName;
        }
        if (_slist.length == 0) {
            return _sElementName;
        }
        while (bElementexists) {
            for (int i = 0; i < _slist.length; ++i) {
                if (JavaTools.FieldInList(_slist, scompname) != -1) continue;
                return scompname;
            }
            scompname = _sElementName + _sSuffixSeparator + a++;
        }
        return PropertyNames.EMPTY_STRING;
    }

    public static XInterface getRegistryKeyContent(XMultiServiceFactory xMSF, String KeyName, boolean bForUpdate) {
        try {
            Object[] aNodePath = new PropertyValue[1];
            Object oConfigProvider = xMSF.createInstance("com.sun.star.configuration.ConfigurationProvider");
            aNodePath[0] = new PropertyValue();
            aNodePath[0].Name = "nodepath";
            aNodePath[0].Value = KeyName;
            XMultiServiceFactory xMSFConfig = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oConfigProvider);
            if (bForUpdate) {
                return (XInterface)xMSFConfig.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", aNodePath);
            }
            return (XInterface)xMSFConfig.createInstanceWithArguments("com.sun.star.configuration.ConfigurationAccess", aNodePath);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static String getTemplatePath(XMultiServiceFactory _xMSF) {
        try {
            return FileAccess.getOfficePath(_xMSF, "Template", "share", "/wizard");
        }
        catch (NoValidPathException noValidPathException) {
            return PropertyNames.EMPTY_STRING;
        }
    }

    public static String getUserTemplatePath(XMultiServiceFactory _xMSF) {
        try {
            return FileAccess.getOfficePath(_xMSF, "Template", "user", PropertyNames.EMPTY_STRING);
        }
        catch (NoValidPathException noValidPathException) {
            return PropertyNames.EMPTY_STRING;
        }
    }

    public static String getBitmapPath(XMultiServiceFactory _xMSF) {
        try {
            return FileAccess.combinePaths(_xMSF, Desktop.getTemplatePath(_xMSF), "/../wizard/bitmap");
        }
        catch (NoValidPathException noValidPathException) {
            return PropertyNames.EMPTY_STRING;
        }
    }

    public static String getWorkPath(XMultiServiceFactory _xMSF) {
        try {
            return FileAccess.getOfficePath(_xMSF, "Work", PropertyNames.EMPTY_STRING, PropertyNames.EMPTY_STRING);
        }
        catch (NoValidPathException noValidPathException) {
            return PropertyNames.EMPTY_STRING;
        }
    }

    public static XStringSubstitution createStringSubstitution(XMultiServiceFactory xMSF) {
        Object xPathSubst = null;
        try {
            xPathSubst = xMSF.createInstance("com.sun.star.util.PathSubstitution");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace();
        }
        if (xPathSubst != null) {
            return (XStringSubstitution)UnoRuntime.queryInterface(XStringSubstitution.class, (Object)xPathSubst);
        }
        return null;
    }

    public static XFrame findAFrame(XMultiServiceFactory xMSF, XFrame myFrame, XFrame desktop) throws NoSuchElementException, WrappedTargetException {
        if (desktop == null) {
            desktop = myFrame;
        }
        while (desktop != null && desktop.getComponentWindow() == null) {
            desktop = desktop.findFrame("_parent", 1);
        }
        if (desktop == null) {
            XEnumeration e = Desktop.getDesktop(xMSF).getComponents().createEnumeration();
            while (e.hasMoreElements()) {
                Object comp = ((Any)e.nextElement()).getObject();
                XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)comp);
                XFrame xFrame = xModel.getCurrentController().getFrame();
                if (xFrame == null || xFrame.getComponentWindow() == null) continue;
                return xFrame;
            }
        }
        return desktop;
    }

    public class OfficePathRetriever {
        public String TemplatePath;
        public String BitmapPath;
        public String UserTemplatePath;
        public String WorkPath;

        public OfficePathRetriever(XMultiServiceFactory xMSF) {
            try {
                this.TemplatePath = FileAccess.getOfficePath(xMSF, "Template", "share", "/wizard");
                this.UserTemplatePath = FileAccess.getOfficePath(xMSF, "Template", "user", PropertyNames.EMPTY_STRING);
                this.BitmapPath = FileAccess.combinePaths(xMSF, this.TemplatePath, "/../wizard/bitmap");
                this.WorkPath = FileAccess.getOfficePath(xMSF, "Work", PropertyNames.EMPTY_STRING, PropertyNames.EMPTY_STRING);
            }
            catch (NoValidPathException noValidPathException) {
                // empty catch block
            }
        }
    }
}

