/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.io.XActiveDataSink;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XTextInputStream;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.DateTime;
import com.sun.star.util.XMacroExpander;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.common.SystemDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAccess {
    public XSimpleFileAccess2 fileAccess;
    public XFileIdentifierConverter filenameConverter;

    public static void addOfficePath(XMultiServiceFactory xMSF, String sPath, String sAddPath) {
        XSimpleFileAccess xSimpleFileAccess = null;
        String ResultPath = FileAccess.getOfficePath(xMSF, sPath, xSimpleFileAccess);
        String[] PathList = JavaTools.ArrayoutofString(ResultPath, PropertyNames.SEMI_COLON);
        int MaxIndex = PathList.length - 1;
        String CompAddPath = JavaTools.replaceSubString(sAddPath, PropertyNames.EMPTY_STRING, "/");
        for (int i = 0; i <= MaxIndex; ++i) {
            String CurPath = JavaTools.convertfromURLNotation(PathList[i]);
            String CompCurPath = JavaTools.replaceSubString(CurPath, PropertyNames.EMPTY_STRING, "/");
            if (!CompCurPath.equals(CompAddPath)) continue;
            return;
        }
        ResultPath = ResultPath + PropertyNames.SEMI_COLON + sAddPath;
    }

    public static String deleteLastSlashfromUrl(String _sPath) {
        if (_sPath.endsWith("/")) {
            return _sPath.substring(0, _sPath.length() - 1);
        }
        return _sPath;
    }

    public static String getOfficePath(XMultiServiceFactory xMSF, String sPath, XSimpleFileAccess xSimpleFileAccess) {
        try {
            String ResultPath = PropertyNames.EMPTY_STRING;
            XInterface xInterface = (XInterface)xMSF.createInstance("com.sun.star.util.PathSettings");
            ResultPath = AnyConverter.toString((Object)Helper.getUnoPropertyValue(xInterface, sPath));
            ResultPath = FileAccess.deleteLastSlashfromUrl(ResultPath);
            return ResultPath;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return PropertyNames.EMPTY_STRING;
        }
    }

    public static String getOfficePath(XMultiServiceFactory xMSF, String sPath, String sType, String sSearchDir) throws NoValidPathException {
        String ResultPath = PropertyNames.EMPTY_STRING;
        String Template_writable = PropertyNames.EMPTY_STRING;
        boolean bexists = false;
        try {
            int i;
            XInterface xPathInterface = (XInterface)xMSF.createInstance("com.sun.star.util.PathSettings");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xPathInterface);
            String WritePath = PropertyNames.EMPTY_STRING;
            String[] ReadPaths = null;
            XInterface xUcbInterface = (XInterface)xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xUcbInterface);
            Template_writable = (String)xPropertySet.getPropertyValue(sPath + "_writable");
            String[] Template_internal = (String[])xPropertySet.getPropertyValue(sPath + "_internal");
            String[] Template_user = (String[])xPropertySet.getPropertyValue(sPath + "_user");
            int iNumEntries = Template_user.length + Template_internal.length + 1;
            ReadPaths = new String[iNumEntries];
            int t = 0;
            for (i = 0; i < Template_internal.length; ++i) {
                ReadPaths[t] = Template_internal[i];
                ++t;
            }
            for (i = 0; i < Template_user.length; ++i) {
                ReadPaths[t] = Template_user[i];
                ++t;
            }
            ReadPaths[t] = Template_writable;
            WritePath = Template_writable;
            if (sType.equalsIgnoreCase("user")) {
                ResultPath = WritePath;
                bexists = true;
            } else {
                for (i = 0; i < ReadPaths.length; ++i) {
                    String tmpPath = ReadPaths[i] + sSearchDir;
                    if (!xSimpleFileAccess.exists(tmpPath)) continue;
                    ResultPath = ReadPaths[i];
                    bexists = true;
                    break;
                }
            }
            ResultPath = FileAccess.deleteLastSlashfromUrl(ResultPath);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            ResultPath = PropertyNames.EMPTY_STRING;
        }
        if (!bexists) {
            throw new NoValidPathException(xMSF, PropertyNames.EMPTY_STRING);
        }
        return ResultPath;
    }

    public static ArrayList<String> getOfficePaths(XMultiServiceFactory xMSF, String _sPath, String sType, String sSearchDir) throws NoValidPathException {
        ArrayList<String> aPathList = new ArrayList<String>();
        String Template_writable = PropertyNames.EMPTY_STRING;
        try {
            XInterface xPathInterface = (XInterface)xMSF.createInstance("com.sun.star.util.PathSettings");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xPathInterface);
            Template_writable = (String)xPropertySet.getPropertyValue(_sPath + "_writable");
            String[] Template_internal = (String[])xPropertySet.getPropertyValue(_sPath + "_internal");
            String[] Template_user = (String[])xPropertySet.getPropertyValue(_sPath + "_user");
            for (int i = 0; i < Template_internal.length; ++i) {
                String sPath = Template_internal[i];
                if (sPath.startsWith("vnd.")) {
                    String sPathToExpand = sPath.substring("vnd.sun.star.Expand:".length());
                    XMacroExpander xExpander = Helper.getMacroExpander(xMSF);
                    sPath = xExpander.expandMacros(sPathToExpand);
                }
                sPath = FileAccess.checkIfLanguagePathExists(xMSF, sPath);
                aPathList.add(sPath);
            }
            aPathList.addAll(Arrays.asList(Template_user));
            aPathList.add(Template_writable);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return aPathList;
    }

    private static String checkIfLanguagePathExists(XMultiServiceFactory _xMSF, String _sPath) {
        try {
            Object defaults = _xMSF.createInstance("com.sun.star.text.Defaults");
            Locale aLocale = (Locale)Helper.getUnoStructValue(defaults, "CharLocale");
            if (aLocale == null) {
                java.util.Locale.getDefault();
                aLocale = new Locale();
                aLocale.Country = java.util.Locale.getDefault().getCountry();
                aLocale.Language = java.util.Locale.getDefault().getLanguage();
                aLocale.Variant = java.util.Locale.getDefault().getVariant();
            }
            String sLanguage = aLocale.Language;
            String sCountry = aLocale.Country;
            String sVariant = aLocale.Variant;
            StringBuffer aLocaleAll = new StringBuffer();
            aLocaleAll.append(sLanguage).append('-').append(sCountry).append('-').append(sVariant);
            String sPath = _sPath + "/" + aLocaleAll.toString();
            XInterface xInterface = (XInterface)_xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            if (xSimpleFileAccess.exists(sPath)) {
                return sPath;
            }
            StringBuffer aLocaleLang_Country = new StringBuffer();
            aLocaleLang_Country.append(sLanguage).append('-').append(sCountry);
            sPath = _sPath + "/" + aLocaleLang_Country.toString();
            if (xSimpleFileAccess.exists(sPath)) {
                return sPath;
            }
            StringBuffer aLocaleLang = new StringBuffer();
            aLocaleLang.append(sLanguage);
            sPath = _sPath + "/" + aLocaleLang.toString();
            if (xSimpleFileAccess.exists(sPath)) {
                return sPath;
            }
            sPath = _sPath + "/en-US";
            if (xSimpleFileAccess.exists(sPath)) {
                return sPath;
            }
            sPath = _sPath + "/en";
            if (xSimpleFileAccess.exists(sPath)) {
                return sPath;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _sPath;
    }

    public static void combinePaths(XMultiServiceFactory xMSF, ArrayList<String> _aFirstPath, String _sSecondPath) throws NoValidPathException {
        for (int i = 0; i < _aFirstPath.size(); ++i) {
            String sOnePath = _aFirstPath.get(i);
            if (FileAccess.isPathValid(xMSF, sOnePath = FileAccess.addPath(sOnePath, _sSecondPath))) {
                _aFirstPath.add(i, sOnePath);
                _aFirstPath.remove(i + 1);
                continue;
            }
            _aFirstPath.remove(i);
            --i;
        }
    }

    public static boolean isPathValid(XMultiServiceFactory xMSF, String _sPath) {
        boolean bExists = false;
        try {
            XInterface xUcbInterface = (XInterface)xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xUcbInterface);
            bExists = xSimpleFileAccess.exists(_sPath);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return bExists;
    }

    public static String combinePaths(XMultiServiceFactory xMSF, String _sFirstPath, String _sSecondPath) throws NoValidPathException {
        boolean bexists = false;
        String ReturnPath = PropertyNames.EMPTY_STRING;
        try {
            XInterface xUcbInterface = (XInterface)xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xUcbInterface);
            ReturnPath = _sFirstPath + _sSecondPath;
            bexists = xSimpleFileAccess.exists(ReturnPath);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return PropertyNames.EMPTY_STRING;
        }
        if (!bexists) {
            throw new NoValidPathException(xMSF, PropertyNames.EMPTY_STRING);
        }
        return ReturnPath;
    }

    public static boolean createSubDirectory(XMultiServiceFactory xMSF, XSimpleFileAccess xSimpleFileAccess, String Path) {
        String sNoDirCreation = PropertyNames.EMPTY_STRING;
        try {
            Resource oResource = new Resource(xMSF, "ImportWizard", "imp");
            sNoDirCreation = oResource.getResText(1050);
            String sMsgDirNotThere = oResource.getResText(1051);
            String sQueryForNewCreation = oResource.getResText(1052);
            String OSPath = JavaTools.convertfromURLNotation(Path);
            String sQueryMessage = JavaTools.replaceSubString(sMsgDirNotThere, OSPath, "%1");
            sQueryMessage = sQueryMessage + '\r' + sQueryForNewCreation;
            int icreate = SystemDialog.showMessageBox(xMSF, "QueryBox", 0x1000000, sQueryMessage);
            if (icreate == 2) {
                xSimpleFileAccess.createFolder(Path);
                return true;
            }
            return false;
        }
        catch (CommandAbortedException exception) {
            String sMsgNoDir = JavaTools.replaceSubString(sNoDirCreation, Path, "%1");
            SystemDialog.showMessageBox(xMSF, "ErrorBox", 0x400000, sMsgNoDir);
            return false;
        }
        catch (Exception unoexception) {
            String sMsgNoDir = JavaTools.replaceSubString(sNoDirCreation, Path, "%1");
            SystemDialog.showMessageBox(xMSF, "ErrorBox", 0x400000, sMsgNoDir);
            return false;
        }
    }

    public static boolean PathisValid(XMultiServiceFactory xMSF, String Path, String sMsgFilePathInvalid, boolean baskbeforeOverwrite) {
        try {
            String[] DirArray;
            int MaxIndex;
            String SubDirPath = PropertyNames.EMPTY_STRING;
            boolean bSubDirexists = true;
            String NewPath = Path;
            XInterface xInterface = (XInterface)xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            if (baskbeforeOverwrite && xSimpleFileAccess.exists(Path)) {
                Resource oResource = new Resource(xMSF, "ImportWizard", "imp");
                String sFileexists = oResource.getResText(1053);
                String NewString = JavaTools.convertfromURLNotation(Path);
                sFileexists = JavaTools.replaceSubString(sFileexists, NewString, "<1>");
                int iLeave = SystemDialog.showMessageBox(xMSF, "QueryBox", 0x1000000, sFileexists = JavaTools.replaceSubString(sFileexists, String.valueOf('\r'), "<CR>"));
                if (iLeave == 3) {
                    return false;
                }
            }
            if ((MaxIndex = (DirArray = JavaTools.ArrayoutofString(Path, "/")).length - 1) > 0) {
                for (int i = MaxIndex; i >= 0; --i) {
                    boolean bexists;
                    String SubDir = DirArray[i];
                    int SubLen = SubDir.length();
                    int NewLen = NewPath.length();
                    int RestLen = NewLen - SubLen;
                    if (RestLen <= 0) continue;
                    NewPath = NewPath.substring(0, NewLen - SubLen - 1);
                    if (i == MaxIndex) {
                        SubDirPath = NewPath;
                    }
                    if (bexists = xSimpleFileAccess.exists(NewPath)) {
                        String LowerCasePath = NewPath.toLowerCase();
                        boolean bl = bexists = !LowerCasePath.equals("file:///") && !LowerCasePath.equals("file://") && !LowerCasePath.equals("file:/") && !LowerCasePath.equals("file:");
                    }
                    if (bexists) {
                        if (!bSubDirexists) {
                            return FileAccess.createSubDirectory(xMSF, xSimpleFileAccess, SubDirPath);
                        }
                        return true;
                    }
                    bSubDirexists = false;
                }
            }
            SystemDialog.showMessageBox(xMSF, "ErrorBox", 0x400000, sMsgFilePathInvalid);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            SystemDialog.showMessageBox(xMSF, "ErrorBox", 0x400000, sMsgFilePathInvalid);
            return false;
        }
    }

    public static String[][] getFolderTitles(XMultiServiceFactory xMSF, String FilterName, String FolderName) {
        String[][] LocLayoutFiles = new String[2][];
        try {
            ArrayList<String> TitleVector = null;
            ArrayList<String> NameVector = null;
            XInterface xDocInterface = (XInterface)xMSF.createInstance("com.sun.star.document.DocumentProperties");
            XDocumentProperties xDocProps = (XDocumentProperties)UnoRuntime.queryInterface(XDocumentProperties.class, (Object)xDocInterface);
            XInterface xInterface = (XInterface)xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            String[] nameList = xSimpleFileAccess.getFolderContents(FolderName, false);
            TitleVector = new ArrayList<String>();
            NameVector = new ArrayList<String>(nameList.length);
            FilterName = FilterName == null || FilterName.equals(PropertyNames.EMPTY_STRING) ? null : FilterName + "-";
            String fileName = PropertyNames.EMPTY_STRING;
            PropertyValue[] noArgs = new PropertyValue[]{};
            for (int i = 0; i < nameList.length; ++i) {
                fileName = FileAccess.getFilename(nameList[i]);
                if (FilterName != null && !fileName.startsWith(FilterName)) continue;
                xDocProps.loadFromMedium(nameList[i], noArgs);
                NameVector.add(nameList[i]);
                TitleVector.add(xDocProps.getTitle());
            }
            String[] LocNameList = new String[NameVector.size()];
            String[] LocTitleList = new String[TitleVector.size()];
            NameVector.toArray(LocNameList);
            TitleVector.toArray(LocTitleList);
            LocLayoutFiles[1] = LocNameList;
            LocLayoutFiles[0] = LocTitleList;
            JavaTools.bubblesortList(LocLayoutFiles);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return LocLayoutFiles;
    }

    public static String addPath(String _sPath, String _sPath2) {
        if (!_sPath.endsWith("/")) {
            _sPath = _sPath + "/";
        }
        if (_sPath2.startsWith("/")) {
            _sPath2 = _sPath2.substring(1);
        }
        String sNewPath = _sPath + _sPath2;
        return sNewPath;
    }

    public static String getPathFromList(XMultiServiceFactory xMSF, ArrayList<String> _aList, String _sFile) {
        String sFoundFile = PropertyNames.EMPTY_STRING;
        try {
            XInterface xInterface = (XInterface)xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            for (int i = 0; i < _aList.size(); ++i) {
                String sPath = _aList.get(i);
                if (!xSimpleFileAccess.exists(sPath = FileAccess.addPath(sPath, _sFile))) continue;
                sFoundFile = sPath;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return sFoundFile;
    }

    public static String[][] getFolderTitles(XMultiServiceFactory xMSF, String _sStartFilterName, ArrayList<String> FolderNames) throws NoValidPathException {
        return FileAccess.getFolderTitles(xMSF, _sStartFilterName, FolderNames, PropertyNames.EMPTY_STRING);
    }

    private static String getTitle(XMultiServiceFactory xMSF, String _sFile) {
        String sTitle = PropertyNames.EMPTY_STRING;
        try {
            XInterface xDocInterface = (XInterface)xMSF.createInstance("com.sun.star.document.DocumentProperties");
            XDocumentProperties xDocProps = (XDocumentProperties)UnoRuntime.queryInterface(XDocumentProperties.class, (Object)xDocInterface);
            PropertyValue[] noArgs = new PropertyValue[]{};
            xDocProps.loadFromMedium(_sFile, noArgs);
            sTitle = xDocProps.getTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sTitle;
    }

    public static String[][] getFolderTitles(XMultiServiceFactory xMSF, String _sStartFilterName, ArrayList<String> FolderName, String _sEndFilterName) throws NoValidPathException {
        String[][] LocLayoutFiles = new String[2][];
        if (FolderName.size() == 0) {
            throw new NoValidPathException(null, "Path not given.");
        }
        ArrayList<String> TitleVector = new ArrayList<String>();
        ArrayList<String> URLVector = new ArrayList<String>();
        XSimpleFileAccess xSimpleFileAccess = null;
        try {
            XInterface xInterface = (XInterface)xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoValidPathException(null, "Internal error.");
        }
        for (int j = 0; j < FolderName.size(); ++j) {
            String sFolderName = FolderName.get(j);
            try {
                String[] nameList = xSimpleFileAccess.getFolderContents(sFolderName, false);
                _sStartFilterName = _sStartFilterName == null || _sStartFilterName.equals(PropertyNames.EMPTY_STRING) ? null : _sStartFilterName + "-";
                String fileName = PropertyNames.EMPTY_STRING;
                for (int i = 0; i < nameList.length; ++i) {
                    String sTitle;
                    fileName = FileAccess.getFilename(nameList[i]);
                    if (_sStartFilterName != null && !fileName.startsWith(_sStartFilterName)) continue;
                    if (_sEndFilterName.equals(PropertyNames.EMPTY_STRING)) {
                        sTitle = FileAccess.getTitle(xMSF, nameList[i]);
                    } else {
                        if (!fileName.endsWith(_sEndFilterName)) continue;
                        sTitle = fileName = fileName.replaceAll(_sEndFilterName + "$", PropertyNames.EMPTY_STRING);
                    }
                    URLVector.add(nameList[i]);
                    TitleVector.add(sTitle);
                }
                continue;
            }
            catch (CommandAbortedException exception) {
                exception.printStackTrace(System.err);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String[] LocNameList = new String[URLVector.size()];
        String[] LocTitleList = new String[TitleVector.size()];
        URLVector.toArray(LocNameList);
        TitleVector.toArray(LocTitleList);
        LocLayoutFiles[1] = LocNameList;
        LocLayoutFiles[0] = LocTitleList;
        JavaTools.bubblesortList(LocLayoutFiles);
        return LocLayoutFiles;
    }

    public FileAccess(XMultiServiceFactory xmsf) throws Exception {
        Object fa = xmsf.createInstance("com.sun.star.ucb.SimpleFileAccess");
        this.fileAccess = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)fa);
        Object fcv = xmsf.createInstance("com.sun.star.ucb.FileContentProvider");
        this.filenameConverter = (XFileIdentifierConverter)UnoRuntime.queryInterface(XFileIdentifierConverter.class, (Object)fcv);
    }

    public String getURL(String parentPath, String childPath) {
        String parent = this.filenameConverter.getSystemPathFromFileURL(parentPath);
        File f = new File(parent, childPath);
        return this.filenameConverter.getFileURLFromSystemPath(parentPath, f.getAbsolutePath());
    }

    public String getURL(String path) {
        File f = new File(path);
        return this.filenameConverter.getFileURLFromSystemPath(path, f.getAbsolutePath());
    }

    public String getPath(String parentURL, String childURL) {
        return this.filenameConverter.getSystemPathFromFileURL(parentURL + (childURL == null || childURL.equals(PropertyNames.EMPTY_STRING) ? PropertyNames.EMPTY_STRING : "/" + childURL));
    }

    public static String getExtension(String filename) {
        int p = filename.indexOf(".");
        if (p == -1) {
            return PropertyNames.EMPTY_STRING;
        }
        while ((p = (filename = filename.substring(p + 1)).indexOf(".")) > -1) {
        }
        return filename;
    }

    public boolean mkdir(String s) {
        try {
            this.fileAccess.createFolder(s);
            return true;
        }
        catch (CommandAbortedException cax) {
            cax.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public boolean exists(String filename, boolean def) {
        try {
            return this.fileAccess.exists(filename);
        }
        catch (CommandAbortedException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public boolean isDirectory(String filename) {
        try {
            return this.fileAccess.isFolder(filename);
        }
        catch (CommandAbortedException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String[] listFiles(String dir, boolean includeFolders) {
        try {
            return this.fileAccess.getFolderContents(dir, includeFolders);
        }
        catch (CommandAbortedException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[0];
    }

    public boolean delete(String file) {
        try {
            this.fileAccess.kill(file);
            return true;
        }
        catch (CommandAbortedException e) {
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return false;
    }

    public static String getFilename(String path) {
        return FileAccess.getFilename(path, "/");
    }

    public static String getPathFilename(String path) {
        return FileAccess.getFilename(path, File.separator);
    }

    public static String getFilename(String path, String pathSeparator) {
        String[] s = JavaTools.ArrayoutofString(path, pathSeparator);
        return s[s.length - 1];
    }

    public static String getBasename(String path, String pathSeparator) {
        String filename = FileAccess.getFilename(path, pathSeparator);
        String sExtension = FileAccess.getExtension(filename);
        return filename.substring(0, filename.length() - (sExtension.length() + 1));
    }

    public boolean copy(String source, String target) {
        try {
            this.fileAccess.copy(source, target);
            return true;
        }
        catch (CommandAbortedException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public DateTime getLastModified(String url) {
        try {
            return this.fileAccess.getDateTimeModified(url);
        }
        catch (CommandAbortedException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getParentDir(String url) {
        if (url.endsWith("/")) {
            return FileAccess.getParentDir(url.substring(0, url.length() - 1));
        }
        int pos = -1;
        int lastPos = 0;
        while ((pos = url.indexOf("/", pos + 1)) > -1) {
            lastPos = pos;
        }
        return url.substring(0, lastPos);
    }

    public String createNewDir(String parentDir, String name) {
        String s = this.getNewFile(parentDir, name, PropertyNames.EMPTY_STRING);
        if (this.mkdir(s)) {
            return s;
        }
        return null;
    }

    public String getNewFile(String parentDir, String name, String extension) {
        String filename;
        String url;
        int i = 0;
        while (this.exists(url = this.getURL(parentDir, filename = FileAccess.filename(name, extension, i++)), true)) {
        }
        return url;
    }

    private static String filename(String name, String ext, int i) {
        return name + (i == 0 ? PropertyNames.EMPTY_STRING : String.valueOf(i)) + (ext.equals(PropertyNames.EMPTY_STRING) ? PropertyNames.EMPTY_STRING : "." + ext);
    }

    public int getSize(String url) {
        try {
            return this.fileAccess.getSize(url);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static String connectURLs(String urlFolder, String urlFilename) {
        return urlFolder + (urlFolder.endsWith("/") ? PropertyNames.EMPTY_STRING : "/") + (urlFilename.startsWith("/") ? urlFilename.substring(1) : urlFilename);
    }

    public static String[] getDataFromTextFile(XMultiServiceFactory _xMSF, String _filepath) {
        String[] sFileData = null;
        try {
            Vector<String> oDataVector = new Vector<String>();
            Object oSimpleFileAccess = _xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)oSimpleFileAccess);
            if (xSimpleFileAccess.exists(_filepath)) {
                XInputStream xInputStream = xSimpleFileAccess.openFileRead(_filepath);
                Object oTextInputStream = _xMSF.createInstance("com.sun.star.io.TextInputStream");
                XTextInputStream xTextInputStream = (XTextInputStream)UnoRuntime.queryInterface(XTextInputStream.class, (Object)oTextInputStream);
                XActiveDataSink xActiveDataSink = (XActiveDataSink)UnoRuntime.queryInterface(XActiveDataSink.class, (Object)oTextInputStream);
                xActiveDataSink.setInputStream(xInputStream);
                while (!xTextInputStream.isEOF()) {
                    oDataVector.addElement(xTextInputStream.readLine());
                }
                xTextInputStream.closeInput();
                sFileData = new String[oDataVector.size()];
                oDataVector.toArray(sFileData);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return sFileData;
    }

    public static String getShortFilename(String path, int maxLength) {
        int firstPart = 0;
        if (path.length() > maxLength) {
            if (path.startsWith("/")) {
                int nextSlash = path.indexOf("/", 1) + 1;
                firstPart = Math.min(nextSlash, (maxLength - 3) / 2);
            } else {
                firstPart = Math.min(10, (maxLength - 3) / 2);
            }
            String s1 = path.substring(0, firstPart);
            String s2 = path.substring(path.length() - (maxLength - (3 + firstPart)));
            return s1 + "..." + s2;
        }
        return path;
    }
}

