/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.DebugHelper;
import com.sun.star.wizards.common.NumericalHelper;
import com.sun.star.wizards.common.PropertyNames;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySetHelper {
    protected XPropertySet m_xPropertySet;
    private HashMap<String, Object> m_aHashMap;

    public PropertySetHelper(Object _aObj) {
        if (_aObj == null) {
            return;
        }
        this.m_xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)_aObj);
    }

    private HashMap<String, Object> getHashMap() {
        if (this.m_aHashMap == null) {
            this.m_aHashMap = new HashMap();
        }
        return this.m_aHashMap;
    }

    public void setPropertyValueDontThrow(String _sName, Object _aValue) {
        try {
            this.setPropertyValue(_sName, _aValue);
        }
        catch (Exception e) {
            DebugHelper.writeInfo("Don't throw the exception with property name(" + _sName + " ) : " + e.getMessage());
        }
    }

    public void setPropertyValue(String _sName, Object _aValue) throws Exception {
        if (this.m_xPropertySet != null) {
            try {
                this.m_xPropertySet.setPropertyValue(_sName, _aValue);
            }
            catch (UnknownPropertyException e) {
                DebugHelper.writeInfo(e.getMessage());
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)e));
            }
            catch (PropertyVetoException e) {
                DebugHelper.writeInfo(e.getMessage());
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)e));
            }
            catch (WrappedTargetException e) {
                DebugHelper.writeInfo(e.getMessage());
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)e));
            }
        } else {
            this.getHashMap().put(_sName, _aValue);
        }
    }

    public int getPropertyValueAsInteger(String _sName, int _nDefault) {
        Object aObject = null;
        int nValue = _nDefault;
        if (this.m_xPropertySet != null) {
            try {
                aObject = this.m_xPropertySet.getPropertyValue(_sName);
            }
            catch (UnknownPropertyException e) {
                DebugHelper.writeInfo(e.getMessage());
            }
            catch (WrappedTargetException e) {
                DebugHelper.writeInfo(e.getMessage());
            }
        }
        if (aObject != null) {
            try {
                nValue = NumericalHelper.toInt(aObject);
            }
            catch (IllegalArgumentException e) {
                DebugHelper.writeInfo("can't convert a object to integer.");
            }
        }
        return nValue;
    }

    public short getPropertyValueAsShort(String _sName, short _nDefault) {
        Object aObject = null;
        short nValue = _nDefault;
        if (this.m_xPropertySet != null) {
            try {
                aObject = this.m_xPropertySet.getPropertyValue(_sName);
            }
            catch (UnknownPropertyException e) {
                DebugHelper.writeInfo(e.getMessage());
            }
            catch (WrappedTargetException e) {
                DebugHelper.writeInfo(e.getMessage());
            }
        }
        if (aObject != null) {
            try {
                nValue = NumericalHelper.toShort(aObject);
            }
            catch (IllegalArgumentException e) {
                DebugHelper.writeInfo("can't convert a object to short.");
            }
        }
        return nValue;
    }

    public double getPropertyValueAsDouble(String _sName, double _nDefault) {
        Object aObject = null;
        double nValue = _nDefault;
        if (this.m_xPropertySet != null) {
            try {
                aObject = this.m_xPropertySet.getPropertyValue(_sName);
            }
            catch (UnknownPropertyException e) {
                DebugHelper.writeInfo(e.getMessage());
            }
            catch (WrappedTargetException e) {
                DebugHelper.writeInfo(e.getMessage());
            }
        }
        if (aObject == null && this.getHashMap().containsKey(_sName)) {
            aObject = this.getHashMap().get(_sName);
        }
        if (aObject != null) {
            try {
                nValue = NumericalHelper.toDouble(aObject);
            }
            catch (IllegalArgumentException e) {
                DebugHelper.writeInfo("can't convert a object to integer.");
            }
        }
        return nValue;
    }

    public boolean getPropertyValueAsBoolean(String _sName, boolean _bDefault) {
        Object aObject = null;
        boolean bValue = _bDefault;
        if (this.m_xPropertySet != null) {
            try {
                aObject = this.m_xPropertySet.getPropertyValue(_sName);
            }
            catch (UnknownPropertyException e) {
                DebugHelper.writeInfo(e.getMessage());
                DebugHelper.writeInfo("UnknownPropertyException caught: Name:=" + _sName);
            }
            catch (WrappedTargetException e) {
                DebugHelper.writeInfo(e.getMessage());
            }
        }
        if (aObject != null) {
            try {
                bValue = NumericalHelper.toBoolean(aObject);
            }
            catch (IllegalArgumentException e) {
                DebugHelper.writeInfo("can't convert a object to boolean.");
            }
        }
        return bValue;
    }

    public String getPropertyValueAsString(String _sName, String _sDefault) {
        Object aObject = null;
        String sValue = _sDefault;
        if (this.m_xPropertySet != null) {
            try {
                aObject = this.m_xPropertySet.getPropertyValue(_sName);
            }
            catch (UnknownPropertyException e) {
                DebugHelper.writeInfo(e.getMessage());
            }
            catch (WrappedTargetException e) {
                DebugHelper.writeInfo(e.getMessage());
            }
        }
        if (aObject != null) {
            try {
                sValue = AnyConverter.toString(aObject);
            }
            catch (IllegalArgumentException e) {
                DebugHelper.writeInfo("can't convert a object to string.");
            }
        }
        return sValue;
    }

    public Object getPropertyValueAsObject(String _sName) {
        Object aObject = null;
        if (this.m_xPropertySet != null) {
            try {
                aObject = this.m_xPropertySet.getPropertyValue(_sName);
            }
            catch (UnknownPropertyException e) {
                DebugHelper.writeInfo(e.getMessage());
            }
            catch (WrappedTargetException e) {
                DebugHelper.writeInfo(e.getMessage());
            }
        }
        return aObject;
    }

    public static void showProperties(Object _xObj) {
        PropertySetHelper aHelper = new PropertySetHelper(_xObj);
        aHelper.showProperties();
    }

    public void showProperties() {
        String sName = PropertyNames.EMPTY_STRING;
        if (this.m_xPropertySet != null) {
            XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)this.m_xPropertySet);
            if (xServiceInfo != null) {
                sName = xServiceInfo.getImplementationName();
            }
            XPropertySetInfo xInfo = this.m_xPropertySet.getPropertySetInfo();
            Property[] aAllProperties = xInfo.getProperties();
            DebugHelper.writeInfo("Show all properties of Implementation of :'" + sName + "'");
            for (int i = 0; i < aAllProperties.length; ++i) {
                DebugHelper.writeInfo(" - " + aAllProperties[i].Name);
            }
        } else {
            DebugHelper.writeInfo("The given object don't support XPropertySet interface.");
        }
    }
}

