/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.SystemDialog;

public class Resource {
    XMultiServiceFactory xMSF;
    String Module;
    XIndexAccess xStringIndexAccess;
    XIndexAccess xStringListIndexAccess;

    public Resource(XMultiServiceFactory _xMSF, String _Unit, String _Module) {
        this.xMSF = _xMSF;
        this.Module = _Module;
        try {
            Object[] aArgs = new Object[]{this.Module};
            XInterface xResource = (XInterface)this.xMSF.createInstanceWithArguments("org.libreoffice.resource.ResourceIndexAccess", aArgs);
            if (xResource == null) {
                throw new Exception("could not initialize ResourceIndexAccess");
            }
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xResource);
            if (xNameAccess == null) {
                throw new Exception("ResourceIndexAccess is no XNameAccess");
            }
            this.xStringIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xNameAccess.getByName("String"));
            this.xStringListIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xNameAccess.getByName("StringList"));
            if (this.xStringListIndexAccess == null) {
                throw new Exception("could not initialize xStringListIndexAccess");
            }
            if (this.xStringIndexAccess == null) {
                throw new Exception("could not initialize xStringIndexAccess");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Resource.showCommonResourceError(this.xMSF);
        }
    }

    public String getResText(int nID) {
        try {
            return (String)this.xStringIndexAccess.getByIndex(nID);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Resource with ID not " + String.valueOf(nID) + "not found");
        }
    }

    public PropertyValue[] getStringList(int nID) {
        try {
            return (PropertyValue[])this.xStringListIndexAccess.getByIndex(nID);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Resource with ID not " + String.valueOf(nID) + "not found");
        }
    }

    public String[] getResArray(int nID, int iCount) {
        try {
            String[] ResArray = new String[iCount];
            for (int i = 0; i < iCount; ++i) {
                ResArray[i] = this.getResText(nID + i);
            }
            return ResArray;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new IllegalArgumentException("Resource with ID not" + String.valueOf(nID) + "not found");
        }
    }

    public static void showCommonResourceError(XMultiServiceFactory xMSF) {
        String ProductName = Configuration.getProductName(xMSF);
        String sError = "The files required could not be found.\nPlease start the %PRODUCTNAME Setup and choose 'Repair'.";
        sError = JavaTools.replaceSubString(sError, ProductName, "%PRODUCTNAME");
        SystemDialog.showMessageBox(xMSF, "ErrorBox", 0x400000, sError);
    }
}

