/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.CommandName;
import java.util.ArrayList;

public class RelationController
extends CommandName {
    private int PKTABLE_CAT = 1;
    private int PKTABLE_SCHEM = 2;
    private int PKTABLE_NAME = 3;
    private int PKCOLUMN_NAME = 4;
    private int FKTABLE_CAT = 5;
    private int FKTABLE_SCHEM = 6;
    private int FKTABLE_NAME = 7;
    private int FKCOLUMN_NAME = 8;

    public RelationController(CommandMetaData _CommandMetaData, String _CatalogName, String _SchemaName, String _TableName, boolean _baddQuotation) {
        super(_CommandMetaData, _CatalogName, _SchemaName, _TableName, _baddQuotation);
    }

    public RelationController(CommandMetaData _CommandMetaData, String _DisplayName) {
        super(_CommandMetaData, _DisplayName);
    }

    public String[] getExportedKeys() {
        String[] sReferencedTableNames = new String[]{};
        try {
            String[] sTableNames = super.getCommandMetaData().getTableNames();
            ArrayList<String> aReferencedTableVector = new ArrayList<String>();
            XResultSet xResultSet = super.getCommandMetaData().xDBMetaData.getExportedKeys(this.getCatalogName(this), this.getSchemaName(), this.getTableName());
            XRow xRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)xResultSet);
            while (xResultSet.next()) {
                String sForeignCatalog = xRow.getString(this.FKTABLE_CAT);
                String sForeignScheme = xRow.getString(this.FKTABLE_SCHEM);
                String sForeignTableName = xRow.getString(this.FKTABLE_NAME);
                CommandName oCommandName = new CommandName(this.getCommandMetaData(), sForeignCatalog, sForeignScheme, sForeignTableName, false);
                aReferencedTableVector.add(oCommandName.getComposedName());
            }
            sReferencedTableNames = new String[aReferencedTableVector.size()];
            aReferencedTableVector.toArray(sReferencedTableNames);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
        return sReferencedTableNames;
    }

    private Object getCatalogName(CommandName _oCommandName) {
        String sLocCatalog = _oCommandName.getCatalogName();
        if (sLocCatalog.equals(PropertyNames.EMPTY_STRING)) {
            return null;
        }
        return sLocCatalog;
    }

    public String[][] getImportedKeyColumns(String _sreferencedtablename) {
        String[][] sKeyColumnNames = new String[][]{};
        try {
            CommandName oLocCommandName = new CommandName(super.getCommandMetaData(), _sreferencedtablename);
            XResultSet xResultSet = super.getCommandMetaData().xDBMetaData.getImportedKeys(this.getCatalogName(oLocCommandName), oLocCommandName.getSchemaName(), oLocCommandName.getTableName());
            XRow xRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)xResultSet);
            boolean bleaveLoop = false;
            ArrayList<String> aMasterFieldNamesVector = new ArrayList<String>();
            ArrayList<String> aSlaveFieldNamesVector = new ArrayList<String>();
            while (xResultSet.next() && !bleaveLoop) {
                String sPrimaryCatalog = null;
                String sPrimarySchema = null;
                if (super.getCommandMetaData().xDBMetaData.supportsCatalogsInDataManipulation()) {
                    sPrimaryCatalog = xRow.getString(this.PKTABLE_CAT);
                }
                if (super.getCommandMetaData().xDBMetaData.supportsSchemasInDataManipulation()) {
                    sPrimarySchema = xRow.getString(this.PKTABLE_SCHEM);
                }
                String sPrimaryTableName = xRow.getString(this.PKTABLE_NAME);
                String sPrimaryColumnName = xRow.getString(this.PKCOLUMN_NAME);
                String sForeignColumnName = xRow.getString(this.FKCOLUMN_NAME);
                if (!JavaTools.isSame(this.getTableName(), sPrimaryTableName) || sPrimarySchema != null && !JavaTools.isSame(this.getSchemaName(), sPrimarySchema) || !JavaTools.isSame(this.getCatalogName(), sPrimaryCatalog)) continue;
                aSlaveFieldNamesVector.add(sForeignColumnName);
                aMasterFieldNamesVector.add(sPrimaryColumnName);
                bleaveLoop = true;
            }
            sKeyColumnNames = new String[2][aMasterFieldNamesVector.size()];
            sKeyColumnNames[0] = new String[aSlaveFieldNamesVector.size()];
            sKeyColumnNames[1] = new String[aMasterFieldNamesVector.size()];
            aSlaveFieldNamesVector.toArray(sKeyColumnNames[0]);
            aMasterFieldNamesVector.toArray(sKeyColumnNames[1]);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return sKeyColumnNames;
    }
}

