/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XSingleSelectQueryAnalyzer;
import com.sun.star.sdb.XSingleSelectQueryComposer;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.CommandName;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.QueryMetaData;
import java.util.ArrayList;

public class SQLQueryComposer {
    public XColumnsSupplier xColSuppl;
    QueryMetaData CurDBMetaData;
    public XSingleSelectQueryAnalyzer m_xQueryAnalyzer;
    ArrayList<CommandName> composedCommandNames = new ArrayList(1);
    private XSingleSelectQueryComposer m_queryComposer;
    XMultiServiceFactory xMSF;
    boolean bincludeGrouping = true;

    public SQLQueryComposer(QueryMetaData _CurDBMetaData) {
        try {
            this.setDBMetaData(_CurDBMetaData);
            this.xMSF = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.CurDBMetaData.DBConnection);
            Object oQueryComposer = this.xMSF.createInstance("com.sun.star.sdb.SingleSelectQueryComposer");
            this.m_xQueryAnalyzer = (XSingleSelectQueryAnalyzer)UnoRuntime.queryInterface(XSingleSelectQueryAnalyzer.class, (Object)oQueryComposer);
            this.m_queryComposer = (XSingleSelectQueryComposer)UnoRuntime.queryInterface(XSingleSelectQueryComposer.class, (Object)this.m_xQueryAnalyzer);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private boolean addtoSelectClause(String DisplayFieldName) throws SQLException {
        return !this.bincludeGrouping || !this.CurDBMetaData.xDBMetaData.supportsGroupByUnrelated() || this.CurDBMetaData.GroupFieldNames == null || JavaTools.FieldInList(this.CurDBMetaData.GroupFieldNames, DisplayFieldName) <= -1;
    }

    public String getSelectClause(boolean _baddAliasFieldNames) throws SQLException {
        String sSelectBaseClause;
        String sSelectClause = sSelectBaseClause = "SELECT ";
        for (int i = 0; i < this.CurDBMetaData.FieldColumns.length; ++i) {
            if (!this.addtoSelectClause(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName())) continue;
            int iAggregate = this.CurDBMetaData.getAggregateIndex(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName());
            if (iAggregate > -1) {
                sSelectClause = sSelectClause + this.CurDBMetaData.AggregateFieldNames[iAggregate][1] + "(" + this.getComposedAliasFieldName(this.CurDBMetaData.AggregateFieldNames[iAggregate][0]) + ")";
                if (_baddAliasFieldNames) {
                    sSelectClause = sSelectClause + this.getAliasFieldNameClause(this.CurDBMetaData.AggregateFieldNames[iAggregate][0]);
                }
            } else {
                sSelectClause = sSelectClause + this.getComposedAliasFieldName(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName());
                if (_baddAliasFieldNames) {
                    sSelectClause = sSelectClause + this.getAliasFieldNameClause(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName());
                }
            }
            sSelectClause = sSelectClause + ", ";
        }
        sSelectClause = sSelectClause.equals(sSelectBaseClause) ? sSelectClause.substring(0, sSelectClause.length() - 1) : sSelectClause.substring(0, sSelectClause.length() - 2);
        return sSelectClause;
    }

    public String getAliasFieldNameClause(String _FieldName) {
        String FieldTitle = this.CurDBMetaData.getFieldTitle(_FieldName);
        if (!FieldTitle.equals(_FieldName)) {
            return " AS " + CommandName.quoteName(FieldTitle, this.CurDBMetaData.getIdentifierQuote());
        }
        return "";
    }

    public void appendFilterConditions() throws SQLException {
        try {
            for (int i = 0; i < this.CurDBMetaData.getFilterConditions().length; ++i) {
                this.m_queryComposer.setStructuredFilter(this.CurDBMetaData.getFilterConditions());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void prependSortingCriteria() throws SQLException {
        this.prependSortingCriteria(false);
    }

    public void prependSortingCriteria(boolean _baddAliasFieldNames) throws SQLException {
        int i;
        XIndexAccess xColumnIndexAccess = this.m_xQueryAnalyzer.getOrderColumns();
        this.m_queryComposer.setOrder("");
        for (i = 0; i < this.CurDBMetaData.getSortFieldNames().length; ++i) {
            this.appendSortingCriterion(i, _baddAliasFieldNames);
        }
        for (i = 0; i < xColumnIndexAccess.getCount(); ++i) {
            try {
                XPropertySet xColumnPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xColumnIndexAccess.getByIndex(i));
                String sName = (String)xColumnPropertySet.getPropertyValue(PropertyNames.PROPERTY_NAME);
                if (JavaTools.FieldInTable(this.CurDBMetaData.getSortFieldNames(), sName) != -1) continue;
                boolean bascend = AnyConverter.toBoolean((Object)xColumnPropertySet.getPropertyValue("IsAscending"));
                this.m_queryComposer.appendOrderByColumn(xColumnPropertySet, bascend);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void appendSortingCriterion(int _SortIndex, boolean _baddAliasFieldNames) throws SQLException {
        String sSortValue = this.CurDBMetaData.getSortFieldNames()[_SortIndex][0];
        XPropertySet xColumn = this.CurDBMetaData.getColumnObjectByFieldName(sSortValue, _baddAliasFieldNames);
        String sSort = "ASC";
        if (this.CurDBMetaData.getSortFieldNames()[_SortIndex].length > 1) {
            sSort = this.CurDBMetaData.getSortFieldNames()[_SortIndex][1];
        }
        boolean bascend = !sSort.equals("DESC");
        this.m_queryComposer.appendOrderByColumn(xColumn, bascend);
    }

    public void appendSortingcriteria(boolean _baddAliasFieldNames) throws SQLException {
        String sOrder = "";
        this.m_queryComposer.setOrder("");
        for (int i = 0; i < this.CurDBMetaData.getSortFieldNames().length; ++i) {
            String sSortValue = this.CurDBMetaData.getSortFieldNames()[i][0];
            int iAggregate = this.CurDBMetaData.getAggregateIndex(sSortValue);
            if (iAggregate > -1) {
                sOrder = this.m_xQueryAnalyzer.getOrder();
                if (sOrder.length() > 0) {
                    sOrder = sOrder + ", ";
                }
                sOrder = sOrder + this.CurDBMetaData.AggregateFieldNames[iAggregate][1] + "(" + this.getComposedAliasFieldName(this.CurDBMetaData.AggregateFieldNames[iAggregate][0]) + ")";
                sOrder = sOrder + " " + this.CurDBMetaData.getSortFieldNames()[i][1];
                this.m_queryComposer.setOrder(sOrder);
            } else {
                this.appendSortingCriterion(i, _baddAliasFieldNames);
            }
            sOrder = this.m_xQueryAnalyzer.getOrder();
        }
        sOrder = this.m_queryComposer.getOrder();
    }

    public void appendGroupByColumns(boolean _baddAliasFieldNames) throws SQLException {
        for (int i = 0; i < this.CurDBMetaData.GroupFieldNames.length; ++i) {
            XPropertySet xColumn = this.CurDBMetaData.getColumnObjectByFieldName(this.CurDBMetaData.GroupFieldNames[i], _baddAliasFieldNames);
            this.m_queryComposer.appendGroupByColumn(xColumn);
        }
    }

    public void setDBMetaData(QueryMetaData _oDBMetaData) {
        this.CurDBMetaData = _oDBMetaData;
        this.updateComposedCommandNames();
    }

    private PropertyValue[][] replaceConditionsByAlias(PropertyValue[][] _filterconditions) {
        XColumnsSupplier columnSup = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.m_xQueryAnalyzer);
        XNameAccess columns = columnSup.getColumns();
        for (int n = 0; n < _filterconditions.length; ++n) {
            for (int m = 0; m < _filterconditions[n].length; ++m) {
                String aliasName;
                _filterconditions[n][m].Name = aliasName = this.getComposedAliasFieldName(_filterconditions[n][m].Name);
            }
        }
        return _filterconditions;
    }

    public String getQuery() {
        return this.m_xQueryAnalyzer.getQuery();
    }

    private void updateComposedCommandNames() {
        this.composedCommandNames.clear();
        String[] sCommandNames = this.CurDBMetaData.getIncludedCommandNames();
        for (int i = 0; i < sCommandNames.length; ++i) {
            CommandName curCommandName = new CommandName(this.CurDBMetaData, sCommandNames[i]);
            curCommandName.setAliasName(this.getuniqueAliasName(curCommandName.getTableName()));
            this.composedCommandNames.add(curCommandName);
        }
    }

    public StringBuilder getFromClause() {
        StringBuilder sFromClause = new StringBuilder("FROM");
        String[] sCommandNames = this.CurDBMetaData.getIncludedCommandNames();
        for (int i = 0; i < sCommandNames.length; ++i) {
            CommandName curCommandName = this.getComposedCommandByDisplayName(sCommandNames[i]);
            sFromClause.append(" ").append(curCommandName.getComposedName()).append(" ").append(this.quoteName(curCommandName.getAliasName()));
            if (i >= sCommandNames.length - 1) continue;
            sFromClause.append(", ");
        }
        return sFromClause;
    }

    public boolean setQueryCommand(XWindow _xParentWindow, boolean _bincludeGrouping, boolean _baddAliasFieldNames) {
        return this.setQueryCommand(_xParentWindow, _bincludeGrouping, _baddAliasFieldNames, true);
    }

    public boolean setQueryCommand(XWindow _xParentWindow, boolean _bincludeGrouping, boolean _baddAliasFieldNames, boolean addQuery) {
        return this.setQueryCommand(_xParentWindow, _bincludeGrouping, _baddAliasFieldNames, addQuery, false);
    }

    public boolean setQueryCommand(XWindow _xParentWindow, boolean _bincludeGrouping, boolean _baddAliasFieldNames, boolean addQuery, boolean prependSortingCriteria) {
        try {
            this.bincludeGrouping = _bincludeGrouping;
            if (addQuery) {
                StringBuilder fromClause = this.getFromClause();
                String sSelectClause = this.getSelectClause(_baddAliasFieldNames);
                StringBuilder queryclause = new StringBuilder(sSelectClause).append(" ").append((CharSequence)fromClause);
                this.m_xQueryAnalyzer.setQuery(queryclause.toString());
                if (this.CurDBMetaData.getFilterConditions() != null && this.CurDBMetaData.getFilterConditions().length > 0) {
                    this.CurDBMetaData.setFilterConditions(this.replaceConditionsByAlias(this.CurDBMetaData.getFilterConditions()));
                    this.m_queryComposer.setStructuredFilter(this.CurDBMetaData.getFilterConditions());
                }
            }
            if (_bincludeGrouping) {
                this.appendGroupByColumns(_baddAliasFieldNames);
                if (this.CurDBMetaData.GroupByFilterConditions.length > 0) {
                    this.m_queryComposer.setStructuredHavingClause(this.CurDBMetaData.GroupByFilterConditions);
                }
            }
            if (prependSortingCriteria) {
                this.prependSortingCriteria(_baddAliasFieldNames);
            } else {
                this.appendSortingcriteria(_baddAliasFieldNames);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            this.displaySQLErrorDialog(exception, _xParentWindow);
            return false;
        }
    }

    private String getComposedAliasFieldName(String _fieldname) {
        FieldColumn CurFieldColumn = this.CurDBMetaData.getFieldColumnByDisplayName(_fieldname);
        String curCommandName = CurFieldColumn.getCommandName();
        String curFieldName = CurFieldColumn.getFieldName();
        CommandName curComposedCommandName = this.getComposedCommandByDisplayName(curCommandName);
        if (curComposedCommandName == null) {
            if (curCommandName.length() > 0) {
                return this.quoteName(curCommandName) + "." + this.quoteName(curFieldName);
            }
            return this.quoteName(curFieldName);
        }
        String curAliasName = curComposedCommandName.getAliasName();
        return this.quoteName(curAliasName) + "." + this.quoteName(curFieldName);
    }

    private CommandName getComposedCommandByAliasName(String _AliasName) {
        if (this.composedCommandNames != null) {
            for (CommandName commandName : this.composedCommandNames) {
                if (!commandName.getAliasName().equals(_AliasName)) continue;
                return commandName;
            }
        }
        return null;
    }

    public CommandName getComposedCommandByDisplayName(String _DisplayName) {
        if (this.composedCommandNames != null) {
            for (CommandName commandName : this.composedCommandNames) {
                if (!commandName.getDisplayName().equals(_DisplayName)) continue;
                return commandName;
            }
        }
        return null;
    }

    public String getuniqueAliasName(String _TableName) {
        int a = 0;
        String AliasName = "";
        boolean bAliasNameexists = true;
        String locAliasName = _TableName;
        while (bAliasNameexists) {
            boolean bl = bAliasNameexists = this.getComposedCommandByAliasName(locAliasName) != null;
            if (bAliasNameexists) {
                locAliasName = _TableName + "_" + String.valueOf(++a);
                continue;
            }
            AliasName = locAliasName;
        }
        return AliasName;
    }

    private String quoteName(String _sname) {
        return CommandName.quoteName(_sname, this.CurDBMetaData.getIdentifierQuote());
    }

    public void displaySQLErrorDialog(Exception _exception, XWindow _xParentWindow) {
        try {
            Object oErrorDialog = this.CurDBMetaData.xMSF.createInstance("com.sun.star.sdb.ErrorMessageDialog");
            XInitialization xInitialize = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)oErrorDialog);
            XExecutableDialog xExecute = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)oErrorDialog);
            Object[] rDispatchArguments = new PropertyValue[]{Properties.createProperty(PropertyNames.PROPERTY_TITLE, Configuration.getProductName(this.CurDBMetaData.xMSF) + " Base"), Properties.createProperty("ParentWindow", _xParentWindow), Properties.createProperty("SQLException", (Object)_exception)};
            xInitialize.initialize(rDispatchArguments);
            xExecute.execute();
        }
        catch (Exception typeexception) {
            typeexception.printStackTrace(System.err);
        }
    }

    public PropertyValue[][] getNormalizedStructuredFilter() {
        PropertyValue[][] structuredFilter = this.m_queryComposer.getStructuredFilter();
        for (int i = 0; i < structuredFilter.length; ++i) {
            for (int j = 0; j < structuredFilter[i].length; ++j) {
                if (!(structuredFilter[i][j].Value instanceof String)) continue;
                StringBuffer textualValue = new StringBuffer((String)structuredFilter[i][j].Value);
                switch (structuredFilter[i][j].Handle) {
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        textualValue.delete(0, 2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        textualValue.delete(0, 1);
                        break;
                    }
                    case 8: {
                        textualValue.delete(0, 8);
                        break;
                    }
                    case 7: {
                        textualValue.delete(0, 4);
                        break;
                    }
                    case 9: {
                        textualValue.delete(0, 7);
                        break;
                    }
                    case 10: {
                        textualValue.delete(0, 11);
                    }
                }
                structuredFilter[i][j].Value = textualValue.toString().trim();
            }
        }
        return structuredFilter;
    }

    public XSingleSelectQueryComposer getQueryComposer() {
        return this.m_queryComposer;
    }
}

