/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDevice;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XChild;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNamed;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapeGrouper;
import com.sun.star.drawing.XShapes;
import com.sun.star.form.XFormsSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XControlAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.document.Control;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FormHandler {
    private static final String CHECKBOX = "CheckBox";
    private static final String DATEFIELD = "DateField";
    private static final String FORMATTEDFIELD = "FormattedField";
    private static final String IMAGECONTROL = "ImageControl";
    private static final String TEXTFIELD = "TextField";
    private static final String TIMEFIELD = "TimeField";
    public XFormsSupplier xFormsSupplier;
    public XMultiServiceFactory xMSFDoc;
    public XMultiServiceFactory xMSF;
    public XDrawPage xDrawPage;
    private XDrawPageSupplier xDrawPageSupplier;
    public String[] sModelServices = new String[8];
    public static ControlData[] oControlData;
    public static final int SOLABEL = 0;
    public static final int SOTEXTBOX = 1;
    public static final int SOCHECKBOX = 2;
    public static final int SODATECONTROL = 3;
    public static final int SOTIMECONTROL = 4;
    public static final int SONUMERICCONTROL = 5;
    public static final int SOGRIDCONTROL = 6;
    public static final int SOIMAGECONTROL = 7;
    public static final int SODATETIMECONTROL = 8;
    int iImageControlHeight = 2000;
    public static String SOSIZETEXT;
    int iXPixelFactor = -1;
    int iYPixelFactor = -1;
    int iXNirwanaPos = 50000;
    int iYNirwanaPos = 50000;
    public int nLabelHeight = -1;
    public int nDBRefHeight = -1;
    public int BasicLabelDiffHeight = -1;
    XNameAccess xNamedForms;
    XControlAccess xControlAccess;
    XShapeGrouper xShapeGrouper;
    XNameContainer xNamedFormContainer;

    public FormHandler(XMultiServiceFactory _xMSF, XTextDocument xTextDocument) {
        this.xMSF = _xMSF;
        this.xDrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)xTextDocument);
        this.xDrawPage = this.xDrawPageSupplier.getDrawPage();
        this.xFormsSupplier = (XFormsSupplier)UnoRuntime.queryInterface(XFormsSupplier.class, (Object)this.xDrawPage);
        this.xShapeGrouper = (XShapeGrouper)UnoRuntime.queryInterface(XShapeGrouper.class, (Object)this.xDrawPage);
        this.xControlAccess = (XControlAccess)UnoRuntime.queryInterface(XControlAccess.class, (Object)xTextDocument.getCurrentController());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xTextDocument);
        this.sModelServices[0] = "com.sun.star.form.component.FixedText";
        this.sModelServices[1] = "com.sun.star.form.component.TextField";
        this.sModelServices[2] = "com.sun.star.form.component.CheckBox";
        this.sModelServices[3] = "com.sun.star.form.component.DateField";
        this.sModelServices[4] = "com.sun.star.form.component.TimeField";
        this.sModelServices[5] = "com.sun.star.form.component.FormattedField";
        this.sModelServices[6] = "com.sun.star.form.component.GridControl";
        this.sModelServices[7] = "com.sun.star.form.component.DatabaseImageControl";
        oControlData = new ControlData[22];
        FormHandler.oControlData[0] = this.createControlData(-7, 2, CHECKBOX, CHECKBOX, false);
        FormHandler.oControlData[1] = this.createControlData(16, 2, CHECKBOX, CHECKBOX, false);
        FormHandler.oControlData[2] = this.createControlData(-6, 5, FORMATTEDFIELD, FORMATTEDFIELD, false);
        FormHandler.oControlData[3] = this.createControlData(5, 5, FORMATTEDFIELD, FORMATTEDFIELD, false);
        FormHandler.oControlData[4] = this.createControlData(4, 5, FORMATTEDFIELD, FORMATTEDFIELD, false);
        FormHandler.oControlData[5] = this.createControlData(-5, 5, FORMATTEDFIELD, FORMATTEDFIELD, false);
        FormHandler.oControlData[6] = this.createControlData(6, 5, FORMATTEDFIELD, FORMATTEDFIELD, false);
        FormHandler.oControlData[7] = this.createControlData(7, 5, FORMATTEDFIELD, FORMATTEDFIELD, false);
        FormHandler.oControlData[8] = this.createControlData(8, 5, FORMATTEDFIELD, FORMATTEDFIELD, false);
        FormHandler.oControlData[9] = this.createControlData(2, 5, FORMATTEDFIELD, FORMATTEDFIELD, false);
        FormHandler.oControlData[10] = this.createControlData(3, 5, FORMATTEDFIELD, FORMATTEDFIELD, false);
        FormHandler.oControlData[11] = this.createControlData(1, 1, TEXTFIELD, TEXTFIELD, false);
        FormHandler.oControlData[12] = this.createControlData(12, 1, TEXTFIELD, TEXTFIELD, true);
        FormHandler.oControlData[13] = this.createControlData(-1, 1, TEXTFIELD, TEXTFIELD, true);
        FormHandler.oControlData[14] = this.createControlData(91, 3, DATEFIELD, DATEFIELD, false);
        FormHandler.oControlData[15] = this.createControlData(92, 4, TIMEFIELD, TIMEFIELD, false);
        FormHandler.oControlData[16] = this.createControlData(93, 3, DATEFIELD, TEXTFIELD, false);
        FormHandler.oControlData[17] = this.createControlData(-2, 7, IMAGECONTROL, TEXTFIELD, false);
        FormHandler.oControlData[18] = this.createControlData(-3, 7, IMAGECONTROL, TEXTFIELD, false);
        FormHandler.oControlData[19] = this.createControlData(-4, 7, IMAGECONTROL, TEXTFIELD, false);
        FormHandler.oControlData[20] = this.createControlData(2004, 7, IMAGECONTROL, TEXTFIELD, false);
        FormHandler.oControlData[21] = this.createControlData(1111, 7, IMAGECONTROL, TEXTFIELD, false);
    }

    public int getControlType(int _fieldtype) {
        for (int i = 0; i < oControlData.length; ++i) {
            if (FormHandler.oControlData[i].DataType != _fieldtype) continue;
            return FormHandler.oControlData[i].ControlType;
        }
        return -1;
    }

    public void setglobalMultiServiceFactory(XMultiServiceFactory _xMSF) {
        this.xMSF = _xMSF;
    }

    public String getModelServiceName(int _fieldtype) {
        int icontroltype = this.getControlType(_fieldtype);
        if (icontroltype > -1) {
            return this.sModelServices[icontroltype];
        }
        return null;
    }

    public void initializeBasicControlValues() {
        Control oLabelControl = new Control(this, 0, new Point(), new Size());
        XDevice xDevice = (XDevice)UnoRuntime.queryInterface(XDevice.class, (Object)oLabelControl.xWindowPeer);
        this.iXPixelFactor = (int)(100000.0 / xDevice.getInfo().PixelPerMeterX);
        this.iYPixelFactor = (int)(100000.0 / xDevice.getInfo().PixelPerMeterY);
        this.nLabelHeight = oLabelControl.getPreferredHeight("The quick brown fox...") + 1;
        Control oTextControl = new Control(this, 1, new Point(), new Size());
        this.nDBRefHeight = oTextControl.getPreferredHeight("The quick brown fox...") + 1;
        this.BasicLabelDiffHeight = (this.nDBRefHeight - this.nLabelHeight) / 2;
        this.xDrawPage.remove(oLabelControl.xShape);
        this.xDrawPage.remove(oTextControl.xShape);
    }

    public ControlData createControlData(int _datatype, int _controltype, String _scontrolservicename, String _gridcolumnname, boolean _bIsTextControl) {
        ControlData curControlData = new ControlData();
        curControlData.DataType = _datatype;
        curControlData.ControlType = _controltype;
        curControlData.ControlService = _scontrolservicename;
        curControlData.GridColumnName = _gridcolumnname;
        curControlData.bIsText = _bIsTextControl;
        return curControlData;
    }

    public XNameContainer getDocumentForms() {
        return this.xFormsSupplier.getForms();
    }

    public String getValueofHiddenControl(XNameAccess xNamedForm, String ControlName) {
        String value = "";
        try {
            if (xNamedForm.hasByName(ControlName)) {
                value = AnyConverter.toString((Object)Helper.getUnoPropertyValue(xNamedForm.getByName(ControlName), "HiddenValue"));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        return value;
    }

    public void insertHiddenControl(XNameAccess xNameAccess, XNameContainer xNamedForm, String ControlName, String ControlValue) {
        try {
            XInterface xHiddenControl;
            if (xNameAccess.hasByName(ControlName)) {
                xHiddenControl = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)xNameAccess.getByName(ControlName));
            } else {
                xHiddenControl = (XInterface)this.xMSFDoc.createInstance("com.sun.star.form.component.HiddenControl");
                xNamedForm.insertByName(ControlName, (Object)xHiddenControl);
            }
            Helper.setUnoPropertyValue(xHiddenControl, "HiddenValue", ControlValue);
        }
        catch (Exception ex) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean hasFormByName(String _FormName) {
        this.xNamedFormContainer = this.getDocumentForms();
        this.xNamedForms = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.xNamedFormContainer);
        return this.xNamedForms.hasByName(_FormName);
    }

    public void removeFormByName(String _FormName) {
        try {
            if (this.hasFormByName(_FormName)) {
                this.removeControlsofForm(_FormName);
                this.xNamedFormContainer.removeByName(_FormName);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void removeControlsofForm(String _FormName) {
        try {
            for (int i = this.xDrawPage.getCount() - 1; i >= 0; --i) {
                if (!this.belongsToForm(this.xDrawPage.getByIndex(i), _FormName)) continue;
                XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)this.xDrawPage.getByIndex(i));
                this.xDrawPage.remove(xShape);
            }
        }
        catch (Exception e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void removeElement(XNameContainer _parentContainer, String _formName) {
        try {
            _parentContainer.removeByName(_formName);
        }
        catch (WrappedTargetException e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (NoSuchElementException e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public boolean belongsToForm(Object _oDrawPageElement, String _FormName) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)_oDrawPageElement);
        if (xServiceInfo.supportsService("com.sun.star.drawing.ControlShape")) {
            XControlShape xControlShape = (XControlShape)UnoRuntime.queryInterface(XControlShape.class, (Object)_oDrawPageElement);
            XControlModel xControlModel = xControlShape.getControl();
            xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xControlShape.getControl());
            if (xServiceInfo.supportsService("com.sun.star.form.FormComponent")) {
                XChild xChild = (XChild)UnoRuntime.queryInterface(XChild.class, (Object)xControlModel);
                XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)xChild.getParent());
                String sName = xNamed.getName();
                return _FormName.equals(sName);
            }
        }
        return false;
    }

    public XNameContainer insertFormbyName(String _FormName, XNameContainer _xNamedFormContainer) {
        try {
            if (!this.hasFormByName(_FormName)) {
                Object oDBForm = this.xMSFDoc.createInstance("com.sun.star.form.component.Form");
                _xNamedFormContainer.insertByName(_FormName, oDBForm);
                XNameContainer xNamedForm = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)oDBForm);
                return xNamedForm;
            }
            return this.getFormByName(_FormName);
        }
        catch (Exception e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public XNameContainer insertSubFormbyName(String _FormName, XNameContainer _xNamedFormContainer) {
        return this.insertFormbyName(_FormName, _xNamedFormContainer);
    }

    public XNameContainer insertFormbyName(String _FormName) {
        return this.insertFormbyName(_FormName, this.getDocumentForms());
    }

    public XNameContainer getFormByName(String _sname) {
        XNameContainer xNamedForm = null;
        try {
            if (this.xNamedForms.hasByName(_sname)) {
                Object oDBForm = AnyConverter.toObject((Type)new Type(XInterface.class), (Object)Helper.getUnoObjectbyName(this.xNamedForms, _sname));
                xNamedForm = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)oDBForm);
            }
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
        }
        return xNamedForm;
    }

    public int getXPixelFactor() {
        if (this.iXPixelFactor == -1) {
            this.initializeBasicControlValues();
        }
        return this.iXPixelFactor;
    }

    public int getYPixelFactor() {
        if (this.iYPixelFactor == -1) {
            this.initializeBasicControlValues();
        }
        return this.iYPixelFactor;
    }

    public void setXPixelFactor(int i) {
        this.iXPixelFactor = i;
    }

    public void setYPixelFactor(int i) {
        this.iYPixelFactor = i;
    }

    public int getImageControlHeight() {
        return this.iImageControlHeight;
    }

    public void setImageControlHeight(int i) {
        this.iImageControlHeight = i;
    }

    public void moveShapesToNirwana(Control[] ControlList) {
        if (ControlList != null) {
            for (int i = 0; i < ControlList.length; ++i) {
                if (ControlList[i] == null) continue;
                ControlList[i].setPosition(new Point(this.iXNirwanaPos, this.iYNirwanaPos));
            }
        }
    }

    public void moveShapesToNirwana() {
        try {
            for (int i = 0; i < this.xDrawPage.getCount(); ++i) {
                XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)this.xDrawPage.getByIndex(i));
                xShape.setPosition(new Point(this.iXNirwanaPos, this.iYNirwanaPos));
            }
        }
        catch (Exception e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void removeAllShapes() throws Exception {
        for (int i = this.xDrawPage.getCount(); i > -1; --i) {
            XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)this.xDrawPage.getByIndex(i));
            this.removeShape(xShape);
        }
    }

    public void removeShape(XShape _xShape) {
        this.xDrawPage.remove(_xShape);
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)_xShape);
        xComponent.dispose();
    }

    public void removeNirwanaShapes() throws Exception {
        for (int i = this.xDrawPage.getCount(); i > -1; --i) {
            XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)this.xDrawPage.getByIndex(i));
            if (xShape.getPosition().Y >= this.iYNirwanaPos) continue;
            this.xDrawPage.remove(xShape);
        }
    }

    public XShape groupShapesTogether(XMultiServiceFactory _xMSF, XShape _xLabelShape, XShape _xControlShape) {
        try {
            Object oGroupShape = _xMSF.createInstance("com.sun.star.drawing.ShapeCollection");
            XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)oGroupShape);
            xShapes.add(_xLabelShape);
            xShapes.add(_xControlShape);
            return this.xShapeGrouper.group(xShapes);
        }
        catch (Exception e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public int getBasicLabelDiffHeight() {
        if (this.BasicLabelDiffHeight == -1) {
            this.initializeBasicControlValues();
        }
        return this.BasicLabelDiffHeight;
    }

    public int getControlReferenceHeight() {
        if (this.nDBRefHeight == -1) {
            this.initializeBasicControlValues();
        }
        return this.nDBRefHeight;
    }

    public int getLabelHeight() {
        if (this.nLabelHeight == -1) {
            this.initializeBasicControlValues();
        }
        return this.nLabelHeight;
    }

    public void setDrawObjectsCaptureMode(boolean _bCaptureObjects) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xMSFDoc.createInstance("com.sun.star.text.DocumentSettings"));
            xPropertySet.setPropertyValue("DoNotCaptureDrawObjsOnPage", (Object)(!_bCaptureObjects ? 1 : 0));
        }
        catch (Exception e) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    static {
        SOSIZETEXT = "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog.";
    }

    public class ControlData {
        int DataType;
        int ControlType;
        String ControlService;
        String GridColumnName;
        boolean bIsText;
    }
}

